/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.std.SwarUtils;
import io.questdb.std.str.DirectUtf16Sink;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8Sink;

public class VarcharAdapter
extends AbstractTypeAdapter {
    private static final byte DOUBLE_QUOTE = 34;
    private static final long DOUBLE_QUOTE_WORD = SwarUtils.broadcast((byte)34);
    private final DirectUtf8Sink utf8Sink;

    public VarcharAdapter(DirectUtf8Sink utf8Sink) {
        this.utf8Sink = utf8Sink;
    }

    @Override
    public int getType() {
        return 26;
    }

    @Override
    public boolean probe(DirectUtf8Sequence text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectUtf8Sequence value) throws Exception {
        this.write(row, column, value, null, this.utf8Sink);
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectUtf8Sequence value, DirectUtf16Sink utf16Sink, DirectUtf8Sink utf8Sink) {
        VarcharAdapter.deflateConsecutiveDoubleQuotes(value, utf8Sink);
        row.putVarchar(column, utf8Sink);
    }

    private static void deflateConsecutiveDoubleQuotes(DirectUtf8Sequence value, DirectUtf8Sink utf8Sink) {
        utf8Sink.clear();
        int quoteCount = 0;
        int len = value.size();
        int i = 0;
        while (i < len) {
            byte b;
            long word;
            long zeroBytesWord;
            if (i < len - 7 && (zeroBytesWord = SwarUtils.markZeroBytes((word = value.longAt(i)) ^ DOUBLE_QUOTE_WORD)) == 0L) {
                quoteCount = 0;
                utf8Sink.putAny8(word);
                i += 8;
                continue;
            }
            if ((b = value.byteAt(i++)) == 34) {
                if (quoteCount++ % 2 != 0) continue;
                utf8Sink.putAny((byte)34);
                continue;
            }
            quoteCount = 0;
            utf8Sink.putAny(b);
        }
        if (quoteCount % 2 != 0) {
            utf8Sink.putAny((byte)34);
        }
    }
}

