/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.SqlException;
import io.questdb.std.Chars;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;

public class SqlKeywords {
    public static final int CAST_KEYWORD_LENGTH = 4;
    public static final String CONCAT_FUNC_NAME = "concat";
    public static final int GEOHASH_KEYWORD_LENGTH = 7;
    protected static final LowerCaseCharSequenceHashSet KEYWORDS = new LowerCaseCharSequenceHashSet();
    private static final LowerCaseCharSequenceHashSet TIMESTAMP_PART_SET = new LowerCaseCharSequenceHashSet();

    public static boolean isAddKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 97 && (tok.charAt(1) | 0x20) == 100 && (tok.charAt(2) | 0x20) == 100;
    }

    public static boolean isAlignKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 97 && (tok.charAt(1) | 0x20) == 108 && (tok.charAt(2) | 0x20) == 105 && (tok.charAt(3) | 0x20) == 103 && (tok.charAt(4) | 0x20) == 110;
    }

    public static boolean isAllKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 97 && (tok.charAt(1) | 0x20) == 108 && (tok.charAt(2) | 0x20) == 108;
    }

    public static boolean isAlterKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 97 && (tok.charAt(1) | 0x20) == 108 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114;
    }

    public static boolean isAndKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 97 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 100;
    }

    public static boolean isArrayKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 97 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 121;
    }

    public static boolean isAsKeyword(CharSequence tok) {
        return tok.length() == 2 && (tok.charAt(0) | 0x20) == 97 && (tok.charAt(1) | 0x20) == 115;
    }

    public static boolean isAscKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 97 && (tok.charAt(1) | 0x20) == 115 && (tok.charAt(2) | 0x20) == 99;
    }

    public static boolean isAtKeyword(CharSequence tok) {
        return tok.length() == 2 && (tok.charAt(0) | 0x20) == 97 && (tok.charAt(1) | 0x20) == 116;
    }

    public static boolean isAtomicKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 97 && (tok.charAt(1) | 0x20) == 116 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 109 && (tok.charAt(4) | 0x20) == 105 && (tok.charAt(5) | 0x20) == 99;
    }

    public static boolean isAttachKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 97 && (tok.charAt(1) | 0x20) == 116 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 99 && (tok.charAt(5) | 0x20) == 104;
    }

    public static boolean isBatchKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 98 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 99 && (tok.charAt(4) | 0x20) == 104;
    }

    public static boolean isBetweenKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 98 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 119 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 101 && (tok.charAt(6) | 0x20) == 110;
    }

    public static boolean isByKeyword(CharSequence tok) {
        return tok.length() == 2 && (tok.charAt(0) | 0x20) == 98 && (tok.charAt(1) | 0x20) == 121;
    }

    public static boolean isBypassKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 98 && (tok.charAt(1) | 0x20) == 121 && (tok.charAt(2) | 0x20) == 112 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 115 && (tok.charAt(5) | 0x20) == 115;
    }

    public static boolean isCacheKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 104 && (tok.charAt(4) | 0x20) == 101;
    }

    public static boolean isCalendarKeyword(CharSequence tok) {
        return tok.length() == 8 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 110 && (tok.charAt(5) | 0x20) == 100 && (tok.charAt(6) | 0x20) == 97 && (tok.charAt(7) | 0x20) == 114;
    }

    public static boolean isCancelKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 99 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 108;
    }

    public static boolean isCapacityKeyword(CharSequence tok) {
        return tok.length() == 8 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 112 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 99 && (tok.charAt(5) | 0x20) == 105 && (tok.charAt(6) | 0x20) == 116 && (tok.charAt(7) | 0x20) == 121;
    }

    public static boolean isCaseKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 101;
    }

    public static boolean isCastKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 116;
    }

    public static boolean isCenturyKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 116 && (tok.charAt(4) | 0x20) == 117 && (tok.charAt(5) | 0x20) == 114 && (tok.charAt(6) | 0x20) == 121;
    }

    public static boolean isColonColon(CharSequence tok) {
        return tok.length() == 2 && tok.charAt(0) == ':' && tok.charAt(1) == ':';
    }

    public static boolean isColumnKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 109 && (tok.charAt(5) | 0x20) == 110;
    }

    public static boolean isColumnsKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 109 && (tok.charAt(5) | 0x20) == 110 && (tok.charAt(6) | 0x20) == 115;
    }

    public static boolean isConcatKeyword(CharSequence tok) {
        if (tok.length() != 6) {
            return false;
        }
        if (tok == CONCAT_FUNC_NAME) {
            return true;
        }
        return (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 99 && (tok.charAt(4) | 0x20) == 97 && (tok.charAt(5) | 0x20) == 116;
    }

    public static boolean isConcatOperator(CharSequence tok) {
        return tok.length() == 2 && tok.charAt(0) == '|' && tok.charAt(1) == '|';
    }

    public static boolean isConvertKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 118 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 114 && (tok.charAt(6) | 0x20) == 116;
    }

    public static boolean isCopyKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 112 && (tok.charAt(3) | 0x20) == 121;
    }

    public static boolean isCountKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 117 && (tok.charAt(3) | 0x20) == 110 && (tok.charAt(4) | 0x20) == 116;
    }

    public static boolean isCreateKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 101 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 116 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isCurrentKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 99 && (tok.charAt(1) | 0x20) == 117 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 110 && (tok.charAt(6) | 0x20) == 116;
    }

    public static boolean isDatabaseKeyword(CharSequence tok) {
        return tok.length() == 8 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 98 && (tok.charAt(5) | 0x20) == 97 && (tok.charAt(6) | 0x20) == 115 && (tok.charAt(7) | 0x20) == 101;
    }

    public static boolean isDateStyleKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 115 && (tok.charAt(5) | 0x20) == 116 && (tok.charAt(6) | 0x20) == 121 && (tok.charAt(7) | 0x20) == 108 && (tok.charAt(8) | 0x20) == 101;
    }

    public static boolean isDayKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 121;
    }

    public static boolean isDaysKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 121 && (tok.charAt(3) | 0x20) == 115;
    }

    public static boolean isDecadeKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 100 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isDeclareKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 97 && (tok.charAt(5) | 0x20) == 114 && (tok.charAt(6) | 0x20) == 101;
    }

    public static boolean isDedupKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 100 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 112;
    }

    public static boolean isDeduplicateKeyword(CharSequence tok) {
        return tok.length() == 11 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 100 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 112 && (tok.charAt(5) | 0x20) == 108 && (tok.charAt(6) | 0x20) == 105 && (tok.charAt(7) | 0x20) == 99 && (tok.charAt(8) | 0x20) == 97 && (tok.charAt(9) | 0x20) == 116 && (tok.charAt(10) | 0x20) == 101;
    }

    public static boolean isDeferredKeyword(CharSequence tok) {
        return tok.length() == 8 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 102 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114 && (tok.charAt(5) | 0x20) == 114 && (tok.charAt(6) | 0x20) == 101 && (tok.charAt(7) | 0x20) == 100;
    }

    public static boolean isDelayKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 121;
    }

    public static boolean isDelimiterKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 105 && (tok.charAt(4) | 0x20) == 109 && (tok.charAt(5) | 0x20) == 105 && (tok.charAt(6) | 0x20) == 116 && (tok.charAt(7) | 0x20) == 101 && (tok.charAt(8) | 0x20) == 114;
    }

    public static boolean isDescKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 99;
    }

    public static boolean isDetachKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 99 && (tok.charAt(5) | 0x20) == 104;
    }

    public static boolean isDisableKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 98 && (tok.charAt(5) | 0x20) == 108 && (tok.charAt(6) | 0x20) == 101;
    }

    public static boolean isDistinctKeyword(CharSequence tok) {
        return tok.length() == 8 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 116 && (tok.charAt(4) | 0x20) == 105 && (tok.charAt(5) | 0x20) == 110 && (tok.charAt(6) | 0x20) == 99 && (tok.charAt(7) | 0x20) == 116;
    }

    public static boolean isDoubleKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 117 && (tok.charAt(3) | 0x20) == 98 && (tok.charAt(4) | 0x20) == 108 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isDowKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 119;
    }

    public static boolean isDoyKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 121;
    }

    public static boolean isDropKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 100 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 112;
    }

    public static boolean isEmptyAlias(CharSequence tok) {
        return tok.length() == 2 && (tok.charAt(0) == '\'' && tok.charAt(1) == '\'' || tok.charAt(0) == '\"' && tok.charAt(1) == '\"');
    }

    public static boolean isEnableKeyword(@NotNull CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 101 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 97 && (tok.charAt(3) | 0x20) == 98 && (tok.charAt(4) | 0x20) == 108 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isEndKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 101 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 100;
    }

    public static boolean isEpochKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 101 && (tok.charAt(1) | 0x20) == 112 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 99 && (tok.charAt(4) | 0x20) == 104;
    }

    public static boolean isEveryKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 101 && (tok.charAt(1) | 0x20) == 118 && (tok.charAt(2) | 0x20) == 101 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 121;
    }

    public static boolean isExceptKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 101 && (tok.charAt(1) | 0x20) == 120 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 112 && (tok.charAt(5) | 0x20) == 116;
    }

    public static boolean isExcludeKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 101 && (tok.charAt(1) | 0x20) == 120 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 117 && (tok.charAt(5) | 0x20) == 100 && (tok.charAt(6) | 0x20) == 101;
    }

    public static boolean isExclusiveKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 101 && (tok.charAt(1) | 0x20) == 120 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 117 && (tok.charAt(5) | 0x20) == 115 && (tok.charAt(6) | 0x20) == 105 && (tok.charAt(7) | 0x20) == 118 && (tok.charAt(8) | 0x20) == 101;
    }

    public static boolean isExistsKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 101 && (tok.charAt(1) | 0x20) == 120 && (tok.charAt(2) | 0x20) == 105 && (tok.charAt(3) | 0x20) == 115 && (tok.charAt(4) | 0x20) == 116 && (tok.charAt(5) | 0x20) == 115;
    }

    public static boolean isExplainKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 101 && (tok.charAt(1) | 0x20) == 120 && (tok.charAt(2) | 0x20) == 112 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 97 && (tok.charAt(5) | 0x20) == 105 && (tok.charAt(6) | 0x20) == 110;
    }

    public static boolean isExtractKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 101 && (tok.charAt(1) | 0x20) == 120 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 97 && (tok.charAt(5) | 0x20) == 99 && (tok.charAt(6) | 0x20) == 116;
    }

    public static boolean isFalseKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 102 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 115 && (tok.charAt(4) | 0x20) == 101;
    }

    public static boolean isFalseKeyword(Utf8Sequence tok) {
        return tok.size() == 5 && (tok.byteAt(0) | 0x20) == 102 && (tok.byteAt(1) | 0x20) == 97 && (tok.byteAt(2) | 0x20) == 108 && (tok.byteAt(3) | 0x20) == 115 && (tok.byteAt(4) | 0x20) == 101;
    }

    public static boolean isFillKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 102 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 108;
    }

    public static boolean isFirstKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 102 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 115 && (tok.charAt(4) | 0x20) == 116;
    }

    public static boolean isFloat4Keyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 102 && (tok.charAt(1) | 0x20) == 108 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 116 && tok.charAt(5) == '4';
    }

    public static boolean isFloat8Keyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 102 && (tok.charAt(1) | 0x20) == 108 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 116 && tok.charAt(5) == '8';
    }

    public static boolean isFloatKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 102 && (tok.charAt(1) | 0x20) == 108 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 116;
    }

    public static boolean isFollowingKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 102 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 111 && (tok.charAt(5) | 0x20) == 119 && (tok.charAt(6) | 0x20) == 105 && (tok.charAt(7) | 0x20) == 110 && (tok.charAt(8) | 0x20) == 103;
    }

    public static boolean isForceKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 102 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 99 && (tok.charAt(4) | 0x20) == 101;
    }

    public static boolean isFormatKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 102 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 109 && (tok.charAt(4) | 0x20) == 97 && (tok.charAt(5) | 0x20) == 116;
    }

    public static boolean isFromKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 102 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 109;
    }

    public static boolean isFullKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 102 && (tok.charAt(1) | 0x20) == 117 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 108;
    }

    public static boolean isGeoHashKeyword(CharSequence tok) {
        return tok.length() == 7 && SqlKeywords.isGeoHashKeywordInternal(tok);
    }

    public static boolean isGroupKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 103 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 112;
    }

    public static boolean isGroupsKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 103 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 112 && (tok.charAt(5) | 0x20) == 115;
    }

    public static boolean isHeaderKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 104 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 97 && (tok.charAt(3) | 0x20) == 100 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 114;
    }

    public static boolean isHourKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 104 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 117 && (tok.charAt(3) | 0x20) == 114;
    }

    public static boolean isHoursKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 104 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 117 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 115;
    }

    public static boolean isIfKeyword(CharSequence tok) {
        return tok.length() == 2 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 102;
    }

    public static boolean isIgnoreWord(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 103 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 111 && (tok.charAt(4) | 0x20) == 114 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isImmediateKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 109 && (tok.charAt(2) | 0x20) == 109 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 100 && (tok.charAt(5) | 0x20) == 105 && (tok.charAt(6) | 0x20) == 97 && (tok.charAt(7) | 0x20) == 116 && (tok.charAt(8) | 0x20) == 101;
    }

    public static boolean isInKeyword(CharSequence tok) {
        return tok.length() == 2 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 110;
    }

    public static boolean isIncrementalKeyword(CharSequence tok) {
        return tok.length() == 11 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 109 && (tok.charAt(6) | 0x20) == 101 && (tok.charAt(7) | 0x20) == 110 && (tok.charAt(8) | 0x20) == 116 && (tok.charAt(9) | 0x20) == 97 && (tok.charAt(10) | 0x20) == 108;
    }

    public static boolean isIndexKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 100 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 120;
    }

    public static boolean isInsertKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114 && (tok.charAt(5) | 0x20) == 116;
    }

    public static boolean isInt2Keyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 50;
    }

    public static boolean isInt4Keyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 52;
    }

    public static boolean isInt8Keyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 56;
    }

    public static boolean isIntersectKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114 && (tok.charAt(5) | 0x20) == 115 && (tok.charAt(6) | 0x20) == 101 && (tok.charAt(7) | 0x20) == 99 && (tok.charAt(8) | 0x20) == 116;
    }

    public static boolean isIntervalKeyword(CharSequence tok) {
        return tok.length() == 8 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114 && (tok.charAt(5) | 0x20) == 118 && (tok.charAt(6) | 0x20) == 97 && (tok.charAt(7) | 0x20) == 108;
    }

    public static boolean isIntoKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 111;
    }

    public static boolean isIsKeyword(CharSequence tok) {
        return tok.length() == 2 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 115;
    }

    public static boolean isIsoDowKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 115 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 100 && (tok.charAt(4) | 0x20) == 111 && (tok.charAt(5) | 0x20) == 119;
    }

    public static boolean isIsoYearKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 115 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 121 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 97 && (tok.charAt(6) | 0x20) == 114;
    }

    public static boolean isIsolationKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 105 && (tok.charAt(1) | 0x20) == 115 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 97 && (tok.charAt(5) | 0x20) == 116 && (tok.charAt(6) | 0x20) == 105 && (tok.charAt(7) | 0x20) == 111 && (tok.charAt(8) | 0x20) == 110;
    }

    public static boolean isJsonExtract(CharSequence tok) {
        return tok.length() == 12 && (tok.charAt(0) | 0x20) == 106 && (tok.charAt(1) | 0x20) == 115 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 110 && tok.charAt(4) == '_' && (tok.charAt(5) | 0x20) == 101 && (tok.charAt(6) | 0x20) == 120 && (tok.charAt(7) | 0x20) == 116 && (tok.charAt(8) | 0x20) == 114 && (tok.charAt(9) | 0x20) == 97 && (tok.charAt(10) | 0x20) == 99 && (tok.charAt(11) | 0x20) == 116;
    }

    public static boolean isJsonKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 106 && (tok.charAt(1) | 0x20) == 115 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 110;
    }

    public static boolean isKeepKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 107 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 101 && (tok.charAt(3) | 0x20) == 112;
    }

    public static boolean isKeysKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 107 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 121 && (tok.charAt(3) | 0x20) == 115;
    }

    public static boolean isKeyword(CharSequence text) {
        if (text != null) {
            return KEYWORDS.contains(text);
        }
        return false;
    }

    public static boolean isLastKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 108 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 116;
    }

    public static boolean isLatestKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 108 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 115 && (tok.charAt(5) | 0x20) == 116;
    }

    public static boolean isLeftKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 108 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 102 && (tok.charAt(3) | 0x20) == 116;
    }

    public static boolean isLengthKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 108 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 103 && (tok.charAt(4) | 0x20) == 116 && (tok.charAt(5) | 0x20) == 104;
    }

    public static boolean isLevelKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 108 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 118 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 108;
    }

    public static boolean isLikeKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 108 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 107 && (tok.charAt(3) | 0x20) == 101;
    }

    public static boolean isLimitKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 108 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 109 && (tok.charAt(3) | 0x20) == 105 && (tok.charAt(4) | 0x20) == 116;
    }

    public static boolean isLinearKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 108 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 97 && (tok.charAt(5) | 0x20) == 114;
    }

    public static boolean isListKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 108 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 116;
    }

    public static boolean isLockKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 108 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 107;
    }

    public static boolean isManualKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 97 && (tok.charAt(5) | 0x20) == 108;
    }

    public static boolean isMapsKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 112 && (tok.charAt(3) | 0x20) == 115;
    }

    public static boolean isMaterializedKeyword(CharSequence tok) {
        return tok.length() == 12 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114 && (tok.charAt(5) | 0x20) == 105 && (tok.charAt(6) | 0x20) == 97 && (tok.charAt(7) | 0x20) == 108 && (tok.charAt(8) | 0x20) == 105 && (tok.charAt(9) | 0x20) == 122 && (tok.charAt(10) | 0x20) == 101 && (tok.charAt(11) | 0x20) == 100;
    }

    public static boolean isMaxIdentifierLength(CharSequence tok) {
        return tok.length() == 21 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 120 && tok.charAt(3) == '_' && (tok.charAt(4) | 0x20) == 105 && (tok.charAt(5) | 0x20) == 100 && (tok.charAt(6) | 0x20) == 101 && (tok.charAt(7) | 0x20) == 110 && (tok.charAt(8) | 0x20) == 116 && (tok.charAt(9) | 0x20) == 105 && (tok.charAt(10) | 0x20) == 102 && (tok.charAt(11) | 0x20) == 105 && (tok.charAt(12) | 0x20) == 101 && (tok.charAt(13) | 0x20) == 114 && tok.charAt(14) == '_' && (tok.charAt(15) | 0x20) == 108 && (tok.charAt(16) | 0x20) == 101 && (tok.charAt(17) | 0x20) == 110 && (tok.charAt(18) | 0x20) == 103 && (tok.charAt(19) | 0x20) == 116 && (tok.charAt(20) | 0x20) == 104;
    }

    public static boolean isMaxUncommittedRowsKeyword(CharSequence tok) {
        return tok.length() == 18 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 120 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 110 && (tok.charAt(5) | 0x20) == 99 && (tok.charAt(6) | 0x20) == 111 && (tok.charAt(7) | 0x20) == 109 && (tok.charAt(8) | 0x20) == 109 && (tok.charAt(9) | 0x20) == 105 && (tok.charAt(10) | 0x20) == 116 && (tok.charAt(11) | 0x20) == 116 && (tok.charAt(12) | 0x20) == 101 && (tok.charAt(13) | 0x20) == 100 && (tok.charAt(14) | 0x20) == 114 && (tok.charAt(15) | 0x20) == 111 && (tok.charAt(16) | 0x20) == 119 && (tok.charAt(17) | 0x20) == 115;
    }

    public static boolean isMicrosecondKeyword(CharSequence tok) {
        return tok.length() == 11 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 111 && (tok.charAt(5) | 0x20) == 115 && (tok.charAt(6) | 0x20) == 101 && (tok.charAt(7) | 0x20) == 99 && (tok.charAt(8) | 0x20) == 111 && (tok.charAt(9) | 0x20) == 110 && (tok.charAt(10) | 0x20) == 100;
    }

    public static boolean isMicrosecondsKeyword(CharSequence tok) {
        return tok.length() == 12 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 111 && (tok.charAt(5) | 0x20) == 115 && (tok.charAt(6) | 0x20) == 101 && (tok.charAt(7) | 0x20) == 99 && (tok.charAt(8) | 0x20) == 111 && (tok.charAt(9) | 0x20) == 110 && (tok.charAt(10) | 0x20) == 100 && (tok.charAt(11) | 0x20) == 115;
    }

    public static boolean isMillenniumKeyword(CharSequence tok) {
        return tok.length() == 10 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 110 && (tok.charAt(6) | 0x20) == 110 && (tok.charAt(7) | 0x20) == 105 && (tok.charAt(8) | 0x20) == 117 && (tok.charAt(9) | 0x20) == 109;
    }

    public static boolean isMillisecondKeyword(CharSequence tok) {
        return tok.length() == 11 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 105 && (tok.charAt(5) | 0x20) == 115 && (tok.charAt(6) | 0x20) == 101 && (tok.charAt(7) | 0x20) == 99 && (tok.charAt(8) | 0x20) == 111 && (tok.charAt(9) | 0x20) == 110 && (tok.charAt(10) | 0x20) == 100;
    }

    public static boolean isMillisecondsKeyword(CharSequence tok) {
        return tok.length() == 12 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 105 && (tok.charAt(5) | 0x20) == 115 && (tok.charAt(6) | 0x20) == 101 && (tok.charAt(7) | 0x20) == 99 && (tok.charAt(8) | 0x20) == 111 && (tok.charAt(9) | 0x20) == 110 && (tok.charAt(10) | 0x20) == 100 && (tok.charAt(11) | 0x20) == 115;
    }

    public static boolean isMinuteKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 116 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isMinutesKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 116 && (tok.charAt(5) | 0x20) == 101 && (tok.charAt(6) | 0x20) == 115;
    }

    public static boolean isMonthKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 109 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 116 && (tok.charAt(4) | 0x20) == 104;
    }

    public static boolean isNanKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 110 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 110;
    }

    public static boolean isNativeKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 110 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 105 && (tok.charAt(4) | 0x20) == 118 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isNoCacheKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 110 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 99 && (tok.charAt(5) | 0x20) == 104 && (tok.charAt(6) | 0x20) == 101;
    }

    public static boolean isNoKeyword(CharSequence tok) {
        return tok.length() == 2 && (tok.charAt(0) | 0x20) == 110 && (tok.charAt(1) | 0x20) == 111;
    }

    public static boolean isNoneKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 110 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 101;
    }

    public static boolean isNotJoinKeyword(CharSequence tok) {
        return tok.length() != 4 || (tok.charAt(0) | 0x20) != 106 || (tok.charAt(1) | 0x20) != 111 || (tok.charAt(2) | 0x20) != 105 || (tok.charAt(3) | 0x20) != 110;
    }

    public static boolean isNotKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 110 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 116;
    }

    public static boolean isNullKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 110 && (tok.charAt(1) | 0x20) == 117 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 108;
    }

    public static boolean isNullKeyword(Utf8Sequence tok) {
        return tok.size() == 4 && (tok.byteAt(0) | 0x20) == 110 && (tok.byteAt(1) | 0x20) == 117 && (tok.byteAt(2) | 0x20) == 108 && (tok.byteAt(3) | 0x20) == 108;
    }

    public static boolean isNullsWord(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 110 && (tok.charAt(1) | 0x20) == 117 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 115;
    }

    public static boolean isO3MaxLagKeyword(CharSequence tok) {
        return tok.length() == 8 && (tok.charAt(0) | 0x20) == 111 && (tok.charAt(1) | 0x20) == 51 && (tok.charAt(2) | 0x20) == 109 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 120 && (tok.charAt(5) | 0x20) == 108 && (tok.charAt(6) | 0x20) == 97 && (tok.charAt(7) | 0x20) == 103;
    }

    public static boolean isObservationKeyword(CharSequence tok) {
        return tok.length() == 11 && (tok.charAt(0) | 0x20) == 111 && (tok.charAt(1) | 0x20) == 98 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114 && (tok.charAt(5) | 0x20) == 118 && (tok.charAt(6) | 0x20) == 97 && (tok.charAt(7) | 0x20) == 116 && (tok.charAt(8) | 0x20) == 105 && (tok.charAt(9) | 0x20) == 111 && (tok.charAt(10) | 0x20) == 110;
    }

    public static boolean isOffsetKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 111 && (tok.charAt(1) | 0x20) == 102 && (tok.charAt(2) | 0x20) == 102 && (tok.charAt(3) | 0x20) == 115 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 116;
    }

    public static boolean isOnKeyword(CharSequence tok) {
        return tok.length() == 2 && (tok.charAt(0) | 0x20) == 111 && (tok.charAt(1) | 0x20) == 110;
    }

    public static boolean isOnlyKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 111 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 121;
    }

    public static boolean isOrKeyword(CharSequence tok) {
        return tok.length() == 2 && (tok.charAt(0) | 0x20) == 111 && (tok.charAt(1) | 0x20) == 114;
    }

    public static boolean isOrderKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 111 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 100 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114;
    }

    public static boolean isOthersKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 111 && (tok.charAt(1) | 0x20) == 116 && (tok.charAt(2) | 0x20) == 104 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114 && (tok.charAt(5) | 0x20) == 115;
    }

    public static boolean isOuterKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 111 && (tok.charAt(1) | 0x20) == 117 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114;
    }

    public static boolean isOverKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 111 && (tok.charAt(1) | 0x20) == 118 && (tok.charAt(2) | 0x20) == 101 && (tok.charAt(3) | 0x20) == 114;
    }

    public static boolean isParamKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 112 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 109;
    }

    public static boolean isParametersKeyword(CharSequence tok) {
        if (tok.length() != 10) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 112 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i++) | 0x20) == 97 && (tok.charAt(i++) | 0x20) == 109 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 116 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i) | 0x20) == 115;
    }

    public static boolean isParquetKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 112 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 113 && (tok.charAt(4) | 0x20) == 117 && (tok.charAt(5) | 0x20) == 101 && (tok.charAt(6) | 0x20) == 116;
    }

    public static boolean isPartitionKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 112 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 116 && (tok.charAt(4) | 0x20) == 105 && (tok.charAt(5) | 0x20) == 116 && (tok.charAt(6) | 0x20) == 105 && (tok.charAt(7) | 0x20) == 111 && (tok.charAt(8) | 0x20) == 110;
    }

    public static boolean isPartitionsKeyword(CharSequence tok) {
        return tok.length() == 10 && (tok.charAt(0) | 0x20) == 112 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 116 && (tok.charAt(4) | 0x20) == 105 && (tok.charAt(5) | 0x20) == 116 && (tok.charAt(6) | 0x20) == 105 && (tok.charAt(7) | 0x20) == 111 && (tok.charAt(8) | 0x20) == 110 && (tok.charAt(9) | 0x20) == 115;
    }

    public static boolean isPeriodKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 112 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 105 && (tok.charAt(4) | 0x20) == 111 && (tok.charAt(5) | 0x20) == 100;
    }

    public static boolean isPrecedingKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 112 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 101 && (tok.charAt(3) | 0x20) == 99 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 100 && (tok.charAt(6) | 0x20) == 105 && (tok.charAt(7) | 0x20) == 110 && (tok.charAt(8) | 0x20) == 103;
    }

    public static boolean isPrecisionKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 112 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 101 && (tok.charAt(3) | 0x20) == 99 && (tok.charAt(4) | 0x20) == 105 && (tok.charAt(5) | 0x20) == 115 && (tok.charAt(6) | 0x20) == 105 && (tok.charAt(7) | 0x20) == 111 && (tok.charAt(8) | 0x20) == 110;
    }

    public static boolean isPrevKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 112 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 101 && (tok.charAt(3) | 0x20) == 118;
    }

    public static boolean isPublicKeyword(CharSequence tok, int len) {
        return SqlKeywords.isPublicKeyword(tok, 0, len);
    }

    public static boolean isPublicKeyword(CharSequence tok, int lo, int hi) {
        int len = hi - lo;
        return len == 6 && (tok.charAt(lo) | 0x20) == 112 && (tok.charAt(lo + 1) | 0x20) == 117 && (tok.charAt(lo + 2) | 0x20) == 98 && (tok.charAt(lo + 3) | 0x20) == 108 && (tok.charAt(lo + 4) | 0x20) == 105 && (tok.charAt(lo + 5) | 0x20) == 99;
    }

    public static boolean isQuarterKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 113 && (tok.charAt(1) | 0x20) == 117 && (tok.charAt(2) | 0x20) == 97 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 116 && (tok.charAt(5) | 0x20) == 101 && (tok.charAt(6) | 0x20) == 114;
    }

    public static boolean isQueryKeyword(CharSequence tok) {
        if (tok.length() != 5) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 113 && (tok.charAt(i++) | 0x20) == 117 && (tok.charAt(i++) | 0x20) == 101 && (tok.charAt(i++) | 0x20) == 114 && (tok.charAt(i) | 0x20) == 121;
    }

    public static boolean isQuote(CharSequence tok) {
        return tok.length() == 1 && tok.charAt(0) == '\'';
    }

    public static boolean isRangeKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 114 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 103 && (tok.charAt(4) | 0x20) == 101;
    }

    public static boolean isRefreshKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 114 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 102 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 115 && (tok.charAt(6) | 0x20) == 104;
    }

    public static boolean isRenameKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 114 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 109 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isRespectWord(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 114 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 112 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 99 && (tok.charAt(6) | 0x20) == 116;
    }

    public static boolean isResumeKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 114 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 109 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isRightKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 114 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 103 && (tok.charAt(3) | 0x20) == 104 && (tok.charAt(4) | 0x20) == 116;
    }

    public static boolean isRowKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 114 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 119;
    }

    public static boolean isRowsKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 114 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 119 && (tok.charAt(3) | 0x20) == 115;
    }

    public static boolean isSampleKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 109 && (tok.charAt(3) | 0x20) == 112 && (tok.charAt(4) | 0x20) == 108 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isSearchPath(CharSequence tok) {
        return tok.length() == 11 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 97 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 99 && (tok.charAt(5) | 0x20) == 104 && tok.charAt(6) == '_' && (tok.charAt(7) | 0x20) == 112 && (tok.charAt(8) | 0x20) == 97 && (tok.charAt(9) | 0x20) == 116 && (tok.charAt(10) | 0x20) == 104;
    }

    public static boolean isSecondKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 111 && (tok.charAt(4) | 0x20) == 110 && (tok.charAt(5) | 0x20) == 100;
    }

    public static boolean isSecondsKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 99 && (tok.charAt(3) | 0x20) == 111 && (tok.charAt(4) | 0x20) == 110 && (tok.charAt(5) | 0x20) == 100 && (tok.charAt(6) | 0x20) == 115;
    }

    public static boolean isSelectKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 99 && (tok.charAt(5) | 0x20) == 116;
    }

    public static boolean isSemicolon(CharSequence token) {
        return token.length() == 1 && token.charAt(0) == ';';
    }

    public static boolean isServerVersionKeyword(CharSequence tok) {
        return tok.length() == 14 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 118 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 114 && tok.charAt(6) == '_' && (tok.charAt(7) | 0x20) == 118 && (tok.charAt(8) | 0x20) == 101 && (tok.charAt(9) | 0x20) == 114 && (tok.charAt(10) | 0x20) == 115 && (tok.charAt(11) | 0x20) == 105 && (tok.charAt(12) | 0x20) == 111 && (tok.charAt(13) | 0x20) == 110;
    }

    public static boolean isServerVersionNumKeyword(CharSequence tok) {
        return tok.length() == 18 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 114 && (tok.charAt(3) | 0x20) == 118 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 114 && tok.charAt(6) == '_' && (tok.charAt(7) | 0x20) == 118 && (tok.charAt(8) | 0x20) == 101 && (tok.charAt(9) | 0x20) == 114 && (tok.charAt(10) | 0x20) == 115 && (tok.charAt(11) | 0x20) == 105 && (tok.charAt(12) | 0x20) == 111 && (tok.charAt(13) | 0x20) == 110 && tok.charAt(14) == '_' && (tok.charAt(15) | 0x20) == 110 && (tok.charAt(16) | 0x20) == 117 && (tok.charAt(17) | 0x20) == 109;
    }

    public static boolean isSetKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 116;
    }

    public static boolean isShowKeyword(CharSequence tok) {
        if (tok.length() != 4) {
            return false;
        }
        int i = 0;
        return (tok.charAt(i++) | 0x20) == 115 && (tok.charAt(i++) | 0x20) == 104 && (tok.charAt(i++) | 0x20) == 111 && (tok.charAt(i) | 0x20) == 119;
    }

    public static boolean isSquashKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 113 && (tok.charAt(2) | 0x20) == 117 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 115 && (tok.charAt(5) | 0x20) == 104;
    }

    public static boolean isStandardConformingStrings(CharSequence tok) {
        return tok.length() == 27 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 116 && (tok.charAt(2) | 0x20) == 97 && (tok.charAt(3) | 0x20) == 110 && (tok.charAt(4) | 0x20) == 100 && (tok.charAt(5) | 0x20) == 97 && (tok.charAt(6) | 0x20) == 114 && (tok.charAt(7) | 0x20) == 100 && tok.charAt(8) == '_' && (tok.charAt(9) | 0x20) == 99 && (tok.charAt(10) | 0x20) == 111 && (tok.charAt(11) | 0x20) == 110 && (tok.charAt(12) | 0x20) == 102 && (tok.charAt(13) | 0x20) == 111 && (tok.charAt(14) | 0x20) == 114 && (tok.charAt(15) | 0x20) == 109 && (tok.charAt(16) | 0x20) == 105 && (tok.charAt(17) | 0x20) == 110 && (tok.charAt(18) | 0x20) == 103 && tok.charAt(19) == '_' && (tok.charAt(20) | 0x20) == 115 && (tok.charAt(21) | 0x20) == 116 && (tok.charAt(22) | 0x20) == 114 && (tok.charAt(23) | 0x20) == 105 && (tok.charAt(24) | 0x20) == 110 && (tok.charAt(25) | 0x20) == 103 && (tok.charAt(26) | 0x20) == 115;
    }

    public static boolean isStartKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 116 && (tok.charAt(2) | 0x20) == 97 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 116;
    }

    public static boolean isSumKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 117 && (tok.charAt(2) | 0x20) == 109;
    }

    public static boolean isSuspendKeyword(CharSequence tok) {
        return tok.length() == 7 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 117 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 112 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 110 && (tok.charAt(6) | 0x20) == 100;
    }

    public static boolean isSymbolKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 115 && (tok.charAt(1) | 0x20) == 121 && (tok.charAt(2) | 0x20) == 109 && (tok.charAt(3) | 0x20) == 98 && (tok.charAt(4) | 0x20) == 111 && (tok.charAt(5) | 0x20) == 108;
    }

    public static boolean isTableKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 98 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 101;
    }

    public static boolean isTablesKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 98 && (tok.charAt(3) | 0x20) == 108 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 115;
    }

    public static boolean isTextKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 120 && (tok.charAt(3) | 0x20) == 116;
    }

    public static boolean isTiesKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 101 && (tok.charAt(3) | 0x20) == 115;
    }

    public static boolean isTimeKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 109 && (tok.charAt(3) | 0x20) == 101;
    }

    public static boolean isTimestampKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 109 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 115 && (tok.charAt(5) | 0x20) == 116 && (tok.charAt(6) | 0x20) == 97 && (tok.charAt(7) | 0x20) == 109 && (tok.charAt(8) | 0x20) == 112;
    }

    public static boolean isToKeyword(CharSequence tok) {
        return tok.length() == 2 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 111;
    }

    public static boolean isToleranceKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114 && (tok.charAt(5) | 0x20) == 97 && (tok.charAt(6) | 0x20) == 110 && (tok.charAt(7) | 0x20) == 99 && (tok.charAt(8) | 0x20) == 101;
    }

    public static boolean isTransactionIsolation(CharSequence tok) {
        return tok.length() == 21 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 97 && (tok.charAt(3) | 0x20) == 110 && (tok.charAt(4) | 0x20) == 115 && (tok.charAt(5) | 0x20) == 97 && (tok.charAt(6) | 0x20) == 99 && (tok.charAt(7) | 0x20) == 116 && (tok.charAt(8) | 0x20) == 105 && (tok.charAt(9) | 0x20) == 111 && (tok.charAt(10) | 0x20) == 110 && tok.charAt(11) == '_' && (tok.charAt(12) | 0x20) == 105 && (tok.charAt(13) | 0x20) == 115 && (tok.charAt(14) | 0x20) == 111 && (tok.charAt(15) | 0x20) == 108 && (tok.charAt(16) | 0x20) == 97 && (tok.charAt(17) | 0x20) == 116 && (tok.charAt(18) | 0x20) == 105 && (tok.charAt(19) | 0x20) == 111 && (tok.charAt(20) | 0x20) == 110;
    }

    public static boolean isTransactionKeyword(CharSequence tok) {
        return tok.length() == 11 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 97 && (tok.charAt(3) | 0x20) == 110 && (tok.charAt(4) | 0x20) == 115 && (tok.charAt(5) | 0x20) == 97 && (tok.charAt(6) | 0x20) == 99 && (tok.charAt(7) | 0x20) == 116 && (tok.charAt(8) | 0x20) == 105 && (tok.charAt(9) | 0x20) == 111 && (tok.charAt(10) | 0x20) == 110;
    }

    public static boolean isTrueKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 114 && (tok.charAt(2) | 0x20) == 117 && (tok.charAt(3) | 0x20) == 101;
    }

    public static boolean isTrueKeyword(Utf8Sequence tok) {
        return tok.size() == 4 && (tok.byteAt(0) | 0x20) == 116 && (tok.byteAt(1) | 0x20) == 114 && (tok.byteAt(2) | 0x20) == 117 && (tok.byteAt(3) | 0x20) == 101;
    }

    public static boolean isTtlKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 116 && (tok.charAt(2) | 0x20) == 108;
    }

    public static boolean isTxnKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 120 && (tok.charAt(2) | 0x20) == 110;
    }

    public static boolean isTypeKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 116 && (tok.charAt(1) | 0x20) == 121 && (tok.charAt(2) | 0x20) == 112 && (tok.charAt(3) | 0x20) == 101;
    }

    public static boolean isUTC(CharSequence tok) {
        return tok.length() == 5 && tok.charAt(0) == '\'' && (tok.charAt(1) | 0x20) == 117 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 99 && tok.charAt(4) == '\'';
    }

    public static boolean isUnboundedKeyword(CharSequence tok) {
        return tok.length() == 9 && (tok.charAt(0) | 0x20) == 117 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 98 && (tok.charAt(3) | 0x20) == 111 && (tok.charAt(4) | 0x20) == 117 && (tok.charAt(5) | 0x20) == 110 && (tok.charAt(6) | 0x20) == 100 && (tok.charAt(7) | 0x20) == 101 && (tok.charAt(8) | 0x20) == 100;
    }

    public static boolean isUnionKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 117 && (tok.charAt(1) | 0x20) == 110 && (tok.charAt(2) | 0x20) == 105 && (tok.charAt(3) | 0x20) == 111 && (tok.charAt(4) | 0x20) == 110;
    }

    public static boolean isUpdateKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 117 && (tok.charAt(1) | 0x20) == 112 && (tok.charAt(2) | 0x20) == 100 && (tok.charAt(3) | 0x20) == 97 && (tok.charAt(4) | 0x20) == 116 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isUpsertKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 117 && (tok.charAt(1) | 0x20) == 112 && (tok.charAt(2) | 0x20) == 115 && (tok.charAt(3) | 0x20) == 101 && (tok.charAt(4) | 0x20) == 114 && (tok.charAt(5) | 0x20) == 116;
    }

    public static boolean isValuesKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 118 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 101 && (tok.charAt(5) | 0x20) == 115;
    }

    public static boolean isViewKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 118 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 101 && (tok.charAt(3) | 0x20) == 119;
    }

    public static boolean isVolumeKeyword(CharSequence tok) {
        return tok.length() == 6 && (tok.charAt(0) | 0x20) == 118 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 108 && (tok.charAt(3) | 0x20) == 117 && (tok.charAt(4) | 0x20) == 109 && (tok.charAt(5) | 0x20) == 101;
    }

    public static boolean isWalKeyword(CharSequence tok) {
        return tok.length() == 3 && (tok.charAt(0) | 0x20) == 119 && (tok.charAt(1) | 0x20) == 97 && (tok.charAt(2) | 0x20) == 108;
    }

    public static boolean isWeekKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 119 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 101 && (tok.charAt(3) | 0x20) == 107;
    }

    public static boolean isWhereKeyword(CharSequence tok) {
        return tok.length() == 5 && (tok.charAt(0) | 0x20) == 119 && (tok.charAt(1) | 0x20) == 104 && (tok.charAt(2) | 0x20) == 101 && (tok.charAt(3) | 0x20) == 114 && (tok.charAt(4) | 0x20) == 101;
    }

    public static boolean isWithKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 119 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 104;
    }

    public static boolean isWithinKeyword(CharSequence tok) {
        return tok != null && tok.length() == 6 && (tok.charAt(0) | 0x20) == 119 && (tok.charAt(1) | 0x20) == 105 && (tok.charAt(2) | 0x20) == 116 && (tok.charAt(3) | 0x20) == 104 && (tok.charAt(4) | 0x20) == 105 && (tok.charAt(5) | 0x20) == 110;
    }

    public static boolean isYearKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 121 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 97 && (tok.charAt(3) | 0x20) == 114;
    }

    public static boolean isZeroOffset(CharSequence tok) {
        return tok.length() == 7 && tok.charAt(0) == '\'' && tok.charAt(1) == '0' && tok.charAt(2) == '0' && tok.charAt(3) == ':' && tok.charAt(4) == '0' && tok.charAt(5) == '0' && tok.charAt(6) == '\'';
    }

    public static boolean isZoneKeyword(CharSequence tok) {
        return tok.length() == 4 && (tok.charAt(0) | 0x20) == 122 && (tok.charAt(1) | 0x20) == 111 && (tok.charAt(2) | 0x20) == 110 && (tok.charAt(3) | 0x20) == 101;
    }

    public static boolean startsWithGeoHashKeyword(CharSequence tok) {
        return tok.length() >= 7 && SqlKeywords.isGeoHashKeywordInternal(tok);
    }

    public static boolean validateExtractPart(CharSequence token) {
        return TIMESTAMP_PART_SET.contains(token);
    }

    public static void validateLiteral(int pos, CharSequence tok) throws SqlException {
        switch (tok.charAt(0)) {
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case ';': 
            case '`': {
                throw SqlException.position(pos).put("literal expected");
            }
        }
    }

    private static boolean isGeoHashKeywordInternal(CharSequence tok) {
        return (tok.charAt(0) | 0x20) == 103 && (tok.charAt(1) | 0x20) == 101 && (tok.charAt(2) | 0x20) == 111 && (tok.charAt(3) | 0x20) == 104 && (tok.charAt(4) | 0x20) == 97 && (tok.charAt(5) | 0x20) == 115 && (tok.charAt(6) | 0x20) == 104;
    }

    static void assertNameIsQuotedOrNotAKeyword(CharSequence keyword, int position) throws SqlException {
        boolean quoted = Chars.isQuoted(keyword);
        if (!quoted && SqlKeywords.isKeyword(keyword)) {
            throw SqlException.$(position, "table and column names that are SQL keywords have to be enclosed in double quotes, such as \"").put(keyword).put('\"');
        }
    }

    static {
        TIMESTAMP_PART_SET.add("microseconds");
        TIMESTAMP_PART_SET.add("milliseconds");
        TIMESTAMP_PART_SET.add("second");
        TIMESTAMP_PART_SET.add("minute");
        TIMESTAMP_PART_SET.add("hour");
        TIMESTAMP_PART_SET.add("day");
        TIMESTAMP_PART_SET.add("doy");
        TIMESTAMP_PART_SET.add("dow");
        TIMESTAMP_PART_SET.add("week");
        TIMESTAMP_PART_SET.add("month");
        TIMESTAMP_PART_SET.add("quarter");
        TIMESTAMP_PART_SET.add("year");
        TIMESTAMP_PART_SET.add("isoyear");
        TIMESTAMP_PART_SET.add("isodow");
        TIMESTAMP_PART_SET.add("decade");
        TIMESTAMP_PART_SET.add("century");
        TIMESTAMP_PART_SET.add("millennium");
        TIMESTAMP_PART_SET.add("epoch");
        KEYWORDS.add("add");
        KEYWORDS.add("align");
        KEYWORDS.add("all");
        KEYWORDS.add("alter");
        KEYWORDS.add("and");
        KEYWORDS.add("asc");
        KEYWORDS.add("as");
        KEYWORDS.add("attach");
        KEYWORDS.add("batch");
        KEYWORDS.add("between");
        KEYWORDS.add("bypass");
        KEYWORDS.add("cancel");
        KEYWORDS.add("case");
        KEYWORDS.add("cast");
        KEYWORDS.add("column");
        KEYWORDS.add("create");
        KEYWORDS.add("desc");
        KEYWORDS.add("detach");
        KEYWORDS.add("disable");
        KEYWORDS.add("distinct");
        KEYWORDS.add("drop");
        KEYWORDS.add("enable");
        KEYWORDS.add("end");
        KEYWORDS.add("except");
        KEYWORDS.add("exists");
        KEYWORDS.add("explain");
        KEYWORDS.add("false");
        KEYWORDS.add("from");
        KEYWORDS.add("in");
        KEYWORDS.add("insert");
        KEYWORDS.add("intersect");
        KEYWORDS.add("into");
        KEYWORDS.add("like");
        KEYWORDS.add("limit");
        KEYWORDS.add("lock");
        KEYWORDS.add("nan");
        KEYWORDS.add("join");
        KEYWORDS.add("not");
        KEYWORDS.add("null");
        KEYWORDS.add("on");
        KEYWORDS.add("order");
        KEYWORDS.add("or");
        KEYWORDS.add("outer");
        KEYWORDS.add("over");
        KEYWORDS.add("partition");
        KEYWORDS.add("rename");
        KEYWORDS.add("resume");
        KEYWORDS.add("sample");
        KEYWORDS.add("select");
        KEYWORDS.add("set");
        KEYWORDS.add("squash");
        KEYWORDS.add("table");
        KEYWORDS.add("to");
        KEYWORDS.add("true");
        KEYWORDS.add("union");
        KEYWORDS.add("update");
        KEYWORDS.add("upsert");
        KEYWORDS.add("values");
        KEYWORDS.add("where");
        KEYWORDS.add("within");
        KEYWORDS.add("with");
    }
}

