/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.ExpressionParser;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.ExpressionTreeBuilder;
import io.questdb.griffin.GeoHashUtil;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SqlParserCallback;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.json.JsonExtractTypedFunctionFactory;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.griffin.engine.groupby.TimestampSamplerFactory;
import io.questdb.griffin.engine.ops.CreateMatViewOperationBuilder;
import io.questdb.griffin.engine.ops.CreateMatViewOperationBuilderImpl;
import io.questdb.griffin.engine.ops.CreateTableOperationBuilder;
import io.questdb.griffin.engine.ops.CreateTableOperationBuilderImpl;
import io.questdb.griffin.model.CopyModel;
import io.questdb.griffin.model.CreateTableColumnModel;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExplainModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.InsertModel;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.RenameTableModel;
import io.questdb.griffin.model.WindowColumn;
import io.questdb.griffin.model.WithClauseModel;
import io.questdb.std.BufferWindowCharSequence;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseAsciiCharSequenceHashSet;
import io.questdb.std.LowerCaseAsciiCharSequenceIntHashMap;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Os;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlParser {
    public static final int MAX_ORDER_BY_COLUMNS = 1560;
    public static final ExpressionNode ZERO_OFFSET = ExpressionNode.FACTORY.newInstance().of(4, "'00:00'", 0, 0);
    private static final ExpressionNode ONE = ExpressionNode.FACTORY.newInstance().of(4, "1", 0, 0);
    private static final LowerCaseAsciiCharSequenceHashSet columnAliasStop = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceHashSet groupByStopSet = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceIntHashMap joinStartSet = new LowerCaseAsciiCharSequenceIntHashMap();
    private static final LowerCaseAsciiCharSequenceHashSet setOperations = new LowerCaseAsciiCharSequenceHashSet();
    private static final LowerCaseAsciiCharSequenceHashSet tableAliasStop = new LowerCaseAsciiCharSequenceHashSet();
    private static final IntList tableNamePositions = new IntList();
    private static final LowerCaseCharSequenceHashSet tableNames = new LowerCaseCharSequenceHashSet();
    private final IntList accumulatedColumnPositions = new IntList();
    private final ObjList<QueryColumn> accumulatedColumns = new ObjList();
    private final LowerCaseCharSequenceObjHashMap<QueryColumn> aliasMap = new LowerCaseCharSequenceObjHashMap();
    private final CharacterStore characterStore;
    private final CharSequence column;
    private final CairoConfiguration configuration;
    private final ObjectPool<CopyModel> copyModelPool;
    private final CreateMatViewOperationBuilderImpl createMatViewOperationBuilder = new CreateMatViewOperationBuilderImpl();
    private final ObjectPool<CreateTableColumnModel> createTableColumnModelPool;
    private final CreateTableOperationBuilderImpl createTableOperationBuilder = this.createMatViewOperationBuilder.getCreateTableOperationBuilder();
    private final ObjectPool<ExplainModel> explainModelPool;
    private final ObjectPool<ExpressionNode> expressionNodePool;
    private final ExpressionParser expressionParser;
    private final ExpressionTreeBuilder expressionTreeBuilder;
    private final ObjectPool<InsertModel> insertModelPool;
    private final ObjectPool<QueryColumn> queryColumnPool;
    private final ObjectPool<QueryModel> queryModelPool;
    private final ObjectPool<RenameTableModel> renameTableModelPool;
    private final PostOrderTreeTraversalAlgo.Visitor rewriteConcatRef = this::rewriteConcat;
    private final PostOrderTreeTraversalAlgo.Visitor rewriteCountRef = this::rewriteCount;
    private final RewriteDeclaredVariablesInExpressionVisitor rewriteDeclaredVariablesInExpressionVisitor = new RewriteDeclaredVariablesInExpressionVisitor();
    private final PostOrderTreeTraversalAlgo.Visitor rewriteJsonExtractCastRef = this::rewriteJsonExtractCast;
    private final PostOrderTreeTraversalAlgo.Visitor rewritePgCastRef = this::rewritePgCast;
    private final ObjList<ExpressionNode> tempExprNodes = new ObjList();
    private final PostOrderTreeTraversalAlgo.Visitor rewriteCaseRef = this::rewriteCase;
    private final LowerCaseCharSequenceObjHashMap<WithClauseModel> topLevelWithModel = new LowerCaseCharSequenceObjHashMap();
    private final PostOrderTreeTraversalAlgo traversalAlgo;
    private final ObjectPool<WindowColumn> windowColumnPool;
    private final ObjectPool<WithClauseModel> withClauseModelPool;
    private int digit;
    private boolean overClauseMode = false;
    private boolean subQueryMode = false;

    SqlParser(CairoConfiguration configuration, CharacterStore characterStore, ObjectPool<ExpressionNode> expressionNodePool, ObjectPool<QueryColumn> queryColumnPool, ObjectPool<QueryModel> queryModelPool, PostOrderTreeTraversalAlgo traversalAlgo) {
        this.expressionNodePool = expressionNodePool;
        this.queryModelPool = queryModelPool;
        this.queryColumnPool = queryColumnPool;
        this.expressionTreeBuilder = new ExpressionTreeBuilder();
        this.windowColumnPool = new ObjectPool<WindowColumn>(WindowColumn.FACTORY, configuration.getWindowColumnPoolCapacity());
        this.createTableColumnModelPool = new ObjectPool<CreateTableColumnModel>(CreateTableColumnModel.FACTORY, configuration.getCreateTableColumnModelPoolCapacity());
        this.renameTableModelPool = new ObjectPool<RenameTableModel>(RenameTableModel.FACTORY, configuration.getRenameTableModelPoolCapacity());
        this.withClauseModelPool = new ObjectPool<WithClauseModel>(WithClauseModel.FACTORY, configuration.getWithClauseModelPoolCapacity());
        this.insertModelPool = new ObjectPool<InsertModel>(InsertModel.FACTORY, configuration.getInsertModelPoolCapacity());
        this.copyModelPool = new ObjectPool<CopyModel>(CopyModel.FACTORY, configuration.getCopyPoolCapacity());
        this.explainModelPool = new ObjectPool<ExplainModel>(ExplainModel.FACTORY, configuration.getExplainPoolCapacity());
        this.configuration = configuration;
        this.traversalAlgo = traversalAlgo;
        this.characterStore = characterStore;
        boolean tempCairoSqlLegacyOperatorPrecedence = configuration.getCairoSqlLegacyOperatorPrecedence();
        this.expressionParser = tempCairoSqlLegacyOperatorPrecedence ? new ExpressionParser(OperatorExpression.getLegacyRegistry(), OperatorExpression.getRegistry(), expressionNodePool, this, characterStore) : new ExpressionParser(OperatorExpression.getRegistry(), null, expressionNodePool, this, characterStore);
        this.digit = 1;
        this.column = "column";
    }

    public static boolean isFullSampleByPeriod(ExpressionNode n) {
        return n != null && (n.type == 4 || n.type == 7 && SqlParser.isValidSampleByPeriodLetter(n.token));
    }

    public static int parseTtlHoursOrMonths(GenericLexer lexer) throws SqlException {
        int ttlValue;
        int valuePos = lexer.getPosition();
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null || Chars.equals(tok, ';')) {
            throw SqlException.$(lexer.getPosition(), "missing argument, should be <number> <unit> or <number_with_unit>");
        }
        int tokLength = tok.length();
        int unit = -1;
        int unitPos = -1;
        char unitChar = tok.charAt(tokLength - 1);
        if (tokLength > 1 && Character.isLetter(unitChar)) {
            unit = PartitionBy.ttlUnitFromString(tok, tokLength - 1, tokLength);
            if (unit != -1) {
                unitPos = valuePos;
            } else {
                try {
                    Numbers.parseLong(tok, 0, tokLength - 1);
                }
                catch (NumericException e) {
                    throw SqlException.$(valuePos, "invalid argument, should be <number> <unit> or <number_with_unit>");
                }
                throw SqlException.$(valuePos + tokLength - 1, "invalid time unit, expecting 'H', 'D', 'W', 'M' or 'Y', but was '").put(unitChar).put('\'');
            }
        }
        try {
            long ttlLong;
            long l = ttlLong = unit == -1 ? Numbers.parseLong(tok) : Numbers.parseLong(tok, 0, tokLength - 1);
            if (ttlLong > Integer.MAX_VALUE || ttlLong < 0L) {
                throw SqlException.$(valuePos, "value out of range: ").put(ttlLong).put(". Max value: ").put(Integer.MAX_VALUE);
            }
            ttlValue = (int)ttlLong;
        }
        catch (NumericException e) {
            throw SqlException.$(valuePos, "invalid syntax, should be <number> <unit> but was ").put(tok);
        }
        if (unit == -1) {
            unitPos = lexer.getPosition();
            tok = SqlUtil.fetchNext(lexer);
            if (tok == null) {
                throw SqlException.$(unitPos, "missing unit, 'HOUR(S)', 'DAY(S)', 'WEEK(S)', 'MONTH(S)' or 'YEAR(S)' expected");
            }
            unit = PartitionBy.ttlUnitFromString(tok, 0, tok.length());
        }
        if (unit == -1) {
            throw SqlException.$(unitPos, "invalid unit, expected 'HOUR(S)', 'DAY(S)', 'WEEK(S)', 'MONTH(S)' or 'YEAR(S)', but was '").put(tok).put('\'');
        }
        return Timestamps.toHoursOrMonths(ttlValue, unit, valuePos);
    }

    public static ExpressionNode recursiveReplace(ExpressionNode node, ReplacingVisitor visitor) throws SqlException {
        if (node == null) {
            return null;
        }
        switch (node.paramCount) {
            case 0: {
                break;
            }
            case 1: {
                node.rhs = SqlParser.recursiveReplace(node.rhs, visitor);
                break;
            }
            case 2: {
                node.lhs = SqlParser.recursiveReplace(node.lhs, visitor);
                node.rhs = SqlParser.recursiveReplace(node.rhs, visitor);
                break;
            }
            default: {
                for (int i = 0; i < node.paramCount; ++i) {
                    ExpressionNode arg = node.args.get(i);
                    node.args.set(i, SqlParser.recursiveReplace(arg, visitor));
                }
            }
        }
        return visitor.visit(node);
    }

    public static void validateMatViewDelay(int length, char lengthUnit, int delay, char delayUnit, int pos) throws SqlException {
        int delayMinutes;
        int lengthMinutes;
        if (delay < 0) {
            throw SqlException.position(pos).put("delay cannot be negative");
        }
        switch (lengthUnit) {
            case 'm': {
                lengthMinutes = length;
                break;
            }
            case 'h': {
                lengthMinutes = length * 60;
                break;
            }
            case 'd': {
                lengthMinutes = length * 24 * 60;
                break;
            }
            default: {
                throw SqlException.position(pos).put("unsupported length unit: ").put(length).put(lengthUnit).put(", supported units are 'm', 'h', 'd'");
            }
        }
        switch (delayUnit) {
            case 'm': {
                delayMinutes = delay;
                break;
            }
            case 'h': {
                delayMinutes = delay * 60;
                break;
            }
            case 'd': {
                delayMinutes = delay * 24 * 60;
                break;
            }
            default: {
                throw SqlException.position(pos).put("unsupported delay unit: ").put(delay).put(delayUnit).put(", supported units are 'm', 'h', 'd'");
            }
        }
        if (delayMinutes >= lengthMinutes) {
            throw SqlException.position(pos).put("delay cannot be equal to or greater than length");
        }
    }

    public static void validateMatViewEveryUnit(char unit, int pos) throws SqlException {
        if (unit != 'M' && unit != 'y' && unit != 'w' && unit != 'd' && unit != 'h' && unit != 'm') {
            throw SqlException.position(pos).put("unsupported interval unit: ").put(unit).put(", supported units are 'm', 'h', 'd', 'w', 'y', 'M'");
        }
    }

    public static void validateMatViewLength(int interval, char unit, int pos) throws SqlException {
        switch (unit) {
            case 'm': {
                if (interval <= 1440) break;
                throw SqlException.position(pos).put("maximum supported length interval is 24 hours: ").put(interval).put(unit);
            }
            case 'h': {
                if (interval <= 24) break;
                throw SqlException.position(pos).put("maximum supported length interval is 24 hours: ").put(interval).put(unit);
            }
            case 'd': {
                if (interval <= 1) break;
                throw SqlException.position(pos).put("maximum supported length interval is 24 hours: ").put(interval).put(unit);
            }
            default: {
                throw SqlException.position(pos).put("unsupported length unit: ").put(interval).put(unit).put(", supported units are 'm', 'h', 'd'");
            }
        }
    }

    private static void collectAllTableNames(@NotNull QueryModel model, @NotNull LowerCaseCharSequenceHashSet outTableNames, @Nullable IntList outTableNamePositions) {
        QueryModel m = model;
        do {
            ExpressionNode tableNameExpr;
            if ((tableNameExpr = m.getTableNameExpr()) != null && tableNameExpr.type == 7 && outTableNames.add(GenericLexer.unquote(tableNameExpr.token)) && outTableNamePositions != null) {
                outTableNamePositions.add(tableNameExpr.position);
            }
            ObjList<QueryModel> joinModels = m.getJoinModels();
            int n = joinModels.size();
            for (int i = 0; i < n; ++i) {
                QueryModel joinModel = joinModels.getQuick(i);
                if (joinModel == m) continue;
                SqlParser.collectAllTableNames(joinModel, outTableNames, outTableNamePositions);
            }
            QueryModel unionModel = m.getUnionModel();
            if (unionModel == null) continue;
            SqlParser.collectAllTableNames(unionModel, outTableNames, outTableNamePositions);
        } while ((m = m.getNestedModel()) != null);
    }

    private static SqlException err(GenericLexer lexer, @Nullable CharSequence tok, @NotNull String msg) {
        return SqlException.parserErr(lexer.lastTokenPosition(), tok, msg);
    }

    private static SqlException errUnexpected(GenericLexer lexer, CharSequence token) {
        return SqlException.unexpectedToken(lexer.lastTokenPosition(), token);
    }

    private static SqlException errUnexpected(GenericLexer lexer, CharSequence token, @NotNull CharSequence extraMessage) {
        return SqlException.unexpectedToken(lexer.lastTokenPosition(), token, extraMessage);
    }

    private static boolean isValidSampleByPeriodLetter(CharSequence token) {
        if (token.length() != 1) {
            return false;
        }
        switch (token.charAt(0)) {
            case 'M': 
            case 'T': 
            case 'U': 
            case 'd': 
            case 'h': 
            case 'm': 
            case 's': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    private static CreateMatViewOperationBuilder parseCreateMatViewExt(GenericLexer lexer, SqlExecutionContext executionContext, SqlParserCallback sqlParserCallback, CharSequence tok, CreateMatViewOperationBuilder builder) throws SqlException {
        CharSequence nextToken = tok == null || Chars.equals(tok, ';') ? null : tok;
        return sqlParserCallback.parseCreateMatViewExt(lexer, executionContext.getSecurityContext(), builder, nextToken);
    }

    private static CreateTableOperationBuilder parseCreateTableExt(GenericLexer lexer, SqlExecutionContext executionContext, SqlParserCallback sqlParserCallback, CharSequence tok, CreateTableOperationBuilder builder) throws SqlException {
        CharSequence nextToken = tok == null || Chars.equals(tok, ';') ? null : tok;
        return sqlParserCallback.parseCreateTableExt(lexer, executionContext.getSecurityContext(), builder, nextToken);
    }

    private static void validateShowTransactions(GenericLexer lexer) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok != null && SqlKeywords.isIsolationKeyword(tok)) {
            tok = SqlUtil.fetchNext(lexer);
            if (tok != null && SqlKeywords.isLevelKeyword(tok)) {
                return;
            }
            throw SqlException.position(tok != null ? lexer.lastTokenPosition() : lexer.getPosition()).put("expected 'level'");
        }
        throw SqlException.position(tok != null ? lexer.lastTokenPosition() : lexer.getPosition()).put("expected 'isolation'");
    }

    private void addConcatArgs(ObjList<ExpressionNode> args, ExpressionNode leaf) {
        if (leaf.type != 6 || !SqlKeywords.isConcatKeyword(leaf.token)) {
            args.add(leaf);
            return;
        }
        if (leaf.args.size() > 0) {
            args.addAll(leaf.args);
        } else {
            args.add(leaf.rhs);
            args.add(leaf.lhs);
        }
    }

    private void assertNotDot(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (Chars.indexOfLastUnquoted(tok, '.') != -1) {
            throw SqlException.$(lexer.lastTokenPosition(), "'.' is not allowed here");
        }
    }

    private void checkSupportedJoinType(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (tok != null && (SqlKeywords.isFullKeyword(tok) || SqlKeywords.isRightKeyword(tok))) {
            throw SqlException.$(lexer.lastTokenPosition(), "unsupported join type");
        }
    }

    private CharSequence createColumnAlias(CharSequence token, int type, LowerCaseCharSequenceObjHashMap<QueryColumn> aliasToColumnMap) {
        return SqlUtil.createColumnAlias(this.characterStore, GenericLexer.unquote(token), Chars.indexOfLastUnquoted(token, '.'), aliasToColumnMap, type != 7);
    }

    private CharSequence createConstColumnAlias(LowerCaseCharSequenceObjHashMap<QueryColumn> aliasToColumnMap) {
        CharacterStoreEntry characterStoreEntry = this.characterStore.newEntry();
        characterStoreEntry.put(this.column);
        int len = characterStoreEntry.length();
        characterStoreEntry.put(this.digit);
        while (aliasToColumnMap.contains(characterStoreEntry.toImmutable())) {
            characterStoreEntry.trimTo(len);
            ++this.digit;
            characterStoreEntry.put(this.digit);
        }
        return characterStoreEntry.toImmutable();
    }

    @NotNull
    private CreateTableColumnModel ensureCreateTableColumnModel(CharSequence columnName, int columnNamePos) {
        CreateTableColumnModel touchUpModel = this.getCreateTableColumnModel(columnName);
        if (touchUpModel != null) {
            return touchUpModel;
        }
        try {
            return this.newCreateTableColumnModel(columnName, columnNamePos);
        }
        catch (SqlException e) {
            throw new AssertionError("createColumnModel should never fail here", e);
        }
    }

    private void expectBy(GenericLexer lexer) throws SqlException {
        if (SqlKeywords.isByKeyword(this.tok(lexer, "'by'"))) {
            return;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'by' expected");
    }

    private ExpressionNode expectExpr(GenericLexer lexer, SqlParserCallback sqlParserCallback, LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        ExpressionNode n = this.expr(lexer, null, sqlParserCallback, decls);
        if (n != null) {
            return n;
        }
        throw SqlException.$(lexer.hasUnparsed() ? lexer.lastTokenPosition() : lexer.getPosition(), "Expression expected");
    }

    private ExpressionNode expectExpr(GenericLexer lexer, SqlParserCallback sqlParserCallback) throws SqlException {
        return this.expectExpr(lexer, sqlParserCallback, null);
    }

    private int expectInt(GenericLexer lexer) throws SqlException {
        boolean negative;
        CharSequence tok = this.tok(lexer, "integer");
        if (Chars.equals(tok, '-')) {
            negative = true;
            tok = this.tok(lexer, "integer");
        } else {
            negative = false;
        }
        try {
            int result = Numbers.parseInt(tok);
            return negative ? -result : result;
        }
        catch (NumericException e) {
            throw SqlParser.err(lexer, tok, "bad integer");
        }
    }

    private ExpressionNode expectLiteral(GenericLexer lexer) throws SqlException {
        return this.expectLiteral(lexer, null);
    }

    private ExpressionNode expectLiteral(GenericLexer lexer, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        CharSequence tok = this.tok(lexer, "literal");
        int pos = lexer.lastTokenPosition();
        SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, pos);
        SqlKeywords.validateLiteral(pos, tok);
        return this.rewriteDeclaredVariables(this.nextLiteral(GenericLexer.immutableOf(GenericLexer.unquote(tok)), pos), decls, null);
    }

    private long expectLong(GenericLexer lexer) throws SqlException {
        boolean negative;
        CharSequence tok = this.tok(lexer, "long integer");
        if (Chars.equals(tok, '-')) {
            negative = true;
            tok = this.tok(lexer, "long integer");
        } else {
            negative = false;
        }
        try {
            long result = Numbers.parseLong(tok);
            return negative ? -result : result;
        }
        catch (NumericException e) {
            throw SqlParser.err(lexer, tok, "bad long integer");
        }
    }

    private void expectObservation(GenericLexer lexer) throws SqlException {
        if (SqlKeywords.isObservationKeyword(this.tok(lexer, "'observation'"))) {
            return;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'observation' expected");
    }

    private void expectOffset(GenericLexer lexer) throws SqlException {
        if (SqlKeywords.isOffsetKeyword(this.tok(lexer, "'offset'"))) {
            return;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'offset' expected");
    }

    private void expectSample(GenericLexer lexer, QueryModel model, SqlParserCallback sqlParserCallback) throws SqlException {
        ExpressionNode n = this.expr(lexer, null, sqlParserCallback, model.getDecls());
        if (SqlParser.isFullSampleByPeriod(n)) {
            model.setSampleBy(n);
            return;
        }
        int pos = lexer.lastTokenPosition();
        CharSequence tok = this.tok(lexer, "time interval unit");
        if (SqlParser.isValidSampleByPeriodLetter(tok)) {
            model.setSampleBy(n, SqlUtil.nextLiteral(this.expressionNodePool, tok, pos));
            return;
        }
        throw SqlException.$(pos, "one letter sample by period unit expected");
    }

    private CharSequence expectTableNameOrSubQuery(GenericLexer lexer) throws SqlException {
        return this.tok(lexer, "table name or sub-query");
    }

    private void expectTo(GenericLexer lexer) throws SqlException {
        if (SqlKeywords.isToKeyword(this.tok(lexer, "'to'"))) {
            return;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'to' expected");
    }

    private void expectTok(GenericLexer lexer, CharSequence tok, CharSequence expected) throws SqlException {
        if (tok == null || !Chars.equalsLowerCaseAscii(tok, expected)) {
            throw SqlException.position(lexer.lastTokenPosition()).put('\'').put(expected).put("' expected");
        }
    }

    private void expectTok(GenericLexer lexer, CharSequence expected) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(expected).put("' expected");
        }
        this.expectTok(lexer, tok, expected);
    }

    private void expectTok(GenericLexer lexer, char expected) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(lexer.getPosition()).put('\'').put(expected).put("' expected");
        }
        this.expectTok(tok, lexer.lastTokenPosition(), expected);
    }

    private void expectTok(CharSequence tok, int pos, char expected) throws SqlException {
        if (tok == null || !Chars.equals(tok, expected)) {
            throw SqlException.position(pos).put('\'').put(expected).put("' expected");
        }
    }

    private void expectZone(GenericLexer lexer) throws SqlException {
        if (SqlKeywords.isZoneKeyword(this.tok(lexer, "'zone'"))) {
            return;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'zone' expected");
    }

    private void generateColumnAlias(GenericLexer lexer, QueryColumn qc, boolean hasFrom) throws SqlException {
        CharSequence alias;
        CharSequence token = qc.getAst().token;
        if (qc.getAst().isWildcard() && !hasFrom) {
            throw SqlParser.err(lexer, null, "'from' expected");
        }
        if (this.configuration.isColumnAliasExpressionEnabled()) {
            CharacterStoreEntry entry = this.characterStore.newEntry();
            qc.getAst().toSink(entry);
            alias = SqlUtil.createExprColumnAlias(this.characterStore, entry.toImmutable(), this.aliasMap, this.configuration.getColumnAliasGeneratedMaxSize(), qc.getAst().type != 7);
        } else if (qc.getAst().type == 4 && Chars.indexOfLastUnquoted(token, '.') != -1) {
            alias = this.createConstColumnAlias(this.aliasMap);
        } else {
            Object tokenAlias = qc.getAst().token;
            if (qc.isWindowColumn() && ((WindowColumn)qc).isIgnoreNulls()) {
                tokenAlias = String.valueOf(tokenAlias) + "_ignore_nulls";
            }
            alias = this.createColumnAlias((CharSequence)tokenAlias, qc.getAst().type, this.aliasMap);
        }
        qc.setAlias(alias, -1);
        this.aliasMap.put(alias, qc);
    }

    @Nullable
    private CreateTableColumnModel getCreateTableColumnModel(CharSequence columnName) {
        return this.createTableOperationBuilder.getColumnModel(columnName);
    }

    private boolean isCurrentRow(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (SqlKeywords.isCurrentKeyword(tok)) {
            tok = this.tok(lexer, "'row'");
            if (SqlKeywords.isRowKeyword(tok)) {
                return true;
            }
            throw SqlException.$(lexer.lastTokenPosition(), "'row' expected");
        }
        return false;
    }

    private boolean isFieldTerm(CharSequence tok) {
        return Chars.equals(tok, ')') || Chars.equals(tok, ',');
    }

    private boolean isUnboundedPreceding(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (SqlKeywords.isUnboundedKeyword(tok)) {
            tok = this.tok(lexer, "'preceding'");
            if (SqlKeywords.isPrecedingKeyword(tok)) {
                return true;
            }
            throw SqlException.$(lexer.lastTokenPosition(), "'preceding' expected");
        }
        return false;
    }

    private ExpressionNode literal(GenericLexer lexer, CharSequence name) {
        return this.literal(name, lexer.lastTokenPosition());
    }

    private ExpressionNode literal(CharSequence name, int position) {
        return this.expressionNodePool.next().of(7, GenericLexer.unquote(name), 0, position);
    }

    @NotNull
    private CreateTableColumnModel newCreateTableColumnModel(CharSequence columnName, int columnNamePos) throws SqlException {
        if (this.createTableOperationBuilder.getColumnModel(columnName) != null) {
            throw SqlException.duplicateColumn(columnNamePos, columnName);
        }
        CreateTableColumnModel model = this.createTableColumnModelPool.next();
        model.setColumnNamePos(columnNamePos);
        this.createTableOperationBuilder.addColumnModel(columnName, model);
        return model;
    }

    private ExpressionNode nextLiteral(CharSequence token, int position) {
        return SqlUtil.nextLiteral(this.expressionNodePool, token, position);
    }

    private CharSequence notTermTok(GenericLexer lexer) throws SqlException {
        CharSequence tok = this.tok(lexer, "')' or ','");
        if (this.isFieldTerm(tok)) {
            throw SqlParser.err(lexer, tok, "missing column definition");
        }
        return tok;
    }

    private CharSequence optTok(GenericLexer lexer) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null || this.subQueryMode && Chars.equals(tok, ')') && !this.overClauseMode) {
            return null;
        }
        return tok;
    }

    private QueryModel parseAsSubQueryAndExpectClosingBrace(GenericLexer lexer, LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses, boolean useTopLevelWithClauses, SqlParserCallback sqlParserCallback, LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        QueryModel model = this.parseAsSubQuery(lexer, withClauses, useTopLevelWithClauses, sqlParserCallback, decls);
        this.expectTok(lexer, ')');
        return model;
    }

    private ExecutionModel parseCopy(GenericLexer lexer, SqlParserCallback sqlParserCallback) throws SqlException {
        if (Chars.isBlank(this.configuration.getSqlCopyInputRoot())) {
            throw SqlException.$(lexer.lastTokenPosition(), "COPY is disabled ['cairo.sql.copy.root' is not set?]");
        }
        ExpressionNode target = this.expectExpr(lexer, sqlParserCallback);
        CharSequence tok = this.tok(lexer, "'from' or 'to' or 'cancel'");
        if (SqlKeywords.isCancelKeyword(tok)) {
            CopyModel model = this.copyModelPool.next();
            model.setCancel(true);
            model.setTarget(target);
            tok = this.optTok(lexer);
            if (tok == null || Chars.equals(tok, ';')) {
                return model;
            }
            throw SqlParser.errUnexpected(lexer, tok);
        }
        if (SqlKeywords.isFromKeyword(tok)) {
            ExpressionNode fileName = this.expectExpr(lexer, sqlParserCallback);
            if (fileName.token.length() < 3 && Chars.startsWith(fileName.token, '\'')) {
                throw SqlException.$(fileName.position, "file name expected");
            }
            CopyModel model = this.copyModelPool.next();
            model.setTarget(target);
            model.setFileName(fileName);
            tok = this.optTok(lexer);
            if (tok != null && SqlKeywords.isWithKeyword(tok)) {
                tok = this.tok(lexer, "copy option");
                while (tok != null && !SqlKeywords.isSemicolon(tok)) {
                    if (SqlKeywords.isHeaderKeyword(tok)) {
                        model.setHeader(SqlKeywords.isTrueKeyword(this.tok(lexer, "'true' or 'false'")));
                        tok = this.optTok(lexer);
                        continue;
                    }
                    if (SqlKeywords.isPartitionKeyword(tok)) {
                        this.expectTok(lexer, "by");
                        tok = this.tok(lexer, "year month day hour none");
                        int partitionBy = PartitionBy.fromString(tok);
                        if (partitionBy == -1) {
                            throw SqlException.$(lexer.getPosition(), "'NONE', 'HOUR', 'DAY', 'WEEK', 'MONTH' or 'YEAR' expected");
                        }
                        model.setPartitionBy(partitionBy);
                        tok = this.optTok(lexer);
                        continue;
                    }
                    if (SqlKeywords.isTimestampKeyword(tok)) {
                        tok = this.tok(lexer, "timestamp column name expected");
                        CharSequence columnName = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                        if (!TableUtils.isValidColumnName(columnName, this.configuration.getMaxFileNameLength())) {
                            throw SqlException.$(lexer.getPosition(), "timestamp column name contains invalid characters");
                        }
                        model.setTimestampColumnName(columnName);
                        tok = this.optTok(lexer);
                        continue;
                    }
                    if (SqlKeywords.isFormatKeyword(tok)) {
                        tok = this.tok(lexer, "timestamp format expected");
                        CharSequence format = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                        model.setTimestampFormat(format);
                        tok = this.optTok(lexer);
                        continue;
                    }
                    if (SqlKeywords.isOnKeyword(tok)) {
                        this.expectTok(lexer, "error");
                        tok = this.tok(lexer, "skip_column skip_row abort");
                        if (Chars.equalsIgnoreCase(tok, "skip_column")) {
                            model.setAtomicity(2);
                        } else if (Chars.equalsIgnoreCase(tok, "skip_row")) {
                            model.setAtomicity(1);
                        } else if (Chars.equalsIgnoreCase(tok, "abort")) {
                            model.setAtomicity(0);
                        } else {
                            throw SqlException.$(lexer.getPosition(), "invalid 'on error' copy option found");
                        }
                        tok = this.optTok(lexer);
                        continue;
                    }
                    if (SqlKeywords.isDelimiterKeyword(tok)) {
                        tok = this.tok(lexer, "timestamp character expected");
                        CharSequence delimiter = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                        if (delimiter == null || delimiter.length() != 1) {
                            throw SqlException.$(lexer.getPosition(), "delimiter is empty or contains more than 1 character");
                        }
                        char delimiterChar = delimiter.charAt(0);
                        if (delimiterChar > '\u007f') {
                            throw SqlException.$(lexer.getPosition(), "delimiter is not an ascii character");
                        }
                        model.setDelimiter((byte)delimiterChar);
                        tok = this.optTok(lexer);
                        continue;
                    }
                    throw SqlException.$(lexer.lastTokenPosition(), "unexpected option");
                }
            } else if (tok != null && !SqlKeywords.isSemicolon(tok)) {
                throw SqlException.$(lexer.lastTokenPosition(), "'with' expected");
            }
            return model;
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'from' expected");
    }

    private ExecutionModel parseCreate(GenericLexer lexer, SqlExecutionContext executionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        CharSequence tok = this.tok(lexer, "'atomic' or 'table' or 'batch' or 'materialized'");
        if (SqlKeywords.isMaterializedKeyword(tok)) {
            if (!this.configuration.isMatViewEnabled()) {
                throw SqlException.$(0, "materialized views are disabled");
            }
            return this.parseCreateMatView(lexer, executionContext, sqlParserCallback);
        }
        return this.parseCreateTable(lexer, tok, executionContext, sqlParserCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExecutionModel parseCreateMatView(GenericLexer lexer, SqlExecutionContext executionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        CharSequence tok;
        CreateTableOperationBuilderImpl tableOpBuilder;
        CreateMatViewOperationBuilderImpl mvOpBuilder;
        block52: {
            mvOpBuilder = this.createMatViewOperationBuilder;
            tableOpBuilder = mvOpBuilder.getCreateTableOperationBuilder();
            mvOpBuilder.clear();
            tableOpBuilder.setDefaultSymbolCapacity(this.configuration.getDefaultSymbolCapacity());
            tableOpBuilder.setMaxUncommittedRows(this.configuration.getMaxUncommittedRows());
            tableOpBuilder.setWalEnabled(true);
            this.expectTok(lexer, "view");
            tok = this.tok(lexer, "view name or 'if'");
            if (SqlKeywords.isIfKeyword(tok)) {
                if (SqlKeywords.isNotKeyword(this.tok(lexer, "'not'")) && SqlKeywords.isExistsKeyword(this.tok(lexer, "'exists'"))) {
                    tableOpBuilder.setIgnoreIfExists(true);
                    tok = this.tok(lexer, "view name");
                } else {
                    throw SqlException.$(lexer.lastTokenPosition(), "'if not exists' expected");
                }
            }
            tok = this.sansPublicSchema(tok, lexer);
            SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, lexer.lastTokenPosition());
            tableOpBuilder.setTableNameExpr(this.nextLiteral(GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), lexer.lastTokenPosition()), lexer.lastTokenPosition()));
            tok = this.tok(lexer, "'as' or 'with' or 'refresh'");
            CharSequence baseTableName = null;
            int baseTableNamePos = 0;
            if (SqlKeywords.isWithKeyword(tok)) {
                this.expectTok(lexer, "base");
                tok = this.tok(lexer, "base table");
                baseTableName = this.sansPublicSchema(tok, lexer);
                SqlKeywords.assertNameIsQuotedOrNotAKeyword(baseTableName, lexer.lastTokenPosition());
                baseTableName = GenericLexer.unquote(baseTableName);
                baseTableNamePos = lexer.lastTokenPosition();
                tok = this.tok(lexer, "'as' or 'refresh'");
            }
            boolean refreshDefined = false;
            int refreshType = 0;
            boolean deferred = false;
            if (SqlKeywords.isRefreshKeyword(tok)) {
                refreshDefined = true;
                tok = this.tok(lexer, "'immediate' or 'manual' or 'period' or 'every' or 'as'");
                int every = 0;
                char everyUnit = '\u0000';
                if (SqlKeywords.isIncrementalKeyword(tok)) {
                    tok = this.tok(lexer, "'as'");
                } else if (SqlKeywords.isImmediateKeyword(tok)) {
                    tok = this.tok(lexer, "'deferred' or 'period' or 'as'");
                } else if (SqlKeywords.isManualKeyword(tok)) {
                    refreshType = 2;
                    tok = this.tok(lexer, "'deferred' or 'period' or 'as'");
                } else if (SqlKeywords.isEveryKeyword(tok)) {
                    tok = this.tok(lexer, "interval");
                    every = Timestamps.getStrideMultiple(tok, lexer.lastTokenPosition());
                    everyUnit = Timestamps.getStrideUnit(tok, lexer.lastTokenPosition());
                    SqlParser.validateMatViewEveryUnit(everyUnit, lexer.lastTokenPosition());
                    refreshType = 1;
                    tok = this.tok(lexer, "'deferred' or 'start' or 'period' or 'as'");
                }
                if (SqlKeywords.isDeferredKeyword(tok)) {
                    deferred = true;
                    tok = refreshType == 1 ? this.tok(lexer, "'start' or 'period' or 'as'") : this.tok(lexer, "'period' or 'as'");
                }
                if (SqlKeywords.isPeriodKeyword(tok)) {
                    this.expectTok(lexer, "(");
                    this.expectTok(lexer, "length");
                    tok = this.tok(lexer, "LENGTH interval");
                    int length = Timestamps.getStrideMultiple(tok, lexer.lastTokenPosition());
                    char lengthUnit = Timestamps.getStrideUnit(tok, lexer.lastTokenPosition());
                    SqlParser.validateMatViewLength(length, lengthUnit, lexer.lastTokenPosition());
                    TimestampSampler periodSampler = TimestampSamplerFactory.getInstance((long)length, lengthUnit, lexer.lastTokenPosition());
                    tok = this.tok(lexer, "'time zone' or 'delay' or ')'");
                    TimeZoneRules tzRules = null;
                    String tz = null;
                    if (SqlKeywords.isTimeKeyword(tok)) {
                        this.expectTok(lexer, "zone");
                        tok = this.tok(lexer, "TIME ZONE name");
                        if (Chars.equals(tok, ')') || SqlKeywords.isDelayKeyword(tok)) {
                            throw SqlException.position(lexer.lastTokenPosition()).put("TIME ZONE name expected");
                        }
                        tz = GenericLexer.unquote(tok).toString();
                        try {
                            tzRules = Timestamps.getTimezoneRules(TimestampFormatUtils.EN_LOCALE, tz);
                        }
                        catch (NumericException e) {
                            throw SqlException.position(lexer.lastTokenPosition()).put("invalid timezone: ").put(tz);
                        }
                        tok = this.tok(lexer, "'delay' or ')'");
                    }
                    int delay = 0;
                    char delayUnit = '\u0000';
                    if (SqlKeywords.isDelayKeyword(tok)) {
                        tok = this.tok(lexer, "DELAY interval");
                        delay = Timestamps.getStrideMultiple(tok, lexer.lastTokenPosition());
                        delayUnit = Timestamps.getStrideUnit(tok, lexer.lastTokenPosition());
                        SqlParser.validateMatViewDelay(length, lengthUnit, delay, delayUnit, lexer.lastTokenPosition());
                        tok = this.tok(lexer, "')'");
                    }
                    if (!Chars.equals(tok, ')')) {
                        throw SqlException.position(lexer.lastTokenPosition()).put("')' expected");
                    }
                    long now = this.configuration.getMicrosecondClock().getTicks();
                    long nowLocal = tzRules != null ? now + tzRules.getOffset(now) : now;
                    long start = periodSampler.round(nowLocal);
                    mvOpBuilder.setTimer(tz, start, every, everyUnit);
                    mvOpBuilder.setPeriodLength(length, lengthUnit, delay, delayUnit);
                    tok = this.tok(lexer, "'as'");
                } else if (!SqlKeywords.isAsKeyword(tok)) {
                    if (refreshType != 1) {
                        throw SqlException.$(lexer.lastTokenPosition(), "'as' expected");
                    }
                    long start = this.configuration.getMicrosecondClock().getTicks();
                    String tz = null;
                    if (SqlKeywords.isStartKeyword(tok)) {
                        tok = this.tok(lexer, "START timestamp");
                        try {
                            start = IntervalUtils.parseFloorPartialTimestamp(GenericLexer.unquote(tok));
                        }
                        catch (NumericException e) {
                            throw SqlException.$(lexer.lastTokenPosition(), "invalid START timestamp value");
                        }
                        tok = this.tok(lexer, "'time zone' or 'as'");
                        if (SqlKeywords.isTimeKeyword(tok)) {
                            this.expectTok(lexer, "zone");
                            tok = this.tok(lexer, "TIME ZONE name");
                            tz = GenericLexer.unquote(tok).toString();
                            tok = this.tok(lexer, "'as'");
                        }
                    }
                    mvOpBuilder.setTimer(tz, start, every, everyUnit);
                } else if (refreshType == 1) {
                    long start = this.configuration.getMicrosecondClock().getTicks();
                    mvOpBuilder.setTimer(null, start, every, everyUnit);
                }
            }
            mvOpBuilder.setRefreshType(refreshType);
            mvOpBuilder.setDeferred(deferred);
            if (SqlKeywords.isAsKeyword(tok)) {
                int startOfQuery = lexer.getPosition();
                tok = this.tok(lexer, "'(' or 'with' or 'select'");
                boolean enclosedInParentheses = Chars.equals(tok, '(');
                if (enclosedInParentheses) {
                    startOfQuery = lexer.getPosition();
                    tok = this.tok(lexer, "'with' or 'select'");
                }
                if (SqlKeywords.isWithKeyword(tok)) {
                    this.parseWithClauses(lexer, this.topLevelWithModel, sqlParserCallback, null);
                    this.expectTok(lexer, "select");
                }
                lexer.unparseLast();
                QueryModel queryModel = this.parseDml(lexer, null, lexer.getPosition(), true, sqlParserCallback, null);
                int endOfQuery = enclosedInParentheses ? lexer.getPosition() - 1 : lexer.getPosition();
                tableNames.clear();
                tableNamePositions.clear();
                SqlParser.collectAllTableNames(queryModel, tableNames, tableNamePositions);
                if (baseTableName == null) {
                    if (tableNames.size() < 1) {
                        throw SqlException.$(startOfQuery, "missing base table, materialized views have to be based on a table");
                    }
                    if (tableNames.size() > 1) {
                        throw SqlException.$(startOfQuery, "more than one table used in query, base table has to be set using 'WITH BASE'");
                    }
                    baseTableName = Chars.toString(tableNames.getAny());
                    baseTableNamePos = tableNamePositions.getQuick(0);
                }
                mvOpBuilder.setBaseTableNamePosition(baseTableNamePos);
                String baseTableNameStr = Chars.toString(baseTableName);
                mvOpBuilder.setBaseTableName(baseTableNameStr);
                if (!tableNames.contains(baseTableNameStr)) {
                    throw SqlException.position(queryModel.getModelPosition()).put("base table is not referenced in materialized view query: ").put(baseTableName);
                }
                this.validateMatViewQuery(queryModel, baseTableNameStr);
                QueryModel nestedModel = queryModel.getNestedModel();
                if (nestedModel != null) {
                    if (nestedModel.getSampleByTimezoneName() != null) {
                        mvOpBuilder.setTimeZone(GenericLexer.unquote(nestedModel.getSampleByTimezoneName().token).toString());
                    }
                    if (nestedModel.getSampleByOffset() != null) {
                        mvOpBuilder.setTimeZoneOffset(GenericLexer.unquote(nestedModel.getSampleByOffset().token).toString());
                    }
                }
                String matViewSql = Chars.toString(lexer.getContent(), startOfQuery, endOfQuery);
                tableOpBuilder.setSelectText(matViewSql, startOfQuery);
                tableOpBuilder.setSelectModel(queryModel);
                if (enclosedInParentheses) {
                    this.expectTok(lexer, ')');
                    break block52;
                } else {
                    tok = this.optTok(lexer);
                    if (tok != null && !Chars.equals(tok, ';')) {
                        throw SqlException.unexpectedToken(lexer.lastTokenPosition(), tok);
                    }
                    return mvOpBuilder;
                }
            }
            if (refreshDefined) {
                throw SqlException.position(lexer.lastTokenPosition()).put("'as' expected");
            }
            throw SqlException.position(lexer.lastTokenPosition()).put("'refresh' or 'as' expected");
        }
        while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ',')) {
            tok = this.tok(lexer, "'index'");
            if (!SqlKeywords.isIndexKeyword(tok)) {
                throw SqlParser.errUnexpected(lexer, tok);
            }
            this.parseCreateTableIndexDef(lexer, false);
        }
        ExpressionNode timestamp = this.parseTimestamp(lexer, tok);
        if (timestamp != null) {
            tableOpBuilder.setTimestampExpr(timestamp);
            tok = this.optTok(lexer);
        }
        ExpressionNode partitionByExpr = this.parseCreateTablePartition(lexer, tok);
        int partitionBy = -1;
        if (partitionByExpr != null) {
            partitionBy = PartitionBy.fromString(partitionByExpr.token);
            if (partitionBy == -1) {
                throw SqlException.$(partitionByExpr.position, "'HOUR', 'DAY', 'WEEK', 'MONTH' or 'YEAR' expected");
            }
            if (!PartitionBy.isPartitioned(partitionBy)) {
                throw SqlException.position(partitionByExpr.position).put("materialized view has to be partitioned");
            }
            tableOpBuilder.setPartitionByExpr(partitionByExpr);
            tok = this.optTok(lexer);
        }
        if (tok != null && SqlKeywords.isTtlKeyword(tok)) {
            int ttlValuePos = lexer.getPosition();
            int ttlHoursOrMonths = SqlParser.parseTtlHoursOrMonths(lexer);
            if (partitionBy != -1) {
                PartitionBy.validateTtlGranularity(partitionBy, ttlHoursOrMonths, ttlValuePos);
            }
            tableOpBuilder.setTtlHoursOrMonths(ttlHoursOrMonths);
            tableOpBuilder.setTtlPosition(ttlValuePos);
            tok = this.optTok(lexer);
        }
        if (tok != null && SqlKeywords.isInKeyword(tok)) {
            this.parseInVolume(lexer, tableOpBuilder);
            tok = this.optTok(lexer);
        }
        return SqlParser.parseCreateMatViewExt(lexer, executionContext, sqlParserCallback, tok, mvOpBuilder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutionModel parseCreateTable(GenericLexer lexer, CharSequence tok, SqlExecutionContext executionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        CharSequence tableName;
        CreateTableOperationBuilderImpl builder = this.createTableOperationBuilder;
        builder.clear();
        builder.setDefaultSymbolCapacity(this.configuration.getDefaultSymbolCapacity());
        builder.setBatchSize(this.configuration.getInsertModelBatchSize());
        boolean atomicSpecified = false;
        boolean batchSpecified = false;
        boolean isDirectCreate = true;
        if (SqlKeywords.isAtomicKeyword(tok)) {
            atomicSpecified = true;
            builder.setBatchSize(-1L);
            this.expectTok(lexer, "table");
            tok = this.tok(lexer, "table name or 'if'");
        } else if (SqlKeywords.isBatchKeyword(tok)) {
            batchSpecified = true;
            long val = this.expectLong(lexer);
            if (val <= 0L) {
                throw SqlException.$(lexer.lastTokenPosition(), "batch size must be positive integer");
            }
            builder.setBatchSize(val);
            tok = this.tok(lexer, "table or o3MaxLag");
            if (SqlKeywords.isO3MaxLagKeyword(tok)) {
                int pos = lexer.getPosition();
                builder.setBatchO3MaxLag(SqlUtil.expectMicros(this.tok(lexer, "lag value"), pos));
                this.expectTok(lexer, "table");
            }
            tok = this.tok(lexer, "table name or 'if'");
        } else {
            if (!SqlKeywords.isTableKeyword(tok)) throw SqlException.$(lexer.lastTokenPosition(), "'atomic' or 'table' or 'batch' expected");
            tok = this.tok(lexer, "table name or 'if'");
        }
        if (SqlKeywords.isIfKeyword(tok)) {
            if (!SqlKeywords.isNotKeyword(this.tok(lexer, "'not'")) || !SqlKeywords.isExistsKeyword(this.tok(lexer, "'exists'"))) throw SqlException.$(lexer.lastTokenPosition(), "'if not exists' expected");
            builder.setIgnoreIfExists(true);
            tableName = this.tok(lexer, "table name");
        } else {
            tableName = tok;
        }
        tableName = this.sansPublicSchema(tableName, lexer);
        SqlKeywords.assertNameIsQuotedOrNotAKeyword(tableName, lexer.lastTokenPosition());
        builder.setTableNameExpr(this.nextLiteral(GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tableName), lexer.lastTokenPosition()), lexer.lastTokenPosition()));
        tok = this.tok(lexer, "'(' or 'as'");
        if (Chars.equals(tok, '(')) {
            tok = this.tok(lexer, "like");
            if (SqlKeywords.isLikeKeyword(tok)) {
                builder.setBatchSize(-1L);
                this.parseCreateTableLikeTable(lexer);
                tok = this.optTok(lexer);
                return SqlParser.parseCreateTableExt(lexer, executionContext, sqlParserCallback, tok, builder);
            }
            lexer.unparseLast();
            this.parseCreateTableColumns(lexer);
        } else {
            if (!SqlKeywords.isAsKeyword(tok)) throw SqlParser.errUnexpected(lexer, tok);
            isDirectCreate = false;
            this.parseCreateTableAsSelect(lexer, sqlParserCallback);
        }
        if (isDirectCreate) {
            builder.setBatchSize(-1L);
            builder.setBatchO3MaxLag(-1L);
            if (atomicSpecified || batchSpecified) {
                throw SqlException.$(lexer.lastTokenPosition(), "'atomic' or 'batch' keywords can only be used in CREATE ... AS SELECT statements.");
            }
        }
        while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ',')) {
            tok = this.tok(lexer, "'index' or 'cast'");
            if (SqlKeywords.isIndexKeyword(tok)) {
                this.parseCreateTableIndexDef(lexer, isDirectCreate);
                continue;
            }
            if (!SqlKeywords.isCastKeyword(tok)) throw SqlParser.errUnexpected(lexer, tok);
            this.parseCreateTableCastDef(lexer);
        }
        ExpressionNode timestamp = this.parseTimestamp(lexer, tok);
        if (timestamp != null) {
            if (isDirectCreate) {
                CreateTableColumnModel model = builder.getColumnModel(timestamp.token);
                if (model == null) {
                    throw SqlException.position(timestamp.position).put("invalid designated timestamp column [name=").put(timestamp.token).put(']');
                }
                if (model.getColumnType() != 8) {
                    throw SqlException.position(timestamp.position).put("TIMESTAMP column expected [actual=").put(ColumnType.nameOf(model.getColumnType())).put(", columnName=").put(timestamp.token).put(']');
                }
            }
            builder.setTimestampExpr(timestamp);
            tok = this.optTok(lexer);
        }
        int walSetting = -1;
        ExpressionNode partitionByExpr = this.parseCreateTablePartition(lexer, tok);
        if (partitionByExpr != null) {
            if (builder.getTimestampExpr() == null) {
                throw SqlException.$(partitionByExpr.position, "partitioning is possible only on tables with designated timestamps");
            }
            int partitionBy = PartitionBy.fromString(partitionByExpr.token);
            if (partitionBy == -1) {
                throw SqlException.$(partitionByExpr.position, "'NONE', 'HOUR', 'DAY', 'WEEK', 'MONTH' or 'YEAR' expected");
            }
            builder.setPartitionByExpr(partitionByExpr);
            tok = this.optTok(lexer);
            if (tok != null && SqlKeywords.isTtlKeyword(tok)) {
                int ttlValuePos = lexer.getPosition();
                int ttlHoursOrMonths = SqlParser.parseTtlHoursOrMonths(lexer);
                PartitionBy.validateTtlGranularity(partitionBy, ttlHoursOrMonths, ttlValuePos);
                builder.setTtlHoursOrMonths(ttlHoursOrMonths);
                tok = this.optTok(lexer);
            }
            if (tok != null) {
                if (SqlKeywords.isWalKeyword(tok)) {
                    if (!PartitionBy.isPartitioned(builder.getPartitionByFromExpr())) {
                        throw SqlException.position(lexer.lastTokenPosition()).put("WAL Write Mode can only be used on partitioned tables");
                    }
                    walSetting = 1;
                    tok = this.optTok(lexer);
                } else if (SqlKeywords.isBypassKeyword(tok)) {
                    tok = this.optTok(lexer);
                    if (tok == null || !SqlKeywords.isWalKeyword(tok)) throw SqlException.position(tok == null ? lexer.getPosition() : lexer.lastTokenPosition()).put(" invalid syntax, should be BYPASS WAL but was BYPASS ").put(tok != null ? tok : "");
                    walSetting = 0;
                    tok = this.optTok(lexer);
                }
            }
        }
        boolean isWalEnabled = this.configuration.isWalSupported() && PartitionBy.isPartitioned(builder.getPartitionByFromExpr()) && (walSetting == -1 && this.configuration.getWalEnabledDefault() || walSetting == 1);
        builder.setWalEnabled(isWalEnabled);
        int maxUncommittedRows = this.configuration.getMaxUncommittedRows();
        long o3MaxLag = this.configuration.getO3MaxLag();
        if (tok != null && SqlKeywords.isWithKeyword(tok)) {
            ExpressionNode expr;
            while ((expr = this.expr(lexer, (QueryModel)null, sqlParserCallback)) != null) {
                if (!Chars.equals(expr.token, '=')) throw SqlException.position(lexer.getPosition()).put(" expected parameter after WITH");
                if (SqlKeywords.isMaxUncommittedRowsKeyword(expr.lhs.token)) {
                    try {
                        maxUncommittedRows = Numbers.parseInt(expr.rhs.token);
                    }
                    catch (NumericException e) {
                        throw SqlException.position(lexer.getPosition()).put(" could not parse maxUncommittedRows value \"").put(expr.rhs.token).put('\"');
                    }
                } else {
                    if (!SqlKeywords.isO3MaxLagKeyword(expr.lhs.token)) throw SqlException.position(lexer.getPosition()).put(" unrecognized ").put(expr.lhs.token).put(" after WITH");
                    o3MaxLag = SqlUtil.expectMicros(expr.rhs.token, lexer.getPosition());
                }
                tok = this.optTok(lexer);
                if (tok == null || !Chars.equals(tok, ',')) break;
                CharSequence peek = this.optTok(lexer);
                if (peek != null && SqlKeywords.isInKeyword(peek)) {
                    tok = peek;
                    break;
                }
                lexer.unparseLast();
            }
        }
        builder.setMaxUncommittedRows(maxUncommittedRows);
        builder.setO3MaxLag(o3MaxLag);
        if (tok != null && SqlKeywords.isInKeyword(tok)) {
            this.parseInVolume(lexer, builder);
            tok = this.optTok(lexer);
        }
        if (tok == null || !SqlKeywords.isDedupKeyword(tok) && !SqlKeywords.isDeduplicateKeyword(tok)) return SqlParser.parseCreateTableExt(lexer, executionContext, sqlParserCallback, tok, builder);
        if (!builder.isWalEnabled()) {
            throw SqlException.position(lexer.getPosition()).put("deduplication is possible only on WAL tables");
        }
        tok = this.optTok(lexer);
        if (tok == null || !SqlKeywords.isUpsertKeyword(tok)) {
            throw SqlException.position(lexer.lastTokenPosition()).put("expected 'upsert'");
        }
        tok = this.optTok(lexer);
        if (tok == null || !SqlKeywords.isKeysKeyword(tok)) {
            throw SqlException.position(lexer.lastTokenPosition()).put("expected 'keys'");
        }
        boolean timestampColumnFound = false;
        tok = this.optTok(lexer);
        if (tok == null || !Chars.equals(tok, '(')) throw SqlException.position(lexer.getPosition()).put("column list expected");
        tok = this.optTok(lexer);
        int columnListPos = lexer.lastTokenPosition();
        while (tok != null && !Chars.equals(tok, ')')) {
            SqlKeywords.validateLiteral(lexer.lastTokenPosition(), tok);
            CharSequence columnName = GenericLexer.unquote(tok);
            CreateTableColumnModel model = this.getCreateTableColumnModel(columnName);
            if (model == null) {
                if (isDirectCreate) {
                    throw SqlException.position(lexer.lastTokenPosition()).put("deduplicate key column not found [column=").put(columnName).put(']');
                }
                model = this.newCreateTableColumnModel(columnName, lexer.lastTokenPosition());
            } else {
                if (model.isDedupKey() && isDirectCreate) {
                    throw SqlException.position(lexer.lastTokenPosition()).put("duplicate dedup column [column=").put(columnName).put(']');
                }
                if (ColumnType.isArray(model.getColumnType())) {
                    throw SqlException.position(lexer.lastTokenPosition()).put("dedup key columns cannot include ARRAY [column=").put(columnName).put(", type=").put(ColumnType.nameOf(model.getColumnType())).put(']');
                }
            }
            model.setIsDedupKey();
            int colIndex = builder.getColumnIndex(columnName);
            if (colIndex == builder.getTimestampIndex()) {
                timestampColumnFound = true;
            }
            if ((tok = this.optTok(lexer)) == null || !Chars.equals(tok, ',')) continue;
            tok = this.optTok(lexer);
        }
        if (!timestampColumnFound && isDirectCreate) {
            throw SqlException.position(columnListPos).put("deduplicate key list must include dedicated timestamp column");
        }
        tok = this.optTok(lexer);
        return SqlParser.parseCreateTableExt(lexer, executionContext, sqlParserCallback, tok, builder);
    }

    private void parseCreateTableAsSelect(GenericLexer lexer, SqlParserCallback sqlParserCallback) throws SqlException {
        this.expectTok(lexer, '(');
        int startOfSelect = lexer.getPosition();
        QueryModel selectModel = this.parseDml(lexer, null, startOfSelect, true, sqlParserCallback, null);
        int endOfSelect = lexer.getPosition() - 1;
        String selectText = Chars.toString(lexer.getContent(), startOfSelect, endOfSelect);
        this.createTableOperationBuilder.setSelectText(selectText, startOfSelect);
        this.createTableOperationBuilder.setSelectModel(selectModel);
        this.expectTok(lexer, ')');
    }

    private void parseCreateTableCastDef(GenericLexer lexer) throws SqlException {
        if (this.createTableOperationBuilder.getSelectText() == null) {
            throw SqlException.$(lexer.lastTokenPosition(), "cast is only supported in 'create table as ...' context");
        }
        this.expectTok(lexer, '(');
        ExpressionNode columnName = this.expectLiteral(lexer);
        CreateTableColumnModel model = this.ensureCreateTableColumnModel(columnName.token, columnName.position);
        if (model.getColumnType() != 0) {
            throw SqlException.$(lexer.lastTokenPosition(), "duplicate cast");
        }
        this.expectTok(lexer, "as");
        ExpressionNode columnType = this.expectLiteral(lexer);
        int type = this.toColumnType(lexer, columnType.token);
        model.setCastType(type, columnType.position);
        if (ColumnType.isSymbol(type)) {
            boolean isCached;
            int symbolCapacity;
            int capacityPosition;
            CharSequence tok = this.tok(lexer, "'capacity', 'nocache', 'cache' or ')'");
            if (SqlKeywords.isCapacityKeyword(tok)) {
                capacityPosition = lexer.getPosition();
                symbolCapacity = this.parseSymbolCapacity(lexer);
                tok = this.tok(lexer, "'nocache', 'cache' or ')'");
            } else {
                capacityPosition = 0;
                symbolCapacity = this.configuration.getDefaultSymbolCapacity();
            }
            model.setSymbolCapacity(symbolCapacity);
            if (SqlKeywords.isNoCacheKeyword(tok)) {
                isCached = false;
            } else if (SqlKeywords.isCacheKeyword(tok)) {
                isCached = true;
            } else {
                isCached = this.configuration.getDefaultSymbolCacheFlag();
                lexer.unparseLast();
            }
            model.setSymbolCacheFlag(isCached);
            if (isCached) {
                TableUtils.validateSymbolCapacityCached(true, symbolCapacity, capacityPosition);
            }
        }
        this.expectTok(lexer, ')');
    }

    private void parseCreateTableColumns(GenericLexer lexer) throws SqlException {
        block16: {
            CharSequence tok;
            do {
                tok = this.notTermTok(lexer);
                SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, lexer.lastTokenPosition());
                CharSequence columnName = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                int columnPosition = lexer.lastTokenPosition();
                int columnType = this.toColumnType(lexer, this.notTermTok(lexer));
                if (!TableUtils.isValidColumnName(columnName, this.configuration.getMaxFileNameLength())) {
                    throw SqlException.$(columnPosition, " new column name contains invalid characters");
                }
                CreateTableColumnModel model = this.newCreateTableColumnModel(columnName, columnPosition);
                model.setColumnType(columnType);
                model.setSymbolCapacity(this.configuration.getDefaultSymbolCapacity());
                if (ColumnType.isSymbol(columnType)) {
                    boolean cacheFlag;
                    int symbolCapacity;
                    tok = this.tok(lexer, "'capacity', 'nocache', 'cache', 'index' or ')'");
                    if (SqlKeywords.isCapacityKeyword(tok)) {
                        symbolCapacity = this.parseSymbolCapacity(lexer);
                        model.setSymbolCapacity(symbolCapacity);
                        tok = this.tok(lexer, "'nocache', 'cache', 'index' or ')'");
                    } else {
                        symbolCapacity = -1;
                    }
                    if (SqlKeywords.isNoCacheKeyword(tok)) {
                        cacheFlag = false;
                    } else if (SqlKeywords.isCacheKeyword(tok)) {
                        cacheFlag = true;
                    } else {
                        cacheFlag = this.configuration.getDefaultSymbolCacheFlag();
                        lexer.unparseLast();
                    }
                    model.setSymbolCacheFlag(cacheFlag);
                    if (cacheFlag && symbolCapacity != -1) {
                        TableUtils.validateSymbolCapacityCached(true, symbolCapacity, lexer.lastTokenPosition());
                    }
                    tok = this.parseCreateTableInlineIndexDef(lexer, model);
                } else {
                    tok = null;
                }
                CharSequence tempTok = this.optTok(lexer);
                if (tempTok != null && Chars.equals(tempTok, ']')) {
                    throw SqlException.position(columnPosition).put(columnName).put(" has an unmatched `]` - were you trying to define an array?");
                }
                lexer.unparseLast();
                if (tok == null) {
                    tok = this.tok(lexer, "',' or ')'");
                }
                if (SqlKeywords.isPrecisionKeyword(tok)) {
                    tok = this.tok(lexer, "'NOT' or 'NULL' or ',' or ')'");
                }
                if (SqlKeywords.isNotKeyword(tok)) {
                    tok = this.tok(lexer, "'NULL'");
                }
                if (SqlKeywords.isNullKeyword(tok)) {
                    tok = this.tok(lexer, "','");
                }
                if (Chars.equals(tok, ')')) break block16;
            } while (Chars.equals(tok, ','));
            throw SqlParser.err(lexer, tok, "',' or ')' expected");
        }
    }

    private void parseCreateTableIndexDef(GenericLexer lexer, boolean isDirectCreate) throws SqlException {
        int indexValueBlockSize;
        this.expectTok(lexer, '(');
        ExpressionNode columnName = this.expectLiteral(lexer);
        int columnNamePosition = lexer.lastTokenPosition();
        CreateTableColumnModel model = this.getCreateTableColumnModel(columnName.token);
        if (model == null) {
            if (isDirectCreate) {
                throw SqlException.invalidColumn(columnNamePosition, columnName.token);
            }
            model = this.newCreateTableColumnModel(columnName.token, columnName.position);
        } else if (model.isIndexed()) {
            throw SqlException.$(columnNamePosition, "duplicate index clause");
        }
        if (isDirectCreate && model.getColumnType() != 12) {
            throw SqlException.position(columnNamePosition).put("indexes are supported only for SYMBOL columns [columnName=").put(columnName.token).put(", columnType=").put(ColumnType.nameOf(model.getColumnType())).put(']');
        }
        if (SqlKeywords.isCapacityKeyword(this.tok(lexer, "'capacity'"))) {
            int errorPosition = lexer.getPosition();
            indexValueBlockSize = this.expectInt(lexer);
            TableUtils.validateIndexValueBlockSize(errorPosition, indexValueBlockSize);
            indexValueBlockSize = Numbers.ceilPow2(indexValueBlockSize);
        } else {
            indexValueBlockSize = this.configuration.getIndexValueBlockSize();
            lexer.unparseLast();
        }
        model.setIndexed(true, columnNamePosition, indexValueBlockSize);
        this.expectTok(lexer, ')');
    }

    private CharSequence parseCreateTableInlineIndexDef(GenericLexer lexer, CreateTableColumnModel model) throws SqlException {
        CharSequence tok = this.tok(lexer, "')', or 'index'");
        if (this.isFieldTerm(tok)) {
            model.setIndexed(false, -1, this.configuration.getIndexValueBlockSize());
            return tok;
        }
        this.expectTok(lexer, tok, "index");
        int indexColumnPosition = lexer.lastTokenPosition();
        tok = this.tok(lexer, ") | , expected");
        if (this.isFieldTerm(tok)) {
            model.setIndexed(true, indexColumnPosition, this.configuration.getIndexValueBlockSize());
            return tok;
        }
        this.expectTok(lexer, tok, "capacity");
        int errorPosition = lexer.getPosition();
        int indexValueBlockSize = this.expectInt(lexer);
        TableUtils.validateIndexValueBlockSize(errorPosition, indexValueBlockSize);
        model.setIndexed(true, indexColumnPosition, Numbers.ceilPow2(indexValueBlockSize));
        return null;
    }

    private void parseCreateTableLikeTable(GenericLexer lexer) throws SqlException {
        CharSequence tok = this.tok(lexer, "table name");
        tok = this.sansPublicSchema(tok, lexer);
        this.createTableOperationBuilder.setLikeTableNameExpr(this.nextLiteral(GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), lexer.lastTokenPosition()), lexer.lastTokenPosition()));
        tok = this.tok(lexer, ")");
        if (!Chars.equals(tok, ')')) {
            throw SqlParser.errUnexpected(lexer, tok);
        }
    }

    private ExpressionNode parseCreateTablePartition(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (tok != null && SqlKeywords.isPartitionKeyword(tok)) {
            this.expectTok(lexer, "by");
            return this.expectLiteral(lexer);
        }
        return null;
    }

    private void parseDeclare(GenericLexer lexer, QueryModel model, SqlParserCallback sqlParserCallback) throws SqlException {
        int contentLength = lexer.getContent().length();
        while (lexer.getPosition() < contentLength) {
            int pos = lexer.getPosition();
            CharSequence tok = this.optTok(lexer);
            if (tok == null) break;
            if (tok.charAt(0) == ',') continue;
            if (SqlKeywords.isSelectKeyword(tok) || tok.charAt(0) != '@') {
                lexer.unparseLast();
                break;
            }
            CharacterStoreEntry cse = this.characterStore.newEntry();
            cse.put(tok);
            tok = cse.toImmutable();
            CharSequence expectWalrus = this.optTok(lexer);
            if (expectWalrus == null || !Chars.equals(expectWalrus, (CharSequence)":=")) {
                throw SqlParser.errUnexpected(lexer, expectWalrus, "expected variable assignment operator `:=`");
            }
            lexer.goToPosition(pos);
            ExpressionNode expr = this.expr(lexer, model, sqlParserCallback, model.getDecls(), tok);
            if (expr == null) {
                throw SqlParser.errUnexpected(lexer, tok, "declaration was empty or could not be parsed");
            }
            if (!Chars.equalsIgnoreCase(expr.lhs.token, tok)) {
                throw SqlParser.errUnexpected(lexer, tok, "unexpected bind expression - bracket lists are not supported");
            }
            model.getDecls().put(tok, expr);
        }
    }

    private QueryModel parseDml(GenericLexer lexer, @Nullable LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses, int modelPosition, boolean useTopLevelWithClauses, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        QueryModel model = null;
        QueryModel prevModel = null;
        while (true) {
            LowerCaseCharSequenceObjHashMap<WithClauseModel> parentWithClauses = prevModel != null ? prevModel.getWithClauses() : withClauses;
            LowerCaseCharSequenceObjHashMap<WithClauseModel> topWithClauses = useTopLevelWithClauses && model == null ? this.topLevelWithModel : null;
            QueryModel unionModel = this.parseDml0(lexer, parentWithClauses, topWithClauses, modelPosition, sqlParserCallback, decls);
            if (prevModel == null) {
                prevModel = model = unionModel;
            } else {
                prevModel.setUnionModel(unionModel);
                prevModel = unionModel;
            }
            CharSequence tok = this.optTok(lexer);
            if (tok == null || Chars.equals(tok, ';') || setOperations.excludes(tok)) {
                lexer.unparseLast();
                return model;
            }
            if (prevModel.getNestedModel() != null) {
                if (prevModel.getNestedModel().getOrderByPosition() > 0) {
                    throw SqlException.$(prevModel.getNestedModel().getOrderByPosition(), "unexpected token 'order'");
                }
                if (prevModel.getNestedModel().getLimitPosition() > 0) {
                    throw SqlException.$(prevModel.getNestedModel().getLimitPosition(), "unexpected token 'limit'");
                }
            }
            if (SqlKeywords.isUnionKeyword(tok)) {
                tok = this.tok(lexer, "all or select");
                if (SqlKeywords.isAllKeyword(tok)) {
                    prevModel.setSetOperationType(0);
                    modelPosition = lexer.getPosition();
                } else {
                    prevModel.setSetOperationType(1);
                    if (SqlKeywords.isDistinctKeyword(tok)) {
                        modelPosition = lexer.getPosition();
                    } else {
                        lexer.unparseLast();
                        modelPosition = lexer.lastTokenPosition();
                    }
                }
            }
            if (SqlKeywords.isExceptKeyword(tok)) {
                tok = this.tok(lexer, "all or select");
                if (SqlKeywords.isAllKeyword(tok)) {
                    prevModel.setSetOperationType(3);
                    modelPosition = lexer.getPosition();
                } else {
                    prevModel.setSetOperationType(2);
                    lexer.unparseLast();
                    modelPosition = lexer.lastTokenPosition();
                }
            }
            if (SqlKeywords.isIntersectKeyword(tok)) {
                tok = this.tok(lexer, "all or select");
                if (SqlKeywords.isAllKeyword(tok)) {
                    prevModel.setSetOperationType(5);
                    modelPosition = lexer.getPosition();
                } else {
                    prevModel.setSetOperationType(4);
                    lexer.unparseLast();
                    modelPosition = lexer.lastTokenPosition();
                }
            }
            if (prevModel.getDecls() == null || prevModel.getDecls().size() <= 0 || decls != null) continue;
            decls = prevModel.getDecls();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private QueryModel parseDml0(GenericLexer lexer, @Nullable LowerCaseCharSequenceObjHashMap<WithClauseModel> parentWithClauses, @Nullable LowerCaseCharSequenceObjHashMap<WithClauseModel> topWithClauses, int modelPosition, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        CharSequence tok;
        QueryModel model = this.queryModelPool.next();
        model.setModelPosition(modelPosition);
        model.copyDeclsFrom(decls);
        if (parentWithClauses != null) {
            model.getWithClauses().putAll(parentWithClauses);
        }
        if (SqlKeywords.isDeclareKeyword(tok = this.tok(lexer, "'select', 'with', 'declare' or table name expected"))) {
            this.parseDeclare(lexer, model, sqlParserCallback);
            tok = this.tok(lexer, "'select', 'with', or table name expected");
        }
        if (SqlKeywords.isWithKeyword(tok)) {
            this.parseWithClauses(lexer, model.getWithClauses(), sqlParserCallback, model.getDecls());
            tok = this.tok(lexer, "'select' or table name expected");
        } else if (topWithClauses != null) {
            model.getWithClauses().putAll(topWithClauses);
        }
        if (SqlKeywords.isSelectKeyword(tok)) {
            this.parseSelectClause(lexer, model, sqlParserCallback);
            tok = this.optTok(lexer);
            if (tok != null && setOperations.contains(tok)) {
                tok = null;
            }
            if (tok == null || Chars.equals(tok, ';') || Chars.equals(tok, ')')) {
                QueryModel nestedModel = this.queryModelPool.next();
                nestedModel.setModelPosition(modelPosition);
                ExpressionNode tableNameExpr = this.expressionNodePool.next().of(6, "long_sequence", 0, lexer.lastTokenPosition());
                tableNameExpr.paramCount = 1;
                tableNameExpr.rhs = ONE;
                nestedModel.setTableNameExpr(tableNameExpr);
                model.setSelectModelType(2);
                model.setNestedModel(nestedModel);
                lexer.unparseLast();
                return model;
            }
        } else if (SqlKeywords.isShowKeyword(tok)) {
            model.setSelectModelType(7);
            int showKind = -1;
            tok = SqlUtil.fetchNext(lexer);
            if (tok != null) {
                if (SqlKeywords.isTablesKeyword(tok)) {
                    showKind = 1;
                } else if (SqlKeywords.isColumnsKeyword(tok)) {
                    this.parseFromTable(lexer, model);
                    showKind = 2;
                } else if (SqlKeywords.isPartitionsKeyword(tok)) {
                    this.parseFromTable(lexer, model);
                    showKind = 3;
                } else if (SqlKeywords.isTransactionKeyword(tok)) {
                    showKind = 4;
                    SqlParser.validateShowTransactions(lexer);
                } else if (SqlKeywords.isTransactionIsolation(tok)) {
                    showKind = 5;
                } else if (SqlKeywords.isMaxIdentifierLength(tok)) {
                    showKind = 6;
                } else if (SqlKeywords.isStandardConformingStrings(tok)) {
                    showKind = 7;
                } else if (SqlKeywords.isSearchPath(tok)) {
                    showKind = 8;
                } else if (SqlKeywords.isDateStyleKeyword(tok)) {
                    showKind = 9;
                } else if (SqlKeywords.isTimeKeyword(tok)) {
                    tok = SqlUtil.fetchNext(lexer);
                    if (tok != null && SqlKeywords.isZoneKeyword(tok)) {
                        showKind = 10;
                    }
                } else if (SqlKeywords.isParametersKeyword(tok)) {
                    showKind = 11;
                } else if (SqlKeywords.isServerVersionKeyword(tok)) {
                    showKind = 12;
                } else if (SqlKeywords.isServerVersionNumKeyword(tok)) {
                    showKind = 13;
                } else if (SqlKeywords.isCreateKeyword(tok)) {
                    tok = SqlUtil.fetchNext(lexer);
                    if (tok != null && SqlKeywords.isTableKeyword(tok)) {
                        this.parseTableName(lexer, model);
                        showKind = 14;
                    } else {
                        if (tok == null || !SqlKeywords.isMaterializedKeyword(tok)) throw SqlException.position(lexer.getPosition()).put("expected 'TABLE' or 'MATERIALIZED VIEW'");
                        this.expectTok(lexer, "view");
                        this.parseTableName(lexer, model);
                        showKind = 15;
                    }
                } else {
                    showKind = sqlParserCallback.parseShowSql(lexer, model, tok, this.expressionNodePool);
                }
            }
            if (showKind == -1) {
                throw SqlException.position(lexer.getPosition()).put("expected ").put("'TABLES', 'COLUMNS FROM <tab>', 'PARTITIONS FROM <tab>', ").put("'TRANSACTION ISOLATION LEVEL', 'transaction_isolation', ").put("'max_identifier_length', 'standard_conforming_strings', ").put("'parameters', 'server_version', 'server_version_num', ").put("'search_path', 'datestyle', or 'time zone'");
            }
            model.setShowKind(showKind);
        } else {
            lexer.unparseLast();
            SqlUtil.addSelectStar(model, this.queryColumnPool, this.expressionNodePool);
        }
        if (model.getSelectModelType() == 7) return model;
        QueryModel nestedModel = this.queryModelPool.next();
        nestedModel.setModelPosition(modelPosition);
        this.parseFromClause(lexer, nestedModel, model, sqlParserCallback);
        if (nestedModel.getLimitHi() != null || nestedModel.getLimitLo() != null) {
            model.setLimit(nestedModel.getLimitLo(), nestedModel.getLimitHi());
            nestedModel.setLimit(null, null);
        }
        model.setSelectModelType(1);
        model.setNestedModel(nestedModel);
        ExpressionNode n = nestedModel.getAlias();
        if (n == null) return model;
        model.setAlias(n);
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QueryModel parseDmlUpdate(GenericLexer lexer, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        int modelPosition = lexer.getPosition();
        QueryModel updateQueryModel = this.queryModelPool.next();
        updateQueryModel.setModelType(6);
        updateQueryModel.setModelPosition(modelPosition);
        QueryModel fromModel = this.queryModelPool.next();
        fromModel.setModelPosition(modelPosition);
        updateQueryModel.setIsUpdate(true);
        fromModel.setIsUpdate(true);
        CharSequence tok = this.tok(lexer, "UPDATE, WITH or table name expected");
        if (!SqlKeywords.isUpdateKeyword(tok)) return updateQueryModel;
        this.parseUpdateClause(lexer, updateQueryModel, fromModel, sqlParserCallback);
        QueryModel nestedModel = this.queryModelPool.next();
        nestedModel.setTableNameExpr(fromModel.getTableNameExpr());
        nestedModel.setAlias(updateQueryModel.getAlias());
        nestedModel.setIsUpdate(true);
        fromModel.setTableNameExpr(null);
        fromModel.setNestedModel(nestedModel);
        fromModel.getWithClauses().putAll(this.topLevelWithModel);
        tok = this.optTok(lexer);
        if (tok != null && SqlKeywords.isFromKeyword(tok)) {
            int joinType;
            tok = ",";
            int i = 0;
            while (tok != null && (joinType = joinStartSet.get(tok)) != -1) {
                if (i++ == 1) {
                    throw SqlException.$(lexer.lastTokenPosition(), "JOIN is not supported on UPDATE statement");
                }
                nestedModel.addJoinModel(this.parseJoin(lexer, tok, joinType, this.topLevelWithModel, sqlParserCallback, decls));
                tok = this.optTok(lexer);
            }
        } else if (tok != null && SqlKeywords.isSemicolon(tok)) {
            tok = null;
        } else if (tok != null && !SqlKeywords.isWhereKeyword(tok)) {
            throw SqlException.$(lexer.lastTokenPosition(), "FROM, WHERE or EOF expected");
        }
        if (tok != null && SqlKeywords.isWhereKeyword(tok)) {
            ExpressionNode expr = this.expr(lexer, fromModel, sqlParserCallback, decls);
            if (expr == null) throw SqlException.$(lexer.lastTokenPosition(), "empty where clause");
            nestedModel.setWhereClause(expr);
        } else if (tok != null && !SqlKeywords.isSemicolon(tok)) {
            throw SqlParser.errUnexpected(lexer, tok);
        }
        updateQueryModel.setNestedModel(fromModel);
        return updateQueryModel;
    }

    private ExecutionModel parseExplain(GenericLexer lexer, SqlExecutionContext executionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        CharSequence tok = this.tok(lexer, "'create', 'format', 'insert', 'update', 'select' or 'with'");
        if (SqlKeywords.isSelectKeyword(tok)) {
            return this.parseSelect(lexer, sqlParserCallback, null);
        }
        if (SqlKeywords.isCreateKeyword(tok)) {
            return this.parseCreate(lexer, executionContext, sqlParserCallback);
        }
        if (SqlKeywords.isUpdateKeyword(tok)) {
            return this.parseUpdate(lexer, sqlParserCallback, null);
        }
        if (SqlKeywords.isInsertKeyword(tok)) {
            return this.parseInsert(lexer, sqlParserCallback, null);
        }
        if (SqlKeywords.isWithKeyword(tok)) {
            return this.parseWith(lexer, sqlParserCallback, null);
        }
        return this.parseSelect(lexer, sqlParserCallback, null);
    }

    private int parseExplainOptions(GenericLexer lexer, CharSequence prevTok) throws SqlException {
        int parenthesisPos = lexer.getPosition();
        CharSequence explainTok = GenericLexer.immutableOf(prevTok);
        CharSequence tok = this.tok(lexer, "'create', 'insert', 'update', 'select', 'with' or '('");
        if (Chars.equals(tok, '(')) {
            tok = this.tok(lexer, "'format'");
            if (SqlKeywords.isFormatKeyword(tok)) {
                tok = this.tok(lexer, "'text' or 'json'");
                if (SqlKeywords.isTextKeyword(tok) || SqlKeywords.isJsonKeyword(tok)) {
                    int format = SqlKeywords.isJsonKeyword(tok) ? 2 : 1;
                    tok = this.tok(lexer, "')'");
                    if (!Chars.equals(tok, ')')) {
                        throw SqlException.$(lexer.lastTokenPosition(), "unexpected explain option found");
                    }
                    return format;
                }
                throw SqlException.$(lexer.lastTokenPosition(), "unexpected explain format found");
            }
            lexer.backTo(parenthesisPos, explainTok);
            return 1;
        }
        lexer.unparseLast();
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseFromClause(GenericLexer lexer, QueryModel model, QueryModel masterModel, SqlParserCallback sqlParserCallback) throws SqlException {
        int joinType;
        ExpressionNode variableExpr;
        CharSequence tok = this.expectTableNameOrSubQuery(lexer);
        model.copyDeclsFrom(masterModel);
        QueryModel proposedNested = null;
        if (tok.charAt(0) == '@' && (variableExpr = model.getDecls().get(tok)) != null && variableExpr.rhs != null && variableExpr.rhs.queryModel != null) {
            proposedNested = variableExpr.rhs.queryModel;
        }
        if (Chars.equals(tok, '(') || proposedNested != null) {
            if (proposedNested == null) {
                proposedNested = this.parseAsSubQueryAndExpectClosingBrace(lexer, masterModel.getWithClauses(), true, sqlParserCallback, model.getDecls());
            }
            if ((tok = this.optTok(lexer)) == null || tableAliasStop.contains(tok) && !SqlKeywords.isTimestampKeyword(tok)) {
                QueryModel target = proposedNested.getNestedModel();
                if (proposedNested.isArtificialStar() && proposedNested.getUnionModel() == null && target.getWhereClause() == null && target.getOrderBy().size() == 0 && target.getLatestBy().size() == 0 && target.getNestedModel() == null && target.getSampleBy() == null && target.getGroupBy().size() == 0 && proposedNested.getLimitLo() == null && proposedNested.getLimitHi() == null) {
                    model.setTableNameExpr(target.getTableNameExpr());
                    model.setAlias(target.getAlias());
                    model.setTimestamp(target.getTimestamp());
                    int n = target.getJoinModels().size();
                    for (int i = 1; i < n; ++i) {
                        model.addJoinModel(target.getJoinModels().getQuick(i));
                    }
                    proposedNested = null;
                } else {
                    lexer.unparseLast();
                }
            } else {
                lexer.unparseLast();
            }
            if (proposedNested != null) {
                model.setNestedModel(proposedNested);
                model.setNestedModelIsSubQuery(true);
                tok = this.setModelAliasAndTimestamp(lexer, model);
            }
        } else {
            lexer.unparseLast();
            this.parseSelectFrom(lexer, model, masterModel.getWithClauses(), sqlParserCallback);
            tok = this.setModelAliasAndTimestamp(lexer, model);
            if (tok != null && SqlKeywords.isLatestKeyword(tok)) {
                this.parseLatestBy(lexer, model);
                tok = this.optTok(lexer);
            }
        }
        while (tok != null && (joinType = joinStartSet.get(tok)) != -1) {
            model.addJoinModel(this.parseJoin(lexer, tok, joinType, masterModel.getWithClauses(), sqlParserCallback, model.getDecls()));
            tok = this.optTok(lexer);
        }
        this.checkSupportedJoinType(lexer, tok);
        if (tok != null && SqlKeywords.isWhereKeyword(tok)) {
            if (model.getLatestByType() == 2) {
                throw SqlException.$(lexer.lastTokenPosition(), "unexpected where clause after 'latest on'");
            }
            ExpressionNode expr = this.expr(lexer, model, sqlParserCallback, model.getDecls());
            if (expr == null) throw SqlException.$(lexer.lastTokenPosition(), "empty where clause");
            model.setWhereClause(expr);
            tok = this.optTok(lexer);
        }
        if (tok != null && SqlKeywords.isLatestKeyword(tok)) {
            if (model.getLatestByType() == 1) {
                throw SqlException.$(lexer.lastTokenPosition(), "mix of new and deprecated 'latest by' syntax");
            }
            this.expectTok(lexer, "on");
            this.parseLatestByNew(lexer, model);
            tok = this.optTok(lexer);
        }
        if (tok != null && SqlKeywords.isSampleKeyword(tok)) {
            this.expectBy(lexer);
            this.expectSample(lexer, model, sqlParserCallback);
            tok = this.optTok(lexer);
            ExpressionNode fromNode = null;
            ExpressionNode toNode = null;
            if (tok != null && SqlKeywords.isFromKeyword(tok)) {
                fromNode = this.expr(lexer, model, sqlParserCallback, model.getDecls());
                if (fromNode == null) {
                    throw SqlException.$(lexer.lastTokenPosition(), "'timestamp' expression expected");
                }
                tok = this.optTok(lexer);
            }
            if (tok != null && SqlKeywords.isToKeyword(tok)) {
                toNode = this.expr(lexer, model, sqlParserCallback, model.getDecls());
                if (toNode == null) {
                    throw SqlException.$(lexer.lastTokenPosition(), "'timestamp' expression expected");
                }
                tok = this.optTok(lexer);
            }
            model.setSampleByFromTo(fromNode, toNode);
            if (tok != null && SqlKeywords.isFillKeyword(tok)) {
                this.expectTok(lexer, '(');
                while (true) {
                    ExpressionNode fillNode;
                    if ((fillNode = this.expr(lexer, model, sqlParserCallback, model.getDecls())) == null) {
                        throw SqlException.$(lexer.lastTokenPosition(), "'none', 'prev', 'mid', 'null' or number expected");
                    }
                    model.addSampleByFill(fillNode);
                    tok = this.tokIncludingLocalBrace(lexer, "',' or ')'");
                    if (Chars.equals(tok, ')')) break;
                    this.expectTok(tok, lexer.lastTokenPosition(), ',');
                }
                tok = this.optTok(lexer);
            }
            if (tok != null && SqlKeywords.isAlignKeyword(tok)) {
                this.expectTo(lexer);
                tok = this.tok(lexer, "'calendar' or 'first observation'");
                if (SqlKeywords.isCalendarKeyword(tok)) {
                    tok = this.optTok(lexer);
                    if (tok == null) {
                        model.setSampleByTimezoneName(null);
                        model.setSampleByOffset(ZERO_OFFSET);
                    } else if (SqlKeywords.isTimeKeyword(tok)) {
                        this.expectZone(lexer);
                        model.setSampleByTimezoneName(this.expectExpr(lexer, sqlParserCallback, model.getDecls()));
                        tok = this.optTok(lexer);
                        if (tok != null && SqlKeywords.isWithKeyword(tok)) {
                            tok = this.parseWithOffset(lexer, model, sqlParserCallback);
                        } else {
                            model.setSampleByOffset(ZERO_OFFSET);
                        }
                    } else if (SqlKeywords.isWithKeyword(tok)) {
                        tok = this.parseWithOffset(lexer, model, sqlParserCallback);
                    } else {
                        model.setSampleByTimezoneName(null);
                        model.setSampleByOffset(ZERO_OFFSET);
                    }
                } else {
                    if (!SqlKeywords.isFirstKeyword(tok)) throw SqlException.$(lexer.lastTokenPosition(), "'calendar' or 'first observation' expected");
                    this.expectObservation(lexer);
                    if (model.getSampleByTo() != null || model.getSampleByFrom() != null) {
                        throw SqlException.$(lexer.getPosition(), "ALIGN TO FIRST OBSERVATION is incompatible with FROM-TO");
                    }
                    model.setSampleByTimezoneName(null);
                    model.setSampleByOffset(null);
                    tok = this.optTok(lexer);
                }
            } else if (this.configuration.getSampleByDefaultAlignmentCalendar()) {
                model.setSampleByOffset(ZERO_OFFSET);
            } else {
                model.setSampleByOffset(null);
            }
        }
        if (tok != null && SqlKeywords.isGroupKeyword(tok)) {
            this.expectBy(lexer);
            do {
                this.tokIncludingLocalBrace(lexer, "literal");
                lexer.unparseLast();
                ExpressionNode n = this.expr(lexer, model, sqlParserCallback, model.getDecls());
                if (n == null || n.type != 7 && n.type != 4 && n.type != 6 && n.type != 9) {
                    throw SqlException.$(n == null ? lexer.lastTokenPosition() : n.position, "literal expected");
                }
                model.addGroupBy(n);
            } while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ','));
        }
        if (tok != null && SqlKeywords.isOrderKeyword(tok)) {
            model.setOrderByPosition(lexer.lastTokenPosition());
            this.expectBy(lexer);
            do {
                this.tokIncludingLocalBrace(lexer, "literal");
                lexer.unparseLast();
                ExpressionNode n = this.expr(lexer, model, sqlParserCallback, model.getDecls());
                if (n == null || n.type == 10 || n.type == 11) {
                    throw SqlException.$(lexer.lastTokenPosition(), "literal or expression expected");
                }
                if (n.type == 4 && Chars.equals((CharSequence)"''", n.token) || n.type == 7 && n.token.length() == 0) {
                    throw SqlException.$(lexer.lastTokenPosition(), "non-empty literal or expression expected");
                }
                tok = this.optTok(lexer);
                if (tok != null && SqlKeywords.isDescKeyword(tok)) {
                    model.addOrderBy(n, 1);
                    tok = this.optTok(lexer);
                } else {
                    model.addOrderBy(n, 0);
                    if (tok != null && SqlKeywords.isAscKeyword(tok)) {
                        tok = this.optTok(lexer);
                    }
                }
                if (model.getOrderBy().size() < 1560) continue;
                throw SqlParser.err(lexer, tok, "Too many columns");
            } while (tok != null && Chars.equals(tok, ','));
        }
        if (tok != null && SqlKeywords.isLimitKeyword(tok)) {
            model.setLimitPosition(lexer.lastTokenPosition());
            ExpressionNode lo = this.expr(lexer, model, sqlParserCallback, model.getDecls());
            ExpressionNode hi = null;
            tok = this.optTok(lexer);
            if (tok != null && Chars.equals(tok, ',')) {
                hi = this.expr(lexer, model, sqlParserCallback, model.getDecls());
            } else {
                lexer.unparseLast();
            }
            model.setLimit(lo, hi);
            return;
        } else {
            lexer.unparseLast();
        }
    }

    private void parseFromTable(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null || !SqlKeywords.isFromKeyword(tok)) {
            throw SqlException.position(lexer.lastTokenPosition()).put("expected 'from'");
        }
        this.parseTableName(lexer, model);
    }

    private void parseHints(GenericLexer lexer, QueryModel model) {
        CharSequence hintToken;
        boolean parsingParams = false;
        CharSequence hintKey = null;
        CharSink hintValuesEntry = null;
        boolean error = false;
        while ((hintToken = SqlUtil.fetchNextHintToken(lexer)) != null) {
            if (error) continue;
            if (Chars.equals(hintToken, '(')) {
                if (parsingParams) {
                    error = true;
                    continue;
                }
                if (hintKey == null) {
                    error = true;
                    continue;
                }
                parsingParams = true;
                continue;
            }
            if (Chars.equals(hintToken, ')')) {
                if (!parsingParams) {
                    error = true;
                    continue;
                }
                if (hintValuesEntry == null) {
                    model.addHint(hintKey, null);
                } else {
                    model.addHint(hintKey, hintValuesEntry.toImmutable());
                    hintValuesEntry = null;
                }
                hintKey = null;
                parsingParams = false;
                continue;
            }
            if (parsingParams) {
                if (hintValuesEntry == null) {
                    hintValuesEntry = this.characterStore.newEntry();
                } else {
                    hintValuesEntry.put(' ');
                }
                hintValuesEntry.put(GenericLexer.unquote(hintToken));
                continue;
            }
            if (hintKey != null) {
                model.addHint(hintKey, null);
            }
            CharacterStoreEntry entry = this.characterStore.newEntry();
            entry.put(hintToken);
            hintKey = entry.toImmutable();
        }
        if (!error && !parsingParams && hintKey != null) {
            model.addHint(hintKey, null);
        }
    }

    private void parseInVolume(GenericLexer lexer, CreateTableOperationBuilderImpl tableOpBuilder) throws SqlException {
        int volumeKwPos = lexer.getPosition();
        this.expectTok(lexer, "volume");
        CharSequence tok = this.tok(lexer, "path for volume");
        if (Os.isWindows()) {
            throw SqlException.position(volumeKwPos).put("'in volume' is not supported on Windows");
        }
        tableOpBuilder.setVolumeAlias(GenericLexer.unquote(tok), lexer.lastTokenPosition());
    }

    private ExecutionModel parseInsert(GenericLexer lexer, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        InsertModel model = this.insertModelPool.next();
        CharSequence tok = this.tok(lexer, "atomic or into or batch");
        model.setBatchSize(this.configuration.getInsertModelBatchSize());
        boolean atomicSpecified = false;
        if (SqlKeywords.isAtomicKeyword(tok)) {
            atomicSpecified = true;
            model.setBatchSize(-1L);
            tok = this.tok(lexer, "into");
        }
        if (SqlKeywords.isBatchKeyword(tok)) {
            long val = this.expectLong(lexer);
            if (val <= 0L) {
                throw SqlException.$(lexer.lastTokenPosition(), "batch size must be positive integer");
            }
            model.setBatchSize(val);
            tok = this.tok(lexer, "into or o3MaxLag");
            if (SqlKeywords.isO3MaxLagKeyword(tok)) {
                int pos = lexer.getPosition();
                model.setO3MaxLag(SqlUtil.expectMicros(this.tok(lexer, "lag value"), pos));
                tok = this.tok(lexer, "into");
            }
        }
        if (!SqlKeywords.isIntoKeyword(tok)) {
            throw SqlException.$(lexer.lastTokenPosition(), "'into' expected");
        }
        tok = this.tok(lexer, "table name");
        tok = this.sansPublicSchema(tok, lexer);
        SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, lexer.lastTokenPosition());
        model.setTableName(this.nextLiteral(GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), lexer.lastTokenPosition()), lexer.lastTokenPosition()));
        tok = this.tok(lexer, "'(' or 'select'");
        if (Chars.equals(tok, '(')) {
            do {
                if (Chars.equals(tok = this.tok(lexer, "column"), ')')) {
                    throw SqlParser.err(lexer, tok, "missing column name");
                }
                SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, lexer.lastTokenPosition());
                model.addColumn(GenericLexer.unquote(tok), lexer.lastTokenPosition());
            } while (Chars.equals(tok = this.tok(lexer, "','"), ','));
            this.expectTok(tok, lexer.lastTokenPosition(), ')');
            tok = this.optTok(lexer);
        }
        if (tok == null) {
            throw SqlException.$(lexer.getPosition(), "'select' or 'values' expected");
        }
        if (SqlKeywords.isSelectKeyword(tok)) {
            model.setSelectKeywordPosition(lexer.lastTokenPosition());
            lexer.unparseLast();
            QueryModel queryModel = this.parseDml(lexer, null, lexer.lastTokenPosition(), true, sqlParserCallback, decls);
            model.setQueryModel(queryModel);
            tok = this.optTok(lexer);
            if (tok == null || Chars.equals(tok, ';')) {
                return model;
            }
            throw SqlParser.errUnexpected(lexer, tok);
        }
        model.setBatchSize(-1L);
        if (atomicSpecified) {
            throw SqlException.$(lexer.lastTokenPosition(), "'atomic' keyword can only be used in INSERT INTO SELECT statements.");
        }
        if (SqlKeywords.isValuesKeyword(tok)) {
            while (true) {
                this.expectTok(lexer, '(');
                ObjList<ExpressionNode> rowValues = new ObjList<ExpressionNode>();
                do {
                    rowValues.add(this.expectExpr(lexer, sqlParserCallback));
                } while (Chars.equals(tok = this.tok(lexer, "','"), ','));
                this.expectTok(tok, lexer.lastTokenPosition(), ')');
                model.addRowTupleValues(rowValues);
                model.addEndOfRowTupleValuesPosition(lexer.lastTokenPosition());
                tok = this.optTok(lexer);
                if (tok == null || Chars.equals(tok, ';')) {
                    return model;
                }
                this.expectTok(tok, lexer.lastTokenPosition(), ',');
            }
        }
        throw SqlParser.err(lexer, tok, "'select' or 'values' expected");
    }

    private QueryModel parseJoin(GenericLexer lexer, CharSequence tok, int joinType, LowerCaseCharSequenceObjHashMap<WithClauseModel> parent, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        QueryModel joinModel = this.queryModelPool.next();
        joinModel.copyDeclsFrom(decls);
        int errorPos = lexer.lastTokenPosition();
        if (SqlKeywords.isNotJoinKeyword(tok) && !Chars.equals(tok, ',')) {
            if (SqlKeywords.isLeftKeyword(tok)) {
                tok = this.tok(lexer, "join");
                joinType = 2;
                if (SqlKeywords.isOuterKeyword(tok)) {
                    tok = this.tok(lexer, "join");
                }
            } else {
                tok = this.tok(lexer, "join");
            }
            if (SqlKeywords.isNotJoinKeyword(tok)) {
                throw SqlException.position(errorPos).put("'join' expected");
            }
        }
        joinModel.setJoinType(joinType);
        joinModel.setJoinKeywordPosition(errorPos);
        tok = this.expectTableNameOrSubQuery(lexer);
        if (Chars.equals(tok, '(')) {
            joinModel.setNestedModel(this.parseAsSubQueryAndExpectClosingBrace(lexer, parent, true, sqlParserCallback, decls));
        } else {
            lexer.unparseLast();
            this.parseSelectFrom(lexer, joinModel, parent, sqlParserCallback);
        }
        tok = this.setModelAliasAndGetOptTok(lexer, joinModel);
        if (joinType == 3 && tok != null && SqlKeywords.isOnKeyword(tok)) {
            throw SqlException.$(lexer.lastTokenPosition(), "Cross joins cannot have join clauses");
        }
        boolean onClauseObserved = false;
        block1 : switch (joinType) {
            case 4: 
            case 5: 
            case 6: {
                if (tok == null || !SqlKeywords.isOnKeyword(tok)) {
                    lexer.unparseLast();
                    break;
                }
            }
            case 1: 
            case 2: {
                this.expectTok(lexer, tok, "on");
                onClauseObserved = true;
                try {
                    this.expressionParser.parseExpr(lexer, this.expressionTreeBuilder, sqlParserCallback, decls);
                    switch (this.expressionTreeBuilder.size()) {
                        case 0: {
                            throw SqlException.$(lexer.lastTokenPosition(), "Expression expected");
                        }
                        case 1: {
                            ExpressionNode expr = this.expressionTreeBuilder.poll();
                            if (expr.type == 7) {
                                do {
                                    joinModel.addJoinColumn(expr);
                                } while ((expr = this.expressionTreeBuilder.poll()) != null);
                                break;
                            }
                            joinModel.setJoinCriteria(this.rewriteKnownStatements(expr, decls, null));
                            break;
                        }
                        default: {
                            ExpressionNode expr;
                            while ((expr = this.expressionTreeBuilder.poll()) != null) {
                                if (expr.type != 7) {
                                    throw SqlException.$(lexer.lastTokenPosition(), "Column name expected");
                                }
                                joinModel.addJoinColumn(expr);
                            }
                            break block1;
                        }
                    }
                    break;
                }
                catch (SqlException e) {
                    this.expressionTreeBuilder.reset();
                    throw e;
                }
            }
            default: {
                lexer.unparseLast();
            }
        }
        tok = this.optTok(lexer);
        if (tok == null || !SqlKeywords.isToleranceKeyword(tok)) {
            lexer.unparseLast();
            return joinModel;
        }
        if (joinType != 4 && joinType != 6) {
            throw SqlException.$(lexer.lastTokenPosition(), "TOLERANCE is only supported for ASOF and LT joins");
        }
        ExpressionNode n = this.expr(lexer, null, sqlParserCallback, decls);
        if (n == null) {
            throw SqlException.$(lexer.lastTokenPosition(), "ASOF JOIN TOLERANCE period expected");
        }
        if (n.type == 9 && n.token != null && Chars.equals(n.token, (CharSequence)"-")) {
            throw SqlException.$(lexer.lastTokenPosition(), "ASOF JOIN TOLERANCE must be positive");
        }
        if (n.type != 4) {
            throw SqlException.$(lexer.lastTokenPosition(), "ASOF JOIN TOLERANCE must be a constant");
        }
        joinModel.setAsOfJoinTolerance(n);
        if (!onClauseObserved) {
            tok = this.optTok(lexer);
            if (tok != null && SqlKeywords.isOnKeyword(tok)) {
                throw SqlException.$(lexer.lastTokenPosition(), "'ON' clause must precede 'TOLERANCE' clause. Hint: put the ON condition right after the JOIN, then add TOLERANCE, e.g. \u2026 ASOF JOIN t2 ON t1.ts = t2.ts TOLERANCE 1h");
            }
            lexer.unparseLast();
        }
        return joinModel;
    }

    private void parseLatestBy(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok != null) {
            if (SqlKeywords.isByKeyword(tok)) {
                this.parseLatestByDeprecated(lexer, model);
                return;
            }
            if (SqlKeywords.isOnKeyword(tok)) {
                this.parseLatestByNew(lexer, model);
                return;
            }
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'on' or 'by' expected");
    }

    private void parseLatestByDeprecated(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok;
        do {
            model.addLatestBy(this.expectLiteral(lexer, model.getDecls()));
        } while (Chars.equalsNc(tok = SqlUtil.fetchNext(lexer), ','));
        model.setLatestByType(1);
        if (tok != null) {
            lexer.unparseLast();
        }
    }

    private void parseLatestByNew(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok;
        ExpressionNode timestamp = this.expectLiteral(lexer, model.getDecls());
        model.setTimestamp(timestamp);
        this.expectTok(lexer, "partition");
        this.expectTok(lexer, "by");
        do {
            model.addLatestBy(this.expectLiteral(lexer, model.getDecls()));
        } while (Chars.equalsNc(tok = SqlUtil.fetchNext(lexer), ','));
        model.setLatestByType(2);
        if (tok != null) {
            lexer.unparseLast();
        }
    }

    private ExecutionModel parseRenameStatement(GenericLexer lexer) throws SqlException {
        this.expectTok(lexer, "table");
        RenameTableModel model = this.renameTableModelPool.next();
        CharSequence tok = this.tok(lexer, "from table name");
        tok = this.sansPublicSchema(tok, lexer);
        SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, lexer.lastTokenPosition());
        model.setFrom(this.nextLiteral(GenericLexer.unquote(tok), lexer.lastTokenPosition()));
        tok = this.tok(lexer, "to");
        if (Chars.equals(tok, '(')) {
            throw SqlException.$(lexer.lastTokenPosition(), "function call is not allowed here");
        }
        lexer.unparseLast();
        this.expectTok(lexer, "to");
        tok = this.tok(lexer, "to table name");
        tok = this.sansPublicSchema(tok, lexer);
        SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, lexer.lastTokenPosition());
        model.setTo(this.nextLiteral(GenericLexer.unquote(tok), lexer.lastTokenPosition()));
        tok = this.optTok(lexer);
        if (tok != null && Chars.equals(tok, '(')) {
            throw SqlException.$(lexer.lastTokenPosition(), "function call is not allowed here");
        }
        if (tok != null && !Chars.equals(tok, ';')) {
            throw SqlException.$(lexer.lastTokenPosition(), "debris?");
        }
        return model;
    }

    private ExecutionModel parseSelect(GenericLexer lexer, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        lexer.unparseLast();
        QueryModel model = this.parseDml(lexer, null, lexer.lastTokenPosition(), true, sqlParserCallback, decls);
        CharSequence tok = this.optTok(lexer);
        if (tok == null || Chars.equals(tok, ';')) {
            return model;
        }
        if (Chars.equals(tok, (CharSequence)":=")) {
            throw SqlParser.errUnexpected(lexer, tok, "perhaps `DECLARE` was misspelled?");
        }
        throw SqlParser.errUnexpected(lexer, tok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSelectClause(GenericLexer lexer, QueryModel model, SqlParserCallback sqlParserCallback) throws SqlException {
        int pos = lexer.getPosition();
        CharSequence tok = SqlUtil.fetchNext(lexer, true);
        if (tok == null || this.subQueryMode && Chars.equals(tok, ')') && !this.overClauseMode) {
            throw SqlException.position(pos).put("[distinct] column expected");
        }
        if (Chars.equals(tok, (CharSequence)"/*+")) {
            this.parseHints(lexer, model);
            tok = this.tok(lexer, "[distinct] column");
        }
        if (SqlKeywords.isDistinctKeyword(tok)) {
            model.setDistinct(true);
        } else {
            lexer.unparseLast();
        }
        try {
            boolean hasFrom;
            block92: {
                hasFrom = false;
                do {
                    int aliasPosition;
                    CharSequence alias;
                    QueryColumn col;
                    ExpressionNode expr;
                    if (Chars.equals(tok = this.tok(lexer, "column"), '*')) {
                        expr = this.nextLiteral(GenericLexer.immutableOf(tok), lexer.lastTokenPosition());
                    } else {
                        if (SqlKeywords.isFromKeyword(tok)) {
                            if (this.accumulatedColumns.size() == 0) {
                                throw SqlException.$(lexer.lastTokenPosition(), "column expression expected");
                            }
                            hasFrom = true;
                            lexer.unparseLast();
                            break block92;
                        }
                        if (SqlKeywords.isSelectKeyword(tok)) {
                            throw SqlException.$(lexer.getPosition(), "reserved name");
                        }
                        lexer.unparseLast();
                        expr = this.expr(lexer, model, sqlParserCallback, model.getDecls());
                        if (expr == null) {
                            throw SqlException.$(lexer.lastTokenPosition(), "missing expression");
                        }
                        if (Chars.endsWith(expr.token, '.') && expr.type == 7) {
                            throw SqlException.$(expr.position + expr.token.length(), "'*' or column name expected");
                        }
                    }
                    tok = this.optTok(lexer);
                    int colPosition = lexer.lastTokenPosition();
                    int windowNullsDesc = 0;
                    if (tok != null) {
                        if (SqlKeywords.isIgnoreWord(tok)) {
                            windowNullsDesc = 1;
                        } else if (SqlKeywords.isRespectWord(tok)) {
                            windowNullsDesc = 2;
                        }
                    }
                    if (tok != null && windowNullsDesc > 0) {
                        CharSequence next = this.optTok(lexer);
                        if (next != null && SqlKeywords.isNullsWord(next)) {
                            this.expectTok(lexer, "over");
                        } else {
                            windowNullsDesc = 0;
                            lexer.backTo(colPosition, tok);
                        }
                    }
                    if (tok != null && SqlKeywords.isOverKeyword(tok) || windowNullsDesc > 0) {
                        this.expectTok(lexer, '(');
                        this.overClauseMode = true;
                        try {
                            WindowColumn winCol = this.windowColumnPool.next().of(null, expr);
                            col = winCol;
                            tok = this.tokIncludingLocalBrace(lexer, "'partition' or 'order' or ')'");
                            winCol.setIgnoreNulls(windowNullsDesc == 1);
                            winCol.setNullsDescPos(windowNullsDesc > 0 ? colPosition : 0);
                            if (SqlKeywords.isPartitionKeyword(tok)) {
                                this.expectTok(lexer, "by");
                                ObjList<ExpressionNode> partitionBy = winCol.getPartitionBy();
                                do {
                                    if (SqlKeywords.isOrderKeyword(tok = this.tok(lexer, "column name, 'order' or ')'"))) {
                                        if (partitionBy.size() != 0) break;
                                        throw SqlException.$(lexer.lastTokenPosition(), "at least one column is expected in `partition by` clause");
                                    }
                                    lexer.unparseLast();
                                    partitionBy.add(this.expectExpr(lexer, sqlParserCallback, model.getDecls()));
                                } while (Chars.equals(tok = this.tok(lexer, "'order' or ')'"), ','));
                            }
                            if (SqlKeywords.isOrderKeyword(tok)) {
                                this.expectTok(lexer, "by");
                                do {
                                    ExpressionNode orderByExpr = this.expectExpr(lexer, sqlParserCallback, model.getDecls());
                                    tok = this.tokIncludingLocalBrace(lexer, "'asc' or 'desc'");
                                    if (SqlKeywords.isDescKeyword(tok)) {
                                        winCol.addOrderBy(orderByExpr, 1);
                                        tok = this.tokIncludingLocalBrace(lexer, "',' or ')'");
                                        continue;
                                    }
                                    winCol.addOrderBy(orderByExpr, 0);
                                    if (!SqlKeywords.isAscKeyword(tok)) continue;
                                    tok = this.tokIncludingLocalBrace(lexer, "',' or ')'");
                                } while (Chars.equals(tok, ','));
                            }
                            int framingMode = -1;
                            if (SqlKeywords.isRowsKeyword(tok)) {
                                framingMode = 2;
                            } else if (SqlKeywords.isRangeKeyword(tok)) {
                                framingMode = 1;
                            } else if (SqlKeywords.isGroupsKeyword(tok)) {
                                framingMode = 3;
                            } else if (!Chars.equals(tok, ')')) {
                                throw SqlException.$(lexer.lastTokenPosition(), "'rows', 'groups', 'range' or ')' expected");
                            }
                            if (framingMode != -1) {
                                winCol.setFramingMode(framingMode);
                                if (framingMode == 3 && winCol.getOrderBy().size() == 0) {
                                    throw SqlException.$(lexer.lastTokenPosition(), "GROUPS mode requires an ORDER BY clause");
                                }
                                tok = this.tok(lexer, "'between', 'unbounded', 'current' or expression");
                                if (SqlKeywords.isBetweenKeyword(tok)) {
                                    long timeUnit;
                                    tok = this.tok(lexer, "'unbounded', 'current' or expression");
                                    if (this.isUnboundedPreceding(lexer, tok)) {
                                        winCol.setRowsLoKind(1, lexer.lastTokenPosition());
                                    } else if (this.isCurrentRow(lexer, tok)) {
                                        winCol.setRowsLoKind(3, lexer.lastTokenPosition());
                                    } else {
                                        if (SqlKeywords.isPrecedingKeyword(tok)) {
                                            throw SqlException.$(lexer.lastTokenPosition(), "integer expression expected");
                                        }
                                        pos = lexer.lastTokenPosition();
                                        lexer.unparseLast();
                                        winCol.setRowsLoExpr(this.expectExpr(lexer, sqlParserCallback, model.getDecls()), pos);
                                        if (framingMode == 1 && (timeUnit = this.parseTimeUnit(lexer)) != -1L) {
                                            winCol.setRowsLoExprTimeUnit(timeUnit);
                                        }
                                        if (SqlKeywords.isPrecedingKeyword(tok = this.tok(lexer, "'preceding' or 'following'"))) {
                                            winCol.setRowsLoKind(1, lexer.lastTokenPosition());
                                        } else {
                                            if (!SqlKeywords.isFollowingKeyword(tok)) throw SqlException.$(lexer.lastTokenPosition(), "'preceding' or 'following' expected");
                                            winCol.setRowsLoKind(2, lexer.lastTokenPosition());
                                        }
                                    }
                                    if (winCol.getOrderBy().size() != 1 && winCol.requiresOrderBy()) {
                                        throw SqlException.$(lexer.lastTokenPosition(), "RANGE with offset PRECEDING/FOLLOWING requires exactly one ORDER BY column");
                                    }
                                    tok = this.tok(lexer, "'and'");
                                    if (!SqlKeywords.isAndKeyword(tok)) throw SqlException.$(lexer.lastTokenPosition(), "'and' expected");
                                    tok = this.tok(lexer, "'unbounded', 'current' or expression");
                                    if (SqlKeywords.isUnboundedKeyword(tok)) {
                                        tok = this.tok(lexer, "'following'");
                                        if (!SqlKeywords.isFollowingKeyword(tok)) throw SqlException.$(lexer.lastTokenPosition(), "'following' expected");
                                        winCol.setRowsHiKind(2, lexer.lastTokenPosition());
                                    } else if (this.isCurrentRow(lexer, tok)) {
                                        winCol.setRowsHiKind(3, lexer.lastTokenPosition());
                                    } else {
                                        if (SqlKeywords.isPrecedingKeyword(tok) || SqlKeywords.isFollowingKeyword(tok)) {
                                            throw SqlException.$(lexer.lastTokenPosition(), "integer expression expected");
                                        }
                                        pos = lexer.lastTokenPosition();
                                        lexer.unparseLast();
                                        winCol.setRowsHiExpr(this.expectExpr(lexer, sqlParserCallback, model.getDecls()), pos);
                                        if (framingMode == 1 && (timeUnit = this.parseTimeUnit(lexer)) != -1L) {
                                            winCol.setRowsHiExprTimeUnit(timeUnit);
                                        }
                                        if (SqlKeywords.isPrecedingKeyword(tok = this.tok(lexer, "'preceding'  'following'"))) {
                                            if (winCol.getRowsLoKind() == 3) {
                                                throw SqlException.$(lexer.lastTokenPosition(), "start row is CURRENT, end row not must be PRECEDING");
                                            }
                                            if (winCol.getRowsLoKind() == 2) {
                                                throw SqlException.$(lexer.lastTokenPosition(), "start row is FOLLOWING, end row not must be PRECEDING");
                                            }
                                            winCol.setRowsHiKind(1, lexer.lastTokenPosition());
                                        } else {
                                            if (!SqlKeywords.isFollowingKeyword(tok)) throw SqlException.$(lexer.lastTokenPosition(), "'preceding' or 'following' expected");
                                            winCol.setRowsHiKind(2, lexer.lastTokenPosition());
                                        }
                                    }
                                } else {
                                    pos = lexer.lastTokenPosition();
                                    if (this.isUnboundedPreceding(lexer, tok)) {
                                        winCol.setRowsLoKind(1, lexer.lastTokenPosition());
                                    } else if (this.isCurrentRow(lexer, tok)) {
                                        winCol.setRowsLoKind(3, lexer.lastTokenPosition());
                                    } else {
                                        long timeUnit;
                                        if (SqlKeywords.isPrecedingKeyword(tok) || SqlKeywords.isFollowingKeyword(tok)) {
                                            throw SqlException.$(pos, "integer expression expected");
                                        }
                                        lexer.unparseLast();
                                        winCol.setRowsLoExpr(this.expectExpr(lexer, sqlParserCallback, model.getDecls()), pos);
                                        if (framingMode == 1 && (timeUnit = this.parseTimeUnit(lexer)) != -1L) {
                                            winCol.setRowsLoExprTimeUnit(timeUnit);
                                        }
                                        if (!SqlKeywords.isPrecedingKeyword(tok = this.tok(lexer, "'preceding'"))) throw SqlException.$(lexer.lastTokenPosition(), "'preceding' expected");
                                        winCol.setRowsLoKind(1, lexer.lastTokenPosition());
                                    }
                                    winCol.setRowsHiKind(3, pos);
                                }
                                if (winCol.getOrderBy().size() != 1 && winCol.requiresOrderBy()) {
                                    throw SqlException.$(lexer.lastTokenPosition(), "RANGE with offset PRECEDING/FOLLOWING requires exactly one ORDER BY column");
                                }
                                tok = this.tok(lexer, "'exclude' or ')' expected");
                                if (SqlKeywords.isExcludeKeyword(tok)) {
                                    tok = this.tok(lexer, "'current', 'group', 'ties' or 'no other' expected");
                                    int excludePos = lexer.lastTokenPosition();
                                    if (SqlKeywords.isCurrentKeyword(tok)) {
                                        tok = this.tok(lexer, "'row' expected");
                                        if (!SqlKeywords.isRowKeyword(tok)) throw SqlException.$(lexer.lastTokenPosition(), "'row' expected");
                                        winCol.setExclusionKind(1, excludePos);
                                    } else if (SqlKeywords.isGroupKeyword(tok)) {
                                        winCol.setExclusionKind(2, excludePos);
                                    } else if (SqlKeywords.isTiesKeyword(tok)) {
                                        winCol.setExclusionKind(3, excludePos);
                                    } else {
                                        if (!SqlKeywords.isNoKeyword(tok)) throw SqlException.$(lexer.lastTokenPosition(), "'current', 'group', 'ties' or 'no other' expected");
                                        tok = this.tok(lexer, "'others' expected");
                                        if (!SqlKeywords.isOthersKeyword(tok)) throw SqlException.$(lexer.lastTokenPosition(), "'others' expected");
                                        winCol.setExclusionKind(4, excludePos);
                                    }
                                    tok = this.tok(lexer, "')' expected");
                                }
                            }
                            this.expectTok(tok, lexer.lastTokenPosition(), ')');
                        }
                        finally {
                            this.overClauseMode = false;
                        }
                        tok = this.optTok(lexer);
                    } else {
                        if (expr.type == 10) {
                            throw SqlException.$(expr.position, "query is not expected, did you mean column?");
                        }
                        col = this.queryColumnPool.next().of(null, expr);
                    }
                    if (tok != null && columnAliasStop.excludes(tok)) {
                        this.assertNotDot(lexer, tok);
                        if (SqlKeywords.isAsKeyword(tok)) {
                            tok = this.tok(lexer, "alias");
                            SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, lexer.lastTokenPosition());
                            CharSequence aliasTok = GenericLexer.immutableOf(tok);
                            this.validateIdentifier(lexer, aliasTok);
                            boolean unquoting = Chars.indexOf(aliasTok, '.') == -1;
                            alias = unquoting ? GenericLexer.unquote(aliasTok) : aliasTok;
                            aliasPosition = lexer.lastTokenPosition();
                        } else {
                            this.validateIdentifier(lexer, tok);
                            SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, lexer.lastTokenPosition());
                            boolean unquoting = Chars.indexOf(tok, '.') == -1;
                            alias = GenericLexer.immutableOf(unquoting ? GenericLexer.unquote(tok) : tok);
                            aliasPosition = lexer.lastTokenPosition();
                        }
                        if (col.getAst().isWildcard()) {
                            throw SqlParser.err(lexer, null, "wildcard cannot have alias");
                        }
                        tok = this.optTok(lexer);
                        this.aliasMap.put(alias, col);
                    } else {
                        alias = null;
                        aliasPosition = -1;
                    }
                    if (expr.type == 10) {
                        expr.token = alias;
                    }
                    if (alias != null) {
                        if (alias.length() == 0) {
                            throw SqlParser.err(lexer, null, "column alias cannot be a blank string");
                        }
                        col.setAlias(alias, aliasPosition);
                    }
                    this.accumulatedColumns.add(col);
                    this.accumulatedColumnPositions.add(colPosition);
                    if (tok == null || Chars.equals(tok, ';') || Chars.equals(tok, ')')) {
                        lexer.unparseLast();
                    } else if (SqlKeywords.isFromKeyword(tok)) {
                        hasFrom = true;
                        lexer.unparseLast();
                    } else {
                        if (!setOperations.contains(tok)) continue;
                        lexer.unparseLast();
                    }
                    break block92;
                } while (Chars.equals(tok, ','));
                if (!SqlKeywords.isIgnoreWord(tok) && !SqlKeywords.isRespectWord(tok)) throw SqlParser.err(lexer, tok, "',', 'from' or 'over' expected");
                throw SqlParser.err(lexer, tok, "',', 'nulls' or 'from' expected");
            }
            int n = this.accumulatedColumns.size();
            for (int i = 0; i < n; ++i) {
                QueryColumn qc = this.accumulatedColumns.getQuick(i);
                if (qc.getAlias() == null) {
                    this.generateColumnAlias(lexer, qc, hasFrom);
                }
                model.addBottomUpColumn(this.accumulatedColumnPositions.getQuick(i), qc, false);
            }
            return;
        }
        finally {
            this.accumulatedColumns.clear();
            this.accumulatedColumnPositions.clear();
            this.aliasMap.clear();
        }
    }

    private void parseSelectFrom(GenericLexer lexer, QueryModel model, LowerCaseCharSequenceObjHashMap<WithClauseModel> masterModel, SqlParserCallback sqlParserCallback) throws SqlException {
        ExpressionNode expr = this.expr(lexer, model, sqlParserCallback);
        if (expr == null) {
            throw SqlException.position(lexer.lastTokenPosition()).put("table name expected");
        }
        if (expr.type != 7 && expr.type != 4 && expr.type != 6) {
            throw SqlException.$(expr.position, "function, literal or constant is expected");
        }
        if (model.getDecls().contains(expr.token)) {
            if (expr.type == 7) {
                expr = model.getDecls().get((CharSequence)expr.token).rhs;
            } else {
                throw SqlException.$(lexer.lastTokenPosition(), "expected literal table name or subquery");
            }
        }
        CharSequence tableName = expr.token;
        switch (expr.type) {
            case 4: 
            case 7: {
                WithClauseModel withClause = masterModel.get(tableName);
                if (withClause != null) {
                    model.setNestedModel(this.parseWith(lexer, withClause, sqlParserCallback, model.getDecls()));
                    model.setAlias(this.literal(tableName, expr.position));
                    break;
                }
                int dot = Chars.indexOfLastUnquoted(tableName, '.');
                if (dot == -1) {
                    model.setTableNameExpr(this.literal(tableName, expr.position));
                    break;
                }
                if (SqlKeywords.isPublicKeyword(tableName, 0, dot)) {
                    if (dot + 1 == tableName.length()) {
                        throw SqlException.$(expr.position, "table name expected");
                    }
                    BufferWindowCharSequence fs = (BufferWindowCharSequence)tableName;
                    fs.shiftLo(dot + 1);
                    model.setTableNameExpr(this.literal(tableName, expr.position + dot + 1));
                    break;
                }
                model.setTableNameExpr(this.literal(tableName, expr.position));
                break;
            }
            case 6: {
                model.setTableNameExpr(expr);
                break;
            }
            default: {
                throw SqlException.$(expr.position, "function, literal or constant is expected");
            }
        }
    }

    private int parseSymbolCapacity(GenericLexer lexer) throws SqlException {
        int errorPosition = lexer.getPosition();
        int symbolCapacity = this.expectInt(lexer);
        TableUtils.validateSymbolCapacity(errorPosition, symbolCapacity);
        return Numbers.ceilPow2(symbolCapacity);
    }

    private void parseTableName(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok = this.tok(lexer, "expected a table name");
        tok = this.sansPublicSchema(tok, lexer);
        CharSequence tableName = GenericLexer.assertNoDotsAndSlashes(GenericLexer.unquote(tok), lexer.lastTokenPosition());
        ExpressionNode tableNameExpr = this.expressionNodePool.next().of(7, tableName, 0, lexer.lastTokenPosition());
        tableNameExpr = this.rewriteDeclaredVariables(tableNameExpr, model.getDecls(), null);
        model.setTableNameExpr(tableNameExpr);
    }

    private long parseTimeUnit(GenericLexer lexer) throws SqlException {
        CharSequence tok = this.tok(lexer, "'preceding' or time unit");
        long unit = -1L;
        if (SqlKeywords.isMicrosecondKeyword(tok) || SqlKeywords.isMicrosecondsKeyword(tok)) {
            unit = WindowColumn.ITME_UNIT_MICROSECOND;
        } else if (SqlKeywords.isMillisecondKeyword(tok) || SqlKeywords.isMillisecondsKeyword(tok)) {
            unit = 1000L;
        } else if (SqlKeywords.isSecondKeyword(tok) || SqlKeywords.isSecondsKeyword(tok)) {
            unit = 1000000L;
        } else if (SqlKeywords.isMinuteKeyword(tok) || SqlKeywords.isMinutesKeyword(tok)) {
            unit = 60000000L;
        } else if (SqlKeywords.isHourKeyword(tok) || SqlKeywords.isHoursKeyword(tok)) {
            unit = 3600000000L;
        } else if (SqlKeywords.isDayKeyword(tok) || SqlKeywords.isDaysKeyword(tok)) {
            unit = 86400000000L;
        }
        if (unit == -1L) {
            lexer.unparseLast();
        }
        return unit;
    }

    private ExpressionNode parseTimestamp(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (tok != null && SqlKeywords.isTimestampKeyword(tok)) {
            this.expectTok(lexer, '(');
            ExpressionNode result = this.expectLiteral(lexer);
            this.tokIncludingLocalBrace(lexer, "')'");
            return result;
        }
        return null;
    }

    private ExecutionModel parseUpdate(GenericLexer lexer, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        lexer.unparseLast();
        QueryModel model = this.parseDmlUpdate(lexer, sqlParserCallback, decls);
        CharSequence tok = this.optTok(lexer);
        if (tok == null || Chars.equals(tok, ';')) {
            return model;
        }
        throw SqlParser.errUnexpected(lexer, tok);
    }

    private void parseUpdateClause(GenericLexer lexer, QueryModel updateQueryModel, QueryModel fromModel, SqlParserCallback sqlParserCallback) throws SqlException {
        block4: {
            CharSequence tok = this.tok(lexer, "table name or alias");
            tok = this.sansPublicSchema(tok, lexer);
            SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, lexer.lastTokenPosition());
            CharSequence tableName = GenericLexer.immutableOf(GenericLexer.unquote(tok));
            ExpressionNode tableNameExpr = ExpressionNode.FACTORY.newInstance().of(7, tableName, 0, 0);
            updateQueryModel.setTableNameExpr(tableNameExpr);
            fromModel.setTableNameExpr(tableNameExpr);
            tok = this.tok(lexer, "AS, SET or table alias expected");
            if (SqlKeywords.isAsKeyword(tok) && SqlKeywords.isSetKeyword(tok = this.tok(lexer, "table alias expected"))) {
                throw SqlException.$(lexer.lastTokenPosition(), "table alias expected");
            }
            if (!SqlKeywords.isAsKeyword(tok) && !SqlKeywords.isSetKeyword(tok)) {
                CharSequence tableAlias = GenericLexer.immutableOf(tok);
                SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, lexer.lastTokenPosition());
                ExpressionNode tableAliasExpr = ExpressionNode.FACTORY.newInstance().of(7, tableAlias, 0, 0);
                updateQueryModel.setAlias(tableAliasExpr);
                tok = this.tok(lexer, "SET expected");
            }
            if (!SqlKeywords.isSetKeyword(tok)) {
                throw SqlException.$(lexer.lastTokenPosition(), "SET expected");
            }
            do {
                tok = this.tok(lexer, "column name");
                CharSequence col = GenericLexer.immutableOf(GenericLexer.unquote(tok));
                int colPosition = lexer.lastTokenPosition();
                this.expectTok(lexer, "=");
                ExpressionNode expr = this.expr(lexer, (QueryModel)null, sqlParserCallback);
                ExpressionNode setColumnExpression = this.expressionNodePool.next().of(7, col, 0, colPosition);
                updateQueryModel.getUpdateExpressions().add(setColumnExpression);
                QueryColumn valueColumn = this.queryColumnPool.next().of(col, expr);
                fromModel.addBottomUpColumn(colPosition, valueColumn, false, "in SET clause");
                tok = this.optTok(lexer);
                if (tok == null) break block4;
            } while (tok.length() == 1 && tok.charAt(0) == ',');
            lexer.unparseLast();
        }
    }

    @NotNull
    private ExecutionModel parseWith(GenericLexer lexer, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        this.parseWithClauses(lexer, this.topLevelWithModel, sqlParserCallback, decls);
        CharSequence tok = this.tok(lexer, "'select', 'update' or name expected");
        if (SqlKeywords.isSelectKeyword(tok)) {
            return this.parseSelect(lexer, sqlParserCallback, decls);
        }
        if (SqlKeywords.isUpdateKeyword(tok)) {
            return this.parseUpdate(lexer, sqlParserCallback, decls);
        }
        if (SqlKeywords.isInsertKeyword(tok)) {
            return this.parseInsert(lexer, sqlParserCallback, decls);
        }
        throw SqlException.$(lexer.lastTokenPosition(), "'select' | 'update' | 'insert' expected");
    }

    private QueryModel parseWith(GenericLexer lexer, WithClauseModel wcm, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        QueryModel m = wcm.popModel();
        if (m != null) {
            return m;
        }
        lexer.stash();
        lexer.goToPosition(wcm.getPosition());
        m = this.parseAsSubQueryAndExpectClosingBrace(lexer, wcm.getWithClauses(), false, sqlParserCallback, decls);
        lexer.unstash();
        return m;
    }

    private void parseWithClauses(GenericLexer lexer, LowerCaseCharSequenceObjHashMap<WithClauseModel> model, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        CharSequence tok;
        do {
            ExpressionNode name = this.expectLiteral(lexer);
            if (name.token.length() == 0) {
                throw SqlException.$(name.position, "empty common table expression name");
            }
            if (model.get(name.token) != null) {
                throw SqlException.$(name.position, "duplicate name");
            }
            this.expectTok(lexer, "as");
            this.expectTok(lexer, '(');
            int lo = lexer.lastTokenPosition();
            WithClauseModel wcm = this.withClauseModelPool.next();
            wcm.of(lo + 1, model, this.parseAsSubQueryAndExpectClosingBrace(lexer, model, true, sqlParserCallback, decls));
            model.put(name.token, wcm);
        } while ((tok = this.optTok(lexer)) != null && Chars.equals(tok, ','));
        lexer.unparseLast();
    }

    private CharSequence parseWithOffset(GenericLexer lexer, QueryModel model, SqlParserCallback sqlParserCallback) throws SqlException {
        this.expectOffset(lexer);
        model.setSampleByOffset(this.expectExpr(lexer, sqlParserCallback, model.getDecls()));
        CharSequence tok = this.optTok(lexer);
        return tok;
    }

    private void rewriteCase(ExpressionNode node) {
        if (node.type == 6 && SqlKeywords.isCaseKeyword(node.token)) {
            int lim;
            ExpressionNode elseExpr;
            this.tempExprNodes.clear();
            ExpressionNode literal = null;
            boolean convertToSwitch = true;
            int paramCount = node.paramCount;
            if ((paramCount & 1) == 0) {
                elseExpr = node.args.getQuick(0);
                lim = 0;
            } else {
                elseExpr = null;
                lim = -1;
            }
            ExpressionNode first = node.args.getQuick(paramCount - 1);
            if (first.token != null) {
                node.token = "switch";
                return;
            }
            int thenRemainder = elseExpr == null ? 0 : 1;
            for (int i = paramCount - 2; i > lim; --i) {
                if ((i & 1) == thenRemainder) {
                    this.tempExprNodes.add(node.args.getQuick(i));
                    continue;
                }
                ExpressionNode where = node.args.getQuick(i);
                if (where.type == 9 && where.token.charAt(0) == '=') {
                    ExpressionNode thisLiteral;
                    ExpressionNode thisConstant;
                    if (where.lhs.type == 4 && where.rhs.type == 7) {
                        thisConstant = where.lhs;
                        thisLiteral = where.rhs;
                    } else if (where.lhs.type == 7 && where.rhs.type == 4) {
                        thisConstant = where.rhs;
                        thisLiteral = where.lhs;
                    } else {
                        convertToSwitch = false;
                        break;
                    }
                    if (literal == null) {
                        literal = thisLiteral;
                        this.tempExprNodes.add(thisConstant);
                        continue;
                    }
                    if (Chars.equals(literal.token, thisLiteral.token)) {
                        this.tempExprNodes.add(thisConstant);
                        continue;
                    }
                    convertToSwitch = false;
                    break;
                }
                convertToSwitch = false;
                break;
            }
            if (convertToSwitch) {
                int n = this.tempExprNodes.size();
                node.token = "switch";
                node.args.clear();
                if (elseExpr == null) {
                    elseExpr = SqlUtil.nextConstant(this.expressionNodePool, "null", node.position);
                }
                node.args.add(elseExpr);
                for (int i = n - 1; i > -1; --i) {
                    node.args.add(this.tempExprNodes.getQuick(i));
                }
                node.args.add(literal);
                node.paramCount = n + 2;
            } else {
                node.args.remove(paramCount - 1);
                node.paramCount = paramCount - 1;
                if (node.paramCount < 3) {
                    node.rhs = node.args.get(0);
                    node.lhs = node.args.get(1);
                    node.args.clear();
                }
            }
        }
    }

    private void rewriteConcat(ExpressionNode node) {
        if (node.type == 9 && SqlKeywords.isConcatOperator(node.token)) {
            node.type = 6;
            node.token = "concat";
            this.addConcatArgs(node.args, node.rhs);
            this.addConcatArgs(node.args, node.lhs);
            node.paramCount = node.args.size();
            if (node.paramCount > 2) {
                node.rhs = null;
                node.lhs = null;
            }
        }
    }

    private void rewriteCount(ExpressionNode node) {
        if (node.type == 6 && SqlKeywords.isCountKeyword(node.token) && node.paramCount == 1) {
            ExpressionNode that = node.rhs;
            if (Chars.equalsNc(that.token, '*') && that.rhs == null && node.lhs == null) {
                that.paramCount = 0;
                node.rhs = null;
                node.paramCount = 0;
            }
        }
    }

    private ExpressionNode rewriteDeclaredVariables(ExpressionNode expr, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls, @Nullable CharSequence exprTargetVariableName) throws SqlException {
        if (decls == null || decls.size() == 0) {
            return expr;
        }
        return SqlParser.recursiveReplace(expr, this.rewriteDeclaredVariablesInExpressionVisitor.of(decls, exprTargetVariableName));
    }

    private void rewriteJsonExtractCast(ExpressionNode node) {
        if (node.type == 6 && SqlKeywords.isCastKeyword(node.token) && node.lhs != null && SqlKeywords.isJsonExtract(node.lhs.token) && node.lhs.paramCount == 2) {
            ExpressionNode jsonExtractNode = node.lhs;
            ExpressionNode typeNode = node.rhs;
            if (typeNode != null) {
                int castType = ColumnType.typeOf(typeNode.token);
                if (castType == 26) {
                    node.token = jsonExtractNode.token;
                    node.paramCount = jsonExtractNode.paramCount;
                    node.type = jsonExtractNode.type;
                    node.position = jsonExtractNode.position;
                    node.lhs = jsonExtractNode.lhs;
                    node.rhs = jsonExtractNode.rhs;
                    node.args.clear();
                } else if (JsonExtractTypedFunctionFactory.isIntrusivelyOptimized(castType)) {
                    int type = ColumnType.typeOf(typeNode.token);
                    node.token = jsonExtractNode.token;
                    node.paramCount = 3;
                    node.type = jsonExtractNode.type;
                    node.position = jsonExtractNode.position;
                    node.lhs = null;
                    node.rhs = null;
                    node.args.clear();
                    CharacterStoreEntry characterStoreEntry = this.characterStore.newEntry();
                    characterStoreEntry.put(type);
                    node.args.add(this.expressionNodePool.next().of(4, characterStoreEntry.toImmutable(), typeNode.precedence, typeNode.position));
                    node.args.add(jsonExtractNode.rhs);
                    node.args.add(jsonExtractNode.lhs);
                }
            }
        }
    }

    private ExpressionNode rewriteKnownStatements(ExpressionNode parent, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls, @Nullable CharSequence exprTargetVariableName) throws SqlException {
        this.traversalAlgo.traverse(parent, this.rewriteCountRef);
        this.traversalAlgo.traverse(parent, this.rewriteCaseRef);
        this.traversalAlgo.traverse(parent, this.rewriteConcatRef);
        this.traversalAlgo.traverse(parent, this.rewritePgCastRef);
        this.traversalAlgo.traverse(parent, this.rewriteJsonExtractCastRef);
        return this.rewriteDeclaredVariables(parent, decls, exprTargetVariableName);
    }

    private void rewritePgCast(ExpressionNode node) {
        if (node.type == 9 && SqlKeywords.isColonColon(node.token)) {
            node.token = "cast";
            node.type = 6;
            node.rhs.type = 4;
            if (this.rewritePgCast0(node.rhs, "float", (short)10)) {
                return;
            }
            if (this.rewritePgCast0(node.rhs, "float8", (short)10)) {
                return;
            }
            if (this.rewritePgCast0(node.rhs, "float4", (short)9)) {
                return;
            }
            if (this.rewritePgCast0(node.rhs, "int4", (short)5)) {
                return;
            }
            if (this.rewritePgCast0(node.rhs, "int8", (short)6)) {
                return;
            }
            if (this.rewritePgCast0(node.rhs, "int2", (short)3)) {
                return;
            }
            this.rewritePgCast0(node.rhs, "double precision", (short)10);
        }
    }

    private boolean rewritePgCast0(ExpressionNode typeNode, String srcTypePrefix, short type) {
        int dims;
        String suffix;
        int prefixLen;
        CharSequence token = typeNode.token;
        if (!Chars.startsWithLowerCase(token, srcTypePrefix)) {
            return false;
        }
        int len = token.length();
        int rem = len - (prefixLen = srcTypePrefix.length());
        if (rem == 0) {
            typeNode.token = ColumnType.nameOf(type);
            return true;
        }
        if (rem % 2 == 0 && Chars.endsWith(token, suffix = ColumnType.ARRAY_DIM_SUFFIX[dims = rem / 2])) {
            typeNode.token = ColumnType.nameOf(ColumnType.encodeArrayType(type, dims));
            return true;
        }
        return false;
    }

    @NotNull
    private CharSequence sansPublicSchema(@NotNull CharSequence tok, GenericLexer lexer) throws SqlException {
        int lo = 0;
        int hi = tok.length();
        if (Chars.isQuoted(tok)) {
            lo = 1;
            --hi;
        }
        if (!SqlKeywords.isPublicKeyword(tok, lo, hi)) {
            return tok;
        }
        CharSequence savedTok = GenericLexer.immutableOf(tok);
        tok = this.optTok(lexer);
        if (tok == null) {
            return savedTok;
        }
        if (!Chars.equals(tok, '.')) {
            lexer.unparseLast();
            return savedTok;
        }
        tok = this.tok(lexer, "table name");
        return tok;
    }

    private CharSequence setModelAliasAndGetOptTok(GenericLexer lexer, QueryModel joinModel) throws SqlException {
        CharSequence tok = this.optTok(lexer);
        if (tok != null && tableAliasStop.excludes(tok)) {
            this.checkSupportedJoinType(lexer, tok);
            if (SqlKeywords.isAsKeyword(tok)) {
                tok = this.tok(lexer, "alias");
            }
            if (tok.length() == 0 || SqlKeywords.isEmptyAlias(tok)) {
                throw SqlException.position(lexer.lastTokenPosition()).put("Empty table alias");
            }
            SqlKeywords.assertNameIsQuotedOrNotAKeyword(tok, lexer.lastTokenPosition());
            joinModel.setAlias(this.literal(lexer, tok));
            tok = this.optTok(lexer);
        }
        return tok;
    }

    private CharSequence setModelAliasAndTimestamp(GenericLexer lexer, QueryModel model) throws SqlException {
        CharSequence tok = this.setModelAliasAndGetOptTok(lexer, model);
        ExpressionNode timestamp = this.parseTimestamp(lexer, tok);
        if (timestamp != null) {
            model.setTimestamp(timestamp);
            model.setExplicitTimestamp(true);
            tok = this.optTok(lexer);
        }
        return tok;
    }

    private int toColumnType(GenericLexer lexer, @NotNull CharSequence tok) throws SqlException {
        int nDims;
        CharSequence next;
        int typePosition = lexer.lastTokenPosition();
        if (Chars.equalsNc(tok, '[')) {
            tok = this.optTok(lexer);
            if (tok == null) {
                throw SqlException.position(typePosition).put("dangling '[' where column type is expected");
            }
            if (Chars.equals(tok, ']')) {
                tok = this.optTok(lexer);
                if (tok == null) {
                    throw SqlException.position(typePosition).put("did you mean 'double[]'?");
                }
                if (!(Chars.equals(tok, ')') || Chars.equals(tok, ',') || Chars.equals(tok, '('))) {
                    throw SqlException.position(typePosition).put("did you mean '").put(tok).put("[]'?");
                }
            }
            throw SqlException.position(typePosition).put("column type is expected here");
        }
        short typeTag = SqlUtil.toPersistedTypeTag(tok, typePosition);
        int typeTagPosition = lexer.lastTokenPosition();
        if (typeTag == 10 && (next = this.optTok(lexer)) != null && !SqlKeywords.isPrecisionKeyword(next)) {
            lexer.unparseLast();
        }
        if ((nDims = SqlUtil.parseArrayDimensionality(lexer, typeTag, typeTagPosition)) > 0) {
            if (!ColumnType.isSupportedArrayElementType(typeTag)) {
                throw SqlException.position(typePosition).put("unsupported array element type [type=").put(ColumnType.nameOf(typeTag)).put(']');
            }
            if (nDims > 32) {
                throw SqlException.position(typePosition).put("too many array dimensions [nDims=").put(nDims).put(", maxNDims=").put(32).put(']');
            }
            return ColumnType.encodeArrayType(typeTag, nDims);
        }
        if (typeTag == 23) {
            this.expectTok(lexer, '(');
            int bits = GeoHashUtil.parseGeoHashBits(lexer.lastTokenPosition(), 0, this.expectLiteral((GenericLexer)lexer).token);
            this.expectTok(lexer, ')');
            return ColumnType.getGeoHashTypeWithBits(bits);
        }
        return typeTag;
    }

    @NotNull
    private CharSequence tok(GenericLexer lexer, String expectedList) throws SqlException {
        int pos = lexer.getPosition();
        CharSequence tok = this.optTok(lexer);
        if (tok == null) {
            throw SqlException.position(pos).put(expectedList).put(" expected");
        }
        return tok;
    }

    @NotNull
    private CharSequence tokIncludingLocalBrace(GenericLexer lexer, String expectedList) throws SqlException {
        int pos = lexer.getPosition();
        CharSequence tok = SqlUtil.fetchNext(lexer);
        if (tok == null) {
            throw SqlException.position(pos).put(expectedList).put(" expected");
        }
        return tok;
    }

    private void validateIdentifier(GenericLexer lexer, CharSequence tok) throws SqlException {
        if (tok == null || tok.length() == 0) {
            throw SqlException.position(lexer.lastTokenPosition()).put("non-empty identifier expected");
        }
        if (Chars.isQuoted(tok)) {
            if (tok.length() == 2) {
                throw SqlException.position(lexer.lastTokenPosition()).put("non-empty identifier expected");
            }
            return;
        }
        char c = tok.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            throw SqlException.position(lexer.lastTokenPosition()).put("identifier should start with a letter or '_'");
        }
        int n = tok.length();
        for (int i = 1; i < n; ++i) {
            c = tok.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '$') continue;
            throw SqlException.position(lexer.lastTokenPosition()).put("identifier can contain letters, digits, '_' or '$'");
        }
    }

    private void validateMatViewQuery(QueryModel model, String baseTableName) throws SqlException {
        for (QueryModel m = model; m != null; m = m.getNestedModel()) {
            tableNames.clear();
            tableNamePositions.clear();
            SqlParser.collectAllTableNames(m, tableNames, null);
            boolean baseTableQueried = tableNames.contains(baseTableName);
            int queriedTableCount = tableNames.size();
            if (baseTableQueried) {
                if (m.getSampleBy() != null && m.getSampleByOffset() == null) {
                    throw SqlException.position(m.getSampleBy().position + m.getSampleBy().token.length() + 1).put("ALIGN TO FIRST OBSERVATION on base table is not supported for materialized views: ").put(baseTableName);
                }
                if (m.getSampleByFrom() != null || m.getSampleByTo() != null) {
                    int position = m.getSampleByFrom() != null ? m.getSampleByFrom().position : m.getSampleByTo().position;
                    throw SqlException.position(position).put("FROM-TO on base table is not supported for materialized views: ").put(baseTableName);
                }
                ObjList<ExpressionNode> sampleByFill = m.getSampleByFill();
                if (sampleByFill != null && sampleByFill.size() > 0) {
                    throw SqlException.position(sampleByFill.get((int)0).position).put("FILL on base table is not supported for materialized views: ").put(baseTableName);
                }
                ObjList<QueryColumn> columns = m.getColumns();
                QueryColumn windowFuncColumn = null;
                int n = columns.size();
                for (int i = 0; i < n; ++i) {
                    QueryColumn column = columns.getQuick(i);
                    if (column.isWindowColumn()) {
                        windowFuncColumn = column;
                    }
                    if (Chars.equals(column.getName(), '*') || TableUtils.isValidColumnName(column.getName(), this.configuration.getMaxFileNameLength())) continue;
                    if (column.getAliasPosition() == -1) {
                        throw SqlException.position(column.getAst().position).put("column '").put(column.getName()).put("' requires an explicit alias. Use: ").put(column.getName()).put(" AS your_column_name");
                    }
                    throw SqlException.position(column.getAliasPosition()).put("column alias '").put(column.getName()).put("' contains unsupported characters");
                }
                if (windowFuncColumn != null) {
                    throw SqlException.position(windowFuncColumn.getAst().position).put("window function on base table is not supported for materialized views: ").put(baseTableName);
                }
            }
            ObjList<QueryModel> joinModels = m.getJoinModels();
            int n = joinModels.size();
            for (int i = 0; i < n; ++i) {
                QueryModel joinModel = joinModels.getQuick(i);
                if (joinModel == m) continue;
                this.validateMatViewQuery(joinModel, baseTableName);
            }
            QueryModel unionModel = m.getUnionModel();
            if (unionModel == null) continue;
            if (baseTableQueried && queriedTableCount > 1) {
                throw SqlException.position(m.getUnionModel().getModelPosition()).put("union on base table is not supported for materialized views: ").put(baseTableName);
            }
            this.validateMatViewQuery(unionModel, baseTableName);
        }
    }

    void clear() {
        this.queryModelPool.clear();
        this.queryColumnPool.clear();
        this.expressionNodePool.clear();
        this.windowColumnPool.clear();
        this.createMatViewOperationBuilder.clear();
        this.createTableOperationBuilder.clear();
        this.createTableColumnModelPool.clear();
        this.renameTableModelPool.clear();
        this.withClauseModelPool.clear();
        this.subQueryMode = false;
        this.characterStore.clear();
        this.insertModelPool.clear();
        this.expressionTreeBuilder.reset();
        this.copyModelPool.clear();
        this.topLevelWithModel.clear();
        this.explainModelPool.clear();
        this.digit = 1;
        this.traversalAlgo.clear();
    }

    ExpressionNode expr(GenericLexer lexer, QueryModel model, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls, @Nullable CharSequence exprTargetVariableName) throws SqlException {
        try {
            this.expressionTreeBuilder.pushModel(model);
            this.expressionParser.parseExpr(lexer, this.expressionTreeBuilder, sqlParserCallback, decls);
            ExpressionNode expressionNode = this.rewriteKnownStatements(this.expressionTreeBuilder.poll(), decls, exprTargetVariableName);
            return expressionNode;
        }
        catch (SqlException e) {
            this.expressionTreeBuilder.reset();
            throw e;
        }
        finally {
            this.expressionTreeBuilder.popModel();
        }
    }

    ExpressionNode expr(GenericLexer lexer, QueryModel model, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        return this.expr(lexer, model, sqlParserCallback, decls, null);
    }

    ExpressionNode expr(GenericLexer lexer, QueryModel model, SqlParserCallback sqlParserCallback) throws SqlException {
        return this.expr(lexer, model, sqlParserCallback, null, null);
    }

    void expr(GenericLexer lexer, ExpressionParserListener listener, SqlParserCallback sqlParserCallback) throws SqlException {
        this.expressionParser.parseExpr(lexer, listener, sqlParserCallback, null);
    }

    ExecutionModel parse(GenericLexer lexer, SqlExecutionContext executionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        CharSequence tok = this.tok(lexer, "'create', 'rename' or 'select'");
        if (SqlKeywords.isExplainKeyword(tok)) {
            int format = this.parseExplainOptions(lexer, tok);
            ExecutionModel model = this.parseExplain(lexer, executionContext, sqlParserCallback);
            ExplainModel explainModel = this.explainModelPool.next();
            explainModel.setFormat(format);
            explainModel.setModel(model);
            return explainModel;
        }
        if (SqlKeywords.isSelectKeyword(tok)) {
            return this.parseSelect(lexer, sqlParserCallback, null);
        }
        if (SqlKeywords.isCreateKeyword(tok)) {
            return this.parseCreate(lexer, executionContext, sqlParserCallback);
        }
        if (SqlKeywords.isUpdateKeyword(tok)) {
            return this.parseUpdate(lexer, sqlParserCallback, null);
        }
        if (SqlKeywords.isRenameKeyword(tok)) {
            return this.parseRenameStatement(lexer);
        }
        if (SqlKeywords.isInsertKeyword(tok)) {
            return this.parseInsert(lexer, sqlParserCallback, null);
        }
        if (SqlKeywords.isCopyKeyword(tok)) {
            return this.parseCopy(lexer, sqlParserCallback);
        }
        if (SqlKeywords.isWithKeyword(tok)) {
            return this.parseWith(lexer, sqlParserCallback, null);
        }
        if (SqlKeywords.isFromKeyword(tok)) {
            throw SqlException.$(lexer.lastTokenPosition(), "Did you mean 'select * from'?");
        }
        return this.parseSelect(lexer, sqlParserCallback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueryModel parseAsSubQuery(GenericLexer lexer, @Nullable LowerCaseCharSequenceObjHashMap<WithClauseModel> withClauses, boolean useTopLevelWithClauses, SqlParserCallback sqlParserCallback, LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        QueryModel model;
        this.subQueryMode = true;
        try {
            model = this.parseDml(lexer, withClauses, lexer.getPosition(), useTopLevelWithClauses, sqlParserCallback, decls);
        }
        finally {
            this.subQueryMode = false;
        }
        return model;
    }

    static {
        tableAliasStop.add("where");
        tableAliasStop.add("latest");
        tableAliasStop.add("join");
        tableAliasStop.add("inner");
        tableAliasStop.add("left");
        tableAliasStop.add("outer");
        tableAliasStop.add("asof");
        tableAliasStop.add("splice");
        tableAliasStop.add("lt");
        tableAliasStop.add("cross");
        tableAliasStop.add("sample");
        tableAliasStop.add("order");
        tableAliasStop.add("on");
        tableAliasStop.add("timestamp");
        tableAliasStop.add("limit");
        tableAliasStop.add(")");
        tableAliasStop.add(";");
        tableAliasStop.add("union");
        tableAliasStop.add("group");
        tableAliasStop.add("except");
        tableAliasStop.add("intersect");
        tableAliasStop.add("from");
        tableAliasStop.add("tolerance");
        columnAliasStop.add("from");
        columnAliasStop.add(",");
        columnAliasStop.add("over");
        columnAliasStop.add("union");
        columnAliasStop.add("except");
        columnAliasStop.add("intersect");
        columnAliasStop.add(")");
        columnAliasStop.add(";");
        groupByStopSet.add("order");
        groupByStopSet.add(")");
        groupByStopSet.add(",");
        joinStartSet.put("left", 1);
        joinStartSet.put("join", 1);
        joinStartSet.put("inner", 1);
        joinStartSet.put("left", 2);
        joinStartSet.put("cross", 3);
        joinStartSet.put("asof", 4);
        joinStartSet.put("splice", 5);
        joinStartSet.put("lt", 6);
        joinStartSet.put(",", 3);
        setOperations.add("union");
        setOperations.add("except");
        setOperations.add("intersect");
    }

    private static class RewriteDeclaredVariablesInExpressionVisitor
    implements ReplacingVisitor {
        public LowerCaseCharSequenceObjHashMap<ExpressionNode> decls;
        public CharSequence exprTargetVariableName;
        public boolean hasAtChar;

        private RewriteDeclaredVariablesInExpressionVisitor() {
        }

        @Override
        public ExpressionNode visit(ExpressionNode node) throws SqlException {
            if (node.token == null) {
                return node;
            }
            this.hasAtChar = node.token.charAt(0) == '@';
            if (this.hasAtChar && this.exprTargetVariableName != null && Chars.equalsIgnoreCase(node.token, this.exprTargetVariableName)) {
                return node;
            }
            if (node.token != null && node.type == 7 && this.decls.contains(node.token)) {
                return this.decls.get((CharSequence)node.token).rhs;
            }
            if (this.hasAtChar) {
                throw SqlException.$(node.position, "tried to use undeclared variable `" + String.valueOf(node.token) + "`");
            }
            return node;
        }

        ReplacingVisitor of(@NotNull LowerCaseCharSequenceObjHashMap<ExpressionNode> decls, @Nullable CharSequence exprTargetVariableName) {
            this.decls = decls;
            this.exprTargetVariableName = exprTargetVariableName;
            return this;
        }
    }

    public static interface ReplacingVisitor {
        public ExpressionNode visit(ExpressionNode var1) throws SqlException;
    }
}

