/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DerivedArrayView;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class DoubleArrayTransposeFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "transpose(D[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends ArrayFunction
    implements UnaryFunction {
        private final Function arrayArg;
        private final DerivedArrayView borrowedView = new DerivedArrayView();

        public Func(Function arrayArg) {
            this.arrayArg = arrayArg;
            this.type = arrayArg.getType();
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView array = this.arrayArg.getArray(rec);
            this.borrowedView.of(array);
            this.borrowedView.transpose();
            return this.borrowedView;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("transpose(").val(this.arrayArg).val(')');
        }
    }
}

