/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToVarcharFunction;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;

public class CastFloatToVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(F\u00f8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function floatFunc = args.getQuick(0);
        if (floatFunc.isConstant()) {
            StringSink sink = Misc.getThreadLocalSink();
            sink.put(floatFunc.getFloat(null));
            return new VarcharConstant(Chars.toString(sink));
        }
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends AbstractCastToVarcharFunction {
        private final Utf8StringSink sinkA = new Utf8StringSink();
        private final Utf8StringSink sinkB = new Utf8StringSink();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            float value = this.arg.getFloat(rec);
            if (!Numbers.isNull(value)) {
                this.sinkA.clear();
                this.sinkA.put(value);
                return this.sinkA;
            }
            return null;
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            float value = this.arg.getFloat(rec);
            if (!Numbers.isNull(value)) {
                this.sinkB.clear();
                this.sinkB.put(value);
                return this.sinkB;
            }
            return null;
        }
    }
}

