/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class WalTransactionsFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;
    private static final String SIGNATURE = "wal_transactions(s)";
    private static final int alterCommandTypeColumn;
    private static final int maxTimestampColumn;
    private static final int minTimestampColumn;
    private static final int rowCountColumn;
    private static final int segmentIdColumn;
    private static final int segmentTxnColumn;
    private static final int sequencerTxnColumn;
    private static final int structureVersionColumn;
    private static final int timestampColumn;
    private static final int walIdColumn;

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        CharSequence tableName = args.get(0).getStrA(null);
        TableToken tableToken = sqlExecutionContext.getCairoEngine().getTableTokenIfExists(tableName);
        if (tableToken == null) {
            throw SqlException.$(argPositions.get(0), "table does not exist: ").put(tableName);
        }
        if (!sqlExecutionContext.getCairoEngine().isWalTable(tableToken)) {
            throw SqlException.$(argPositions.get(0), "table is not a WAL table: ").put(tableName);
        }
        return new CursorFunction(new WalTransactionsCursorFactory(tableToken));
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("sequencerTxn", 6));
        sequencerTxnColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("timestamp", 8));
        timestampColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("walId", 5));
        walIdColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("segmentId", 5));
        segmentIdColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("segmentTxn", 5));
        segmentTxnColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("structureVersion", 6));
        structureVersionColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("minTimestamp", 8));
        minTimestampColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("maxTimestamp", 8));
        maxTimestampColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("rowCount", 6));
        rowCountColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("alterCommandType", 3));
        alterCommandTypeColumn = metadata.getColumnCount() - 1;
        METADATA = metadata;
    }

    private static class WalTransactionsCursorFactory
    extends AbstractRecordCursorFactory {
        private final TableListRecordCursor cursor;
        private final TableToken tableToken;

        public WalTransactionsCursorFactory(TableToken tableToken) {
            super(METADATA);
            this.tableToken = tableToken;
            this.cursor = new TableListRecordCursor();
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.close();
            long txnLo = 0L;
            while (true) {
                TransactionLogCursor cursor = null;
                try {
                    cursor = executionContext.getCairoEngine().getTableSequencerAPI().getCursor(this.tableToken, txnLo);
                    cursor.toMinTxn();
                    this.cursor.logCursor = cursor;
                }
                catch (CairoException e) {
                    long writerTxn;
                    Misc.free(cursor);
                    if (!e.errnoFileCannotRead()) continue;
                    if (txnLo == 0L && (writerTxn = executionContext.getCairoEngine().getTableSequencerAPI().getTxnTracker(this.tableToken).getWriterTxn()) > 0L) {
                        txnLo = writerTxn;
                        continue;
                    }
                    throw e;
                }
                break;
            }
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("wal_transactions of: ").val(this.tableToken.getTableName());
        }

        private static class TableListRecordCursor
        implements NoRandomAccessRecordCursor {
            TransactionRecord record = new TransactionRecord();
            private TransactionLogCursor logCursor;

            private TableListRecordCursor() {
            }

            @Override
            public void close() {
                this.logCursor = Misc.free(this.logCursor);
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() {
                return this.logCursor.hasNext();
            }

            @Override
            public long preComputedStateSize() {
                return 0L;
            }

            @Override
            public long size() {
                return -1L;
            }

            @Override
            public void toTop() {
                this.logCursor.toTop();
            }

            public class TransactionRecord
            implements Record {
                @Override
                public int getInt(int col) {
                    if (col == walIdColumn) {
                        return TableListRecordCursor.this.logCursor.getWalId();
                    }
                    if (col == segmentIdColumn) {
                        return TableListRecordCursor.this.logCursor.getSegmentId();
                    }
                    if (col == segmentTxnColumn) {
                        return TableListRecordCursor.this.logCursor.getSegmentTxn();
                    }
                    return Integer.MIN_VALUE;
                }

                @Override
                public long getLong(int col) {
                    if (col == structureVersionColumn) {
                        return TableListRecordCursor.this.logCursor.getStructureVersion();
                    }
                    if (col == sequencerTxnColumn) {
                        return TableListRecordCursor.this.logCursor.getTxn();
                    }
                    if (col == rowCountColumn) {
                        if (TableListRecordCursor.this.logCursor.getVersion() == 1 && TableListRecordCursor.this.logCursor.getTxnRowCount() > 0L) {
                            return TableListRecordCursor.this.logCursor.getTxnRowCount();
                        }
                        return Long.MIN_VALUE;
                    }
                    return Long.MIN_VALUE;
                }

                @Override
                public short getShort(int col) {
                    if (col == alterCommandTypeColumn && TableListRecordCursor.this.logCursor.getVersion() == 1 && TableListRecordCursor.this.logCursor.getTxnRowCount() == 0L) {
                        return (short)TableListRecordCursor.this.logCursor.getTxnMinTimestamp();
                    }
                    return 0;
                }

                @Override
                public long getTimestamp(int col) {
                    if (col == timestampColumn) {
                        return TableListRecordCursor.this.logCursor.getCommitTimestamp();
                    }
                    if (col == minTimestampColumn) {
                        if (TableListRecordCursor.this.logCursor.getVersion() == 1 && TableListRecordCursor.this.logCursor.getTxnRowCount() > 0L) {
                            return TableListRecordCursor.this.logCursor.getTxnMinTimestamp();
                        }
                        return Long.MIN_VALUE;
                    }
                    if (col == maxTimestampColumn) {
                        if (TableListRecordCursor.this.logCursor.getVersion() == 1 && TableListRecordCursor.this.logCursor.getTxnRowCount() > 0L) {
                            return TableListRecordCursor.this.logCursor.getTxnMaxTimestamp();
                        }
                        return Long.MIN_VALUE;
                    }
                    return Long.MIN_VALUE;
                }
            }
        }
    }
}

