/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.FunctionExtension;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.IntervalFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.Interval;
import org.jetbrains.annotations.NotNull;

public class IntervalConstant
extends IntervalFunction
implements ConstantFunction,
FunctionExtension {
    public static final IntervalConstant NULL = new IntervalConstant(Long.MIN_VALUE, Long.MIN_VALUE);
    private final Interval interval = new Interval();

    public IntervalConstant(long lo, long hi) {
        this.interval.of(lo, hi);
    }

    public static IntervalConstant newInstance(long lo, long hi) {
        return lo != Long.MIN_VALUE || hi != Long.MIN_VALUE ? new IntervalConstant(lo, hi) : NULL;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public void cursorClosed() {
        super.cursorClosed();
    }

    @Override
    public FunctionExtension extendedOps() {
        return this;
    }

    @Override
    public int getArrayLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Interval getInterval(Record rec) {
        return this.interval;
    }

    @Override
    public Record getRecord(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getStrA(Record rec, int arrayIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getStrB(Record rec, int arrayIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getStrLen(Record rec, int arrayIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNullConstant() {
        return this.interval.equals(Interval.NULL);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.interval);
    }

    @Override
    public void toTop() {
        super.toTop();
    }
}

