/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.millitime.DateFormatFactory;
import io.questdb.std.str.Utf8Sequence;

public class VarcharToDateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_date(\u00d8s)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arg = args.getQuick(0);
        CharSequence pattern = args.getQuick(1).getStrA(null);
        if (pattern == null) {
            throw SqlException.$(argPositions.getQuick(1), "pattern is required");
        }
        DateLocale defaultDateLocale = configuration.getDefaultDateLocale();
        if ("en".equals(defaultDateLocale.getName()) || defaultDateLocale.getName() != null && defaultDateLocale.getName().startsWith("en-")) {
            return new ToAsciiDateFunction(arg, DateFormatFactory.INSTANCE.get(pattern), defaultDateLocale, pattern);
        }
        return new ToDateFunction(arg, DateFormatFactory.INSTANCE.get(pattern), defaultDateLocale, pattern);
    }

    private static final class ToAsciiDateFunction
    extends DateFunction
    implements UnaryFunction {
        private final Function arg;
        private final DateFormat dateFormat;
        private final DateLocale locale;
        private final CharSequence pattern;

        public ToAsciiDateFunction(Function arg, DateFormat dateFormat, DateLocale locale, CharSequence pattern) {
            this.arg = arg;
            this.dateFormat = dateFormat;
            this.locale = locale;
            this.pattern = pattern;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getDate(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            try {
                if (value != null && value.isAscii()) {
                    return this.dateFormat.parse(value.asAsciiCharSequence(), this.locale);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
            return Long.MIN_VALUE;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("to_date(").val(this.arg).val(',').val(this.pattern).val(')');
        }
    }

    private static final class ToDateFunction
    extends DateFunction
    implements UnaryFunction {
        private final Function arg;
        private final DateFormat dateFormat;
        private final DateLocale locale;
        private final CharSequence pattern;

        public ToDateFunction(Function arg, DateFormat dateFormat, DateLocale locale, CharSequence pattern) {
            this.arg = arg;
            this.dateFormat = dateFormat;
            this.locale = locale;
            this.pattern = pattern;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getDate(Record rec) {
            CharSequence value = this.arg.getStrA(rec);
            try {
                return this.dateFormat.parse(value, this.locale);
            }
            catch (NumericException numericException) {
                return Long.MIN_VALUE;
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("to_date(").val(this.arg).val(',').val(this.pattern).val(')');
        }
    }
}

