/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.griffin.engine.functions.groupby.ApproxPercentileDoubleGroupByFunction;
import io.questdb.griffin.engine.functions.groupby.ApproxPercentileDoubleGroupByFunctionFactory;
import io.questdb.griffin.engine.functions.groupby.ApproxPercentileDoublePackedGroupByFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class ApproxMedianDoubleGroupByFunctionFactory
implements FunctionFactory {
    private static final DoubleConstant percentileFunc = DoubleConstant.newInstance(0.5);

    @Override
    public String getSignature() {
        return "approx_median(Di)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int precisionPosition;
        Function exprFunc = args.getQuick(0);
        Function precisionFunc = args.getQuick(1);
        int precision = ApproxPercentileDoubleGroupByFunctionFactory.checkAndReturnPrecision(precisionFunc, precisionPosition = argPositions.getQuick(1));
        if (precision > 2) {
            return new ApproxPercentileDoublePackedGroupByFunction(exprFunc, percentileFunc, precision, position);
        }
        return new ApproxPercentileDoubleGroupByFunction(exprFunc, percentileFunc, precision, position);
    }
}

