/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.groupby.AbstractCountGroupByFunction;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;

public class CountVarcharGroupByFunction
extends AbstractCountGroupByFunction {
    public CountVarcharGroupByFunction(@NotNull Function arg) {
        super(arg);
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        Utf8Sequence value = this.arg.getVarcharA(record);
        if (value != null) {
            mapValue.putLong(this.valueIndex, 1L);
        } else {
            mapValue.putLong(this.valueIndex, 0L);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        Utf8Sequence value = this.arg.getVarcharA(record);
        if (value != null) {
            mapValue.addLong(this.valueIndex, 1L);
        }
    }
}

