/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class IsIPv4OrderedGroupByFunction
extends BooleanFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public IsIPv4OrderedGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putBool(this.valueIndex, true);
        mapValue.putLong(this.valueIndex + 1, Numbers.ipv4ToLong(this.arg.getIPv4(record)));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        if (mapValue.getBool(this.valueIndex)) {
            long prev = Numbers.ipv4ToLong(mapValue.getIPv4(this.valueIndex + 1));
            long curr = Numbers.ipv4ToLong(this.arg.getIPv4(record));
            if (curr < prev) {
                mapValue.putBool(this.valueIndex, false);
            } else {
                mapValue.putLong(this.valueIndex + 1, curr);
            }
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public boolean getBool(Record rec) {
        return rec.getBool(this.valueIndex);
    }

    @Override
    public String getName() {
        return "isOrdered";
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(1);
        columnTypes.add(25);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putBool(this.valueIndex, true);
    }

    @Override
    public boolean supportsParallelism() {
        return false;
    }
}

