/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class MaxIntGroupByFunction
extends IntFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MaxIntGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putInt(this.valueIndex, this.arg.getInt(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        mapValue.maxInt(this.valueIndex, this.arg.getInt(record));
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public int getInt(Record rec) {
        return rec.getInt(this.valueIndex);
    }

    @Override
    public String getName() {
        return "max";
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(5);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        int destMax;
        int srcMax = srcValue.getInt(this.valueIndex);
        if (srcMax > (destMax = destValue.getInt(this.valueIndex))) {
            destValue.putInt(this.valueIndex, srcMax);
        }
    }

    @Override
    public void setInt(MapValue mapValue, int value) {
        mapValue.putInt(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putInt(this.valueIndex, Integer.MIN_VALUE);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }
}

