/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class NotMatchStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "!~(Ss)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        CharSequence regex = args.getQuick(1).getStrA(null);
        if (regex == null) {
            return BooleanConstant.FALSE;
        }
        try {
            Matcher matcher = Pattern.compile(Chars.toString(regex)).matcher("");
            return new NoMatchStrFunction(value, matcher);
        }
        catch (PatternSyntaxException e) {
            throw SqlException.$(argPositions.getQuick(1) + e.getIndex() + 1, e.getMessage());
        }
    }

    private static class NoMatchStrFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final Matcher matcher;

        public NoMatchStrFunction(Function arg, Matcher matcher) {
            this.arg = arg;
            this.matcher = matcher;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.getArg().getStrA(rec);
            return cs == null || !this.matcher.reset(cs).find();
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val(" !~ ").val(this.matcher.pattern().toString());
        }
    }
}

