/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinFunction;
import io.questdb.std.BinarySequence;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndBinCCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_bin(lli)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        long lo = args.getQuick(0).getLong(null);
        long hi = args.getQuick(1).getLong(null);
        int nullRate = args.getQuick(2).getInt(null);
        if (nullRate < 0) {
            throw SqlException.$(argPositions.getQuick(2), "invalid null rate");
        }
        if (lo > hi) {
            throw SqlException.$(position, "invalid range");
        }
        if (lo < 1L) {
            throw SqlException.$(argPositions.getQuick(0), "minimum has to be grater than 0");
        }
        if (lo < hi) {
            return new VarLenFunction(lo, hi, nullRate);
        }
        return new FixLenFunction(lo, nullRate);
    }

    private static final class VarLenFunction
    extends BinFunction
    implements Function {
        private final long lo;
        private final int nullRate;
        private final long range;
        private final Sequence sequence = new Sequence();

        public VarLenFunction(long lo, long hi, int nullRate) {
            this.lo = lo;
            this.range = hi - lo + 1L;
            this.nullRate = nullRate + 1;
        }

        @Override
        public BinarySequence getBin(Record rec) {
            if (this.sequence.rnd.nextPositiveInt() % this.nullRate == 1) {
                return null;
            }
            this.sequence.len = this.lo + this.sequence.rnd.nextPositiveLong() % this.range;
            return this.sequence;
        }

        @Override
        public long getBinLen(Record rec) {
            return this.sequence.len;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.sequence.rnd = executionContext.getRandom();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_bin(").val(this.lo).val(',').val(this.range + this.lo - 1L).val(',').val(this.nullRate - 1).val(')');
        }
    }

    private static final class FixLenFunction
    extends BinFunction
    implements Function {
        private final int nullRate;
        private final Sequence sequence = new Sequence();

        public FixLenFunction(long len, int nullRate) {
            this.nullRate = nullRate + 1;
            this.sequence.len = len;
        }

        @Override
        public BinarySequence getBin(Record rec) {
            if (this.sequence.rnd.nextPositiveInt() % this.nullRate == 1) {
                return null;
            }
            return this.sequence;
        }

        @Override
        public long getBinLen(Record rec) {
            return this.sequence.len;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.sequence.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_bin(").val(this.sequence.len).val(',').val(this.sequence.len).val(',').val(this.nullRate - 1).val(')');
        }
    }

    private static class Sequence
    implements BinarySequence {
        private long len;
        private Rnd rnd;

        private Sequence() {
        }

        @Override
        public byte byteAt(long index) {
            return this.rnd.nextByte();
        }

        @Override
        public long length() {
            return this.len;
        }
    }
}

