/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.BasePartitionedWindowFunction;
import io.questdb.griffin.engine.functions.window.BaseWindowFunction;
import io.questdb.griffin.engine.functions.window.WindowDoubleFunction;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class AvgDoubleWindowFunctionFactory
extends AbstractWindowFunctionFactory {
    public static final ArrayColumnTypes AVG_COLUMN_TYPES = new ArrayColumnTypes();
    public static final ArrayColumnTypes AVG_OVER_PARTITION_RANGE_COLUMN_TYPES;
    public static final ArrayColumnTypes AVG_OVER_PARTITION_ROWS_COLUMN_TYPES;
    private static final String NAME = "avg";
    private static final String SIGNATURE = "avg(D)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        windowContext.validate(position, this.supportNullsDesc());
        int framingMode = windowContext.getFramingMode();
        RecordSink partitionBySink = windowContext.getPartitionBySink();
        ColumnTypes partitionByKeyTypes = windowContext.getPartitionByKeyTypes();
        VirtualRecord partitionByRecord = windowContext.getPartitionByRecord();
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        if (rowsHi < rowsLo) {
            return new AbstractWindowFunctionFactory.DoubleNullFunction(args.get(0), NAME, rowsLo, rowsHi, framingMode == 1, partitionByRecord);
        }
        if (partitionByRecord != null) {
            if (framingMode == 1) {
                if (windowContext.isDefaultFrame() && (!windowContext.isOrdered() || windowContext.getRowsHi() == Long.MAX_VALUE)) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, AVG_COLUMN_TYPES);
                    return new AvgOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, AVG_COLUMN_TYPES);
                    return new AvgOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                Map map = null;
                MemoryCARW mem = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, AVG_OVER_PARTITION_RANGE_COLUMN_TYPES);
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    return new AvgOverPartitionRangeFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem, configuration.getSqlWindowInitialRangeBufferSize(), timestampIndex);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    Misc.free(mem);
                    throw th;
                }
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, AVG_COLUMN_TYPES);
                    return new AvgOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new AvgOverCurrentRowFunction(args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, AVG_COLUMN_TYPES);
                    return new AvgOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                ArrayColumnTypes columnTypes = new ArrayColumnTypes();
                columnTypes.add(10);
                columnTypes.add(6);
                columnTypes.add(6);
                columnTypes.add(6);
                Map map = null;
                MemoryCARW mem = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, AVG_OVER_PARTITION_ROWS_COLUMN_TYPES);
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    return new AvgOverPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    Misc.free(mem);
                    throw th;
                }
            }
        } else {
            if (framingMode == 1) {
                if (!windowContext.isOrdered() && windowContext.isDefaultFrame()) {
                    return new AvgOverWholeResultSetFunction(args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new AvgOverUnboundedRowsFrameFunction(args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                return new AvgOverRangeFrameFunction(rowsLo, rowsHi, args.get(0), configuration, timestampIndex);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new AvgOverUnboundedRowsFrameFunction(args.get(0));
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new AvgOverCurrentRowFunction(args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    return new AvgOverWholeResultSetFunction(args.get(0));
                }
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new AvgOverRowsFrameFunction(args.get(0), rowsLo, rowsHi, mem);
            }
        }
        throw SqlException.$(position, "function not implemented for given window parameters");
    }

    static {
        AVG_COLUMN_TYPES.add(10);
        AVG_COLUMN_TYPES.add(6);
        AVG_OVER_PARTITION_RANGE_COLUMN_TYPES = new ArrayColumnTypes();
        AVG_OVER_PARTITION_RANGE_COLUMN_TYPES.add(10);
        AVG_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        AVG_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        AVG_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        AVG_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        AVG_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        AVG_OVER_PARTITION_ROWS_COLUMN_TYPES = new ArrayColumnTypes();
        AVG_OVER_PARTITION_ROWS_COLUMN_TYPES.add(10);
        AVG_OVER_PARTITION_ROWS_COLUMN_TYPES.add(6);
        AVG_OVER_PARTITION_ROWS_COLUMN_TYPES.add(6);
        AVG_OVER_PARTITION_ROWS_COLUMN_TYPES.add(6);
    }

    static class AvgOverPartitionFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        public AvgOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(map, partitionByRecord, partitionBySink, arg);
        }

        @Override
        public String getName() {
            return AvgDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 2;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                double sum;
                long count;
                this.partitionByRecord.of(record);
                MapKey key = this.map.withKey();
                key.put(this.partitionByRecord, this.partitionBySink);
                MapValue value = key.createValue();
                if (value.isNew()) {
                    count = 1L;
                    sum = d;
                } else {
                    count = value.getLong(1) + 1L;
                    sum = value.getDouble(0) + d;
                }
                value.putDouble(0, sum);
                value.putLong(1, count);
            }
        }

        @Override
        public void pass2(Record record, long recordOffset, WindowSPI spi) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.findValue();
            double val = value != null ? value.getDouble(0) : Double.NaN;
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), val);
        }

        @Override
        public void preparePass2() {
            MapRecordCursor cursor = this.map.getCursor();
            MapRecord record = this.map.getRecord();
            while (cursor.hasNext()) {
                MapValue value = record.getValue();
                long count = value.getLong(1);
                if (count <= 0L) continue;
                double sum = value.getDouble(0);
                value.putDouble(0, sum / (double)count);
            }
        }
    }

    static class AvgOverUnboundedPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private double avg;

        public AvgOverUnboundedPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(map, partitionByRecord, partitionBySink, arg);
        }

        @Override
        public void computeNext(Record record) {
            long count;
            double sum;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            if (value.isNew()) {
                sum = 0.0;
                count = 0L;
            } else {
                sum = value.getDouble(0);
                count = value.getLong(1);
            }
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                sum += d;
                ++count;
            }
            value.putDouble(0, sum);
            value.putLong(1, count);
            this.avg = count != 0L ? sum / (double)count : Double.NaN;
        }

        @Override
        public double getDouble(Record rec) {
            return this.avg;
        }

        @Override
        public String getName() {
            return AvgDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.avg);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(AvgDoubleWindowFunctionFactory.NAME);
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between unbounded preceding and current row)");
        }
    }

    public static class AvgOverPartitionRangeFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private static final int RECORD_SIZE = 16;
        private final boolean frameIncludesCurrentValue;
        private final boolean frameLoBounded;
        private final LongList freeList = new LongList();
        private final int initialBufferSize;
        private final long maxDiff;
        private final MemoryARW memory;
        private final AbstractWindowFunctionFactory.RingBufferDesc memoryDesc = new AbstractWindowFunctionFactory.RingBufferDesc();
        private final long minDiff;
        private final int timestampIndex;
        protected double sum;
        private double avg;

        public AvgOverPartitionRangeFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rangeLo, long rangeHi, Function arg, MemoryARW memory, int initialBufferSize, int timestampIdx) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.frameLoBounded = rangeLo != Long.MIN_VALUE;
            this.maxDiff = this.frameLoBounded ? Math.abs(rangeLo) : Long.MAX_VALUE;
            this.minDiff = Math.abs(rangeHi);
            this.memory = memory;
            this.initialBufferSize = initialBufferSize;
            this.timestampIndex = timestampIdx;
            this.frameIncludesCurrentValue = rangeHi == 0L;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
            this.freeList.clear();
        }

        @Override
        public void computeNext(Record record) {
            long size;
            long frameSize;
            double sum;
            long firstIdx;
            long startOffset;
            long capacity;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            long timestamp = record.getTimestamp(this.timestampIndex);
            double d = this.arg.getDouble(record);
            if (mapValue.isNew()) {
                capacity = this.initialBufferSize;
                startOffset = this.memory.appendAddressFor(capacity * 16L) - this.memory.getPageAddress(0);
                firstIdx = 0L;
                if (Numbers.isFinite(d)) {
                    this.memory.putLong(startOffset, timestamp);
                    this.memory.putDouble(startOffset + 8L, d);
                    if (this.frameIncludesCurrentValue) {
                        sum = d;
                        this.avg = d;
                        this.sum = d;
                        frameSize = 1L;
                        size = this.frameLoBounded ? 1L : 0L;
                    } else {
                        sum = 0.0;
                        this.avg = Double.NaN;
                        this.sum = Double.NaN;
                        frameSize = 0L;
                        size = 1L;
                    }
                } else {
                    size = 0L;
                    sum = 0.0;
                    this.avg = Double.NaN;
                    this.sum = Double.NaN;
                    frameSize = 0L;
                }
            } else {
                double val;
                long idx;
                long ts;
                long i;
                long n;
                sum = mapValue.getDouble(0);
                frameSize = mapValue.getLong(1);
                startOffset = mapValue.getLong(2);
                size = mapValue.getLong(3);
                capacity = mapValue.getLong(4);
                long newFirstIdx = firstIdx = mapValue.getLong(5);
                if (this.frameLoBounded) {
                    n = size;
                    for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(startOffset + (idx = (firstIdx + i) % capacity) * 16L))) > this.maxDiff; ++i) {
                        if (frameSize > 0L) {
                            val = this.memory.getDouble(startOffset + idx * 16L + 8L);
                            sum -= val;
                            --frameSize;
                        }
                        newFirstIdx = (idx + 1L) % capacity;
                        --size;
                    }
                }
                firstIdx = newFirstIdx;
                if (Numbers.isFinite(d)) {
                    if (size == capacity) {
                        this.memoryDesc.reset(capacity, startOffset, size, firstIdx, this.freeList);
                        AbstractWindowFunctionFactory.expandRingBuffer(this.memory, this.memoryDesc, 16);
                        capacity = this.memoryDesc.capacity;
                        startOffset = this.memoryDesc.startOffset;
                        firstIdx = this.memoryDesc.firstIdx;
                    }
                    this.memory.putLong(startOffset + (firstIdx + size) % capacity * 16L, timestamp);
                    this.memory.putDouble(startOffset + (firstIdx + size) % capacity * 16L + 8L, d);
                    ++size;
                }
                if (this.frameLoBounded) {
                    long idx2;
                    long ts2;
                    long diff;
                    for (i = frameSize; i < size && (diff = Math.abs((ts2 = this.memory.getLong(startOffset + (idx2 = (firstIdx + i) % capacity) * 16L)) - timestamp)) <= this.maxDiff && diff >= this.minDiff; ++i) {
                        double value = this.memory.getDouble(startOffset + idx2 * 16L + 8L);
                        sum += value;
                        ++frameSize;
                    }
                } else {
                    newFirstIdx = firstIdx;
                    n = size;
                    for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(startOffset + (idx = (firstIdx + i) % capacity) * 16L))) >= this.minDiff; ++i) {
                        val = this.memory.getDouble(startOffset + idx * 16L + 8L);
                        sum += val;
                        ++frameSize;
                        newFirstIdx = (idx + 1L) % capacity;
                        --size;
                    }
                    firstIdx = newFirstIdx;
                }
                if (frameSize != 0L) {
                    this.avg = sum / (double)frameSize;
                    this.sum = sum;
                } else {
                    this.avg = Double.NaN;
                    this.sum = Double.NaN;
                }
            }
            mapValue.putDouble(0, sum);
            mapValue.putLong(1, frameSize);
            mapValue.putLong(2, startOffset);
            mapValue.putLong(3, size);
            mapValue.putLong(4, capacity);
            mapValue.putLong(5, firstIdx);
        }

        @Override
        public double getDouble(Record rec) {
            return this.avg;
        }

        @Override
        public String getName() {
            return AvgDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reopen() {
            super.reopen();
            this.avg = Double.NaN;
            this.sum = Double.NaN;
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
            this.freeList.clear();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" range between ");
            if (this.frameLoBounded) {
                sink.val(this.maxDiff);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.minDiff == 0L) {
                sink.val("current row");
            } else {
                sink.val(this.minDiff).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
            this.freeList.clear();
        }
    }

    static class AvgOverCurrentRowFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private double value;

        AvgOverCurrentRowFunction(Function arg) {
            super(arg);
        }

        @Override
        public void computeNext(Record record) {
            this.value = this.arg.getDouble(record);
        }

        @Override
        public double getDouble(Record rec) {
            return this.value;
        }

        @Override
        public String getName() {
            return AvgDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }
    }

    static class AvgOverPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private final int bufferSize;
        private final boolean frameIncludesCurrentValue;
        private final boolean frameLoBounded;
        private final int frameSize;
        private final MemoryARW memory;
        protected double sum;
        private double avg;

        public AvgOverPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rowsLo, long rowsHi, Function arg, MemoryARW memory) {
            super(map, partitionByRecord, partitionBySink, arg);
            if (rowsLo > Long.MIN_VALUE) {
                this.frameSize = (int)(rowsHi - rowsLo + (long)(rowsHi < 0L ? 1 : 0));
                this.bufferSize = (int)Math.abs(rowsLo);
                this.frameLoBounded = true;
            } else {
                this.frameSize = 1;
                this.bufferSize = (int)Math.abs(rowsHi);
                this.frameLoBounded = false;
            }
            this.frameIncludesCurrentValue = rowsHi == 0L;
            this.memory = memory;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
        }

        @Override
        public void computeNext(Record record) {
            long count;
            double sum;
            long startOffset;
            long loIdx;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            double d = this.arg.getDouble(record);
            if (value.isNew()) {
                loIdx = 0L;
                startOffset = this.memory.appendAddressFor((long)this.bufferSize * 8L) - this.memory.getPageAddress(0);
                if (this.frameIncludesCurrentValue && Numbers.isFinite(d)) {
                    sum = d;
                    count = 1L;
                    this.avg = d;
                    this.sum = d;
                } else {
                    sum = 0.0;
                    this.avg = Double.NaN;
                    this.sum = Double.NaN;
                    count = 0L;
                }
                for (int i = 0; i < this.bufferSize; ++i) {
                    this.memory.putDouble(startOffset + (long)i * 8L, Double.NaN);
                }
            } else {
                double loValue;
                double hiValue;
                sum = value.getDouble(0);
                count = value.getLong(1);
                loIdx = value.getLong(2);
                startOffset = value.getLong(3);
                double d2 = hiValue = this.frameIncludesCurrentValue ? d : this.memory.getDouble(startOffset + (loIdx + (long)this.frameSize - 1L) % (long)this.bufferSize * 8L);
                if (Numbers.isFinite(hiValue)) {
                    ++count;
                    sum += hiValue;
                }
                if (count != 0L) {
                    this.avg = sum / (double)count;
                    this.sum = sum;
                } else {
                    this.avg = Double.NaN;
                    this.sum = Double.NaN;
                }
                if (this.frameLoBounded && Numbers.isFinite(loValue = this.memory.getDouble(startOffset + loIdx * 8L))) {
                    sum -= loValue;
                    --count;
                }
            }
            value.putDouble(0, sum);
            value.putLong(1, count);
            value.putLong(2, (loIdx + 1L) % (long)this.bufferSize);
            value.putLong(3, startOffset);
            this.memory.putDouble(startOffset + loIdx * 8L, d);
        }

        @Override
        public double getDouble(Record rec) {
            return this.avg;
        }

        @Override
        public String getName() {
            return AvgDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.avg);
        }

        @Override
        public void reopen() {
            super.reopen();
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between ");
            if (this.frameLoBounded) {
                sink.val(this.bufferSize);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.frameIncludesCurrentValue) {
                sink.val("current row");
            } else {
                sink.val(this.bufferSize - this.frameSize).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
        }
    }

    static class AvgOverWholeResultSetFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private double avg;
        private long count;
        private double sum;

        public AvgOverWholeResultSetFunction(Function arg) {
            super(arg);
        }

        @Override
        public String getName() {
            return AvgDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 2;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                this.sum += d;
                ++this.count;
            }
        }

        @Override
        public void pass2(Record record, long recordOffset, WindowSPI spi) {
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.avg);
        }

        @Override
        public void preparePass2() {
            this.avg = this.count > 0L ? this.sum / (double)this.count : Double.NaN;
        }

        @Override
        public void reset() {
            super.reset();
            this.avg = Double.NaN;
            this.count = 0L;
            this.sum = 0.0;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.avg = Double.NaN;
            this.count = 0L;
            this.sum = 0.0;
        }
    }

    static class AvgOverUnboundedRowsFrameFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private double avg;
        private long count = 0L;
        private double sum = 0.0;

        public AvgOverUnboundedRowsFrameFunction(Function arg) {
            super(arg);
        }

        @Override
        public void computeNext(Record record) {
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                this.sum += d;
                ++this.count;
            }
            this.avg = this.count != 0L ? this.sum / (double)this.count : Double.NaN;
        }

        @Override
        public double getDouble(Record rec) {
            return this.avg;
        }

        @Override
        public String getName() {
            return AvgDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.avg);
        }

        @Override
        public void reset() {
            super.reset();
            this.avg = Double.NaN;
            this.count = 0L;
            this.sum = 0.0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(AvgDoubleWindowFunctionFactory.NAME);
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (rows between unbounded preceding and current row)");
        }

        @Override
        public void toTop() {
            super.toTop();
            this.avg = Double.NaN;
            this.count = 0L;
            this.sum = 0.0;
        }
    }

    static class AvgOverRangeFrameFunction
    extends BaseWindowFunction
    implements Reopenable,
    WindowDoubleFunction {
        private static final int RECORD_SIZE = 16;
        private final boolean frameLoBounded;
        private final long initialCapacity;
        private final long maxDiff;
        private final MemoryARW memory;
        private final long minDiff;
        private final int timestampIndex;
        protected double externalSum;
        private double avg;
        private long capacity;
        private long firstIdx;
        private long frameSize;
        private long size;
        private long startOffset;
        private double sum;

        public AvgOverRangeFrameFunction(long rangeLo, long rangeHi, Function arg, CairoConfiguration configuration, int timestampIdx) {
            this(rangeLo, rangeHi, arg, configuration.getSqlWindowStorePageSize() / 16, Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24), timestampIdx);
        }

        public AvgOverRangeFrameFunction(long rangeLo, long rangeHi, Function arg, long initialCapacity, MemoryARW memory, int timestampIdx) {
            super(arg);
            this.initialCapacity = initialCapacity;
            this.memory = memory;
            this.frameLoBounded = rangeLo != Long.MIN_VALUE;
            this.maxDiff = this.frameLoBounded ? Math.abs(rangeLo) : Long.MAX_VALUE;
            this.minDiff = Math.abs(rangeHi);
            this.timestampIndex = timestampIdx;
            this.capacity = initialCapacity;
            this.startOffset = memory.appendAddressFor(this.capacity * 16L) - memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.frameSize = 0L;
            this.sum = 0.0;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
        }

        @Override
        public void computeNext(Record record) {
            double val;
            long idx;
            long ts;
            long i;
            long n;
            long timestamp = record.getTimestamp(this.timestampIndex);
            double d = this.arg.getDouble(record);
            long newFirstIdx = this.firstIdx;
            if (this.frameLoBounded) {
                n = this.size;
                for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 16L))) > this.maxDiff; ++i) {
                    if (this.frameSize > 0L) {
                        val = this.memory.getDouble(this.startOffset + idx * 16L + 8L);
                        this.sum -= val;
                        --this.frameSize;
                    }
                    newFirstIdx = (idx + 1L) % this.capacity;
                    --this.size;
                }
            }
            this.firstIdx = newFirstIdx;
            if (Numbers.isFinite(d)) {
                if (this.size == this.capacity) {
                    long newAddress = this.memory.appendAddressFor((this.capacity << 1) * 16L);
                    long oldAddress = this.memory.getPageAddress(0) + this.startOffset;
                    if (this.firstIdx == 0L) {
                        Vect.memcpy(newAddress, oldAddress, this.size * 16L);
                    } else {
                        this.firstIdx %= this.size;
                        long firstPieceSize = (this.size - this.firstIdx) * 16L;
                        Vect.memcpy(newAddress, oldAddress + this.firstIdx * 16L, firstPieceSize);
                        Vect.memcpy(newAddress + firstPieceSize, oldAddress, this.firstIdx * 16L);
                        this.firstIdx = 0L;
                    }
                    this.startOffset = newAddress - this.memory.getPageAddress(0);
                    this.capacity <<= 1;
                }
                this.memory.putLong(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L, timestamp);
                this.memory.putDouble(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L + 8L, d);
                ++this.size;
            }
            if (this.frameLoBounded) {
                long diff;
                n = this.size;
                for (i = this.frameSize; i < n && (diff = Math.abs((ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 16L)) - timestamp)) <= this.maxDiff && diff >= this.minDiff; ++i) {
                    double value = this.memory.getDouble(this.startOffset + idx * 16L + 8L);
                    this.sum += value;
                    ++this.frameSize;
                }
            } else {
                newFirstIdx = this.firstIdx;
                n = this.size;
                for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 16L))) >= this.minDiff; ++i) {
                    val = this.memory.getDouble(this.startOffset + idx * 16L + 8L);
                    this.sum += val;
                    ++this.frameSize;
                    newFirstIdx = (idx + 1L) % this.capacity;
                    --this.size;
                }
                this.firstIdx = newFirstIdx;
            }
            if (this.frameSize != 0L) {
                this.avg = this.sum / (double)this.frameSize;
                this.externalSum = this.sum;
            } else {
                this.avg = Double.NaN;
                this.externalSum = Double.NaN;
            }
        }

        @Override
        public double getDouble(Record rec) {
            return this.avg;
        }

        @Override
        public String getName() {
            return AvgDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reopen() {
            this.avg = Double.NaN;
            this.externalSum = Double.NaN;
            this.capacity = this.initialCapacity;
            this.startOffset = this.memory.appendAddressFor(this.capacity * 16L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.frameSize = 0L;
            this.size = 0L;
            this.sum = 0.0;
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val("range between ");
            if (this.frameLoBounded) {
                sink.val(this.maxDiff);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.minDiff == 0L) {
                sink.val("current row");
            } else {
                sink.val(this.minDiff).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.avg = Double.NaN;
            this.externalSum = Double.NaN;
            this.capacity = this.initialCapacity;
            this.memory.truncate();
            this.startOffset = this.memory.appendAddressFor(this.capacity * 16L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.frameSize = 0L;
            this.size = 0L;
            this.sum = 0.0;
        }
    }

    static class AvgOverRowsFrameFunction
    extends BaseWindowFunction
    implements Reopenable,
    WindowDoubleFunction {
        private final MemoryARW buffer;
        private final int bufferSize;
        private final boolean frameIncludesCurrentValue;
        private final boolean frameLoBounded;
        private final int frameSize;
        protected double externalSum = 0.0;
        private double avg = 0.0;
        private long count = 0L;
        private int loIdx = 0;
        private double sum = 0.0;

        public AvgOverRowsFrameFunction(Function arg, long rowsLo, long rowsHi, MemoryARW memory) {
            super(arg);
            assert (rowsLo != Long.MIN_VALUE || rowsHi != 0L);
            if (rowsLo > Long.MIN_VALUE) {
                this.frameSize = (int)(rowsHi - rowsLo + (long)(rowsHi < 0L ? 1 : 0));
                this.bufferSize = (int)Math.abs(rowsLo);
                this.frameLoBounded = true;
            } else {
                this.bufferSize = this.frameSize = (int)Math.abs(rowsHi);
                this.frameLoBounded = false;
            }
            this.frameIncludesCurrentValue = rowsHi == 0L;
            this.buffer = memory;
            try {
                this.initBuffer();
            }
            catch (Throwable t) {
                this.close();
                throw t;
            }
        }

        @Override
        public void close() {
            super.close();
            this.buffer.close();
        }

        @Override
        public void computeNext(Record record) {
            double loValue;
            double d;
            double hiValue = d = this.arg.getDouble(record);
            if (this.frameLoBounded && !this.frameIncludesCurrentValue) {
                hiValue = this.buffer.getDouble((long)((this.loIdx + this.frameSize - 1) % this.bufferSize) * 8L);
            } else if (!this.frameLoBounded && !this.frameIncludesCurrentValue) {
                hiValue = this.buffer.getDouble((long)(this.loIdx % this.bufferSize) * 8L);
            }
            if (Numbers.isFinite(hiValue)) {
                this.sum += hiValue;
                ++this.count;
            }
            if (this.count != 0L) {
                this.avg = this.sum / (double)this.count;
                this.externalSum = this.sum;
            } else {
                this.avg = Double.NaN;
                this.externalSum = Double.NaN;
            }
            if (this.frameLoBounded && Numbers.isFinite(loValue = this.buffer.getDouble((long)this.loIdx * 8L))) {
                this.sum -= loValue;
                --this.count;
            }
            this.buffer.putDouble((long)this.loIdx * 8L, d);
            this.loIdx = (this.loIdx + 1) % this.bufferSize;
        }

        @Override
        public double getDouble(Record rec) {
            return this.avg;
        }

        @Override
        public String getName() {
            return AvgDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.avg);
        }

        @Override
        public void reopen() {
            this.avg = 0.0;
            this.count = 0L;
            this.loIdx = 0;
            this.sum = 0.0;
            this.initBuffer();
        }

        @Override
        public void reset() {
            super.reset();
            this.buffer.close();
            this.avg = 0.0;
            this.count = 0L;
            this.loIdx = 0;
            this.sum = 0.0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val(" rows between ");
            if (this.frameLoBounded) {
                sink.val(this.bufferSize);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.frameIncludesCurrentValue) {
                sink.val("current row");
            } else {
                sink.val(this.bufferSize - this.frameSize).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.avg = 0.0;
            this.count = 0L;
            this.loIdx = 0;
            this.sum = 0.0;
            this.initBuffer();
        }

        private void initBuffer() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer.putDouble((long)i * 8L, Double.NaN);
            }
        }
    }
}

