/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.TimeFrame;
import io.questdb.cairo.sql.TimeFrameRecordCursor;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.std.Misc;
import io.questdb.std.Rows;

public abstract class AbstractAsOfJoinFastRecordCursor
implements NoRandomAccessRecordCursor {
    protected final int columnSplit;
    protected final int lookahead;
    protected final int masterTimestampIndex;
    protected final OuterJoinRecord record;
    protected final int slaveTimestampIndex;
    protected boolean isMasterHasNextPending;
    protected boolean isSlaveForwardScan;
    protected boolean isSlaveOpenPending;
    protected long lookaheadTimestamp = Long.MIN_VALUE;
    protected RecordCursor masterCursor;
    protected boolean masterHasNext;
    protected Record masterRecord;
    protected int slaveFrameIndex = -1;
    protected long slaveFrameRow = Long.MIN_VALUE;
    protected Record slaveRecA;
    protected Record slaveRecB;
    protected TimeFrame slaveTimeFrame;
    protected TimeFrameRecordCursor slaveTimeFrameCursor;

    public AbstractAsOfJoinFastRecordCursor(int columnSplit, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex, int lookahead) {
        this.columnSplit = columnSplit;
        this.record = new OuterJoinRecord(columnSplit, nullRecord);
        this.masterTimestampIndex = masterTimestampIndex;
        this.slaveTimestampIndex = slaveTimestampIndex;
        this.lookahead = lookahead;
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        this.masterCursor.calculateSize(circuitBreaker, counter);
    }

    @Override
    public void close() {
        this.masterCursor = Misc.free(this.masterCursor);
        this.slaveTimeFrameCursor = Misc.free(this.slaveTimeFrameCursor);
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        if (columnIndex < this.columnSplit) {
            return this.masterCursor.getSymbolTable(columnIndex);
        }
        return this.slaveTimeFrameCursor.getSymbolTable(columnIndex - this.columnSplit);
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        if (columnIndex < this.columnSplit) {
            return this.masterCursor.newSymbolTable(columnIndex);
        }
        return this.slaveTimeFrameCursor.newSymbolTable(columnIndex - this.columnSplit);
    }

    public void of(RecordCursor masterCursor, TimeFrameRecordCursor slaveCursor) {
        this.masterCursor = masterCursor;
        this.slaveTimeFrameCursor = slaveCursor;
        this.slaveTimeFrame = slaveCursor.getTimeFrame();
        this.masterRecord = masterCursor.getRecord();
        this.slaveRecA = slaveCursor.getRecord();
        this.slaveRecB = slaveCursor.getRecordB();
        this.record.of(this.masterRecord, this.slaveRecB);
        this.lookaheadTimestamp = Long.MIN_VALUE;
        this.slaveFrameRow = Long.MIN_VALUE;
        this.slaveFrameIndex = -1;
        this.toTop();
    }

    @Override
    public long size() {
        return this.masterCursor.size();
    }

    @Override
    public void skipRows(RecordCursor.Counter rowCount) throws DataUnavailableException {
        assert (this.isMasterHasNextPending);
        this.masterCursor.skipRows(rowCount);
    }

    @Override
    public void toTop() {
        this.lookaheadTimestamp = Long.MIN_VALUE;
        this.slaveFrameIndex = -1;
        this.slaveFrameRow = Long.MIN_VALUE;
        this.record.hasSlave(false);
        this.masterCursor.toTop();
        this.slaveTimeFrameCursor.toTop();
        this.isMasterHasNextPending = true;
        this.isSlaveOpenPending = false;
        this.isSlaveForwardScan = true;
    }

    private long binarySearchScanDown(long v, long low, long high, long totalRowLo) {
        for (long i = high - 1L; i >= low; --i) {
            this.slaveTimeFrameCursor.recordAtRowIndex(this.slaveRecA, i);
            long that = this.slaveRecA.getTimestamp(this.slaveTimestampIndex);
            if (that > v) continue;
            return i;
        }
        return totalRowLo - 1L;
    }

    private long binarySearchScrollDown(long low, long high, long value) {
        long data;
        do {
            if (low >= high) {
                return low;
            }
            this.slaveTimeFrameCursor.recordAtRowIndex(this.slaveRecA, ++low);
        } while ((data = this.slaveRecA.getTimestamp(this.slaveTimestampIndex)) == value);
        return low - 1L;
    }

    private boolean linearScan(long masterTimestamp) {
        long scanHi = Math.min(this.slaveFrameRow + (long)this.lookahead, this.slaveTimeFrame.getRowHi());
        while (this.slaveFrameRow < scanHi || this.lookaheadTimestamp == masterTimestamp && this.slaveFrameRow < this.slaveTimeFrame.getRowHi()) {
            this.slaveTimeFrameCursor.recordAt(this.slaveRecA, Rows.toRowID(this.slaveFrameIndex, this.slaveFrameRow));
            this.lookaheadTimestamp = this.slaveRecA.getTimestamp(this.slaveTimestampIndex);
            if (this.lookaheadTimestamp > masterTimestamp) {
                return true;
            }
            this.record.hasSlave(true);
            this.slaveTimeFrameCursor.recordAt(this.slaveRecB, Rows.toRowID(this.slaveFrameIndex, this.slaveFrameRow));
            ++this.slaveFrameRow;
        }
        return false;
    }

    private boolean openSlaveFrame(long masterTimestamp) {
        while (true) {
            if (this.isSlaveOpenPending) {
                if (this.slaveTimeFrameCursor.open() < 1L) {
                    this.isSlaveOpenPending = false;
                    continue;
                }
                this.isSlaveOpenPending = false;
                if (this.isSlaveForwardScan) {
                    if (masterTimestamp < this.slaveTimeFrame.getTimestampLo()) {
                        this.isSlaveForwardScan = false;
                        continue;
                    }
                    this.slaveFrameIndex = this.slaveTimeFrame.getFrameIndex();
                    this.slaveFrameRow = masterTimestamp < this.slaveTimeFrame.getTimestampHi() - 1L ? this.slaveTimeFrame.getRowLo() : this.slaveTimeFrame.getRowHi() - 1L;
                } else {
                    this.slaveFrameIndex = this.slaveTimeFrame.getFrameIndex();
                    this.slaveFrameRow = this.slaveTimeFrame.getRowHi() - 1L;
                    this.isSlaveForwardScan = true;
                }
                return true;
            }
            if (this.isSlaveForwardScan) {
                if (!this.slaveTimeFrameCursor.next() || masterTimestamp < this.slaveTimeFrame.getTimestampEstimateLo()) {
                    this.isSlaveForwardScan = false;
                    continue;
                }
                if (masterTimestamp < this.slaveTimeFrame.getTimestampEstimateLo() || masterTimestamp >= this.slaveTimeFrame.getTimestampEstimateHi()) continue;
                this.isSlaveOpenPending = true;
                continue;
            }
            if (!this.slaveTimeFrameCursor.prev() || this.slaveFrameIndex == this.slaveTimeFrame.getFrameIndex()) {
                this.isSlaveForwardScan = true;
                return false;
            }
            this.isSlaveOpenPending = true;
        }
    }

    protected long binarySearch(long value, long rowLo, long rowHi) {
        assert (Rows.toPartitionIndex(this.slaveRecA.getRowId()) == this.slaveFrameIndex);
        long low = rowLo;
        long high = rowHi;
        while (high - low > 65L) {
            long mid = low + high >>> 1;
            this.slaveTimeFrameCursor.recordAtRowIndex(this.slaveRecA, mid);
            long midVal = this.slaveRecA.getTimestamp(this.slaveTimestampIndex);
            if (midVal < value) {
                low = mid;
                continue;
            }
            if (midVal > value) {
                high = mid - 1L;
                continue;
            }
            return this.binarySearchScrollDown(mid, high, midVal);
        }
        return this.binarySearchScanDown(value, low, high + 1L, rowLo);
    }

    protected void nextSlave(long masterTimestamp) {
        do {
            if (!this.slaveTimeFrame.isOpen() || this.slaveTimeFrame.getFrameIndex() != this.slaveFrameIndex) continue;
            if (this.linearScan(masterTimestamp)) {
                return;
            }
            if (this.slaveFrameRow >= this.slaveTimeFrame.getRowHi()) continue;
            long foundRow = this.binarySearch(masterTimestamp, this.slaveFrameRow, this.slaveTimeFrame.getRowHi() - 1L);
            if (foundRow < this.slaveFrameRow) {
                return;
            }
            this.slaveFrameRow = foundRow;
            this.record.hasSlave(true);
            this.slaveTimeFrameCursor.recordAt(this.slaveRecB, Rows.toRowID(this.slaveFrameIndex, this.slaveFrameRow));
            long slaveTimestamp = this.slaveRecB.getTimestamp(this.slaveTimestampIndex);
            if (this.slaveFrameRow < this.slaveTimeFrame.getRowHi() - 1L) {
                this.slaveTimeFrameCursor.recordAt(this.slaveRecA, Rows.toRowID(this.slaveFrameIndex, this.slaveFrameRow + 1L));
                this.lookaheadTimestamp = this.slaveRecA.getTimestamp(this.slaveTimestampIndex);
            } else {
                this.lookaheadTimestamp = slaveTimestamp;
            }
            if (foundRow >= this.slaveTimeFrame.getRowHi() - 1L && slaveTimestamp != masterTimestamp) continue;
            return;
        } while (this.openSlaveFrame(masterTimestamp));
    }
}

