/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.LongChain;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class HashOuterJoinFilteredLightRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final HashOuterJoinLightRecordCursor cursor;
    private final Function filter;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;

    public HashOuterJoinFilteredLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, @NotNull Function filter, JoinContext joinContext) {
        super(metadata, joinContext, masterFactory, slaveFactory);
        try {
            this.masterKeySink = masterKeySink;
            this.slaveKeySink = slaveKeySink;
            this.cursor = new HashOuterJoinLightRecordCursor(columnSplit, NullRecordFactory.getInstance(slaveFactory.getMetadata()), joinColumnTypes, valueTypes, configuration);
            this.filter = filter;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        RecordCursor masterCursor = null;
        try {
            masterCursor = this.masterFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Hash Outer Join Light");
        sink.optAttr((CharSequence)"condition", this.joinContext);
        sink.attr("filter").val(this.filter);
        sink.child(this.masterFactory);
        sink.child("Hash", this.slaveFactory);
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
        Misc.free(this.cursor);
        Misc.free(this.filter);
    }

    private class HashOuterJoinLightRecordCursor
    extends AbstractJoinCursor {
        private final Map joinKeyMap;
        private final OuterJoinRecord record;
        private final LongChain slaveChain;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isMapBuilt;
        private boolean isOpen;
        private Record masterRecord;
        private LongChain.Cursor slaveChainCursor;
        private Record slaveRecord;

        public HashOuterJoinLightRecordCursor(int columnSplit, Record nullRecord, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, CairoConfiguration configuration) {
            super(columnSplit);
            this.joinKeyMap = MapFactory.createUnorderedMap(configuration, joinColumnTypes, valueTypes);
            this.slaveChain = new LongChain(configuration.getSqlHashJoinLightValuePageSize(), configuration.getSqlHashJoinLightValueMaxPages());
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                this.slaveChain.close();
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (!this.isMapBuilt) {
                this.buildMapOfSlaveRecords();
                this.isMapBuilt = true;
            }
            if (this.slaveChainCursor != null && this.slaveChainCursor.hasNext()) {
                this.record.hasSlave(true);
                while (this.slaveChainCursor.hasNext()) {
                    this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                    if (!HashOuterJoinFilteredLightRecordCursorFactory.this.filter.getBool(this.record)) continue;
                    return true;
                }
            }
            if (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashOuterJoinFilteredLightRecordCursorFactory.this.masterKeySink);
                MapValue value = key.findValue();
                if (value != null) {
                    this.slaveChainCursor = this.slaveChain.getCursor(value.getInt(0));
                    this.record.hasSlave(true);
                    while (this.slaveChainCursor.hasNext()) {
                        this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                        if (!HashOuterJoinFilteredLightRecordCursorFactory.this.filter.getBool(this.record)) continue;
                        return true;
                    }
                }
                this.slaveChainCursor = null;
                this.record.hasSlave(false);
                return true;
            }
            return false;
        }

        @Override
        public long preComputedStateSize() {
            return this.isMapBuilt ? 1L : 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            HashOuterJoinFilteredLightRecordCursorFactory.this.filter.toTop();
            this.masterCursor.toTop();
            this.slaveChainCursor = null;
            if (!this.isMapBuilt) {
                this.slaveCursor.toTop();
                this.joinKeyMap.clear();
                this.slaveChain.clear();
            }
        }

        private void buildMapOfSlaveRecords() {
            Record record = this.slaveCursor.getRecord();
            while (this.slaveCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.joinKeyMap.withKey();
                key.put(record, HashOuterJoinFilteredLightRecordCursorFactory.this.slaveKeySink);
                MapValue value = key.createValue();
                if (value.isNew()) {
                    int offset = this.slaveChain.put(record.getRowId(), -1);
                    value.putInt(0, offset);
                    continue;
                }
                value.putInt(0, this.slaveChain.put(record.getRowId(), value.getInt(0)));
            }
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor, SqlExecutionContext sqlExecutionContext) throws SqlException {
            if (!this.isOpen) {
                this.isOpen = true;
                this.slaveChain.reopen();
                this.joinKeyMap.reopen();
            }
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.circuitBreaker = sqlExecutionContext.getCircuitBreaker();
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecord);
            this.slaveChainCursor = null;
            this.isMapBuilt = false;
            HashOuterJoinFilteredLightRecordCursorFactory.this.filter.init(this, sqlExecutionContext);
        }
    }
}

