/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LimitedSizeLongTreeChain;
import io.questdb.griffin.engine.table.AsyncTopKAtom;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Os;
import io.questdb.std.Rows;

class AsyncTopKRecordCursor
implements RecordCursor {
    private static final Log LOG = LogFactory.getLog(AsyncTopKRecordCursor.class);
    private LimitedSizeLongTreeChain.TreeCursor chainCursor;
    private int frameLimit;
    private PageFrameMemoryPool frameMemoryPool;
    private PageFrameSequence<AsyncTopKAtom> frameSequence;
    private boolean isChainBuilt;
    private boolean isOpen = true;
    private PageFrameMemoryRecord recordA;
    private PageFrameMemoryRecord recordB;

    AsyncTopKRecordCursor() {
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        this.buildChainConditionally();
        AsyncTopKAtom atom = this.frameSequence.getAtom();
        counter.add(atom.getOwnerChain().size());
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            if (this.frameSequence != null) {
                LOG.debug().$("closing [shard=").$(this.frameSequence.getShard()).$(", frameCount=").$(this.frameLimit).I$();
                if (this.frameLimit > -1) {
                    this.frameSequence.await();
                }
                this.frameSequence.clear();
            }
        }
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordB() {
        return this.recordB;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.frameSequence.getSymbolTableSource().getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        this.buildChainConditionally();
        if (this.chainCursor.hasNext()) {
            this.recordAt(this.recordA, this.chainCursor.next());
            return true;
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.frameSequence.getSymbolTableSource().newSymbolTable(columnIndex);
    }

    @Override
    public long preComputedStateSize() {
        return this.isChainBuilt ? 1L : 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        PageFrameMemoryRecord frameMemoryRecord = (PageFrameMemoryRecord)record;
        this.frameMemoryPool.navigateTo(Rows.toPartitionIndex(atRowId), frameMemoryRecord);
        frameMemoryRecord.setRowIndex(Rows.toLocalRowID(atRowId));
    }

    @Override
    public long size() {
        if (!this.isChainBuilt) {
            return -1L;
        }
        AsyncTopKAtom atom = this.frameSequence.getAtom();
        return atom.getOwnerChain().size();
    }

    @Override
    public void toTop() {
        if (this.isChainBuilt && this.chainCursor != null) {
            this.chainCursor.toTop();
        }
    }

    private void buildChain() {
        if (this.frameLimit == -1) {
            this.frameSequence.prepareForDispatch();
            this.frameLimit = this.frameSequence.getFrameCount() - 1;
        }
        int frameIndex = -1;
        boolean allFramesActive = true;
        try {
            do {
                long cursor;
                if ((cursor = this.frameSequence.next()) > -1L) {
                    PageFrameReduceTask task = this.frameSequence.getTask(cursor);
                    LOG.debug().$("collected [shard=").$(this.frameSequence.getShard()).$(", frameIndex=").$(task.getFrameIndex()).$(", frameCount=").$(this.frameSequence.getFrameCount()).$(", active=").$(this.frameSequence.isActive()).$(", cursor=").$(cursor).I$();
                    if (task.hasError()) {
                        throw CairoException.nonCritical().position(task.getErrorMessagePosition()).put(task.getErrorMsg());
                    }
                    allFramesActive &= this.frameSequence.isActive();
                    frameIndex = task.getFrameIndex();
                    this.frameSequence.collect(cursor, false);
                    continue;
                }
                if (cursor == -2L) break;
                Os.pause();
            } while (frameIndex < this.frameLimit);
        }
        catch (CairoException e) {
            if (e.isInterruption()) {
                this.throwTimeoutException();
            }
            throw e;
        }
        if (!allFramesActive) {
            this.throwTimeoutException();
        }
        this.mergeChains();
    }

    private void buildChainConditionally() {
        if (!this.isChainBuilt) {
            this.buildChain();
            this.isChainBuilt = true;
        }
    }

    private void mergeChains() {
        AsyncTopKAtom atom = this.frameSequence.getAtom();
        LimitedSizeLongTreeChain ownerChain = atom.getOwnerChain();
        RecordComparator ownerComparator = atom.getOwnerComparator();
        int n = atom.getWorkerCount();
        for (int i = 0; i < n; ++i) {
            LimitedSizeLongTreeChain workerChain = atom.getPerWorkerChains().getQuick(i);
            LimitedSizeLongTreeChain.TreeCursor workerCursor = workerChain.getCursor();
            while (workerCursor.hasNext()) {
                this.recordAt(this.recordA, workerCursor.next());
                ownerChain.put(this.recordA, this.frameMemoryPool, this.recordB, ownerComparator);
            }
        }
        atom.freePerWorkerChainsAndPools();
        this.chainCursor = ownerChain.getCursor();
    }

    private void throwTimeoutException() {
        if (this.frameSequence.getCancelReason() == 3) {
            throw CairoException.queryCancelled();
        }
        throw CairoException.queryTimedOut();
    }

    void of(PageFrameSequence<AsyncTopKAtom> frameSequence) {
        AsyncTopKAtom atom = frameSequence.getAtom();
        if (!this.isOpen) {
            this.isOpen = true;
            atom.reopen();
        }
        this.frameSequence = frameSequence;
        this.frameMemoryPool = atom.getOwnerMemoryPool();
        this.recordA = atom.getOwnerRecordA();
        this.recordB = atom.getOwnerRecordB();
        atom.initMemoryPools(frameSequence.getPageFrameAddressCache());
        this.frameLimit = -1;
        this.isChainBuilt = false;
    }
}

