/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.OperatorRegistry;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ExpressionNode
implements Mutable,
Sinkable {
    public static final int ARRAY_ACCESS = 1;
    public static final int ARRAY_CONSTRUCTOR = 2;
    public static final int BIND_VARIABLE = 3;
    public static final int CONSTANT = 4;
    public static final int CONTROL = 5;
    public static final int FUNCTION = 6;
    public static final int LITERAL = 7;
    public static final int MEMBER_ACCESS = 8;
    public static final int OPERATION = 9;
    public static final int QUERY = 10;
    public static final int SET_OPERATION = 11;
    public static final ExpressionNodeFactory FACTORY = new ExpressionNodeFactory();
    public static final int UNKNOWN = 0;
    public final ObjList<ExpressionNode> args = new ObjList(4);
    public boolean innerPredicate = false;
    public int intrinsicValue = 0;
    public ExpressionNode lhs;
    public int paramCount;
    public int position;
    public int precedence;
    public QueryModel queryModel;
    public ExpressionNode rhs;
    public CharSequence token;
    public int type;

    private ExpressionNode() {
    }

    public static boolean compareNodesExact(ExpressionNode a, ExpressionNode b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null || a.type != b.type) {
            return false;
        }
        return (a.type == 6 || a.type == 7 ? Chars.equalsIgnoreCase(a.token, b.token) : Chars.equals(a.token, b.token)) && ExpressionNode.compareArgsExact(a, b);
    }

    public static boolean compareNodesGroupBy(ExpressionNode groupByExpr, ExpressionNode columnExpr, QueryModel translatingModel) {
        if (groupByExpr == null && columnExpr == null) {
            return true;
        }
        if (groupByExpr == null || columnExpr == null || groupByExpr.type != columnExpr.type) {
            return false;
        }
        if (!Chars.equals(groupByExpr.token, columnExpr.token)) {
            int index = translatingModel.getAliasToColumnMap().keyIndex(columnExpr.token);
            if (index > -1) {
                return false;
            }
            QueryColumn qc = translatingModel.getAliasToColumnMap().valueAt(index);
            CharSequence qcTok = qc.getAst().token;
            CharSequence tok = groupByExpr.token;
            if (Chars.equals(qcTok, tok)) {
                return true;
            }
            int dot = Chars.indexOfLastUnquoted(tok, '.');
            if (dot > -1 && translatingModel.getModelAliasIndex(tok, 0, dot) > -1 && Chars.equals(qcTok, tok, dot + 1, tok.length())) {
                return ExpressionNode.compareArgs(groupByExpr, columnExpr, translatingModel);
            }
            return false;
        }
        return ExpressionNode.compareArgs(groupByExpr, columnExpr, translatingModel);
    }

    public static ExpressionNode deepClone(ObjectPool<ExpressionNode> pool, ExpressionNode node) {
        if (node == null) {
            return null;
        }
        ExpressionNode copy = pool.next();
        int n = node.args.size();
        for (int i = 0; i < n; ++i) {
            copy.args.add(ExpressionNode.deepClone(pool, node.args.get(i)));
        }
        copy.token = node.token;
        copy.queryModel = node.queryModel;
        copy.precedence = node.precedence;
        copy.position = node.position;
        copy.lhs = ExpressionNode.deepClone(pool, node.lhs);
        copy.rhs = ExpressionNode.deepClone(pool, node.rhs);
        copy.type = node.type;
        copy.paramCount = node.paramCount;
        copy.intrinsicValue = node.intrinsicValue;
        copy.innerPredicate = node.innerPredicate;
        return copy;
    }

    @Override
    public void clear() {
        this.args.clear();
        this.token = null;
        this.precedence = 0;
        this.position = 0;
        this.lhs = null;
        this.rhs = null;
        this.type = 0;
        this.paramCount = 0;
        this.intrinsicValue = 0;
        this.queryModel = null;
        this.innerPredicate = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionNode that = (ExpressionNode)o;
        return this.precedence == that.precedence && this.position == that.position && this.type == that.type && this.paramCount == that.paramCount && this.intrinsicValue == that.intrinsicValue && this.innerPredicate == that.innerPredicate && Objects.equals(this.args, that.args) && Objects.equals(this.token, that.token) && Objects.equals(this.queryModel, that.queryModel) && Objects.equals(this.lhs, that.lhs) && Objects.equals(this.rhs, that.rhs);
    }

    public int hashCode() {
        return Objects.hash(this.args, this.token, this.queryModel, this.precedence, this.position, this.lhs, this.rhs, this.type, this.paramCount, this.intrinsicValue, this.innerPredicate);
    }

    public boolean isWildcard() {
        return this.type == 7 && Chars.endsWith(this.token, '*');
    }

    public boolean noLeafs() {
        return this.lhs == null || this.rhs == null;
    }

    public ExpressionNode of(int type, CharSequence token, int precedence, int position) {
        this.clear();
        this.type = type == 7 && token != null && token.length() != 0 && (token.charAt(0) == '$' && Numbers.isDecimal(token, 1) || token.charAt(0) == ':') ? 3 : type;
        this.precedence = precedence;
        this.token = token;
        this.position = position;
        return this;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        OperatorRegistry registry = OperatorExpression.getRegistry();
        char openBracket = '(';
        char closeBracket = ')';
        if (this.token != null && SqlKeywords.isArrayKeyword(this.token)) {
            openBracket = '[';
            closeBracket = ']';
        }
        switch (this.paramCount) {
            case 0: {
                if (this.queryModel != null) {
                    sink.putAscii('(').put(this.queryModel).putAscii(')');
                    break;
                }
                sink.put(this.token);
                if (this.type != 6) break;
                sink.putAscii("()");
                break;
            }
            case 1: {
                sink.put(this.token);
                sink.putAscii(openBracket);
                ExpressionNode.toSink(sink, this.rhs);
                sink.putAscii(closeBracket);
                break;
            }
            case 2: {
                if (registry.isOperator(this.token)) {
                    boolean rhsParent;
                    boolean lhsParent;
                    boolean bl = lhsParent = this.lhs.type == 9 && this.lhs.precedence > this.precedence;
                    if (lhsParent) {
                        sink.putAscii('(');
                    }
                    ExpressionNode.toSink(sink, this.lhs);
                    if (lhsParent) {
                        sink.putAscii(')');
                    }
                    sink.putAscii(' ');
                    sink.put(this.token);
                    sink.putAscii(' ');
                    boolean bl2 = rhsParent = this.rhs.type == 9 && this.rhs.precedence >= this.precedence;
                    if (rhsParent) {
                        sink.putAscii('(');
                    }
                    ExpressionNode.toSink(sink, this.rhs);
                    if (!rhsParent) break;
                    sink.putAscii(')');
                    break;
                }
                if (this.token.length() == 2 && this.token.charAt(0) == '[' && this.token.charAt(1) == ']') {
                    sink.put(this.lhs);
                    sink.put('[');
                    sink.put(this.rhs);
                    sink.put(']');
                    break;
                }
                if (SqlKeywords.isCaseKeyword(this.token)) {
                    sink.put("case when ");
                    sink.put(this.lhs);
                    sink.put(" then ");
                    sink.put(this.rhs);
                    sink.put(" end");
                    break;
                }
                if (SqlKeywords.isCastKeyword(this.token)) {
                    boolean parent;
                    boolean bl = parent = this.lhs.type == 9 || SqlKeywords.isCaseKeyword(this.lhs.token) || SqlKeywords.isBetweenKeyword(this.lhs.token);
                    if (parent) {
                        sink.put('(');
                        sink.put(this.lhs);
                        sink.put(')');
                    } else {
                        sink.put(this.lhs);
                    }
                    sink.put(':');
                    sink.put(':');
                    sink.put(this.rhs);
                    break;
                }
                sink.put(this.token);
                sink.putAscii(openBracket);
                ExpressionNode.toSink(sink, this.lhs);
                sink.putAscii(',');
                sink.putAscii(' ');
                ExpressionNode.toSink(sink, this.rhs);
                sink.putAscii(closeBracket);
                break;
            }
            default: {
                int n = this.args.size();
                if (registry.isOperator(this.token) && n > 0) {
                    ExpressionNode.toSink(sink, this.args.getQuick(n - 1));
                    sink.putAscii(' ');
                    sink.put(this.token);
                    sink.putAscii(' ');
                    sink.putAscii('(');
                    for (int i = n - 2; i > -1; --i) {
                        if (i < n - 2) {
                            sink.putAscii(',');
                            sink.putAscii(' ');
                        }
                        ExpressionNode.toSink(sink, this.args.getQuick(i));
                    }
                    sink.putAscii(')');
                    break;
                }
                if (SqlKeywords.isCaseKeyword(this.token)) {
                    sink.put("case");
                    for (int i = n - 1; i > 0; i -= 2) {
                        sink.put(" when ");
                        sink.put(this.args.getQuick(i));
                        sink.put(" then ");
                        ExpressionNode.toSink(sink, this.args.getQuick(i - 1));
                    }
                    if (n % 2 == 1) {
                        sink.put(" else ");
                        ExpressionNode.toSink(sink, this.args.getQuick(0));
                    }
                    sink.put(" end");
                    break;
                }
                sink.put(this.token);
                sink.putAscii(openBracket);
                for (int i = n - 1; i > -1; --i) {
                    if (i < n - 1) {
                        sink.putAscii(',');
                        sink.putAscii(' ');
                    }
                    ExpressionNode.toSink(sink, this.args.getQuick(i));
                }
                sink.putAscii(closeBracket);
            }
        }
    }

    public String toString() {
        return Objects.toString(this.token);
    }

    private static boolean compareArgs(ExpressionNode groupByExpr, ExpressionNode columnExpr, QueryModel translatingModel) {
        int selectNodeArgsSize;
        int groupByArgsSize = groupByExpr.args.size();
        if (groupByArgsSize != (selectNodeArgsSize = columnExpr.args.size())) {
            return false;
        }
        if (groupByArgsSize < 3) {
            return ExpressionNode.compareNodesGroupBy(groupByExpr.lhs, columnExpr.lhs, translatingModel) && ExpressionNode.compareNodesGroupBy(groupByExpr.rhs, columnExpr.rhs, translatingModel);
        }
        for (int i = 0; i < groupByArgsSize; ++i) {
            if (ExpressionNode.compareNodesGroupBy(groupByExpr.args.get(i), columnExpr.args.get(i), translatingModel)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareArgsExact(ExpressionNode a, ExpressionNode b) {
        int selectNodeArgsSize;
        int groupByArgsSize = a.args.size();
        if (groupByArgsSize != (selectNodeArgsSize = b.args.size())) {
            return false;
        }
        if (groupByArgsSize < 3) {
            return ExpressionNode.compareNodesExact(a.lhs, b.lhs) && ExpressionNode.compareNodesExact(a.rhs, b.rhs);
        }
        for (int i = 0; i < groupByArgsSize; ++i) {
            if (ExpressionNode.compareNodesExact(a.args.get(i), b.args.get(i))) continue;
            return false;
        }
        return true;
    }

    private static void toSink(CharSink<?> sink, ExpressionNode e) {
        if (e == null) {
            sink.putAscii("null");
        } else {
            e.toSink(sink);
        }
    }

    public static final class ExpressionNodeFactory
    implements ObjectFactory<ExpressionNode> {
        @Override
        public ExpressionNode newInstance() {
            return new ExpressionNode();
        }
    }
}

