/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.std.str.CharSink;
import io.questdb.std.str.Utf8Sink;

class PrometheusFormatUtils {
    static final char LF = '\n';
    static final CharSequence METRIC_NAME_PREFIX = "questdb_";
    static final CharSequence TYPE_PREFIX = "# TYPE questdb_";

    PrometheusFormatUtils() {
    }

    static void appendCounterNamePrefix(CharSequence name, CharSink<?> sink) {
        sink.putAscii(METRIC_NAME_PREFIX);
        sink.put(name);
        sink.putAscii("_total");
    }

    static void appendCounterType(CharSequence name, CharSink<?> sink) {
        sink.putAscii(TYPE_PREFIX);
        sink.put(name);
        sink.putAscii("_total counter\n");
    }

    static void appendLabel(Utf8Sink utf8Sink, CharSequence labelName, CharSequence labelValue) {
        utf8Sink.put(labelName);
        utf8Sink.putAscii('=');
        utf8Sink.putQuote().escapeJsonStr(labelValue).putQuote();
    }

    static void appendNewLine(CharSink<?> sink) {
        sink.putAscii('\n');
    }

    static void appendSampleLineSuffix(CharSink<?> sink, long value) {
        sink.putAscii(' ');
        sink.put(value);
        sink.putAscii('\n');
    }

    static void appendSampleLineSuffix(CharSink<?> sink, double value) {
        sink.putAscii(' ');
        sink.put(value);
        sink.putAscii('\n');
    }
}

