/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.LongGauge;
import io.questdb.metrics.MetricsRegistry;
import io.questdb.std.Mutable;

public class WorkerMetrics
implements Mutable {
    private final LongGauge max;
    private final LongGauge min;

    public WorkerMetrics(MetricsRegistry metricsRegistry) {
        this.min = metricsRegistry.newLongGauge("workers_job_start_micros_min");
        this.max = metricsRegistry.newLongGauge("workers_job_start_micros_max");
        this.min.setValue(Long.MAX_VALUE);
        this.max.setValue(Long.MIN_VALUE);
    }

    @Override
    public void clear() {
        this.min.setValue(Long.MAX_VALUE);
        this.max.setValue(Long.MIN_VALUE);
    }

    public long getMaxElapsedMicros() {
        return this.max.getValue();
    }

    public long getMinElapsedMicros() {
        return this.min.getValue();
    }

    public void update(long candidateMin, long candidateMax) {
        if (candidateMin < this.min.getValue()) {
            this.min.setValue(candidateMin);
        }
        if (candidateMax > this.max.getValue()) {
            this.max.setValue(candidateMax);
        }
    }
}

