/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.KqueueFacade;
import io.questdb.network.NetworkError;
import io.questdb.network.SuspendEvent;

public class PipeSuspendEvent
extends SuspendEvent {
    private final KqueueFacade kqf;
    private final long readEndFd;
    private final long writeEndFd;

    public PipeSuspendEvent(KqueueFacade kqf) {
        this.kqf = kqf;
        long fds = kqf.pipe();
        if (fds < 0L) {
            throw NetworkError.instance(kqf.getNetworkFacade().errno(), "could not create PipeSuspendEvent");
        }
        this.readEndFd = kqf.getNetworkFacade().bumpFdCount((int)(fds >>> 32));
        this.writeEndFd = kqf.getNetworkFacade().bumpFdCount((int)fds);
    }

    @Override
    public void _close() {
        this.kqf.getNetworkFacade().close(this.readEndFd);
        this.kqf.getNetworkFacade().close(this.writeEndFd);
    }

    @Override
    public boolean checkTriggered() {
        return this.kqf.readPipe(this.readEndFd) == 1;
    }

    @Override
    public long getFd() {
        return this.readEndFd;
    }

    @Override
    public void trigger() {
        if (this.kqf.writePipe(this.writeEndFd) < 0) {
            throw NetworkError.instance(this.kqf.getNetworkFacade().errno()).put("could not write to pipe [fd=").put(this.writeEndFd).put(']');
        }
    }
}

