/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.bytes.DirectSequence;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;

public class DirectIntSlice
implements DirectSequence {
    private int length = 0;
    private long ptr = 0L;

    public int get(int index) {
        assert (index >= 0);
        assert (index < this.length);
        return Unsafe.getUnsafe().getInt(this.ptr + ((long)index << 2));
    }

    public int length() {
        return this.length;
    }

    public DirectIntSlice of(long ptr, int length) {
        assert (ptr >= 0L);
        assert (length >= 0);
        assert (ptr != 0L || length == 0);
        this.ptr = ptr;
        this.length = length;
        return this;
    }

    @Override
    public long ptr() {
        assert (this.ptr != 0L);
        return this.ptr;
    }

    public void reset() {
        this.ptr = 0L;
        this.length = 0;
    }

    @Override
    public int size() {
        assert (this.length >= 0);
        return this.length * 4;
    }

    public void shl(long delta) {
        this.ptr -= delta;
    }

    public int[] toArray() {
        int[] res = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            res[i] = this.get(i);
        }
        return res;
    }

    public String toString() {
        StringSink sb = Misc.getThreadLocalSink();
        sb.put('[');
        int maxElementsToPrint = 1000;
        int n = Math.min(1000, this.length);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                ((Utf16Sink)sb.put(',')).put(' ');
            }
            sb.put(this.get(i));
        }
        if (this.size() > 1000) {
            sb.put(", .. ");
        }
        sb.put(']');
        return ((Object)sb).toString();
    }
}

