/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.CairoException;
import io.questdb.log.Log;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.Os;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.MutableUtf8Sink;
import io.questdb.std.str.Path;
import org.jetbrains.annotations.Nullable;

public class FilesFacadeImpl
implements FilesFacade {
    public static final FilesFacade INSTANCE = new FilesFacadeImpl();
    public static final int _16M = 0x1000000;
    private static final long ZFS_MAGIC_NUMBER = 801189825L;
    private final FsOperation copyFsOperation = this::copy;
    private final FsOperation hardLinkFsOperation = this::hardLink;
    private long mapPageSize = 0L;

    @Override
    public boolean allocate(long fd, long size) {
        return Files.allocate(fd, size);
    }

    @Override
    public boolean allowMixedIO(CharSequence root) {
        if (root == null || Os.isWindows()) {
            return false;
        }
        try (Path path = new Path();){
            path.of(root);
            long fsStatus = Files.getFileSystemStatus(path.$());
            path.seekZ();
            boolean bl = fsStatus < 0L && Math.abs(fsStatus) != 801189825L;
            return bl;
        }
    }

    @Override
    public long append(long fd, long buf, long len) {
        return Files.append(fd, buf, len);
    }

    @Override
    public boolean close(long fd) {
        return Files.close(fd) == 0;
    }

    @Override
    public boolean closeRemove(long fd, LPSZ path) {
        if (this.isRestrictedFileSystem() && fd > -1L) {
            Files.close(fd);
        }
        boolean ok = this.removeQuiet(path);
        if (!this.isRestrictedFileSystem() && fd > -1L) {
            Files.close(fd);
        }
        return ok;
    }

    @Override
    public int copy(LPSZ from, LPSZ to) {
        return Files.copy(from, to);
    }

    @Override
    public long copyData(long srcFd, long destFd, long offsetSrc, long length) {
        return Files.copyData(srcFd, destFd, offsetSrc, length);
    }

    @Override
    public long copyData(long srcFd, long destFd, long offsetSrc, long destOffset, long length) {
        return Files.copyDataToOffset(srcFd, destFd, offsetSrc, destOffset, length);
    }

    @Override
    public int copyRecursive(Path src, Path dst, int dirMode) {
        return this.runRecursive(src, dst, dirMode, this.copyFsOperation);
    }

    @Override
    public int errno() {
        return Os.errno();
    }

    @Override
    public boolean exists(LPSZ path) {
        return Files.exists(path);
    }

    @Override
    public boolean exists(long fd) {
        return Files.exists(fd);
    }

    @Override
    public void fadvise(long fd, long offset, long len, int advise) {
        if (advise > -1) {
            Files.fadvise(fd, offset, len, advise);
        }
    }

    @Override
    public long findClose(long findPtr) {
        if (findPtr != 0L) {
            Files.findClose(findPtr);
        }
        return 0L;
    }

    @Override
    public long findFirst(LPSZ path) {
        long ptr = Files.findFirst(path);
        if (ptr == -1L) {
            throw CairoException.critical(Os.errno()).put("findFirst failed on ").put(path);
        }
        return ptr;
    }

    @Override
    public long findName(long findPtr) {
        return Files.findName(findPtr);
    }

    @Override
    public int findNext(long findPtr) {
        int r = Files.findNext(findPtr);
        if (r == -1) {
            throw CairoException.critical(Os.errno()).put("findNext failed");
        }
        return r;
    }

    @Override
    public int findType(long findPtr) {
        return Files.findType(findPtr);
    }

    @Override
    public void fsync(long fd) {
        int res = Files.fsync(fd);
        if (res == 0) {
            return;
        }
        throw CairoException.critical(this.errno()).put("could not fsync [fd=").put(fd).put(']');
    }

    @Override
    public void fsyncAndClose(long fd) {
        int res = Files.fsync(fd);
        if (res == 0) {
            this.close(fd);
            return;
        }
        this.close(fd);
        throw CairoException.critical(this.errno()).put("could not fsync [fd=").put(fd).put(']');
    }

    @Override
    public long getDirSize(Path path) {
        return Files.getDirSize(path);
    }

    @Override
    public long getDiskFreeSpace(LPSZ path) {
        return Files.getDiskFreeSpace(path);
    }

    @Override
    public long getFileLimit() {
        return Files.getFileLimit();
    }

    @Override
    public int getFileSystemStatus(LPSZ lpszName) {
        return Files.getFileSystemStatus(lpszName);
    }

    @Override
    public long getLastModified(LPSZ path) {
        return Files.getLastModified(path);
    }

    @Override
    public long getMapCountLimit() {
        return Files.getMapCountLimit();
    }

    @Override
    public long getMapPageSize() {
        if (this.mapPageSize == 0L) {
            this.mapPageSize = this.computeMapPageSize();
        }
        return this.mapPageSize;
    }

    @Override
    public long getOpenFileCount() {
        return Files.getOpenFileCount();
    }

    @Override
    public long getPageSize() {
        return Files.PAGE_SIZE;
    }

    @Override
    public int hardLink(LPSZ src, LPSZ hardLink) {
        return Files.hardLink(src, hardLink);
    }

    @Override
    public int hardLinkDirRecursive(Path src, Path dst, int dirMode) {
        return this.runRecursive(src, dst, dirMode, this.hardLinkFsOperation);
    }

    @Override
    public boolean isCrossDeviceCopyError(int errno) {
        return Os.isPosix() && errno == 18;
    }

    @Override
    public boolean isDirOrSoftLinkDir(LPSZ path) {
        return Files.isDirOrSoftLinkDir(path);
    }

    @Override
    public boolean isDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type) {
        return Files.isDirOrSoftLinkDirNoDots(path, rootLen, pUtf8NameZ, type);
    }

    @Override
    public boolean isDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type, MutableUtf8Sink nameSink) {
        return Files.isDirOrSoftLinkDirNoDots(path, rootLen, pUtf8NameZ, type, nameSink);
    }

    @Override
    public boolean isRestrictedFileSystem() {
        return Os.isWindows();
    }

    @Override
    public boolean isSoftLink(LPSZ softLink) {
        return Files.isSoftLink(softLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateDir(LPSZ path, FindVisitor func) {
        long p = this.findFirst(path);
        if (p > 0L) {
            try {
                do {
                    func.onFind(this.findName(p), this.findType(p));
                } while (this.findNext(p) > 0);
            }
            finally {
                this.findClose(p);
            }
        }
    }

    @Override
    public long length(long fd) {
        long r = Files.length(fd);
        if (r < 0L) {
            throw CairoException.critical(Os.errno()).put("Checking file size failed");
        }
        return r;
    }

    @Override
    public long length(LPSZ name) {
        return Files.length(name);
    }

    @Override
    public int lock(long fd) {
        return Files.lock(fd);
    }

    @Override
    public void madvise(long address, long len, int advise) {
        if (advise > -1) {
            Files.madvise(address, len, advise);
        }
    }

    @Override
    public int mkdir(LPSZ path, int mode) {
        return Files.mkdir(path, mode);
    }

    @Override
    public int mkdirs(Path path, int mode) {
        return Files.mkdirs(path, mode);
    }

    @Override
    public long mmap(long fd, long len, long offset, int flags, int memoryTag) {
        return Files.mmap(fd, len, offset, flags, memoryTag);
    }

    @Override
    public long mremap(long fd, long addr, long previousSize, long newSize, long offset, int mode, int memoryTag) {
        return Files.mremap(fd, addr, previousSize, newSize, offset, mode, memoryTag);
    }

    @Override
    public void msync(long addr, long len, boolean async) {
        int res = Files.msync(addr, len, async);
        if (res == 0) {
            return;
        }
        throw CairoException.critical(this.errno()).put("could not msync");
    }

    @Override
    public void munmap(long address, long size, int memoryTag) {
        Files.munmap(address, size, memoryTag);
    }

    @Override
    public long openAppend(LPSZ name) {
        return Files.openAppend(name);
    }

    @Override
    public long openCleanRW(LPSZ name, long size) {
        return Files.openCleanRW(name, size);
    }

    @Override
    public long openRO(LPSZ name) {
        return Files.openRO(name);
    }

    @Override
    public long openRONoCache(LPSZ path) {
        return Files.openRONoCache(path);
    }

    @Override
    public long openRW(LPSZ name, int opts) {
        return Files.openRW(name, opts);
    }

    @Override
    public long openRWNoCache(LPSZ name, int opts) {
        return this.openRW(name, opts);
    }

    @Override
    public long read(long fd, long buf, long len, long offset) {
        return Files.read(fd, buf, len, offset);
    }

    @Override
    public long readIntAsUnsignedLong(long fd, long offset) {
        return Files.readIntAsUnsignedLong(fd, offset);
    }

    @Override
    public boolean readLink(Path softLink, Path readTo) {
        return Files.readLink(softLink, readTo);
    }

    @Override
    public byte readNonNegativeByte(long fd, long offset) {
        return Files.readNonNegativeByte(fd, offset);
    }

    @Override
    public int readNonNegativeInt(long fd, long offset) {
        return Files.readNonNegativeInt(fd, offset);
    }

    @Override
    public long readNonNegativeLong(long fd, long offset) {
        return Files.readNonNegativeLong(fd, offset);
    }

    @Override
    public void remove(LPSZ name) {
        if (!this.removeQuiet(name)) {
            throw CairoException.critical(this.errno()).put("could not remove [file=").put(name).put(']');
        }
    }

    @Override
    public boolean removeQuiet(LPSZ name) {
        boolean ok = Files.remove(name);
        if (!ok) {
            int errno = this.errno();
            if (Files.errnoFileDoesNotExist(errno)) {
                return true;
            }
            if (Os.isWindows() && errno == 5) {
                return !this.exists(name);
            }
        }
        return ok;
    }

    @Override
    public int rename(LPSZ from, LPSZ to) {
        return Files.rename(from, to);
    }

    @Override
    public final boolean rmdir(Path name) {
        return this.rmdir(name, true);
    }

    @Override
    public boolean rmdir(Path name, boolean haltOnError) {
        return Files.rmdir(name, haltOnError);
    }

    @Override
    public int softLink(LPSZ src, LPSZ softLink) {
        return Files.softLink(src, softLink);
    }

    @Override
    public int sync() {
        return Files.sync();
    }

    @Override
    public boolean touch(LPSZ path) {
        return Files.touch(path);
    }

    @Override
    public boolean truncate(long fd, long size) {
        return Files.truncate(fd, size);
    }

    @Override
    public int typeDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type, @Nullable MutableUtf8Sink nameSink) {
        return Files.typeDirOrSoftLinkDirNoDots(path, rootLen, pUtf8NameZ, type, nameSink);
    }

    @Override
    public int unlink(LPSZ softLink) {
        return Files.unlink(softLink);
    }

    @Override
    public boolean unlinkOrRemove(Path path, Log LOG) {
        int checkedType = this.isSoftLink(path.$()) ? 10 : 0;
        return this.unlinkOrRemove(path, checkedType, LOG);
    }

    @Override
    public boolean unlinkOrRemove(Path path, int checkedType, Log LOG) {
        if (checkedType == 10) {
            if (this.unlink(path.$()) == 0) {
                LOG.debug().$("removed by unlink [path=").$(path).I$();
                return true;
            }
            LOG.debug().$("failed to unlink, will remove [path=").$(path).I$();
        }
        if (this.rmdir(path)) {
            LOG.debug().$("removed [path=").$(path).I$();
            return true;
        }
        LOG.debug().$("cannot remove [path=").$(path).$(", errno=").$(this.errno()).I$();
        return false;
    }

    @Override
    public void walk(Path path, FindVisitor func) {
        Files.walk(path, func);
    }

    @Override
    public long write(long fd, long address, long len, long offset) {
        return Files.write(fd, address, len, offset);
    }

    private long computeMapPageSize() {
        long pageSize = this.getPageSize();
        long mapPageSize = pageSize * pageSize;
        if (mapPageSize < pageSize || mapPageSize > 0x1000000L) {
            if (0x1000000L % pageSize == 0L) {
                return 0x1000000L;
            }
            return pageSize;
        }
        return mapPageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runRecursive(Path src, Path dst, int dirMode, FsOperation operation) {
        int dstLen = dst.size();
        int srcLen = src.size();
        int len = src.size();
        long p = this.findFirst(src.$());
        LPSZ lpsz = dst.$();
        if (!this.exists(lpsz) && -1 == this.mkdir(lpsz, dirMode)) {
            return -1;
        }
        if (p > 0L) {
            try {
                do {
                    int res;
                    long name;
                    if (!Files.notDots(name = this.findName(p))) continue;
                    int type = this.findType(p);
                    src.trimTo(len);
                    src.concat(name);
                    dst.concat(name);
                    if (type == 8) {
                        res = operation.invoke(src.$(), dst.$());
                        if (res < 0) {
                            int n = res;
                            return n;
                        }
                    } else {
                        this.mkdir(dst.$(), dirMode);
                        res = this.runRecursive(src, dst, dirMode, operation);
                        if (res < 0) {
                            int n = res;
                            return n;
                        }
                    }
                    src.trimTo(srcLen);
                    dst.trimTo(dstLen);
                } while (this.findNext(p) > 0);
            }
            finally {
                this.findClose(p);
                src.trimTo(srcLen);
                dst.trimTo(dstLen);
            }
        }
        return 0;
    }

    @FunctionalInterface
    private static interface FsOperation {
        public int invoke(LPSZ var1, LPSZ var2);
    }
}

