/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;

public class AsciiCharSequence
implements CharSequence {
    private int len;
    private Utf8Sequence original;
    private int start;
    private AsciiCharSequence subSequence;

    @Override
    public char charAt(int i) {
        return (char)this.original.byteAt(i + this.start);
    }

    @Override
    public int length() {
        return this.len;
    }

    public AsciiCharSequence of(Utf8Sequence original) {
        this.original = original;
        this.start = 0;
        this.len = original.size();
        return this;
    }

    public AsciiCharSequence of(Utf8Sequence original, int start, int len) {
        this.original = original;
        this.start = start;
        this.len = len;
        return this;
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        if (this.subSequence == null) {
            this.subSequence = new AsciiCharSequence();
        }
        return this.subSequence.of(this.original, start, end - start);
    }

    @Override
    @NotNull
    public String toString() {
        return this.original.toString();
    }
}

