/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.AbstractServerSocket;
import org.snmp4j.transport.AbstractSocketEntry;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.SocketTimeout;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;
import org.snmp4j.util.CommonTimer;
import org.snmp4j.util.WorkerTask;

public abstract class TcpTransportMapping<S extends AbstractSocketEntry>
extends AbstractTransportMapping<TcpAddress>
implements ConnectionOrientedTransportMapping<TcpAddress> {
    private static final LogAdapter logger = LogFactory.getLogger(TcpTransportMapping.class);
    protected TcpAddress tcpAddress;
    protected Map<Address, S> sockets = new ConcurrentHashMap<Address, S>();
    protected long connectionTimeout = 60000L;
    protected CommonTimer socketCleaner;
    protected boolean serverEnabled = false;
    private transient List<TransportStateListener> transportStateListeners;
    protected boolean openSocketOnSending = true;

    public TcpTransportMapping(TcpAddress tcpAddress) {
        this.tcpAddress = tcpAddress;
    }

    @Override
    public Class<? extends Address> getSupportedAddressClass() {
        return TcpAddress.class;
    }

    public TcpAddress getAddress() {
        return this.tcpAddress;
    }

    protected synchronized void timeoutSocket(AbstractServerSocket<TcpAddress> entry) {
        if (this.connectionTimeout > 0L && this.socketCleaner != null) {
            SocketTimeout<TcpAddress> socketTimeout = new SocketTimeout<TcpAddress>(this, entry);
            entry.setSocketTimeout(socketTimeout);
            this.socketCleaner.schedule(socketTimeout, this.connectionTimeout);
        }
    }

    @Override
    public TcpAddress getListenAddress() {
        return this.tcpAddress;
    }

    protected void closeSockets(Map<Address, S> sockets) {
        for (AbstractSocketEntry entry : sockets.values()) {
            Socket s = entry.getSocket();
            if (s == null) continue;
            try {
                SocketChannel sc = s.getChannel();
                s.close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Socket to " + entry.getPeerAddress() + " closed")));
                }
                if (sc != null) {
                    sc.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Socket channel to " + entry.getPeerAddress() + " closed")));
                    }
                }
                TransportStateEvent e = new TransportStateEvent(this, (Address)entry.getPeerAddress(), 4, null);
                this.fireConnectionStateChanged(e);
            }
            catch (IOException iox) {
                logger.debug(iox);
            }
        }
    }

    @Override
    public synchronized boolean close(TcpAddress remoteAddress) throws IOException {
        AbstractSocketEntry entry;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Closing socket for peer address " + remoteAddress)));
        }
        if ((entry = (AbstractSocketEntry)this.sockets.remove(remoteAddress)) != null) {
            Socket s;
            if (entry.getSocketTimeout() != null) {
                entry.getSocketTimeout().cancel();
            }
            if ((s = entry.getSocket()) != null) {
                SocketChannel sc = entry.getSocket().getChannel();
                entry.getSocket().close();
                if (logger.isInfoEnabled()) {
                    logger.info("Socket to " + entry.getPeerAddress() + " closed");
                }
                if (sc != null) {
                    sc.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Closed socket channel for peer address " + remoteAddress)));
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public abstract void sendMessage(TcpAddress var1, byte[] var2, TransportStateReference var3, long var4, int var6) throws IOException;

    public boolean isOpenSocketOnSending() {
        return this.openSocketOnSending;
    }

    public void setOpenSocketOnSending(boolean openSocketOnSending) {
        this.openSocketOnSending = openSocketOnSending;
    }

    @Override
    public abstract void listen() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    @Override
    public abstract MessageLengthDecoder getMessageLengthDecoder();

    @Override
    public void setServerEnabled(boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
    }

    @Override
    public abstract void setMessageLengthDecoder(MessageLengthDecoder var1);

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public synchronized void addTransportStateListener(TransportStateListener l) {
        if (this.transportStateListeners == null) {
            this.transportStateListeners = new ArrayList<TransportStateListener>(2);
        }
        this.transportStateListeners.add(l);
    }

    @Override
    public synchronized void removeTransportStateListener(TransportStateListener l) {
        if (this.transportStateListeners != null) {
            this.transportStateListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionStateChanged(TransportStateEvent change) {
        block8: {
            List<TransportStateListener> listenersFinalRef;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Firing transport state event: " + change)));
            }
            if ((listenersFinalRef = this.transportStateListeners) != null) {
                try {
                    ArrayList<TransportStateListener> listeners;
                    List<TransportStateListener> list = listenersFinalRef;
                    synchronized (list) {
                        listeners = new ArrayList<TransportStateListener>(listenersFinalRef);
                    }
                    for (TransportStateListener listener : listeners) {
                        listener.connectionStateChanged(change);
                    }
                }
                catch (RuntimeException ex) {
                    logger.error("Exception in fireConnectionStateChanged: " + ex.getMessage(), ex);
                    if (!SNMP4JSettings.isForwardRuntimeExceptions()) break block8;
                    throw ex;
                }
            }
        }
    }

    protected void setSocketOptions(ServerSocket serverSocket) {
    }

    public WorkerTask getListenWorkerTask() {
        return this.listenWorkerTask;
    }

    protected void cancelNonServerSelectionKey(SelectionKey sk) {
        if (!sk.isAcceptable()) {
            sk.cancel();
        }
    }
}

