/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.value.UnsignedShort;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ClickHouseShortValue
implements ClickHouseValue {
    private boolean isNull;
    private short value;

    public static ClickHouseShortValue ofNull() {
        return ClickHouseShortValue.ofNull(null, false);
    }

    public static ClickHouseShortValue ofUnsignedNull() {
        return ClickHouseShortValue.ofNull(null, true);
    }

    public static ClickHouseShortValue ofNull(boolean unsigned) {
        return ClickHouseShortValue.ofNull(null, unsigned);
    }

    public static ClickHouseShortValue ofNull(ClickHouseValue ref, boolean unsigned) {
        if (unsigned) {
            return ref instanceof UnsignedShortValue ? ((UnsignedShortValue)ref).set(true, (short)0) : new UnsignedShortValue(true, 0);
        }
        return ref instanceof ClickHouseShortValue ? ((ClickHouseShortValue)ref).set(true, (short)0) : new ClickHouseShortValue(true, 0);
    }

    public static ClickHouseShortValue of(short value) {
        return ClickHouseShortValue.of(null, value, false);
    }

    public static ClickHouseShortValue ofUnsigned(short value) {
        return ClickHouseShortValue.of(null, value, true);
    }

    public static ClickHouseShortValue of(short value, boolean unsigned) {
        return ClickHouseShortValue.of(null, value, unsigned);
    }

    public static ClickHouseShortValue of(int value) {
        return ClickHouseShortValue.of(null, (short)value, false);
    }

    public static ClickHouseShortValue ofUnsigned(int value) {
        return ClickHouseShortValue.of(null, (short)value, true);
    }

    public static ClickHouseShortValue of(int value, boolean unsigned) {
        return ClickHouseShortValue.of(null, (short)value, unsigned);
    }

    public static ClickHouseShortValue of(Number value, boolean unsigned) {
        return value == null ? ClickHouseShortValue.ofNull(null, unsigned) : ClickHouseShortValue.of(null, value.shortValue(), unsigned);
    }

    public static ClickHouseShortValue of(ClickHouseValue ref, short value, boolean unsigned) {
        if (unsigned) {
            return ref instanceof UnsignedShortValue ? ((UnsignedShortValue)ref).set(false, value) : new UnsignedShortValue(false, value);
        }
        return ref instanceof ClickHouseShortValue ? ((ClickHouseShortValue)ref).set(false, value) : new ClickHouseShortValue(false, value);
    }

    protected ClickHouseShortValue(boolean isNull, short value) {
        this.set(isNull, value);
    }

    protected final ClickHouseShortValue set(boolean isNull, short value) {
        this.isNull = isNull;
        this.value = isNull ? (short)0 : value;
        return this;
    }

    public final short getValue() {
        return this.value;
    }

    @Override
    public ClickHouseShortValue copy(boolean deep) {
        return new ClickHouseShortValue(this.isNull, this.value);
    }

    @Override
    public final boolean isNullOrEmpty() {
        return this.isNull;
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return this.value;
    }

    @Override
    public int asInteger() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNull ? null : BigInteger.valueOf(this.value);
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNull ? null : BigDecimal.valueOf(this.value, scale);
    }

    @Override
    public Object asObject() {
        return this.isNull ? null : Short.valueOf(this.getValue());
    }

    @Override
    public String asString() {
        return this.isNull ? null : Short.toString(this.value);
    }

    @Override
    public ClickHouseShortValue resetToDefault() {
        return this.set(false, (short)0);
    }

    @Override
    public ClickHouseShortValue resetToNullOrEmpty() {
        return this.set(true, (short)0);
    }

    @Override
    public String toSqlExpression() {
        return this.isNullOrEmpty() ? "NULL" : Short.toString(this.value);
    }

    @Override
    public ClickHouseShortValue update(boolean value) {
        return this.set(false, value ? (short)1 : 0);
    }

    @Override
    public ClickHouseShortValue update(char value) {
        return this.set(false, (short)value);
    }

    @Override
    public ClickHouseShortValue update(byte value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseShortValue update(short value) {
        return this.set(false, value);
    }

    @Override
    public ClickHouseShortValue update(int value) {
        return this.set(false, (short)value);
    }

    @Override
    public ClickHouseShortValue update(long value) {
        return this.set(false, (short)value);
    }

    @Override
    public ClickHouseShortValue update(float value) {
        return this.set(false, (short)value);
    }

    @Override
    public ClickHouseShortValue update(double value) {
        return this.set(false, (short)value);
    }

    @Override
    public ClickHouseShortValue update(BigInteger value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.shortValueExact());
    }

    @Override
    public ClickHouseShortValue update(BigDecimal value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, value.shortValueExact());
    }

    @Override
    public ClickHouseShortValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.set(false, (short)value.ordinal());
    }

    @Override
    public ClickHouseShortValue update(String value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (value.isEmpty()) {
            this.resetToDefault();
        } else {
            this.set(false, Short.parseShort(value));
        }
        return this;
    }

    @Override
    public ClickHouseShortValue update(ClickHouseValue value) {
        return value == null || value.isNullOrEmpty() ? this.resetToNullOrEmpty() : this.set(false, value.asShort());
    }

    @Override
    public ClickHouseShortValue update(Object value) {
        if (value instanceof Number) {
            return this.set(false, ((Number)value).shortValue());
        }
        if (value instanceof ClickHouseValue) {
            return this.set(false, ((ClickHouseValue)value).asShort());
        }
        ClickHouseValue.super.update(value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseShortValue v = (ClickHouseShortValue)obj;
        return this.isNull == v.isNull && this.value == v.value;
    }

    public int hashCode() {
        return (31 + (this.isNull ? 1231 : 1237)) * 31 + this.value;
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }

    static final class UnsignedShortValue
    extends ClickHouseShortValue {
        protected UnsignedShortValue(boolean isNull, short value) {
            super(isNull, value);
        }

        @Override
        public int asInteger() {
            return 0xFFFF & this.getValue();
        }

        @Override
        public long asLong() {
            return 0xFFFFL & (long)this.getValue();
        }

        @Override
        public BigInteger asBigInteger() {
            return this.isNullOrEmpty() ? null : BigInteger.valueOf(this.asLong());
        }

        @Override
        public float asFloat() {
            return this.asInteger();
        }

        @Override
        public double asDouble() {
            return this.asLong();
        }

        @Override
        public BigDecimal asBigDecimal(int scale) {
            return this.isNullOrEmpty() ? null : BigDecimal.valueOf(this.asLong(), scale);
        }

        @Override
        public Object asObject() {
            return this.isNullOrEmpty() ? null : UnsignedShort.valueOf(this.getValue());
        }

        @Override
        public String asString() {
            return this.isNullOrEmpty() ? null : Integer.toString(this.asInteger());
        }

        @Override
        public ClickHouseShortValue copy(boolean deep) {
            return new UnsignedShortValue(this.isNullOrEmpty(), this.getValue());
        }

        @Override
        public String toSqlExpression() {
            return this.isNullOrEmpty() ? "NULL" : Integer.toString(this.asInteger());
        }

        @Override
        public ClickHouseShortValue update(byte value) {
            return this.set(false, (short)(0xFF & value));
        }

        @Override
        public ClickHouseShortValue update(BigInteger value) {
            return value == null ? this.resetToNullOrEmpty() : this.set(false, value.shortValue());
        }

        @Override
        public ClickHouseShortValue update(BigDecimal value) {
            return value == null ? this.resetToNullOrEmpty() : this.set(false, value.shortValue());
        }

        @Override
        public ClickHouseShortValue update(String value) {
            if (value == null) {
                this.resetToNullOrEmpty();
            } else if (value.isEmpty()) {
                this.resetToDefault();
            } else {
                this.set(false, UnsignedShort.valueOf(value).shortValue());
            }
            return this;
        }
    }
}

