/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.messaging;

import java.nio.ByteBuffer;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.IpmiCommandName;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.AbstractIpmiRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteOrderUtils;

public class CloseSessionRequest
extends AbstractIpmiRequest {
    public final int systemSessionId;

    public CloseSessionRequest(int systemSessionId) {
        this.systemSessionId = systemSessionId;
    }

    @Override
    public int getDataWireLength(IpmiPacketContext context) {
        return this.systemSessionId == 0 ? 5 : 4;
    }

    @Override
    public void toWireData(IpmiPacketContext context, ByteBuffer buffer) {
        ByteOrderUtils.writeLeInt(buffer, this.systemSessionId);
        if (this.systemSessionId == 0) {
            buffer.put((byte)0);
        }
    }

    @Override
    public IpmiCommandName getCommandName() {
        return IpmiCommandName.CloseSession;
    }
}

