/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

public final class ExponentialBackoff {
    private final long initial;
    private final long max;
    private long current;

    public ExponentialBackoff(long initial, long max) {
        if (initial <= 0L || max < initial) {
            throw new IllegalArgumentException("Invalid exponential backoff params");
        }
        this.initial = initial;
        this.max = max;
        this.current = initial;
    }

    public long nextDelay() {
        long delay = this.current;
        this.current = this.current <= this.max / 2L ? (this.current *= 2L) : this.max;
        return delay;
    }

    public void reset() {
        this.current = this.initial;
    }
}

