/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.columns;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;

public class HiveAccumuloMapColumnMapping
extends ColumnMapping {
    protected final String columnFamily;
    protected final String columnQualifierPrefix;
    protected final ColumnEncoding keyEncoding;
    protected final ColumnEncoding valueEncoding;

    public HiveAccumuloMapColumnMapping(String columnFamily, String columnQualifierPrefix, ColumnEncoding keyEncoding, ColumnEncoding valueEncoding, String columnName, String columnType) {
        super((null == columnFamily ? "" : columnFamily) + ":", valueEncoding, columnName, columnType);
        Preconditions.checkNotNull((Object)columnFamily, (Object)"Must provide a column family");
        this.columnFamily = columnFamily;
        this.columnQualifierPrefix = null == columnQualifierPrefix ? "" : columnQualifierPrefix;
        this.keyEncoding = keyEncoding;
        this.valueEncoding = valueEncoding;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public String getColumnQualifierPrefix() {
        return this.columnQualifierPrefix;
    }

    public ColumnEncoding getKeyEncoding() {
        return this.keyEncoding;
    }

    public ColumnEncoding getValueEncoding() {
        return this.valueEncoding;
    }

    public boolean equals(Object o) {
        if (o instanceof HiveAccumuloMapColumnMapping) {
            HiveAccumuloMapColumnMapping other = (HiveAccumuloMapColumnMapping)o;
            return this.columnFamily.equals(other.columnFamily) && this.columnQualifierPrefix.equals(other.columnQualifierPrefix) && this.keyEncoding.equals((Object)other.keyEncoding) && this.valueEncoding.equals((Object)other.valueEncoding);
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(23, 31);
        hcb.append((Object)this.columnFamily).append((Object)this.columnQualifierPrefix).append((Object)this.keyEncoding).append((Object)this.valueEncoding);
        return hcb.toHashCode();
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.columnFamily + ":" + this.columnQualifierPrefix + "* encoding: " + String.valueOf((Object)this.keyEncoding) + ":" + String.valueOf((Object)this.valueEncoding) + "]";
    }
}

