/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hive.hcatalog.templeton.ProxyUserSupport;
import org.apache.hive.hcatalog.templeton.tool.JobState;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppConfig
extends Configuration {
    public static final String[] HADOOP_CONF_FILENAMES = new String[]{"core-default.xml", "core-site.xml", "mapred-default.xml", "mapred-site.xml", "hdfs-site.xml"};
    public static final String[] HADOOP_PREFIX_VARS = new String[]{"HADOOP_PREFIX", "HADOOP_HOME"};
    public static final String TEMPLETON_HOME_VAR = "TEMPLETON_HOME";
    public static final String WEBHCAT_CONF_DIR = "WEBHCAT_CONF_DIR";
    public static final String[] TEMPLETON_CONF_FILENAMES = new String[]{"webhcat-default.xml", "webhcat-site.xml"};
    public static final String PORT = "templeton.port";
    public static final String JETTY_CONFIGURATION = "templeton.jetty.configuration";
    public static final String EXEC_ENCODING_NAME = "templeton.exec.encoding";
    public static final String EXEC_ENVS_NAME = "templeton.exec.envs";
    public static final String EXEC_MAX_BYTES_NAME = "templeton.exec.max-output-bytes";
    public static final String EXEC_MAX_PROCS_NAME = "templeton.exec.max-procs";
    public static final String EXEC_TIMEOUT_NAME = "templeton.exec.timeout";
    public static final String HADOOP_QUEUE_NAME = "templeton.hadoop.queue.name";
    public static final String ENABLE_JOB_RECONNECT_DEFAULT = "templeton.enable.job.reconnect.default";
    public static final String HADOOP_NAME = "templeton.hadoop";
    public static final String HADOOP_CONF_DIR = "templeton.hadoop.conf.dir";
    public static final String HCAT_NAME = "templeton.hcat";
    public static final String PYTHON_NAME = "templeton.python";
    public static final String HIVE_ARCHIVE_NAME = "templeton.hive.archive";
    public static final String HIVE_PATH_NAME = "templeton.hive.path";
    public static final String MAPPER_MEMORY_MB = "templeton.mapper.memory.mb";
    public static final String MR_AM_MEMORY_MB = "templeton.mr.am.memory.mb";
    public static final String TEMPLETON_JOBSLIST_ORDER = "templeton.jobs.listorder";
    public static final String USE_SSL = "templeton.use.ssl";
    public static final String KEY_STORE_PATH = "templeton.keystore.path";
    public static final String KEY_STORE_PASSWORD = "templeton.keystore.password";
    public static final String SSL_PROTOCOL_BLACKLIST = "templeton.ssl.protocol.blacklist";
    public static final String HOST = "templeton.host";
    public static final String JOB_SUBMIT_MAX_THREADS = "templeton.parallellism.job.submit";
    public static final String JOB_STATUS_MAX_THREADS = "templeton.parallellism.job.status";
    public static final String JOB_LIST_MAX_THREADS = "templeton.parallellism.job.list";
    public static final String JOB_SUBMIT_TIMEOUT = "templeton.job.submit.timeout";
    public static final String JOB_STATUS_TIMEOUT = "templeton.job.status.timeout";
    public static final String JOB_LIST_TIMEOUT = "templeton.job.list.timeout";
    public static final String JOB_TIMEOUT_TASK_RETRY_COUNT = "templeton.job.timeout.task.retry.count";
    public static final String JOB_TIMEOUT_TASK_RETRY_INTERVAL = "templeton.job.timeout.task.retry.interval";
    public static final String HIVE_HOME_PATH = "templeton.hive.home";
    public static final String HCAT_HOME_PATH = "templeton.hcat.home";
    public static final String HIVE_PROPS_NAME = "templeton.hive.properties";
    public static final String HIVE_SERVER2_URL = "templeton.hive.hs2.url";
    public static final String SQOOP_ARCHIVE_NAME = "templeton.sqoop.archive";
    public static final String SQOOP_PATH_NAME = "templeton.sqoop.path";
    public static final String SQOOP_HOME_PATH = "templeton.sqoop.home";
    public static final String LIB_JARS_NAME = "templeton.libjars";
    public static final String PIG_ARCHIVE_NAME = "templeton.pig.archive";
    public static final String PIG_PATH_NAME = "templeton.pig.path";
    public static final String STREAMING_JAR_NAME = "templeton.streaming.jar";
    public static final String OVERRIDE_JARS_NAME = "templeton.override.jars";
    public static final String OVERRIDE_JARS_ENABLED = "templeton.override.enabled";
    public static final String TEMPLETON_CONTROLLER_MR_CHILD_OPTS = "templeton.controller.mr.child.opts";
    public static final String TEMPLETON_CONTROLLER_MR_AM_JAVA_OPTS = "templeton.controller.mr.am.java.opts";
    public static final String KERBEROS_SECRET = "templeton.kerberos.secret";
    public static final String KERBEROS_PRINCIPAL = "templeton.kerberos.principal";
    public static final String KERBEROS_KEYTAB = "templeton.kerberos.keytab";
    public static final String CALLBACK_INTERVAL_NAME = "templeton.callback.retry.interval";
    public static final String CALLBACK_RETRY_NAME = "templeton.callback.retry.attempts";
    public static final String HADOOP_END_INTERVAL_NAME = "job.end.retry.interval";
    public static final String HADOOP_END_RETRY_NAME = "job.end.retry.attempts";
    public static final String HADOOP_END_URL_NAME = "job.end.notification.url";
    public static final String HADOOP_SPECULATIVE_NAME = "mapred.map.tasks.speculative.execution";
    public static final String HADOOP_CHILD_JAVA_OPTS = "mapred.child.java.opts";
    public static final String HADOOP_MAP_MEMORY_MB = "mapreduce.map.memory.mb";
    public static final String HADOOP_MR_AM_JAVA_OPTS = "yarn.app.mapreduce.am.command-opts";
    public static final String HADOOP_MR_AM_MEMORY_MB = "yarn.app.mapreduce.am.resource.mb";
    public static final String UNIT_TEST_MODE = "templeton.unit.test.mode";
    public static final String HIVE_EXTRA_FILES = "templeton.hive.extra.files";
    public static final String XSRF_FILTER_ENABLED = "templeton.xsrf.filter.enabled";
    public static final String FRAME_OPTIONS_FILETER = "templeton.frame.options.filter";
    private static final Logger LOG = LoggerFactory.getLogger(AppConfig.class);

    public AppConfig() {
        this.init();
        LOG.info("Using Hadoop version " + VersionInfo.getVersion());
    }

    private void init() {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            this.set("env." + entry.getKey(), entry.getValue());
        }
        String templetonDir = AppConfig.getTempletonDir();
        for (String fname : TEMPLETON_CONF_FILENAMES) {
            AppConfig.logConfigLoadAttempt(templetonDir + File.separator + fname);
            if (this.loadOneClasspathConfig(fname)) continue;
            this.loadOneFileConfig(templetonDir, fname);
        }
        String string = this.getHadoopConfDir();
        for (String fname : HADOOP_CONF_FILENAMES) {
            AppConfig.logConfigLoadAttempt(string + File.separator + fname);
            this.loadOneFileConfig(string, fname);
        }
        ProxyUserSupport.processProxyuserConfig(this);
        this.handleHiveProperties();
        LOG.info(this.dumpEnvironent());
    }

    private void handleHiveProperties() {
        HiveConf hiveConf = new HiveConf();
        List<String> interestingPropNames = Arrays.asList(HiveConf.ConfVars.METASTORE_URIS.varname, HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL.varname, HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI.varname, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname, HiveConf.ConfVars.HIVE_CONF_HIDDEN_LIST.varname);
        ArrayList<String> webhcatHiveProps = new ArrayList<String>(this.hiveProps());
        for (String string : interestingPropNames) {
            String value = hiveConf.get(string);
            if (value == null) continue;
            boolean found = false;
            for (String whProp : webhcatHiveProps) {
                if (!whProp.startsWith(string + "=")) continue;
                found = true;
                break;
            }
            if (found) continue;
            webhcatHiveProps.add(string + "=" + value);
        }
        StringBuilder hiveProps = new StringBuilder();
        for (String whProp : webhcatHiveProps) {
            hiveProps.append(hiveProps.length() > 0 ? "," : "").append(StringUtils.escapeString((String)whProp));
        }
        this.set(HIVE_PROPS_NAME, hiveProps.toString());
        String string = hiveConf.get(HiveConf.ConfVars.HIVE_CONF_HIDDEN_LIST.varname);
        if (this.get(HiveConf.ConfVars.HIVE_CONF_HIDDEN_LIST.varname) == null && string != null) {
            this.set(HiveConf.ConfVars.HIVE_CONF_HIDDEN_LIST.varname, string);
        }
    }

    private static void logConfigLoadAttempt(String path) {
        LOG.info("Attempting to load config file: " + path);
    }

    private String dumpEnvironent() {
        StringBuilder sb = TempletonUtils.dumpPropMap("========WebHCat System.getenv()========", System.getenv());
        sb.append("START========WebHCat AppConfig.iterator()========: \n");
        HiveConfUtil.dumpConfig((Configuration)this, (StringBuilder)sb);
        sb.append("END========WebHCat AppConfig.iterator()========: \n");
        sb.append((CharSequence)TempletonUtils.dumpPropMap("========WebHCat System.getProperties()========", System.getProperties()));
        sb.append((CharSequence)HiveConfUtil.dumpConfig((HiveConf)new HiveConf()));
        return sb.toString();
    }

    public JobsListOrder getListJobsOrder() {
        String requestedOrder = this.get(TEMPLETON_JOBSLIST_ORDER);
        if (requestedOrder != null) {
            try {
                return JobsListOrder.valueOf(requestedOrder.toLowerCase());
            }
            catch (IllegalArgumentException ex) {
                LOG.warn("Ignoring setting templeton.jobs.listorder configured with in-correct value " + requestedOrder);
            }
        }
        return JobsListOrder.lexicographicalasc;
    }

    public void startCleanup() {
        JobState.getStorageInstance(this).startCleanup(this);
    }

    public String getHadoopConfDir() {
        return this.get(HADOOP_CONF_DIR);
    }

    public static String getTempletonDir() {
        return System.getenv(TEMPLETON_HOME_VAR);
    }

    public static String getWebhcatConfDir() {
        return System.getenv(WEBHCAT_CONF_DIR);
    }

    private boolean loadOneFileConfig(String dir, String fname) {
        File f;
        if (dir != null && (f = new File(dir, fname)).exists()) {
            this.addResource(new Path(f.getAbsolutePath()));
            LOG.info("loaded config file " + f.getAbsolutePath());
            return true;
        }
        return false;
    }

    private boolean loadOneClasspathConfig(String fname) {
        URL x = this.getResource(fname);
        if (x != null) {
            this.addResource(x);
            LOG.info("loaded config from classpath " + String.valueOf(x));
            return true;
        }
        return false;
    }

    public String jettyConfiguration() {
        return this.get(JETTY_CONFIGURATION);
    }

    public String libJars() {
        return this.get(LIB_JARS_NAME);
    }

    public String hadoopQueueName() {
        return this.get(HADOOP_QUEUE_NAME);
    }

    public String enableJobReconnectDefault() {
        return this.get(ENABLE_JOB_RECONNECT_DEFAULT);
    }

    public String clusterHadoop() {
        return this.get(HADOOP_NAME);
    }

    public String clusterHcat() {
        return this.get(HCAT_NAME);
    }

    public String clusterPython() {
        return this.get(PYTHON_NAME);
    }

    public String pigPath() {
        return this.get(PIG_PATH_NAME);
    }

    public String pigArchive() {
        return this.get(PIG_ARCHIVE_NAME);
    }

    public String hivePath() {
        return this.get(HIVE_PATH_NAME);
    }

    public String hiveArchive() {
        return this.get(HIVE_ARCHIVE_NAME);
    }

    public String sqoopPath() {
        return this.get(SQOOP_PATH_NAME);
    }

    public String sqoopArchive() {
        return this.get(SQOOP_ARCHIVE_NAME);
    }

    public String sqoopHome() {
        return this.get(SQOOP_HOME_PATH);
    }

    public String streamingJar() {
        return this.get(STREAMING_JAR_NAME);
    }

    public String kerberosSecret() {
        return this.get(KERBEROS_SECRET);
    }

    public String kerberosPrincipal() {
        return this.get(KERBEROS_PRINCIPAL);
    }

    public String kerberosKeytab() {
        return this.get(KERBEROS_KEYTAB);
    }

    public String controllerMRChildOpts() {
        return this.get(TEMPLETON_CONTROLLER_MR_CHILD_OPTS);
    }

    public String controllerAMChildOpts() {
        return this.get(TEMPLETON_CONTROLLER_MR_AM_JAVA_OPTS);
    }

    public String mapperMemoryMb() {
        return this.get(MAPPER_MEMORY_MB);
    }

    public String amMemoryMb() {
        return this.get(MR_AM_MEMORY_MB);
    }

    public Collection<String> hiveProps() {
        String[] props = StringUtils.split((String)this.get(HIVE_PROPS_NAME));
        if (props == null) {
            return Collections.emptyList();
        }
        for (int i = 0; i < props.length; ++i) {
            props[i] = TempletonUtils.unEscapeString(props[i]);
        }
        return Arrays.asList(props);
    }

    public String[] overrideJars() {
        if (this.getBoolean(OVERRIDE_JARS_ENABLED, true)) {
            return this.getStrings(OVERRIDE_JARS_NAME);
        }
        return null;
    }

    public String overrideJarsString() {
        if (this.getBoolean(OVERRIDE_JARS_ENABLED, true)) {
            return this.get(OVERRIDE_JARS_NAME);
        }
        return null;
    }

    public long zkCleanupInterval() {
        return this.getLong("templeton.zookeeper.cleanup.interval", 43200000L);
    }

    public long zkMaxAge() {
        return this.getLong("templeton.zookeeper.cleanup.maxage", 604800000L);
    }

    public String zkHosts() {
        return this.get("templeton.zookeeper.hosts");
    }

    public int zkSessionTimeout() {
        return this.getInt("templeton.zookeeper.session-timeout", 30000);
    }

    public static enum JobsListOrder {
        lexicographicalasc,
        lexicographicaldesc;

    }
}

