/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.annotation.MetastoreVersionAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MetastoreVersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoreVersionInfo.class);
    private static Package myPackage = MetastoreVersionAnnotation.class.getPackage();
    private static MetastoreVersionAnnotation version = myPackage.getAnnotation(MetastoreVersionAnnotation.class);

    static Package getPackage() {
        return myPackage;
    }

    public static String getVersion() {
        return version != null ? version.version() : "Unknown";
    }

    public static String getShortVersion() {
        return version != null ? version.shortVersion() : "Unknown";
    }

    public static String getRevision() {
        return version != null ? version.revision() : "Unknown";
    }

    public static String getBranch() {
        return version != null ? version.branch() : "Unknown";
    }

    public static String getDate() {
        return version != null ? version.date() : "Unknown";
    }

    public static String getUser() {
        return version != null ? version.user() : "Unknown";
    }

    public static String getUrl() {
        return version != null ? version.url() : "Unknown";
    }

    public static String getSrcChecksum() {
        return version != null ? version.srcChecksum() : "Unknown";
    }

    public static String getBuildVersion() {
        return MetastoreVersionInfo.getVersion() + " from " + MetastoreVersionInfo.getRevision() + " by " + MetastoreVersionInfo.getUser() + " source checksum " + MetastoreVersionInfo.getSrcChecksum();
    }

    public static void main(String[] args) {
        LOG.debug("version: " + String.valueOf(version));
        System.out.println("Hive " + MetastoreVersionInfo.getVersion());
        System.out.println("Git " + MetastoreVersionInfo.getUrl() + " -r " + MetastoreVersionInfo.getRevision());
        System.out.println("Compiled by " + MetastoreVersionInfo.getUser() + " on " + MetastoreVersionInfo.getDate());
        System.out.println("From source with checksum " + MetastoreVersionInfo.getSrcChecksum());
    }
}

