/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class MatchingStringsCompleter
implements Completer {
    protected SortedSet<String> candidateStrings = new TreeSet<String>();

    public MatchingStringsCompleter() {
    }

    public MatchingStringsCompleter(String ... strings) {
        this(Arrays.asList(strings));
    }

    public MatchingStringsCompleter(Iterable<String> strings) {
        strings.forEach(this.candidateStrings::add);
    }

    public Collection<String> getStrings() {
        return this.candidateStrings;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        Objects.requireNonNull(candidates, "candidates must not be null");
        if (line == null) {
            this.candidateStrings.stream().map(Candidate::new).forEach(candidates::add);
        } else {
            String match;
            Iterator iterator = this.candidateStrings.tailSet(line.word()).iterator();
            while (iterator.hasNext() && (match = (String)iterator.next()).startsWith(line.word())) {
                candidates.add(new Candidate(match));
            }
        }
    }
}

