/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.FileFormatProxy;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsckPartitionExpressionProxy
implements PartitionExpressionProxy {
    private static final Logger LOG = LoggerFactory.getLogger(MsckPartitionExpressionProxy.class);

    public String convertExprToFilter(byte[] exprBytes, String defaultPartitionName, boolean decodeFilterExpToStr) throws MetaException {
        return new String(exprBytes, StandardCharsets.UTF_8);
    }

    public boolean filterPartitionsByExpr(List<FieldSchema> partColumns, byte[] expr, String defaultPartitionName, List<String> partitionNames) throws MetaException {
        String[] partitions;
        String partExpr = new String(expr, StandardCharsets.UTF_8);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Partition expr: {}", (Object)expr);
        }
        HashSet<String> filterParts = new HashSet<String>();
        for (String part : partitions = partExpr.split(" OR ")) {
            part = part.substring(1, part.length() - 1);
            String[] pKeyValues = part.split(" AND ");
            StringBuilder builder = new StringBuilder();
            for (String pKeyValue : pKeyValues) {
                String[] colAndValue = pKeyValue.split("=");
                String key = FileUtils.unescapePathName((String)colAndValue[0]);
                String value = FileUtils.unescapePathName((String)colAndValue[1].substring(1, colAndValue[1].length() - 1));
                builder.append(key + "=" + value).append("/");
            }
            builder.setLength(builder.length() - 1);
            filterParts.add(builder.toString());
        }
        ArrayList<String> partNamesSeq = new ArrayList<String>();
        for (String part : partitionNames) {
            if (!filterParts.contains(FileUtils.unescapePathName((String)part))) continue;
            partNamesSeq.add(part);
        }
        partitionNames.clear();
        partitionNames.addAll(partNamesSeq);
        LOG.info("The returned partition list is of size: {}", (Object)partitionNames.size());
        if (LOG.isDebugEnabled()) {
            for (String s : partitionNames) {
                LOG.debug("Matched partition: {}", (Object)s);
            }
        }
        return false;
    }

    public FileMetadataExprType getMetadataType(String inputFormat) {
        throw new UnsupportedOperationException();
    }

    public FileFormatProxy getFileFormatProxy(FileMetadataExprType type) {
        throw new UnsupportedOperationException();
    }

    public SearchArgument createSarg(byte[] expr) {
        throw new UnsupportedOperationException();
    }
}

