/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.crd.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum PodPhase {
    PENDING("Pending"),
    RUNNING("Running"),
    SUCCEEDED("Succeeded"),
    FAILED("Failed"),
    UNKNOWN("Unknown");

    private final String value;
    private static final Map<String, PodPhase> CONSTANTS;

    private PodPhase(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static PodPhase fromValue(String value) {
        PodPhase constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, PodPhase>();
        for (PodPhase c : PodPhase.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

