/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.graph;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.hugegraph.driver.GraphManager;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.structure.graph.Pageable;
import org.apache.hugegraph.util.E;

public class GraphIterator<T extends GraphElement>
implements Iterator<T> {
    private final GraphManager graphManager;
    private final int sizePerPage;
    private final Function<String, Pageable<T>> pageFetcher;
    private List<T> results;
    private String page;
    private int cursor;
    private boolean finished;

    public GraphIterator(GraphManager graphManager, int sizePerPage, Function<String, Pageable<T>> pageFetcher) {
        E.checkNotNull(graphManager, "Graph manager");
        E.checkNotNull(pageFetcher, "Page fetcher");
        this.graphManager = graphManager;
        this.sizePerPage = sizePerPage;
        this.pageFetcher = pageFetcher;
        this.results = null;
        this.page = "";
        this.cursor = 0;
        this.finished = false;
    }

    @Override
    public boolean hasNext() {
        if (this.results == null || this.cursor >= this.results.size()) {
            this.fetch();
        }
        assert (this.results != null);
        return this.cursor < this.results.size();
    }

    private void fetch() {
        if (this.finished) {
            return;
        }
        Pageable<T> pageable = this.pageFetcher.apply(this.page);
        this.results = pageable.results();
        this.page = pageable.page();
        this.cursor = 0;
        E.checkState(this.results.size() <= this.sizePerPage, "Server returned unexpected results: %s > %s", this.results.size(), this.sizePerPage);
        if (this.results.size() < this.sizePerPage || this.page == null) {
            this.finished = true;
        }
    }

    @Override
    public T next() {
        GraphElement elem;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E.checkState((elem = (GraphElement)this.results.get(this.cursor++)) != null, "The server data is invalid, some records are null", new Object[0]);
        elem.attachManager(this.graphManager);
        return (T)elem;
    }
}

