/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt;

import com.google.protobuf.Struct;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.mqtt.ConnListenerBuilder;
import org.apache.bifromq.mqtt.IMQTTBroker;
import org.apache.bifromq.mqtt.IMQTTBrokerBuilder;
import org.apache.bifromq.mqtt.MQTTBroker;
import org.apache.bifromq.mqtt.service.ILocalDistService;
import org.apache.bifromq.mqtt.service.ILocalSessionRegistry;
import org.apache.bifromq.mqtt.service.LocalDistService;
import org.apache.bifromq.mqtt.service.LocalSessionRegistry;
import org.apache.bifromq.mqtt.service.LocalTopicRouter;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.clientbalancer.IClientBalancer;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTBrokerBuilder
implements IMQTTBrokerBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTTBrokerBuilder.class);
    int connectTimeoutSeconds = 20;
    int connectRateLimit = 1000;
    int disconnectRate = 1000;
    long writeLimit = 524288L;
    long readLimit = 524288L;
    int maxBytesInMessage = 262144;
    int mqttBossELGThreads;
    int mqttWorkerELGThreads;
    RPCServerBuilder rpcServerBuilder;
    IAuthProvider authProvider;
    IClientBalancer clientBalancer;
    IResourceThrottler resourceThrottler;
    IEventCollector eventCollector;
    ISettingProvider settingProvider;
    IDistClient distClient;
    IInboxClient inboxClient;
    IRetainClient retainClient;
    ISessionDictClient sessionDictClient;
    Map<String, Struct> userPropsCustomizerFactoryConfig = new HashMap<String, Struct>();
    ILocalSessionRegistry sessionRegistry;
    ILocalDistService distService;
    ConnListenerBuilder.TCPConnListenerBuilder tcpListenerBuilder;
    ConnListenerBuilder.TLSConnListenerBuilder tlsListenerBuilder;
    ConnListenerBuilder.WSConnListenerBuilder wsListenerBuilder;
    ConnListenerBuilder.WSSConnListenerBuilder wssListenerBuilder;

    @Override
    public ConnListenerBuilder.TCPConnListenerBuilder buildTcpConnListener() {
        if (this.tcpListenerBuilder == null) {
            this.tcpListenerBuilder = new ConnListenerBuilder.TCPConnListenerBuilder(this);
        }
        return this.tcpListenerBuilder;
    }

    @Override
    public ConnListenerBuilder.TLSConnListenerBuilder buildTLSConnListener() {
        if (this.tlsListenerBuilder == null) {
            this.tlsListenerBuilder = new ConnListenerBuilder.TLSConnListenerBuilder(this);
        }
        return this.tlsListenerBuilder;
    }

    @Override
    public ConnListenerBuilder.WSConnListenerBuilder buildWSConnListener() {
        if (this.wsListenerBuilder == null) {
            this.wsListenerBuilder = new ConnListenerBuilder.WSConnListenerBuilder(this);
        }
        return this.wsListenerBuilder;
    }

    @Override
    public ConnListenerBuilder.WSSConnListenerBuilder buildWSSConnListener() {
        if (this.wssListenerBuilder == null) {
            this.wssListenerBuilder = new ConnListenerBuilder.WSSConnListenerBuilder(this);
        }
        return this.wssListenerBuilder;
    }

    public MQTTBrokerBuilder distClient(IDistClient distClient) {
        this.distClient = distClient;
        this.sessionRegistry = new LocalSessionRegistry();
        LocalTopicRouter router = new LocalTopicRouter(this.brokerId(), distClient);
        this.distService = new LocalDistService(this.brokerId(), this.sessionRegistry, router, distClient, this.resourceThrottler);
        return this;
    }

    @Override
    public String brokerId() {
        return this.rpcServerBuilder.id();
    }

    @Override
    public IMQTTBroker build() {
        return new MQTTBroker(this);
    }

    @Generated
    MQTTBrokerBuilder() {
    }

    @Generated
    public MQTTBrokerBuilder connectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder connectRateLimit(int connectRateLimit) {
        this.connectRateLimit = connectRateLimit;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder disconnectRate(int disconnectRate) {
        this.disconnectRate = disconnectRate;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder writeLimit(long writeLimit) {
        this.writeLimit = writeLimit;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder readLimit(long readLimit) {
        this.readLimit = readLimit;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder maxBytesInMessage(int maxBytesInMessage) {
        this.maxBytesInMessage = maxBytesInMessage;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder mqttBossELGThreads(int mqttBossELGThreads) {
        this.mqttBossELGThreads = mqttBossELGThreads;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder mqttWorkerELGThreads(int mqttWorkerELGThreads) {
        this.mqttWorkerELGThreads = mqttWorkerELGThreads;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder rpcServerBuilder(RPCServerBuilder rpcServerBuilder) {
        this.rpcServerBuilder = rpcServerBuilder;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder authProvider(IAuthProvider authProvider) {
        this.authProvider = authProvider;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder clientBalancer(IClientBalancer clientBalancer) {
        this.clientBalancer = clientBalancer;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder resourceThrottler(IResourceThrottler resourceThrottler) {
        this.resourceThrottler = resourceThrottler;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder eventCollector(IEventCollector eventCollector) {
        this.eventCollector = eventCollector;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder settingProvider(ISettingProvider settingProvider) {
        this.settingProvider = settingProvider;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder inboxClient(IInboxClient inboxClient) {
        this.inboxClient = inboxClient;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder retainClient(IRetainClient retainClient) {
        this.retainClient = retainClient;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder sessionDictClient(ISessionDictClient sessionDictClient) {
        this.sessionDictClient = sessionDictClient;
        return this;
    }

    @Generated
    public MQTTBrokerBuilder userPropsCustomizerFactoryConfig(Map<String, Struct> userPropsCustomizerFactoryConfig) {
        this.userPropsCustomizerFactoryConfig = userPropsCustomizerFactoryConfig;
        return this;
    }
}

