/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import com.google.common.collect.Sets;
import io.micrometer.core.instrument.Timer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.dist.client.MatchResult;
import org.apache.bifromq.dist.client.UnmatchResult;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.mqtt.handler.DedupCache;
import org.apache.bifromq.mqtt.handler.IMQTTProtocolHelper;
import org.apache.bifromq.mqtt.handler.MQTTSessionHandler;
import org.apache.bifromq.mqtt.handler.RoutedMessage;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.condition.Condition;
import org.apache.bifromq.mqtt.handler.record.ProtocolResponse;
import org.apache.bifromq.mqtt.inbox.util.DelivererKeyUtil;
import org.apache.bifromq.mqtt.service.ILocalDistService;
import org.apache.bifromq.mqtt.session.IMQTTTransientSession;
import org.apache.bifromq.mqtt.utils.AuthUtil;
import org.apache.bifromq.plugin.authprovider.type.CheckResult;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.OutOfTenantResource;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ByClient;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.DropReason;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS1Dropped;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.pushhandling.QoS2Dropped;
import org.apache.bifromq.plugin.eventcollector.session.MQTTSessionStart;
import org.apache.bifromq.plugin.eventcollector.session.MQTTSessionStop;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.retain.rpc.proto.MatchReply;
import org.apache.bifromq.retain.rpc.proto.MatchRequest;
import org.apache.bifromq.sysprops.props.DataPlaneMaxBurstLatencyMillis;
import org.apache.bifromq.sysprops.props.MaxActiveDedupChannels;
import org.apache.bifromq.sysprops.props.MaxActiveDedupTopicsPerChannel;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.InboxState;
import org.apache.bifromq.type.LastWillInfo;
import org.apache.bifromq.type.MatchInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.TopicFilterOption;
import org.apache.bifromq.type.TopicMessagePack;
import org.apache.bifromq.util.TopicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MQTTTransientSessionHandler
extends MQTTSessionHandler
implements IMQTTTransientSession {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTTTransientSessionHandler.class);
    private final Map<String, TopicFilterOption> topicFilters = new ConcurrentHashMap<String, TopicFilterOption>();
    private final NavigableMap<Long, RoutedMessage> inbox = new TreeMap<Long, RoutedMessage>();
    private final DedupCache dedupCache = new DedupCache(2L * (Long)DataPlaneMaxBurstLatencyMillis.INSTANCE.get(), ((Integer)MaxActiveDedupChannels.INSTANCE.get()).intValue(), ((Integer)MaxActiveDedupTopicsPerChannel.INSTANCE.get()).intValue());
    private long nextSendSeq = 0L;
    private long msgSeqNo = 0L;
    private AtomicLong subNumGauge;

    protected MQTTTransientSessionHandler(TenantSettings settings, ITenantMeter tenantMeter, Condition oomCondition, String userSessionId, int keepAliveTimeSeconds, ClientInfo clientInfo, LWT willMessage, ChannelHandlerContext ctx) {
        super(settings, tenantMeter, oomCondition, userSessionId, keepAliveTimeSeconds, clientInfo, willMessage, ctx);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.subNumGauge = this.sessionCtx.getTransientSubNumGauge(this.clientInfo.getTenantId());
        this.onInitialized();
        this.resumeChannelRead();
        this.eventCollector.report((Event)((MQTTSessionStart)ThreadLocalEventPool.getLocal(MQTTSessionStart.class)).sessionId(this.userSessionId).clientInfo(this.clientInfo));
    }

    @Override
    public void doTearDown(ChannelHandlerContext ctx) {
        if (!this.topicFilters.isEmpty()) {
            this.topicFilters.forEach((topicFilter, option) -> this.addBgTask(this.unsubTopicFilter(System.nanoTime(), (String)topicFilter)));
        }
        for (RoutedMessage msg : this.inbox.values()) {
            this.memUsage.addAndGet(-msg.estBytes());
            if (msg.qos() == QoS.AT_LEAST_ONCE) {
                this.eventCollector.report((Event)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)ThreadLocalEventPool.getLocal(QoS1Dropped.class)).reason(DropReason.SessionClosed).reqId(msg.message().getMessageId())).isRetain(msg.isRetain())).sender(msg.publisher())).topic(msg.topic())).matchedFilter(msg.topicFilter())).size(msg.message().getPayload().size())).clientInfo(this.clientInfo()));
                continue;
            }
            if (msg.qos() != QoS.EXACTLY_ONCE) continue;
            this.eventCollector.report((Event)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)ThreadLocalEventPool.getLocal(QoS2Dropped.class)).reason(DropReason.SessionClosed).reqId(msg.message().getMessageId())).isRetain(msg.isRetain())).sender(msg.publisher())).topic(msg.topic())).matchedFilter(msg.topicFilter())).size(msg.message().getPayload().size())).clientInfo(this.clientInfo()));
        }
        this.eventCollector.report((Event)((MQTTSessionStop)ThreadLocalEventPool.getLocal(MQTTSessionStop.class)).sessionId(this.userSessionId).clientInfo(this.clientInfo));
    }

    @Override
    protected ProtocolResponse handleDisconnect(MqttMessage message) {
        Optional<Integer> requestSEI = this.helper().sessionExpiryIntervalOnDisconnect(message);
        if (requestSEI.isPresent() && requestSEI.get() > 0) {
            return this.helper().respondDisconnectProtocolError();
        }
        if (this.helper().isNormalDisconnect(message)) {
            this.discardLWT();
        }
        return ProtocolResponse.goAwayNow(new Event[]{((ByClient)ThreadLocalEventPool.getLocal(ByClient.class)).clientInfo(this.clientInfo)});
    }

    @Override
    protected final void onConfirm(long seq) {
        NavigableMap<Long, RoutedMessage> confirmed = this.inbox.headMap(seq, true);
        for (RoutedMessage msg : confirmed.values()) {
            this.memUsage.addAndGet(-msg.estBytes());
        }
        confirmed.clear();
        this.send(false);
    }

    @Override
    protected final CompletableFuture<IMQTTProtocolHelper.SubResult> subTopicFilter(long reqId, String topicFilter, TopicFilterOption option) {
        if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalTransientSubscriptions)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalTransientSubscriptions.name()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.EXCEED_LIMIT);
        }
        if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalTransientSubscribePerSecond)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalTransientSubscribePerSecond.name()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.EXCEED_LIMIT);
        }
        this.tenantMeter.recordCount(TenantMetric.MqttTransientSubCount);
        int maxTopicFiltersPerInbox = this.settings.maxTopicFiltersPerInbox;
        if (this.topicFilters.size() >= maxTopicFiltersPerInbox) {
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.EXCEED_LIMIT);
        }
        TopicFilterOption prevOption = this.topicFilters.put(topicFilter, option);
        if (prevOption == null) {
            this.subNumGauge.addAndGet(1L);
            this.memUsage.addAndGet(topicFilter.length());
            this.memUsage.addAndGet(option.getSerializedSize());
        }
        Timer.Sample start = Timer.start();
        return this.addMatchRecord(reqId, topicFilter, option.getIncarnation()).thenApplyAsync(matchResult -> {
            switch (matchResult) {
                case OK: {
                    start.stop(this.tenantMeter.timer(TenantMetric.MqttTransientSubLatency));
                    if (prevOption == null) {
                        return IMQTTProtocolHelper.SubResult.OK;
                    }
                    return IMQTTProtocolHelper.SubResult.EXISTS;
                }
                case EXCEED_LIMIT: {
                    return IMQTTProtocolHelper.SubResult.EXCEED_LIMIT;
                }
                case BACK_PRESSURE_REJECTED: {
                    return IMQTTProtocolHelper.SubResult.BACK_PRESSURE_REJECTED;
                }
                case TRY_LATER: {
                    return IMQTTProtocolHelper.SubResult.TRY_LATER;
                }
            }
            return IMQTTProtocolHelper.SubResult.ERROR;
        }, (Executor)this.ctx.executor());
    }

    @Override
    protected CompletableFuture<MatchReply> matchRetainedMessage(long reqId, String topicFilter, TopicFilterOption option) {
        String tenantId = this.clientInfo().getTenantId();
        return this.sessionCtx.retainClient.match(MatchRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setMatchInfo(MatchInfo.newBuilder().setMatcher(TopicUtil.from((String)topicFilter)).setReceiverId(ILocalDistService.globalize(this.channelId())).setIncarnation(option.getIncarnation()).build()).setDelivererKey(DelivererKeyUtil.toDelivererKey((String)tenantId, (String)ILocalDistService.globalize(this.channelId()), (String)this.sessionCtx.serverId)).setBrokerId(0).setLimit(this.settings.retainMatchLimit).build());
    }

    @Override
    protected CompletableFuture<IMQTTProtocolHelper.UnsubResult> unsubTopicFilter(long reqId, String topicFilter) {
        if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalTransientUnsubscribePerSecond)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalTransientUnsubscribePerSecond.name()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.UnsubResult.ERROR);
        }
        this.tenantMeter.recordCount(TenantMetric.MqttTransientUnsubCount);
        Timer.Sample start = Timer.start();
        TopicFilterOption option = this.topicFilters.remove(topicFilter);
        if (option == null) {
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.UnsubResult.NO_SUB);
        }
        this.subNumGauge.addAndGet(-1L);
        this.memUsage.addAndGet(-topicFilter.length());
        this.memUsage.addAndGet(-option.getSerializedSize());
        return this.removeMatchRecord(reqId, topicFilter, option.getIncarnation()).handleAsync((result, e) -> {
            if (e != null) {
                return IMQTTProtocolHelper.UnsubResult.ERROR;
            }
            switch (result) {
                case OK: {
                    start.stop(this.tenantMeter.timer(TenantMetric.MqttTransientUnsubLatency));
                    return IMQTTProtocolHelper.UnsubResult.OK;
                }
                case BACK_PRESSURE_REJECTED: {
                    return IMQTTProtocolHelper.UnsubResult.BACK_PRESSURE_REJECTED;
                }
                case TRY_LATER: {
                    return IMQTTProtocolHelper.UnsubResult.TRY_LATER;
                }
            }
            return IMQTTProtocolHelper.UnsubResult.ERROR;
        }, (Executor)this.ctx.executor());
    }

    @Override
    public boolean hasSubscribed(String topicFilter) {
        return this.topicFilters.containsKey(topicFilter);
    }

    @Override
    public Set<IMQTTTransientSession.MatchedTopicFilter> publish(TopicMessagePack messagePack, Set<IMQTTTransientSession.MatchedTopicFilter> matchedTopicFilters) {
        if (!this.ctx.channel().isActive()) {
            return matchedTopicFilters;
        }
        HashMap<IMQTTTransientSession.MatchedTopicFilter, TopicFilterOption> validTopicFilters = new HashMap<IMQTTTransientSession.MatchedTopicFilter, TopicFilterOption>();
        for (IMQTTTransientSession.MatchedTopicFilter topicFilter : matchedTopicFilters) {
            TopicFilterOption option = this.topicFilters.get(topicFilter.topicFilter());
            if (option == null) continue;
            validTopicFilters.put(topicFilter, option);
            if (option.getIncarnation() <= topicFilter.incarnation()) continue;
            log.debug("Receive message from previous route: topicFilter={}, inc={}, prevInc={}", new Object[]{topicFilter, option.getIncarnation(), topicFilter.incarnation()});
        }
        this.ctx.executor().execute(() -> this.publish(validTopicFilters, messagePack));
        return Sets.difference(matchedTopicFilters, validTopicFilters.keySet());
    }

    @Override
    public InboxState inboxState() {
        InboxState.Builder stateBuilder = InboxState.newBuilder().setCreatedAt(this.createdAt).setLastActiveAt(HLC.INST.getPhysical()).setLimit(this.settings.inboxQueueLength).setExpirySeconds(0).putAllTopicFilters(this.topicFilters).setUndeliveredMsgCount((long)this.inbox.size());
        LWT lwt = this.willMessage();
        if (lwt != null) {
            stateBuilder.setWill(LastWillInfo.newBuilder().setTopic(lwt.getTopic()).setQos(lwt.getMessage().getPubQoS()).setIsRetain(lwt.getMessage().getIsRetain()).setDelaySeconds(lwt.getDelaySeconds()).build());
        }
        return stateBuilder.build();
    }

    private void publish(Map<IMQTTTransientSession.MatchedTopicFilter, TopicFilterOption> matchedTopicFilters, TopicMessagePack topicMsgPack) {
        CompletableFuture[] checkPermissionFutures = new CompletableFuture[matchedTopicFilters.size()];
        ArrayList<TopicFilterAndPermission> topicFilterAndPermissions = new ArrayList<TopicFilterAndPermission>(matchedTopicFilters.size());
        int i = 0;
        for (Map.Entry<IMQTTTransientSession.MatchedTopicFilter, TopicFilterOption> entry : matchedTopicFilters.entrySet()) {
            IMQTTTransientSession.MatchedTopicFilter mtf = entry.getKey();
            TopicFilterOption opt = entry.getValue();
            CompletableFuture<CheckResult> f = this.addFgTask(this.authProvider.checkPermission(this.clientInfo(), AuthUtil.buildSubAction(mtf.topicFilter(), opt.getQos())));
            checkPermissionFutures[i++] = f;
            topicFilterAndPermissions.add(new TopicFilterAndPermission(mtf.topicFilter(), opt, f));
        }
        CompletableFuture.allOf(checkPermissionFutures).thenAccept(v -> {
            for (TopicMessagePack.PublisherPack publisherPack : topicMsgPack.getMessageList()) {
                this.publish(topicMsgPack.getTopic(), publisherPack.getPublisher(), publisherPack.getMessageList(), topicFilterAndPermissions);
            }
        });
    }

    private void publish(String topic, ClientInfo publisher, List<Message> messages, List<TopicFilterAndPermission> topicFilterAndPermissions) {
        AtomicInteger totalMsgBytesSize = new AtomicInteger();
        long now = HLC.INST.get();
        boolean flush = false;
        for (Message message : messages) {
            for (TopicFilterAndPermission tfp : topicFilterAndPermissions) {
                RoutedMessage subMsg = new RoutedMessage(topic, message, publisher, tfp.topicFilter, tfp.option, now, tfp.permissionCheckFuture.join().hasGranted(), this.isDuplicateMessage(topic, publisher, message, this.dedupCache));
                this.logInternalLatency(subMsg);
                if (subMsg.qos() == QoS.AT_MOST_ONCE) {
                    this.sendQoS0SubMessage(subMsg);
                    flush = true;
                    continue;
                }
                if (this.inbox.size() < this.settings.inboxQueueLength) {
                    this.inbox.put(this.msgSeqNo++, subMsg);
                    totalMsgBytesSize.addAndGet(subMsg.estBytes());
                    continue;
                }
                switch (subMsg.qos()) {
                    case AT_LEAST_ONCE: {
                        this.eventCollector.report((Event)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)((QoS1Dropped)ThreadLocalEventPool.getLocal(QoS1Dropped.class)).reason(DropReason.Overflow).reqId(subMsg.message().getMessageId())).isRetain(subMsg.isRetain())).sender(subMsg.publisher())).topic(subMsg.topic())).matchedFilter(subMsg.topicFilter())).size(subMsg.message().getPayload().size())).clientInfo(this.clientInfo()));
                        break;
                    }
                    case EXACTLY_ONCE: {
                        this.eventCollector.report((Event)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)((QoS2Dropped)ThreadLocalEventPool.getLocal(QoS2Dropped.class)).reason(DropReason.Overflow).reqId(subMsg.message().getMessageId())).isRetain(subMsg.isRetain())).sender(subMsg.publisher())).topic(subMsg.topic())).matchedFilter(subMsg.topicFilter())).size(subMsg.message().getPayload().size())).clientInfo(this.clientInfo()));
                        break;
                    }
                }
            }
        }
        this.memUsage.addAndGet(totalMsgBytesSize.get());
        this.send(flush);
    }

    private void send(boolean flushNeeded) {
        SortedMap<Long, RoutedMessage> toBeSent = this.inbox.tailMap(this.nextSendSeq);
        if (toBeSent.isEmpty()) {
            if (flushNeeded) {
                this.flush(true);
            }
            return;
        }
        Iterator<Map.Entry<Long, RoutedMessage>> itr = toBeSent.entrySet().iterator();
        while (this.clientReceiveQuota() > 0 && itr.hasNext()) {
            Map.Entry<Long, RoutedMessage> entry = itr.next();
            long seq = entry.getKey();
            RoutedMessage msg = entry.getValue();
            this.sendConfirmableSubMessage(seq, msg);
            this.nextSendSeq = seq + 1L;
        }
        this.flush(true);
    }

    private void logInternalLatency(RoutedMessage message) {
        Timer timer = switch (message.qos()) {
            case QoS.AT_MOST_ONCE -> this.tenantMeter.timer(TenantMetric.MqttQoS0InternalLatency);
            case QoS.AT_LEAST_ONCE -> this.tenantMeter.timer(TenantMetric.MqttQoS1InternalLatency);
            default -> this.tenantMeter.timer(TenantMetric.MqttQoS2InternalLatency);
        };
        timer.record(HLC.INST.getPhysical(message.hlc() - message.message().getTimestamp()), TimeUnit.MILLISECONDS);
    }

    private CompletableFuture<MatchResult> addMatchRecord(long reqId, String topicFilter, long incarnation) {
        return this.sessionCtx.localDistService.match(reqId, topicFilter, incarnation, this);
    }

    private CompletableFuture<UnmatchResult> removeMatchRecord(long reqId, String topicFilter, long incarnation) {
        return this.sessionCtx.localDistService.unmatch(reqId, topicFilter, incarnation, this);
    }

    private record TopicFilterAndPermission(String topicFilter, TopicFilterOption option, CompletableFuture<CheckResult> permissionCheckFuture) {
    }
}

