# 为什么使用图进行关联运算比表Join更具吸引力？

## 关系模型并不适合处理关系

关系模型被广泛应用于数据库和数仓等数据处理系统的数据建模，**然而名称里带有关系一词的模型却并不适合处理关系**。

在关系模型所用的表结构建模下，关系的运算通过Join运算来处理。但在实际使用中，特别是在流式更新的数据中，这种方式存在诸多痛点。

### 痛点一：关系运算成本高

表模型的重点在于多条记录统一描述为表，但本身缺乏关系描述能力，**只能通过Join运算来完成关系的计算**。

无论是在批或流的计算系统中，Join操作都涉及大量shuffle和计算开销。同时，Join产生的中间结果由于关联会放大多份，造成数据量指数级膨胀和冗余，存储消耗大。

在下图的实验中，我们模拟了依次执行一跳、两跳和三跳关系运算的场景。足以见得，越是复杂的多跳关系计算，关系模型中Join的性能表现越差。在总时间对比中，利用图的Match计算能够节约超过90%的耗时。
![total_time](../../../static/img/vs_join_total_time_cn.jpg)
<center>图1</center>

### 痛点二：数据冗余，时效性低

在很多数仓分析的场景中，为了提高数据查询性能，往往将多张表提前物化成一张大宽表。

大宽表虽然可以加速查询性能，然而其数据膨胀和冗余非常严重。由于表与表之间一对多的关联关系，导致一张表的数据通过关联会放大多份，造成数据量指数级膨胀和冗余。

而且宽表一经生成就难以更改，否则需要重新生成新宽表，费时费力，不够灵活。

此时利用图模型建模，可以轻易解决这个问题。 图是对关系的一种天然描述，以点代表实体，以边代表关系。

比如在人际关系图里面，每一个人可以用一个点来表示，人和人之间的关系通过边来表示，人与人之间可以存在各种各样的复杂关系，这些关系都可以通过不同的边来表示。

显然，**构造图的过程本质上是对事物之间关系的提炼，在数据存储层面实质是对关系做了物化，以获取更好的关联计算性能**。

相比宽表的关系物化方式，由于图结构本身的点边聚合性，构图表现得十分节约。 下图是GeaFlow中高性能构图的表现，可见构图操作本身极为迅速，且由于图可以分片的特性，具有十分良好的可扩展性。

![insert_throuput](../../../static/img/console/insert_throuput_cn.jpg)
<center>图2</center>

在图一的实验中也可以发现，实质上我们用少量的插入图(青色的insert to graph部分开销)耗时，换取了图建模方式对之后关联查询的加速效果。


### 痛点三：复杂关系查询难以描述

使用表建模的分析系统只支持SQL join一种方式进行关系分析，这在复杂场景中能力十分局限。 比如查询一个人4度以内所有好友，或者查询最短路径等，这些复杂关联关系通过SQL表的join方式很难描述。

GeaFlow提供融合GQL和SQL样式的查询语言，这是一种图表一体的数据分析语言，继承自标准SQL+ISO/GQL，可以方便进行图表分析。

![code_style](../../../static/img/code_style.jpg)
<center>图3</center>

**在融合DSL中，图计算的结果与表查询等价，都可以像表数据一样做关系运算处理。**这意味着图3中GQL和SQL两种描述都可以达到类似的效果，极大灵活了用户的查询表达能力。

GeaFlow DSL引擎层还将支持SQL中的Join自动转化为GQL执行，用户可以自由混用SQL和GQL样式查询，同时做图匹配、图算法和表查询。

## 流图计算引擎GeaFlow

GeaFlow是蚂蚁集团开源的分布式流式图计算引擎。在蚂蚁内部，目前已广泛应用于数仓加速、金融风控、知识图谱以及社交网络等大量场景。

GeaFlow已经于2023年6月正式对外开源，开放其以图为数据模型的流批一体计算核心能力。相比传统的流式计算引擎，如Flink、Storm这些以表为模型的实时处理系统，GeaFlow以自研图存储为底座，流批一体计算引擎为矛，融合GQL/SQL DSL语言为旗帜，在复杂多度的关系运算上具备极大的优势。


![insert_throuput](../../../static/img/query_throuput_cn.jpg)
<center>图4</center>

图4展示了GeaFlow使用Match算子在图上进行多跳关联查询，相比Flink的Join算子带来的实时吞吐提升。在复杂多跳场景下，现有的流式计算引擎已经基本不能胜任实时处理。而图模型的存在，则突破这一限制，扩展了实时流计算的应用场景。