/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.vector;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apdplat.word.analysis.CosineTextSimilarity;
import org.apdplat.word.analysis.EditDistanceTextSimilarity;
import org.apdplat.word.analysis.EuclideanDistanceTextSimilarity;
import org.apdplat.word.analysis.JaccardTextSimilarity;
import org.apdplat.word.analysis.JaroDistanceTextSimilarity;
import org.apdplat.word.analysis.JaroWinklerDistanceTextSimilarity;
import org.apdplat.word.analysis.ManhattanDistanceTextSimilarity;
import org.apdplat.word.analysis.SimHashPlusHammingDistanceTextSimilarity;
import org.apdplat.word.analysis.SimpleTextSimilarity;
import org.apdplat.word.analysis.S\u00f8rensenDiceCoefficientTextSimilarity;
import org.apdplat.word.analysis.TextSimilarity;
import org.apdplat.word.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Distance {
    private static final Logger LOGGER = LoggerFactory.getLogger(Distance.class);
    private TextSimilarity textSimilarity = null;
    private Map<String, String> model = null;
    private int limit = 15;

    public Distance(TextSimilarity textSimilarity, String string) throws Exception {
        this.textSimilarity = textSimilarity;
        this.model = this.parseModel(string);
    }

    public void setTextSimilarity(TextSimilarity textSimilarity) {
        LOGGER.info("\u8bbe\u7f6e\u76f8\u4f3c\u5ea6\u7b97\u6cd5\u4e3a\uff1a" + textSimilarity.getClass().getName());
        this.textSimilarity = textSimilarity;
    }

    public void setLimit(int n) {
        LOGGER.info("\u8bbe\u7f6e\u663e\u793a\u7ed3\u679c\u6761\u6570\u4e3a\uff1a" + n);
        this.limit = n;
    }

    private Map<String, String> parseModel(String string) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        LOGGER.info("\u5f00\u59cb\u521d\u59cb\u5316\u6a21\u578b");
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "utf-8"));){
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split(" : ");
                if (stringArray == null || stringArray.length != 2) {
                    LOGGER.error("\u9519\u8bef\u6570\u636e\uff1a" + string2);
                    continue;
                }
                String string3 = stringArray[0];
                String string4 = stringArray[1];
                string4 = string4.substring(1, string4.length() - 1);
                hashMap.put(string3, string4);
            }
        }
        LOGGER.info("\u6a21\u578b\u521d\u59cb\u5316\u5b8c\u6210");
        return hashMap;
    }

    private void tip() {
        LOGGER.info("\u53ef\u901a\u8fc7\u8f93\u5165\u547d\u4ee4sa=cos\u6765\u6307\u5b9a\u76f8\u4f3c\u5ea6\u7b97\u6cd5\uff0c\u53ef\u7528\u7684\u7b97\u6cd5\u6709\uff1a");
        LOGGER.info("   1\u3001sa=cos\uff0c\u4f59\u5f26\u76f8\u4f3c\u5ea6");
        LOGGER.info("   2\u3001sa=edi\uff0c\u7f16\u8f91\u8ddd\u79bb");
        LOGGER.info("   3\u3001sa=euc\uff0c\u6b27\u51e0\u91cc\u5f97\u8ddd\u79bb");
        LOGGER.info("   4\u3001sa=sim\uff0c\u7b80\u5355\u5171\u6709\u8bcd");
        LOGGER.info("   5\u3001sa=jac\uff0cJaccard\u76f8\u4f3c\u6027\u7cfb\u6570");
        LOGGER.info("   6\u3001sa=man\uff0c\u66fc\u54c8\u987f\u8ddd\u79bb");
        LOGGER.info("   7\u3001sa=shh\uff0cSimHash + \u6c49\u660e\u8ddd\u79bb");
        LOGGER.info("   8\u3001sa=ja\uff0cJaro\u8ddd\u79bb");
        LOGGER.info("   9\u3001sa=jaw\uff0cJaro\u2013Winkler\u8ddd\u79bb");
        LOGGER.info("   10\u3001sa=sd\uff0cS\u00f8rensen\u2013Dice\u7cfb\u6570");
        LOGGER.info("\u53ef\u901a\u8fc7\u8f93\u5165\u547d\u4ee4limit=15\u6765\u6307\u5b9a\u663e\u793a\u7ed3\u679c\u6761\u6570");
        LOGGER.info("\u53ef\u901a\u8fc7\u8f93\u5165\u547d\u4ee4exit\u9000\u51fa\u7a0b\u5e8f");
        LOGGER.info("\u8f93\u5165\u8981\u67e5\u8be2\u7684\u8bcd\u6216\u547d\u4ee4\uff1a");
    }

    private void interact(String string) throws Exception {
        this.tip();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, string));){
            String string2 = null;
            block35: while ((string2 = bufferedReader.readLine()) != null) {
                if ("exit".equals(string2)) {
                    System.exit(0);
                }
                if (string2.startsWith("limit=")) {
                    try {
                        this.setLimit(Integer.parseInt(string2.replace("limit=", "").trim()));
                    }
                    catch (Exception exception) {
                        LOGGER.error("\u6307\u4ee4\u4e0d\u6b63\u786e\uff0c\u6570\u5b57\u975e\u6cd5");
                    }
                    continue;
                }
                if (string2.startsWith("sa=")) {
                    switch (string2.substring(3)) {
                        case "cos": {
                            this.setTextSimilarity(new CosineTextSimilarity());
                            continue block35;
                        }
                        case "edi": {
                            this.setTextSimilarity(new EditDistanceTextSimilarity());
                            continue block35;
                        }
                        case "euc": {
                            this.setTextSimilarity(new EuclideanDistanceTextSimilarity());
                            continue block35;
                        }
                        case "sim": {
                            this.setTextSimilarity(new SimpleTextSimilarity());
                            continue block35;
                        }
                        case "jac": {
                            this.setTextSimilarity(new JaccardTextSimilarity());
                            continue block35;
                        }
                        case "man": {
                            this.setTextSimilarity(new ManhattanDistanceTextSimilarity());
                            continue block35;
                        }
                        case "shh": {
                            this.setTextSimilarity(new SimHashPlusHammingDistanceTextSimilarity());
                            continue block35;
                        }
                        case "ja": {
                            this.setTextSimilarity(new JaroDistanceTextSimilarity());
                            continue block35;
                        }
                        case "jaw": {
                            this.setTextSimilarity(new JaroWinklerDistanceTextSimilarity());
                            continue block35;
                        }
                        case "sd": {
                            this.setTextSimilarity(new S\u00f8rensenDiceCoefficientTextSimilarity());
                            continue block35;
                        }
                    }
                    continue;
                }
                String string3 = this.model.get(string2);
                if (string3 == null) {
                    LOGGER.info("\u6ca1\u6709\u5bf9\u5e94\u7684\u8bcd\uff1a" + string2);
                } else {
                    LOGGER.info("\u8ba1\u7b97\u8bcd\u5411\u91cf\uff1a" + string3);
                    LOGGER.info("\u663e\u793a\u7ed3\u679c\u6570\u76ee\uff1a" + this.limit);
                    LOGGER.info(string2 + " \u7684\u76f8\u5173\u8bcd\uff08" + this.textSimilarity.getClass().getSimpleName() + "\uff09\uff1a");
                    LOGGER.info("----------------------------------------------------------");
                    long l = System.currentTimeMillis();
                    List<String> list = this.compute(string3, this.limit);
                    long l2 = System.currentTimeMillis() - l;
                    AtomicInteger atomicInteger = new AtomicInteger();
                    for (String string4 : list) {
                        LOGGER.info("\t" + atomicInteger.incrementAndGet() + "\u3001" + string4);
                    }
                    LOGGER.info("----------------------------------------------------------");
                    LOGGER.info("\u8017\u65f6\uff1a" + Utils.getTimeDes(l2));
                    LOGGER.info("----------------------------------------------------------");
                }
                this.tip();
            }
        }
    }

    public List<String> compute(String string, int n) {
        Object object;
        String[] stringArray;
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        String[] stringArray2 = string.split(", ");
        for (String string2 : stringArray2) {
            stringArray = string2.split(" ");
            object = stringArray[0];
            float f = Float.parseFloat(stringArray[1]);
            hashMap.put((String)object, Float.valueOf(f));
        }
        HashMap hashMap2 = new HashMap();
        Object object2 = this.model.keySet().iterator();
        while (object2.hasNext()) {
            double d;
            String string2;
            String string3 = object2.next();
            string2 = this.model.get(string3);
            stringArray = string2.split(", ");
            object = new HashMap();
            for (String string4 : stringArray) {
                String[] stringArray3 = string4.split(" ");
                String string5 = stringArray3[0];
                float f = Float.parseFloat(stringArray3[1]);
                object.put(string5, Float.valueOf(f));
            }
            if (object.size() < 10 || !((d = this.textSimilarity.similarScore(hashMap, (Map<String, Float>)object)) > 0.0)) continue;
            hashMap2.put(string3, d);
        }
        if (hashMap2.isEmpty()) {
            LOGGER.info("\u6ca1\u6709\u76f8\u4f3c\u8bcd");
            return Collections.emptyList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u76f8\u4f3c\u8bcd\u6570\uff1a" + hashMap2.size());
        }
        if (n > (object2 = hashMap2.entrySet().parallelStream().sorted((entry, entry2) -> ((Double)entry2.getValue()).compareTo((Double)entry.getValue())).collect(Collectors.toList())).size()) {
            n = object2.size();
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add((String)((Map.Entry)object2.get(i)).getKey() + " " + ((Map.Entry)object2.get(i)).getValue());
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "data/vector.txt";
        String string2 = "gbk";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        if (stringArray.length == 2) {
            string = stringArray[0];
            string2 = stringArray[1];
        }
        Distance distance = new Distance(new EditDistanceTextSimilarity(), string);
        distance.interact(string2);
    }
}

