/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.service.PendingRangeCalculatorServiceDiagnostics;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ExecutorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingRangeCalculatorService {
    public static final PendingRangeCalculatorService instance = new PendingRangeCalculatorService();
    private static Logger logger = LoggerFactory.getLogger(PendingRangeCalculatorService.class);
    private final JMXEnabledThreadPoolExecutor executor = new JMXEnabledThreadPoolExecutor(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new NamedThreadFactory("PendingRangeCalculator"), "internal");
    private AtomicInteger updateJobs = new AtomicInteger(0);

    public PendingRangeCalculatorService() {
        this.executor.setRejectedExecutionHandler((r, e) -> {
            PendingRangeCalculatorServiceDiagnostics.taskRejected(instance, this.updateJobs);
            instance.finishUpdate();
        });
    }

    private void finishUpdate() {
        int jobs = this.updateJobs.decrementAndGet();
        PendingRangeCalculatorServiceDiagnostics.taskCountChanged(instance, jobs);
    }

    public void update() {
        int jobs = this.updateJobs.incrementAndGet();
        PendingRangeCalculatorServiceDiagnostics.taskCountChanged(instance, jobs);
        this.executor.execute(new PendingRangeTask(this.updateJobs));
    }

    public void blockUntilFinished() {
        while (this.updateJobs.get() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void calculatePendingRanges(AbstractReplicationStrategy strategy, String keyspaceName) {
        StorageService.instance.getTokenMetadata().calculatePendingRanges(strategy, keyspaceName);
    }

    @VisibleForTesting
    public void shutdownAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownNowAndWait(timeout, unit, this.executor);
    }

    private static class PendingRangeTask
    implements Runnable {
        private final AtomicInteger updateJobs;

        PendingRangeTask(AtomicInteger updateJobs) {
            this.updateJobs = updateJobs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PendingRangeCalculatorServiceDiagnostics.taskStarted(instance, this.updateJobs);
                long start = System.currentTimeMillis();
                List<String> keyspaces = Schema.instance.getNonLocalStrategyKeyspaces();
                for (String keyspaceName : keyspaces) {
                    PendingRangeCalculatorService.calculatePendingRanges(Keyspace.open(keyspaceName).getReplicationStrategy(), keyspaceName);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Finished PendingRangeTask for {} keyspaces in {}ms", (Object)keyspaces.size(), (Object)(System.currentTimeMillis() - start));
                }
                PendingRangeCalculatorServiceDiagnostics.taskFinished(instance, this.updateJobs);
            }
            finally {
                instance.finishUpdate();
            }
        }
    }
}

