/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.fury.Fury;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.resolver.RefResolver;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.util.Preconditions;

public class JdkProxySerializer
extends Serializer {
    private static final Field FIELD = ReflectionUtils.getField(Proxy.class, InvocationHandler.class);
    private static final long PROXY_HANDLER_FIELD_OFFSET = Platform.objectFieldOffset(FIELD);
    private static final InvocationHandler STUB_HANDLER = (proxy, method, args) -> {
        throw new IllegalStateException("Deserialization stub handler still active");
    };

    public JdkProxySerializer(Fury fury, Class cls) {
        super(fury, cls);
        if (cls != ReplaceStub.class) {
            Preconditions.checkArgument(ReflectionUtils.isJdkProxy(cls), "Require a jdk proxy class");
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
        this.fury.writeRef(buffer, value.getClass().getInterfaces());
        this.fury.writeRef(buffer, Proxy.getInvocationHandler(value));
    }

    public Object copy(Object value) {
        Class<?>[] interfaces = value.getClass().getInterfaces();
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(value);
        Preconditions.checkNotNull(interfaces);
        Preconditions.checkNotNull(invocationHandler);
        Object proxy = Proxy.newProxyInstance(this.fury.getClassLoader(), interfaces, STUB_HANDLER);
        if (this.needToCopyRef) {
            this.fury.reference(value, proxy);
        }
        Platform.putObject(proxy, PROXY_HANDLER_FIELD_OFFSET, this.fury.copyObject(invocationHandler));
        return proxy;
    }

    public Object read(MemoryBuffer buffer) {
        RefResolver resolver = this.fury.getRefResolver();
        int refId = resolver.lastPreservedRefId();
        Class[] interfaces = (Class[])this.fury.readRef(buffer);
        Preconditions.checkNotNull(interfaces);
        Object proxy = Proxy.newProxyInstance(this.fury.getClassLoader(), interfaces, STUB_HANDLER);
        resolver.setReadObject(refId, proxy);
        InvocationHandler invocationHandler = (InvocationHandler)this.fury.readRef(buffer);
        Preconditions.checkNotNull(invocationHandler);
        Platform.putObject(proxy, PROXY_HANDLER_FIELD_OFFSET, invocationHandler);
        return proxy;
    }

    public static class ReplaceStub {
    }
}

