/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import com.google.common.base.CharMatcher;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.UUID;
import org.apache.hugegraph.exception.HugeException;
import org.apache.hugegraph.serializer.BytesBuffer;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.LZ4Util;
import org.mindrot.jbcrypt.BCrypt;

public final class StringEncoding {
    private static final MessageDigest DIGEST;
    private static final byte[] BYTES_EMPTY;
    private static final int BLOCK_SIZE = 4096;
    private static final Base64.Encoder BASE64_ENCODER;
    private static final Base64.Decoder BASE64_DECODER;

    public static int writeAsciiString(byte[] array, int offset, String value) {
        E.checkArgument((boolean)CharMatcher.ascii().matchesAllOf((CharSequence)value), (String)"'%s' must be ASCII string", (Object[])new Object[]{value});
        int len = value.length();
        if (len == 0) {
            array[offset++] = -128;
            return offset;
        }
        int i = 0;
        do {
            char c = value.charAt(i);
            assert (c <= '\u007f');
            byte b = (byte)c;
            if (++i == len) {
                b = (byte)(b | 0x80);
            }
            array[offset++] = b;
        } while (i < len);
        return offset;
    }

    public static String readAsciiString(byte[] array, int offset) {
        StringBuilder sb = new StringBuilder();
        int c = 0;
        do {
            if ((c = 0xFF & array[offset++]) == 128) continue;
            sb.append((char)(c & 0x7F));
        } while ((c & 0x80) <= 0);
        return sb.toString();
    }

    public static int getAsciiByteLength(String value) {
        E.checkArgument((boolean)CharMatcher.ascii().matchesAllOf((CharSequence)value), (String)"'%s' must be ASCII string", (Object[])new Object[]{value});
        return value.isEmpty() ? 1 : value.length();
    }

    public static byte[] encode(String value) {
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HugeException("Failed to encode string", e);
        }
    }

    public static String decode(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HugeException("Failed to decode string", e);
        }
    }

    public static String decode(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HugeException("Failed to decode string", e);
        }
    }

    public static String encodeBase64(byte[] bytes) {
        return BASE64_ENCODER.encodeToString(bytes);
    }

    public static byte[] decodeBase64(String value) {
        if (value.isEmpty()) {
            return BYTES_EMPTY;
        }
        return BASE64_DECODER.decode(value);
    }

    public static byte[] compress(String value) {
        return StringEncoding.compress(value, 1.5f);
    }

    public static byte[] compress(String value, float bufferRatio) {
        BytesBuffer buf = LZ4Util.compress(StringEncoding.encode(value), 4096, bufferRatio);
        return buf.bytes();
    }

    public static String decompress(byte[] value) {
        return StringEncoding.decompress(value, 1.5f);
    }

    public static String decompress(byte[] value, float bufferRatio) {
        BytesBuffer buf = LZ4Util.decompress(value, 4096, bufferRatio);
        return StringEncoding.decode(buf.array(), 0, buf.position());
    }

    public static String hashPassword(String password) {
        return BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)4));
    }

    public static boolean checkPassword(String candidatePassword, String dbPassword) {
        return BCrypt.checkpw((String)candidatePassword, (String)dbPassword);
    }

    public static String sha256(String string) {
        byte[] stringBytes = StringEncoding.encode(string);
        DIGEST.reset();
        return StringEncoding.encodeBase64(DIGEST.digest(stringBytes));
    }

    public static String format(byte[] bytes) {
        return String.format("%s[0x%s]", StringEncoding.decode(bytes), Bytes.toHex((byte[])bytes));
    }

    public static UUID uuid(String value) {
        E.checkArgument((value != null ? 1 : 0) != 0, (String)"The UUID can't be null", (Object[])new Object[0]);
        try {
            if (value.contains("-") && value.length() == 36) {
                return UUID.fromString(value);
            }
            E.checkArgument((value.length() == 32 ? 1 : 0) != 0, (String)"Invalid UUID string: %s", (Object[])new Object[]{value});
            String high = value.substring(0, 16);
            String low = value.substring(16);
            return new UUID(Long.parseUnsignedLong(high, 16), Long.parseUnsignedLong(low, 16));
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("Invalid UUID string: " + value);
        }
    }

    static {
        BYTES_EMPTY = new byte[0];
        String ALG = "SHA-256";
        try {
            DIGEST = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HugeException("Failed to load algorithm %s", (Throwable)e, "SHA-256");
        }
        BASE64_ENCODER = Base64.getEncoder();
        BASE64_DECODER = Base64.getDecoder();
    }
}

