/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.meta.Partition;
import org.apache.hugegraph.store.node.metrics.StoreMetrics;

/*
 * Exception performing whole class analysis ignored.
 */
public final class StoreMetrics {
    public static final String PREFIX = "hg";
    private static final HgStoreEngine storeEngine = HgStoreEngine.getInstance();
    private static final AtomicInteger graphs = new AtomicInteger(0);
    private static MeterRegistry registry;

    private StoreMetrics() {
    }

    public static synchronized void init(MeterRegistry meterRegistry) {
        if (registry == null) {
            registry = meterRegistry;
            StoreMetrics.registerMeters();
        }
    }

    private static void registerMeters() {
        Gauge.builder((String)"hg.up", () -> 1).register(registry);
        Gauge.builder((String)"hg.graphs", StoreMetrics::updateGraphs).description("Number of graphs stored in this node").register(registry);
    }

    private static int getGraphs() {
        return StoreMetrics.getGraphPartitions().size();
    }

    private static int updateGraphs() {
        int buf = StoreMetrics.getGraphs();
        if (buf != graphs.get()) {
            graphs.set(buf);
            StoreMetrics.registerPartitionGauge();
        }
        return buf;
    }

    private static void registerPartitionGauge() {
        Map map = StoreMetrics.getGraphPartitions();
        map.forEach((k, v) -> Gauge.builder((String)"hg.partitions", (Supplier)new PartitionsGetter(k)).description("Number of partitions stored in the node").tag("graph", k).register(registry));
    }

    private static int getPartitions(String graph) {
        Map map = (Map)StoreMetrics.getGraphPartitions().get(graph);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    private static Map<String, Map<Integer, Partition>> getGraphPartitions() {
        Map map = storeEngine.getPartitionManager().getPartitions();
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }
}

