/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.analyzer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.splitWord.analysis.BaseAnalysis;
import org.ansj.splitWord.analysis.IndexAnalysis;
import org.ansj.splitWord.analysis.NlpAnalysis;
import org.ansj.splitWord.analysis.ToAnalysis;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.util.InsertionOrderUtil;

public class AnsjAnalyzer
implements Analyzer {
    public static final List<String> SUPPORT_MODES = ImmutableList.of((Object)"BaseAnalysis", (Object)"IndexAnalysis", (Object)"ToAnalysis", (Object)"NlpAnalysis");
    private final String analysis;

    public AnsjAnalyzer(String mode) {
        if (!SUPPORT_MODES.contains(mode)) {
            throw new ConfigException("Unsupported segment mode '%s' for ansj analyzer, the available values are %s", new Object[]{mode, SUPPORT_MODES});
        }
        this.analysis = mode;
    }

    @Override
    public Set<String> segment(String text) {
        Result terms;
        switch (this.analysis) {
            case "BaseAnalysis": {
                terms = BaseAnalysis.parse((String)text);
                break;
            }
            case "ToAnalysis": {
                terms = ToAnalysis.parse((String)text);
                break;
            }
            case "NlpAnalysis": {
                terms = NlpAnalysis.parse((String)text);
                break;
            }
            case "IndexAnalysis": {
                terms = IndexAnalysis.parse((String)text);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported segment mode '%s'", this.analysis));
            }
        }
        assert (terms != null);
        Set result = InsertionOrderUtil.newSet();
        for (Term term : terms) {
            result.add(term.getName());
        }
        return result;
    }
}

