/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.config;

import org.apache.hugegraph.config.ConfigConvOption;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;
import org.apache.hugegraph.type.define.CollectionType;

public class CoreOptions
extends OptionHolder {
    public static final int CPUS = Runtime.getRuntime().availableProcessors();
    public static final ConfigOption<Integer> EDGE_TX_CAPACITY = new ConfigOption("edge.tx_capacity", "The max size(items) of edges(uncommitted) in transaction.", OptionChecker.rangeInt((Number)500, (Number)1000000), (Object)10000);
    public static final ConfigOption<String> GREMLIN_GRAPH = new ConfigOption("gremlin.graph", "Gremlin entrance to create graph.", OptionChecker.disallowEmpty(), (Object)"org.apache.hugegraph.HugeFactory");
    public static final ConfigOption<String> BACKEND = new ConfigOption("backend", "The data store type.", OptionChecker.disallowEmpty(), (Object)"memory");
    public static final ConfigOption<Boolean> QUERY_TRUST_INDEX = new ConfigOption("query.trust_index", "Whether to Trust Index.", OptionChecker.disallowEmpty(), (Object)false);
    public static final ConfigOption<String> STORE = new ConfigOption("store", "The database name like Cassandra Keyspace.", OptionChecker.disallowEmpty(), (Object)"hugegraph");
    public static final ConfigOption<String> STORE_GRAPH = new ConfigOption("store.graph", "The graph table name, which store vertex, edge and property.", OptionChecker.disallowEmpty(), (Object)"g");
    public static final ConfigOption<String> SERIALIZER = new ConfigOption("serializer", "The serializer for backend store, like: text/binary/cassandra.", OptionChecker.disallowEmpty(), (Object)"text");
    public static final ConfigOption<Boolean> RAFT_MODE = new ConfigOption("raft.mode", "Whether the backend storage works in raft mode.", OptionChecker.disallowEmpty(), (Object)false);
    public static final ConfigOption<Boolean> RAFT_SAFE_READ = new ConfigOption("raft.safe_read", "Whether to use linearly consistent read.", OptionChecker.disallowEmpty(), (Object)false);
    public static final ConfigOption<String> RAFT_PATH = new ConfigOption("raft.path", "The log path of current raft node.", OptionChecker.disallowEmpty(), (Object)"./raftlog");
    public static final ConfigOption<Boolean> RAFT_REPLICATOR_PIPELINE = new ConfigOption("raft.use_replicator_pipeline", "Whether to use replicator line, when turned on it multiple logs can be sent in parallel, and the next log doesn't have to wait for the ack message of the current log to be sent.", OptionChecker.disallowEmpty(), (Object)true);
    public static final ConfigOption<Integer> RAFT_ELECTION_TIMEOUT = new ConfigOption("raft.election_timeout", "Timeout in milliseconds to launch a round of election.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)10000);
    public static final ConfigOption<Integer> RAFT_SNAPSHOT_INTERVAL = new ConfigOption("raft.snapshot_interval", "The interval in seconds to trigger snapshot save.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)3600);
    public static final ConfigOption<Integer> RAFT_SNAPSHOT_THREADS = new ConfigOption("raft.snapshot_threads", "The thread number used to do snapshot.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)4);
    public static final ConfigOption<Boolean> RAFT_SNAPSHOT_PARALLEL_COMPRESS = new ConfigOption("raft.snapshot_parallel_compress", "Whether to enable parallel compress.", OptionChecker.disallowEmpty(), (Object)false);
    public static final ConfigOption<Integer> RAFT_SNAPSHOT_COMPRESS_THREADS = new ConfigOption("raft.snapshot_compress_threads", "The thread number used to do snapshot compress.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)4);
    public static final ConfigOption<Integer> RAFT_SNAPSHOT_DECOMPRESS_THREADS = new ConfigOption("raft.snapshot_decompress_threads", "The thread number used to do snapshot decompress.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)4);
    public static final ConfigOption<Integer> RAFT_BACKEND_THREADS = new ConfigOption("raft.backend_threads", "The thread number used to apply task to backend.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)CPUS);
    public static final ConfigOption<Integer> RAFT_READ_INDEX_THREADS = new ConfigOption("raft.read_index_threads", "The thread number used to execute reading index.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)8);
    public static final ConfigOption<String> RAFT_READ_STRATEGY = new ConfigOption("raft.read_strategy", "The linearizability of read strategy.", OptionChecker.allowValues((Object[])new String[]{"ReadOnlyLeaseBased", "ReadOnlySafe"}), (Object)"ReadOnlyLeaseBased");
    public static final ConfigOption<Integer> RAFT_APPLY_BATCH = new ConfigOption("raft.apply_batch", "The apply batch size to trigger disruptor event handler.", OptionChecker.positiveInt(), (Object)1);
    public static final ConfigOption<Integer> RAFT_QUEUE_SIZE = new ConfigOption("raft.queue_size", "The disruptor buffers size for jraft RaftNode, StateMachine and LogManager.", OptionChecker.positiveInt(), (Object)16384);
    public static final ConfigOption<Integer> RAFT_QUEUE_PUBLISH_TIMEOUT = new ConfigOption("raft.queue_publish_timeout", "The timeout in second when publish event into disruptor.", OptionChecker.positiveInt(), (Object)60);
    public static final ConfigOption<Integer> RAFT_RPC_THREADS = new ConfigOption("raft.rpc_threads", "The rpc threads for jraft RPC layer", OptionChecker.positiveInt(), (Object)Math.max(CPUS * 2, 80));
    public static final ConfigOption<Integer> RAFT_RPC_CONNECT_TIMEOUT = new ConfigOption("raft.rpc_connect_timeout", "The rpc connect timeout for jraft rpc.", OptionChecker.positiveInt(), (Object)5000);
    public static final ConfigOption<Integer> RAFT_RPC_TIMEOUT = new ConfigOption("raft.rpc_timeout", "The general rpc timeout in seconds for jraft rpc.", OptionChecker.positiveInt(), (Object)60);
    public static final ConfigOption<Integer> RAFT_INSTALL_SNAPSHOT_TIMEOUT = new ConfigOption("raft.install_snapshot_rpc_timeout", "The install snapshot rpc timeout in seconds for jraft rpc.", OptionChecker.positiveInt(), (Object)36000);
    public static final ConfigOption<Integer> RAFT_RPC_BUF_LOW_WATER_MARK = new ConfigOption("raft.rpc_buf_low_water_mark", "The ChannelOutboundBuffer's low water mark of netty, when buffer size less than this size, the method ChannelOutboundBuffer.isWritable() will return true, it means that low downstream pressure or good network.", OptionChecker.positiveInt(), (Object)0xA00000);
    public static final ConfigOption<Integer> RAFT_RPC_BUF_HIGH_WATER_MARK = new ConfigOption("raft.rpc_buf_high_water_mark", "The ChannelOutboundBuffer's high water mark of netty, only when buffer size exceed this size, the method ChannelOutboundBuffer.isWritable() will return false, it means that the downstream pressure is too great to process the request or network is very congestion, upstream needs to limit rate at this time.", OptionChecker.positiveInt(), (Object)0x1400000);
    public static final ConfigOption<Integer> RATE_LIMIT_WRITE = new ConfigOption("rate_limit.write", "The max rate(items/s) to add/update/delete vertices/edges.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)0);
    public static final ConfigOption<Integer> RATE_LIMIT_READ = new ConfigOption("rate_limit.read", "The max rate(times/s) to execute query of vertices/edges.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)0);
    public static final ConfigOption<Long> TASK_SCHEDULE_PERIOD = new ConfigOption("task.schedule_period", "Period time when scheduler to schedule task", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)10L);
    public static final ConfigOption<Long> TASK_WAIT_TIMEOUT = new ConfigOption("task.wait_timeout", "Timeout in seconds for waiting for the task to complete, such as when truncating or clearing the backend.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)10L);
    public static final ConfigOption<Long> TASK_INPUT_SIZE_LIMIT = new ConfigOption("task.input_size_limit", "The job input size limit in bytes.", OptionChecker.rangeInt((Number)0L, (Number)0x40000000L), (Object)0x1000000L);
    public static final ConfigOption<Long> TASK_RESULT_SIZE_LIMIT = new ConfigOption("task.result_size_limit", "The job result size limit in bytes.", OptionChecker.rangeInt((Number)0L, (Number)0x40000000L), (Object)0x1000000L);
    public static final ConfigOption<Integer> TASK_TTL_DELETE_BATCH = new ConfigOption("task.ttl_delete_batch", "The batch size used to delete expired data.", OptionChecker.rangeInt((Number)1, (Number)500), (Object)1);
    public static final ConfigOption<String> SCHEDULER_TYPE = new ConfigOption("task.scheduler_type", "The type of scheduler used in distribution system.", OptionChecker.allowValues((Object[])new String[]{"local", "distributed"}), (Object)"local");
    public static final ConfigOption<Boolean> TASK_SYNC_DELETION = new ConfigOption("task.sync_deletion", "Whether to delete schema or expired data synchronously.", OptionChecker.disallowEmpty(), (Object)false);
    public static final ConfigOption<Integer> TASK_RETRY = new ConfigOption("task.retry", "Task retry times.", OptionChecker.rangeInt((Number)0, (Number)3), (Object)0);
    public static final ConfigOption<Long> STORE_CONN_DETECT_INTERVAL = new ConfigOption("store.connection_detect_interval", "The interval in seconds for detecting connections, if the idle time of a connection exceeds this value, detect it and reconnect if needed before using, value 0 means detecting every time.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)600L);
    public static final ConfigOption<String> VERTEX_DEFAULT_LABEL = new ConfigOption("vertex.default_label", "The default vertex label.", OptionChecker.disallowEmpty(), (Object)"vertex");
    public static final ConfigOption<Boolean> VERTEX_CHECK_CUSTOMIZED_ID_EXIST = new ConfigOption("vertex.check_customized_id_exist", "Whether to check the vertices exist for those using customized id strategy.", OptionChecker.disallowEmpty(), (Object)false);
    public static final ConfigOption<Boolean> VERTEX_REMOVE_LEFT_INDEX = new ConfigOption("vertex.remove_left_index_at_overwrite", "Whether remove left index at overwrite.", OptionChecker.disallowEmpty(), (Object)false);
    public static final ConfigOption<Boolean> VERTEX_ADJACENT_VERTEX_EXIST = new ConfigOption("vertex.check_adjacent_vertex_exist", "Whether to check the adjacent vertices of edges exist.", OptionChecker.disallowEmpty(), (Object)false);
    public static final ConfigOption<Boolean> VERTEX_ADJACENT_VERTEX_LAZY = new ConfigOption("vertex.lazy_load_adjacent_vertex", "Whether to lazy load adjacent vertices of edges.", OptionChecker.disallowEmpty(), (Object)true);
    public static final ConfigOption<Integer> VERTEX_PART_EDGE_COMMIT_SIZE = new ConfigOption("vertex.part_edge_commit_size", "Whether to enable the mode to commit part of edges of vertex, enabled if commit size > 0, 0 meas disabled.", OptionChecker.rangeInt((Number)0, (Number)800000), (Object)5000);
    public static final ConfigOption<Boolean> VERTEX_ENCODE_PK_NUMBER = new ConfigOption("vertex.encode_primary_key_number", "Whether to encode number value of primary key in vertex id.", OptionChecker.disallowEmpty(), (Object)true);
    public static final ConfigOption<Integer> VERTEX_TX_CAPACITY = new ConfigOption("vertex.tx_capacity", "The max size(items) of vertices(uncommitted) in transaction.", OptionChecker.rangeInt((Number)500, (Number)1000000), (Object)10000);
    public static final ConfigOption<Integer> OLTP_CONCURRENT_THREADS = new ConfigOption("oltp.concurrent_threads", "Thread number to concurrently execute oltp algorithm.", OptionChecker.rangeInt((Number)1, (Number)Math.max(10, CPUS * 2)), (Object)Math.max(10, CPUS / 2));
    public static final ConfigOption<Integer> OLTP_CONCURRENT_DEPTH = new ConfigOption("oltp.concurrent_depth", "The min depth to enable concurrent oltp algorithm.", OptionChecker.rangeInt((Number)0, (Number)65535), (Object)10);
    public static final ConfigConvOption<String, CollectionType> OLTP_COLLECTION_TYPE = new ConfigConvOption("oltp.collection_type", "The implementation type of collections used in oltp algorithm.", OptionChecker.allowValues((Object[])new String[]{"JCF", "EC", "FU"}), CollectionType::valueOf, (Object)"EC");
    public static final ConfigOption<Integer> OLTP_QUERY_BATCH_SIZE = new ConfigOption("oltp.query_batch_size", "The size of each batch when executing oltp algorithm.", OptionChecker.rangeInt((Number)0, (Number)65535), (Object)10000);
    public static final ConfigOption<Double> OLTP_QUERY_BATCH_AVG_DEGREE_RATIO = new ConfigOption("oltp.query_batch_avg_degree_ratio", "The ratio of exponential approximation for average degree of iterator when executing oltp algorithm.", OptionChecker.rangeDouble((Number)0.0, (Number)1.0), (Object)0.95);
    public static final ConfigOption<Long> OLTP_QUERY_BATCH_EXPECT_DEGREE = new ConfigOption("oltp.query_batch_expect_degree", "The expect sum of degree in each batch when executing oltp algorithm.", OptionChecker.rangeInt((Number)10000L, (Number)1000000000L), (Object)100000000L);
    public static final ConfigOption<Boolean> QUERY_IGNORE_INVALID_DATA = new ConfigOption("query.ignore_invalid_data", "Whether to ignore invalid data of vertex or edge.", OptionChecker.disallowEmpty(), (Object)true);
    public static final ConfigOption<Boolean> QUERY_OPTIMIZE_AGGR_BY_INDEX = new ConfigOption("query.optimize_aggregate_by_index", "Whether to optimize aggregate query(like count) by index.", OptionChecker.disallowEmpty(), (Object)false);
    public static final ConfigOption<Integer> QUERY_BATCH_SIZE = new ConfigOption("query.batch_size", "The size of each batch when querying by batch.", OptionChecker.rangeInt((Number)1, (Number)800000), (Object)1000);
    public static final ConfigOption<Integer> QUERY_PAGE_SIZE = new ConfigOption("query.page_size", "The size of each page when querying by paging.", OptionChecker.rangeInt((Number)1, (Number)800000), (Object)500);
    public static final ConfigOption<Integer> QUERY_INDEX_INTERSECT_THRESHOLD = new ConfigOption("query.index_intersect_threshold", "The maximum number of intermediate results to intersect indexes when querying by multiple single index properties.", OptionChecker.rangeInt((Number)1, (Number)800000), (Object)1000);
    public static final ConfigOption<Boolean> QUERY_RAMTABLE_ENABLE = new ConfigOption("query.ramtable_enable", "Whether to enable ramtable for query of adjacent edges.", OptionChecker.disallowEmpty(), (Object)false);
    public static final ConfigOption<Long> QUERY_RAMTABLE_VERTICES_CAPACITY = new ConfigOption("query.ramtable_vertices_capacity", "The maximum number of vertices in ramtable, generally the largest vertex id is used as capacity.", OptionChecker.rangeInt((Number)1L, (Number)0xFFFFFFFEL), (Object)10000000L);
    public static final ConfigOption<Integer> QUERY_RAMTABLE_EDGES_CAPACITY = new ConfigOption("query.ramtable_edges_capacity", "The maximum number of edges in ramtable, include OUT and IN edges.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)20000000);
    public static final ConfigOption<String> SCHEMA_ILLEGAL_NAME_REGEX = new ConfigOption("schema.illegal_name_regex", "The regex specified the illegal format for schema name.", OptionChecker.disallowEmpty(), (Object)".*\\s+$|~.*");
    public static final ConfigOption<Long> SCHEMA_CACHE_CAPACITY = new ConfigOption("schema.cache_capacity", "The max cache size(items) of schema cache.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)10000L);
    public static final ConfigOption<Boolean> SCHEMA_INDEX_REBUILD_USING_PUSHDOWN = new ConfigOption("schema.index_rebuild_using_pushdown", "Whether to use pushdown when to create/rebuid index.", (Object)true);
    public static final ConfigOption<String> VERTEX_CACHE_TYPE = new ConfigOption("vertex.cache_type", "The type of vertex cache, allowed values are [l1, l2].", OptionChecker.allowValues((Object[])new String[]{"l1", "l2"}), (Object)"l2");
    public static final ConfigOption<Long> VERTEX_CACHE_CAPACITY = new ConfigOption("vertex.cache_capacity", "The max cache size(items) of vertex cache.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)10000000L);
    public static final ConfigOption<Integer> VERTEX_CACHE_EXPIRE = new ConfigOption("vertex.cache_expire", "The expiration time in seconds of vertex cache.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)600);
    public static final ConfigOption<String> EDGE_CACHE_TYPE = new ConfigOption("edge.cache_type", "The type of edge cache, allowed values are [l1, l2].", OptionChecker.allowValues((Object[])new String[]{"l1", "l2"}), (Object)"l2");
    public static final ConfigOption<Long> EDGE_CACHE_CAPACITY = new ConfigOption("edge.cache_capacity", "The max cache size(items) of edge cache.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)1000000L);
    public static final ConfigOption<Integer> EDGE_CACHE_EXPIRE = new ConfigOption("edge.cache_expire", "The expiration time in seconds of edge cache.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)600);
    public static final ConfigOption<Long> SNOWFLAKE_WORKER_ID = new ConfigOption("snowflake.worker_id", "The worker id of snowflake id generator.", OptionChecker.disallowEmpty(), (Object)0L);
    public static final ConfigOption<Long> SNOWFLAKE_DATACENTER_ID = new ConfigOption("snowflake.datacenter_id", "The datacenter id of snowflake id generator.", OptionChecker.disallowEmpty(), (Object)0L);
    public static final ConfigOption<Boolean> SNOWFLAKE_FORCE_STRING = new ConfigOption("snowflake.force_string", "Whether to force the snowflake long id to be a string.", OptionChecker.disallowEmpty(), (Object)false);
    public static final ConfigOption<String> TEXT_ANALYZER = new ConfigOption("search.text_analyzer", "Choose a text analyzer for searching the vertex/edge properties, available type are [ansj, hanlp, smartcn, jieba, jcseg, mmseg4j, ikanalyzer].", OptionChecker.disallowEmpty(), (Object)"ikanalyzer");
    public static final ConfigOption<String> TEXT_ANALYZER_MODE = new ConfigOption("search.text_analyzer_mode", "Specify the mode for the text analyzer, the available mode of analyzer are ansj: [BaseAnalysis, IndexAnalysis, ToAnalysis, NlpAnalysis], hanlp: [standard, nlp, index, nShort, shortest, speed], smartcn: [], jieba: [SEARCH, INDEX], jcseg: [Simple, Complex], mmseg4j: [Simple, Complex, MaxWord], ikanalyzer: [smart, max_word]}.", OptionChecker.disallowEmpty(), (Object)"smart");
    public static final ConfigOption<String> COMPUTER_CONFIG = new ConfigOption("computer.config", "The config file path of computer job.", OptionChecker.disallowEmpty(), (Object)"./conf/computer.yaml");
    public static final ConfigOption<String> K8S_OPERATOR_TEMPLATE = new ConfigOption("k8s.operator_template", "the path of operator container template.", OptionChecker.disallowEmpty(), (Object)"./conf/operator-template.yaml");
    public static final ConfigOption<String> K8S_QUOTA_TEMPLATE = new ConfigOption("k8s.quota_template", "the path of resource quota template.", OptionChecker.disallowEmpty(), (Object)"./conf/resource-quota-template.yaml");
    public static final ConfigOption<String> PD_PEERS = new ConfigOption("pd.peers", "The addresses of pd nodes, separated with commas.", OptionChecker.disallowEmpty(), (Object)"127.0.0.1:8686");
    public static final ConfigOption<String> MEMORY_MODE = new ConfigOption("memory.mode", "The memory mode used for query in HugeGraph.", OptionChecker.disallowEmpty(), (Object)"off-heap");
    public static final ConfigOption<Long> MAX_MEMORY_CAPACITY = new ConfigOption("memory.max_capacity", "The maximum memory capacity that can be managed for all queries in HugeGraph.", OptionChecker.nonNegativeInt(), (Object)0x40000000L);
    public static final ConfigOption<Long> ONE_QUERY_MAX_MEMORY_CAPACITY = new ConfigOption("memory.one_query_max_capacity", "The maximum memory capacity that can be managed for a query in HugeGraph.", OptionChecker.nonNegativeInt(), (Object)0x6400000L);
    public static final ConfigOption<Long> MEMORY_ALIGNMENT = new ConfigOption("memory.alignment", "The alignment used for round memory size.", OptionChecker.nonNegativeInt(), (Object)8L);
    public static final ConfigOption<String> GRAPH_SPACE = new ConfigOption("graphspace", "The graph space name.", null, (Object)"DEFAULT");
    public static final ConfigOption<String> ALIAS_NAME = new ConfigOption("alias.graph.id", "The graph alias id.", (Object)"");
    public static final ConfigOption<String> GRAPH_READ_MODE = new ConfigOption("graph.read_mode", "The graph read mode, which could be ALL | OLTP_ONLY | OLAP_ONLY.", OptionChecker.disallowEmpty(), (Object)"OLTP_ONLY");
    public static final ConfigOption<String> SCHEMA_INIT_TEMPLATE = new ConfigOption("schema.init_template", "The template schema used to init graph", null, (Object)"");
    public static final ConfigOption<Integer> QUERY_MAX_INDEXES_AVAILABLE = new ConfigOption("query.max_indexes_available", "The upper limit of the number of indexes that can be used to query", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)1);
    public static final ConfigOption<String> QUERY_DEDUP_OPTION = new ConfigOption("query.dedup_option", "The way to dedup data", OptionChecker.allowValues((Object[])new String[]{"limit", "global"}), (Object)"limit");
    private static volatile CoreOptions instance;

    private CoreOptions() {
    }

    public static synchronized CoreOptions instance() {
        if (instance == null) {
            instance = new CoreOptions();
            instance.registerOptions();
        }
        return instance;
    }
}

