/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.pool;

import java.util.HashSet;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hugegraph.memory.MemoryManager;
import org.apache.hugegraph.memory.consumer.OffHeapObject;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.apache.hugegraph.memory.pool.impl.MemoryPoolStats;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMemoryPool
implements MemoryPool {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMemoryPool.class);
    protected final Queue<MemoryPool> children = new PriorityQueue<MemoryPool>((o1, o2) -> (int)(o2.getFreeBytes() - o1.getFreeBytes()));
    protected final MemoryManager memoryManager;
    protected final ReentrantLock memoryActionLock = new ReentrantLock();
    protected final Condition condition = this.memoryActionLock.newCondition();
    protected final AtomicBoolean isBeingArbitrated = new AtomicBoolean(false);
    protected final MemoryPoolStats stats;
    protected boolean isClosed = false;
    private MemoryPool parent;

    public AbstractMemoryPool(MemoryPool parent, String memoryPoolName, MemoryPoolStats.MemoryPoolType type, MemoryManager memoryManager) {
        this.parent = parent;
        this.stats = new MemoryPoolStats(memoryPoolName, type);
        this.memoryManager = memoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long tryToReclaimLocalMemoryWithoutLock(long neededBytes, MemoryPool requestingPool) {
        long totalReclaimedBytes = 0L;
        try {
            long l = totalReclaimedBytes = this.reclaimChildren(neededBytes, requestingPool);
            return l;
        }
        finally {
            if (totalReclaimedBytes > 0L) {
                this.stats.setNumShrinks(this.stats.getNumShrinks() + 1L);
            }
            this.stats.setAllocatedBytes(this.stats.getAllocatedBytes() - totalReclaimedBytes);
            this.isBeingArbitrated.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long tryToReclaimLocalMemory(long neededBytes, MemoryPool requestingPool) {
        this.memoryActionLock.lock();
        long totalReclaimedBytes = 0L;
        try {
            long l = totalReclaimedBytes = this.reclaimChildren(neededBytes, requestingPool);
            return l;
        }
        finally {
            if (totalReclaimedBytes > 0L) {
                this.stats.setNumShrinks(this.stats.getNumShrinks() + 1L);
            }
            this.stats.setAllocatedBytes(this.stats.getAllocatedBytes() - totalReclaimedBytes);
            this.isBeingArbitrated.set(false);
            this.condition.signalAll();
            this.memoryActionLock.unlock();
        }
    }

    private long reclaimChildren(long neededBytes, MemoryPool requestingPool) {
        LOG.debug("[{}] tryToReclaimLocalMemory: neededBytes={}", (Object)this, (Object)neededBytes);
        this.isBeingArbitrated.set(true);
        long totalReclaimedBytes = 0L;
        long currentNeededBytes = neededBytes;
        for (MemoryPool child : this.children) {
            long reclaimedMemory;
            if (child.equals(requestingPool) || (reclaimedMemory = child.tryToReclaimLocalMemory(currentNeededBytes, requestingPool)) <= 0L) continue;
            totalReclaimedBytes += reclaimedMemory;
            if ((currentNeededBytes -= reclaimedMemory) > 0L) continue;
            break;
        }
        LOG.info("[{}] has finished to reclaim memory: totalReclaimedBytes={}, neededBytes={}, snapshot-[{}]", new Object[]{this, totalReclaimedBytes, neededBytes, this.getSnapShot()});
        return totalReclaimedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSelf(String reason, boolean isTriggeredByOOM) {
        try {
            if (!isTriggeredByOOM) {
                this.memoryActionLock.lock();
                if (this.isBeingArbitrated.get()) {
                    this.condition.await();
                }
            }
            LOG.debug("[{}] starts to releaseSelf", (Object)this);
            this.isClosed = true;
            Optional.ofNullable(this.parent).ifPresent(parent -> parent.gcChildPool(this, false, isTriggeredByOOM));
            HashSet<MemoryPool> copiedChildren = new HashSet<MemoryPool>(this.children);
            for (MemoryPool child : copiedChildren) {
                this.gcChildPool(child, true, isTriggeredByOOM);
            }
            copiedChildren.clear();
            LOG.info("[{}] finishes to releaseSelf because of {}", (Object)this, (Object)reason);
        }
        catch (InterruptedException e) {
            LOG.error("Failed to release self because ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            if (!isTriggeredByOOM) {
                this.memoryActionLock.unlock();
            }
            this.parent = null;
            this.children.clear();
        }
    }

    @Override
    public void gcChildPool(MemoryPool child, boolean force, boolean isTriggeredInternal) {
        if (force) {
            child.releaseSelf(String.format("[%s] releaseChildPool", this), isTriggeredInternal);
            return;
        }
        this.stats.setAllocatedBytes(this.stats.getAllocatedBytes() - child.getAllocatedBytes());
        this.stats.setUsedBytes(this.stats.getUsedBytes() - child.getUsedBytes());
        this.children.remove(child);
    }

    @Override
    public Object tryToAcquireMemoryInternal(long bytes) {
        if (this.isClosed) {
            LOG.warn("[{}] is already closed, will abort this allocate", (Object)this);
            return 0;
        }
        this.stats.setUsedBytes(this.stats.getUsedBytes() + bytes);
        this.stats.setCumulativeBytes(this.stats.getCumulativeBytes() + bytes);
        return null;
    }

    @Override
    public void bindMemoryConsumer(OffHeapObject offHeapObject) {
    }

    @Override
    public Object requireMemory(long bytes, MemoryPool requestingPool) {
        return null;
    }

    @Override
    public long getMaxCapacityBytes() {
        return Optional.of(this.stats).map(MemoryPoolStats::getMaxCapacity).orElse(0L);
    }

    @Override
    public long getUsedBytes() {
        return Optional.of(this.stats).map(MemoryPoolStats::getUsedBytes).orElse(0L);
    }

    @Override
    public long getFreeBytes() {
        return Optional.of(this.stats).map(stats -> stats.getAllocatedBytes() - stats.getUsedBytes()).orElse(0L);
    }

    @Override
    public long getAllocatedBytes() {
        return Optional.of(this.stats).map(MemoryPoolStats::getAllocatedBytes).orElse(0L);
    }

    @Override
    public MemoryPoolStats getSnapShot() {
        return this.stats;
    }

    @Override
    public MemoryPool getParentPool() {
        return this.parent;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.stats.getMemoryPoolName();
    }

    @Override
    public MemoryPool findRootQueryPool() {
        if (this.parent == null) {
            return this;
        }
        return this.getParentPool().findRootQueryPool();
    }

    @Override
    public void setMaxCapacityBytes(long maxCapacityBytes) {
        this.stats.setMaxCapacity(maxCapacityBytes);
    }

    @Override
    @TestOnly
    public int getChildrenCount() {
        return this.children.size();
    }
}

