/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.schema.builder;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.tx.ISchemaTransaction;
import org.apache.hugegraph.exception.ExistedException;
import org.apache.hugegraph.exception.NotAllowException;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.Userdata;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.schema.builder.AbstractBuilder;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Action;
import org.apache.hugegraph.type.define.EdgeLabelType;
import org.apache.hugegraph.type.define.Frequency;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;

public class EdgeLabelBuilder
extends AbstractBuilder
implements EdgeLabel.Builder {
    private Id id;
    private String name;
    private Set<Pair<String, String>> links;
    private EdgeLabelType edgeLabelType;
    private String fatherLabel;
    private String sourceLabel;
    private String targetLabel;
    private Frequency frequency;
    private Set<String> properties;
    private List<String> sortKeys;
    private Set<String> nullableKeys;
    private long ttl;
    private String ttlStartTime;
    private Boolean enableLabelIndex;
    private Userdata userdata;
    private boolean checkExist;

    public EdgeLabelBuilder(ISchemaTransaction transaction, HugeGraph graph, String name) {
        super(transaction, graph);
        E.checkNotNull((Object)name, (String)"name");
        this.id = null;
        this.name = name;
        this.links = new HashSet<Pair<String, String>>();
        this.edgeLabelType = EdgeLabelType.NORMAL;
        this.fatherLabel = null;
        this.frequency = Frequency.DEFAULT;
        this.properties = new HashSet<String>();
        this.sortKeys = new ArrayList<String>();
        this.nullableKeys = new HashSet<String>();
        this.ttl = 0L;
        this.ttlStartTime = null;
        this.enableLabelIndex = null;
        this.userdata = new Userdata();
        this.checkExist = true;
    }

    public EdgeLabelBuilder(ISchemaTransaction transaction, HugeGraph graph, EdgeLabel copy) {
        super(transaction, graph);
        E.checkNotNull((Object)copy, (String)"copy");
        HugeGraph origin = copy.graph();
        this.id = null;
        this.name = copy.name();
        this.links = EdgeLabelBuilder.mapPairId2Name(origin, copy.links());
        this.edgeLabelType = copy.edgeLabelType();
        if (copy.edgeLabelType().sub()) {
            this.fatherLabel = EdgeLabelBuilder.mapElId2Name(origin, copy.fatherId());
        }
        this.frequency = copy.frequency();
        this.properties = EdgeLabelBuilder.mapPkId2Name(origin, copy.properties());
        this.sortKeys = EdgeLabelBuilder.mapPkId2Name(origin, copy.sortKeys());
        this.nullableKeys = EdgeLabelBuilder.mapPkId2Name(origin, copy.nullableKeys());
        this.ttl = copy.ttl();
        this.ttlStartTime = copy.ttlStartTimeName();
        this.enableLabelIndex = copy.enableLabelIndex();
        this.userdata = new Userdata(copy.userdata());
        this.checkExist = false;
    }

    @Override
    public EdgeLabel build() {
        PropertyKey propertyKey;
        Id id = this.validOrGenerateId(HugeType.EDGE_LABEL, this.id, this.name);
        HugeGraph graph = this.graph();
        EdgeLabel edgeLabel = new EdgeLabel(graph, id, this.name);
        for (Pair<String, String> link : this.links) {
            edgeLabel.links((Pair<Id, Id>)Pair.of((Object)graph.vertexLabel((String)link.getLeft()).id(), (Object)graph.vertexLabel((String)link.getRight()).id()));
        }
        edgeLabel.frequency(this.frequency == Frequency.DEFAULT ? Frequency.SINGLE : this.frequency);
        edgeLabel.ttl(this.ttl);
        if (this.ttlStartTime != null) {
            edgeLabel.ttlStartTime(this.graph().propertyKey(this.ttlStartTime).id());
        }
        edgeLabel.enableLabelIndex(this.enableLabelIndex == null || this.enableLabelIndex != false);
        for (String key : this.properties) {
            propertyKey = graph.propertyKey(key);
            edgeLabel.property(propertyKey.id());
        }
        for (String key : this.sortKeys) {
            propertyKey = graph.propertyKey(key);
            edgeLabel.sortKey(propertyKey.id());
        }
        for (String key : this.nullableKeys) {
            propertyKey = graph.propertyKey(key);
            edgeLabel.nullableKey(propertyKey.id());
        }
        edgeLabel.userdata(this.userdata);
        if (this.edgeLabelType.sub()) {
            edgeLabel.edgeLabelType(EdgeLabelType.SUB);
            EdgeLabel fatherEl = graph.edgeLabel(this.fatherLabel);
            edgeLabel.fatherId(fatherEl.id());
            this.registerInfoToFatherEl(fatherEl, edgeLabel);
        } else {
            edgeLabel.edgeLabelType(this.edgeLabelType);
        }
        return edgeLabel;
    }

    private void registerInfoToFatherEl(EdgeLabel fatherEl, EdgeLabel subEl) {
        HugeGraph graph = this.graph();
        for (Pair<String, String> link : this.links) {
            fatherEl.links((Pair<Id, Id>)Pair.of((Object)this.graph().vertexLabel((String)link.getLeft()).id(), (Object)graph.vertexLabel((String)link.getRight()).id()));
        }
        List<Id> fatherSortKeys = fatherEl.sortKeys();
        List<Id> subSortKeys = subEl.sortKeys();
        if (fatherSortKeys == null || fatherSortKeys.size() == 0) {
            for (Id sortKey : subSortKeys) {
                fatherEl.sortKeys(sortKey);
            }
        } else {
            E.checkArgument((fatherSortKeys.size() == subSortKeys.size() ? 1 : 0) != 0, (String)"The sortKeys of each sub edgelabel need to be consistent. Currently, the sortKeys of already exist edgelabel are '%s', and the sortKeys of newly added sub edgelabel are '%s'", (Object[])new Object[]{fatherSortKeys, subSortKeys});
            for (int i = 0; i < fatherSortKeys.size(); ++i) {
                E.checkArgument((boolean)fatherSortKeys.get(i).equals(subSortKeys.get(i)), (String)"The sortKeys of each sub edgelabel need to be consistent. Currently, the sortKeys of already exist edgelabel are '%s', and the sortKeys of newly added sub edgelabel are '%s'", (Object[])new Object[]{fatherSortKeys, subSortKeys});
            }
        }
        this.graph().updateEdgeLabel(fatherEl);
    }

    @Override
    public EdgeLabel create() {
        HugeType type = HugeType.EDGE_LABEL;
        this.checkSchemaName(this.name);
        return this.lockCheckAndCreateSchema(type, this.name, name -> {
            EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
            if (edgeLabel != null) {
                if (this.checkExist || !this.hasSameProperties(edgeLabel)) {
                    throw new ExistedException(type, (Object)this.name);
                }
                return edgeLabel;
            }
            this.checkSchemaIdIfRestoringMode(type, this.id);
            this.checkRelation();
            this.checkProperties(Action.INSERT);
            this.checkSortKeys();
            this.checkNullableKeys(Action.INSERT);
            Userdata.check(this.userdata, Action.INSERT);
            this.checkTtl();
            this.checkUserdata(Action.INSERT);
            edgeLabel = this.build();
            assert (edgeLabel.name().equals(name));
            this.graph().addEdgeLabel(edgeLabel);
            return edgeLabel;
        });
    }

    private boolean hasSameProperties(EdgeLabel existedEdgeLabel) {
        HugeGraph graph = this.graph();
        for (Pair<Id, Id> pair : existedEdgeLabel.links()) {
            String targetName;
            String string = graph.vertexLabel((Id)pair.getLeft()).name();
            if (this.links.contains(Pair.of((Object)string, (Object)(targetName = graph.vertexLabel((Id)pair.getRight()).name())))) continue;
            return false;
        }
        if (this.frequency == Frequency.DEFAULT && existedEdgeLabel.frequency() != Frequency.SINGLE || this.frequency != Frequency.DEFAULT && this.frequency != existedEdgeLabel.frequency()) {
            return false;
        }
        if (this.enableLabelIndex == null || this.enableLabelIndex != false ? !existedEdgeLabel.enableLabelIndex() : existedEdgeLabel.enableLabelIndex()) {
            return false;
        }
        Set<Id> existedProperties = existedEdgeLabel.properties();
        if (this.properties.size() != existedProperties.size()) {
            return false;
        }
        for (String string : this.properties) {
            PropertyKey propertyKey = graph.propertyKey(string);
            if (existedProperties.contains(propertyKey.id())) continue;
            return false;
        }
        List<Id> list = existedEdgeLabel.sortKeys();
        if (this.sortKeys.size() != list.size()) {
            return false;
        }
        for (String key : this.sortKeys) {
            PropertyKey propertyKey = graph.propertyKey(key);
            if (list.contains(propertyKey.id())) continue;
            return false;
        }
        Set<Id> set = existedEdgeLabel.nullableKeys();
        if (this.nullableKeys.size() != set.size()) {
            return false;
        }
        for (String nullableKeyName : this.nullableKeys) {
            PropertyKey nullableKey = graph.propertyKey(nullableKeyName);
            if (set.contains(nullableKey.id())) continue;
            return false;
        }
        return true;
    }

    @Override
    public EdgeLabel append() {
        PropertyKey propertyKey;
        EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
        if (edgeLabel == null) {
            throw new NotFoundException("Can't update edge label '%s' since it doesn't exist", this.name);
        }
        this.checkStableVars();
        this.checkProperties(Action.APPEND);
        this.checkNullableKeys(Action.APPEND);
        Userdata.check(this.userdata, Action.APPEND);
        for (String key : this.properties) {
            propertyKey = this.graph().propertyKey(key);
            edgeLabel.property(propertyKey.id());
        }
        for (String key : this.nullableKeys) {
            propertyKey = this.graph().propertyKey(key);
            edgeLabel.nullableKey(propertyKey.id());
        }
        edgeLabel.userdata(this.userdata);
        this.graph().updateEdgeLabel(edgeLabel);
        return edgeLabel;
    }

    @Override
    public EdgeLabel eliminate() {
        EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
        if (edgeLabel == null) {
            throw new NotFoundException("Can't update edge label '%s' since it doesn't exist", this.name);
        }
        this.checkStableVars();
        this.checkProperties(Action.ELIMINATE);
        this.checkNullableKeys(Action.ELIMINATE);
        Userdata.check(this.userdata, Action.ELIMINATE);
        edgeLabel.removeUserdata(this.userdata);
        this.graph().updateEdgeLabel(edgeLabel);
        return edgeLabel;
    }

    @Override
    public Id remove() {
        EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
        if (edgeLabel == null) {
            return null;
        }
        return this.graph().removeEdgeLabel(edgeLabel.id());
    }

    @Override
    public Id rebuildIndex() {
        EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
        if (edgeLabel == null) {
            return null;
        }
        return this.graph().rebuildIndex(edgeLabel);
    }

    @Override
    public EdgeLabel.Builder asBase() {
        this.edgeLabelType = EdgeLabelType.PARENT;
        return this;
    }

    @Override
    public EdgeLabel.Builder withBase(String fatherLabel) {
        E.checkArgumentNotNull((Object)fatherLabel, (String)"When creating a subtype edgeLabel, the edgeLabel name of the parent type edgeLabel must be entered", (Object[])new Object[0]);
        EdgeLabel edgeLabel = this.edgeLabelOrNull(fatherLabel);
        if (edgeLabel == null) {
            throw new NotFoundException("Can't create subtype edge label '%s' since it's parent edge label doesn't exist", this.name);
        }
        this.edgeLabelType = EdgeLabelType.SUB;
        this.fatherLabel = fatherLabel;
        return this;
    }

    public EdgeLabelBuilder id(long id) {
        E.checkArgument((id != 0L ? 1 : 0) != 0, (String)"Not allowed to assign 0 as edge label id", (Object[])new Object[0]);
        this.id = IdGenerator.of(id);
        return this;
    }

    @Override
    public EdgeLabelBuilder properties(String ... properties) {
        this.properties.addAll(Arrays.asList(properties));
        return this;
    }

    @Override
    public EdgeLabelBuilder nullableKeys(String ... keys) {
        this.nullableKeys.addAll(Arrays.asList(keys));
        return this;
    }

    @Override
    public EdgeLabelBuilder sortKeys(String ... keys) {
        if (keys.length == 0) {
            return this;
        }
        E.checkArgument((boolean)this.sortKeys.isEmpty(), (String)"Not allowed to assign sort keys multitimes", (Object[])new Object[0]);
        List<String> sortKeys = Arrays.asList(keys);
        E.checkArgument((boolean)CollectionUtil.allUnique(sortKeys), (String)"Invalid sort keys %s, which contains some duplicate properties", (Object[])new Object[]{sortKeys});
        this.sortKeys.addAll(sortKeys);
        return this;
    }

    @Override
    public EdgeLabelBuilder link(String sourceLabel, String targetLabel) {
        if (this.links == null) {
            this.links = new HashSet<Pair<String, String>>();
        }
        this.links.add((Pair<String, String>)Pair.of((Object)sourceLabel, (Object)targetLabel));
        return this;
    }

    @Override
    public EdgeLabelBuilder sourceLabel(String label) {
        E.checkArgument((boolean)this.links.isEmpty(), (String)"Not allowed add source label to an edge label which already has links", (Object[])new Object[0]);
        if (this.targetLabel != null) {
            this.links.add((Pair<String, String>)Pair.of((Object)label, (Object)this.targetLabel));
            this.targetLabel = null;
        } else {
            this.sourceLabel = label;
        }
        return this;
    }

    @Override
    public EdgeLabelBuilder targetLabel(String label) {
        E.checkArgument((boolean)this.links.isEmpty(), (String)"Not allowed add source label to an edge label which already has links", (Object[])new Object[0]);
        if (this.sourceLabel != null) {
            this.links.add((Pair<String, String>)Pair.of((Object)this.sourceLabel, (Object)label));
            this.sourceLabel = null;
        } else {
            this.targetLabel = label;
        }
        return this;
    }

    @Override
    public EdgeLabelBuilder singleTime() {
        this.frequency = Frequency.SINGLE;
        return this;
    }

    @Override
    public EdgeLabelBuilder multiTimes() {
        this.frequency = Frequency.MULTIPLE;
        return this;
    }

    public EdgeLabelBuilder ifNotExist() {
        this.checkExist = false;
        return this;
    }

    @Override
    public EdgeLabelBuilder frequency(Frequency frequency) {
        this.frequency = frequency;
        return this;
    }

    @Override
    public EdgeLabel.Builder ttl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public EdgeLabel.Builder ttlStartTime(String ttlStartTime) {
        this.ttlStartTime = ttlStartTime;
        return this;
    }

    @Override
    public EdgeLabelBuilder enableLabelIndex(boolean enable) {
        this.enableLabelIndex = enable;
        return this;
    }

    @Override
    public EdgeLabelBuilder userdata(String key, Object value) {
        this.userdata.put(key, value);
        return this;
    }

    @Override
    public EdgeLabelBuilder userdata(Map<String, Object> userdata) {
        this.userdata.putAll(userdata);
        return this;
    }

    public EdgeLabelBuilder checkExist(boolean checkExist) {
        this.checkExist = checkExist;
        return this;
    }

    private void checkProperties(Action action) {
        switch (action) {
            case INSERT: 
            case APPEND: {
                for (String key : this.properties) {
                    this.graph().propertyKey(key);
                }
                break;
            }
            case ELIMINATE: {
                if (this.properties.isEmpty()) break;
                throw new NotAllowException("Not support to eliminate properties for edge label currently");
            }
            case DELETE: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown schema action '%s'", action));
            }
        }
    }

    private void checkNullableKeys(Action action) {
        if (action == Action.ELIMINATE) {
            if (!this.nullableKeys.isEmpty()) {
                throw new NotAllowException("Not support to eliminate nullableKeys for edge label currently");
            }
            return;
        }
        EdgeLabel edgeLabel = this.edgeLabelOrNull(this.name);
        ImmutableList originProps = edgeLabel == null ? ImmutableList.of() : this.graph().mapPkId2Name(edgeLabel.properties());
        Set<String> appendProps = this.properties;
        E.checkArgument((boolean)CollectionUtil.union((Collection)originProps, appendProps).containsAll(this.nullableKeys), (String)"The nullableKeys: %s to be created or appended must belong to the origin/new properties: %s/%s ", (Object[])new Object[]{this.nullableKeys, originProps, appendProps});
        List<String> sortKeys = edgeLabel == null ? this.sortKeys : this.graph().mapPkId2Name(edgeLabel.sortKeys());
        E.checkArgument((!CollectionUtil.hasIntersection(sortKeys, this.nullableKeys) ? 1 : 0) != 0, (String)"The nullableKeys: %s are not allowed to belong to sortKeys: %s of edge label '%s'", (Object[])new Object[]{this.nullableKeys, sortKeys, this.name});
        if (action == Action.APPEND) {
            Collection newAddedProps = CollectionUtils.subtract(appendProps, (Collection)originProps);
            E.checkArgument((boolean)this.nullableKeys.containsAll(newAddedProps), (String)"The new added properties: %s must be nullable", (Object[])new Object[]{newAddedProps});
        }
    }

    private void checkSortKeys() {
        if (this.frequency == Frequency.SINGLE || this.frequency == Frequency.DEFAULT) {
            E.checkArgument((boolean)this.sortKeys.isEmpty(), (String)"EdgeLabel can't contain sortKeys when the cardinality property is single", (Object[])new Object[0]);
        } else {
            E.checkState((this.sortKeys != null ? 1 : 0) != 0, (String)"The sortKeys can't be null when the cardinality property is multiple", (Object[])new Object[0]);
            E.checkArgument((!this.sortKeys.isEmpty() ? 1 : 0) != 0, (String)"EdgeLabel must contain sortKeys when the cardinality property is multiple", (Object[])new Object[0]);
        }
        if (this.sortKeys.isEmpty()) {
            return;
        }
        E.checkArgument((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"The properties can't be empty when exist sort keys for edge label '%s'", (Object[])new Object[]{this.name});
        for (String key : this.sortKeys) {
            E.checkArgument((boolean)this.properties.contains(key), (String)"The sort key '%s' must be contained in properties '%s' for edge label '%s'", (Object[])new Object[]{key, this.name, this.properties});
        }
    }

    private void checkRelation() {
        if (this.edgeLabelType.parent()) {
            E.checkArgument((boolean)this.links.isEmpty(), (String)"The links of the parent edge label must be empty", (Object[])new Object[0]);
        } else {
            E.checkArgument((!this.links.isEmpty() ? 1 : 0) != 0, (String)"The links of standard and subtype edge label can't be empty", (Object[])new Object[0]);
            E.checkArgument((this.links.size() == 1 ? 1 : 0) != 0, (String)"The links size of standard and subtype edge label must be 1", (Object[])new Object[0]);
            for (Pair<String, String> link : this.links) {
                String srcLabel = (String)link.getLeft();
                String tgtLabel = (String)link.getRight();
                E.checkArgument((srcLabel != null && tgtLabel != null ? 1 : 0) != 0, (String)"Must set source and target label for edge label '%s'", (Object[])new Object[]{this.name});
                E.checkArgumentNotNull((Object)this.vertexLabelOrNull(srcLabel), (String)"Undefined source vertex label '%s' in edge label '%s'", (Object[])new Object[]{srcLabel, this.name});
                E.checkArgumentNotNull((Object)this.vertexLabelOrNull(tgtLabel), (String)"Undefined target vertex label '%s' in edge label '%s'", (Object[])new Object[]{tgtLabel, this.name});
            }
        }
    }

    private void checkStableVars() {
        if (this.sourceLabel != null) {
            throw new NotAllowException("Not allowed to update source label for edge label '%s', it must be null", this.name);
        }
        if (this.targetLabel != null) {
            throw new NotAllowException("Not allowed to update target label for edge label '%s', it must be null", this.name);
        }
        if (this.links != null && !this.links.isEmpty()) {
            throw new NotAllowException("Not allowed to update source/target label for edge label '%s', it must be null", this.name);
        }
        if (this.frequency != Frequency.DEFAULT) {
            throw new NotAllowException("Not allowed to update frequency for edge label '%s'", this.name);
        }
        if (!this.sortKeys.isEmpty()) {
            throw new NotAllowException("Not allowed to update sort keys for edge label '%s'", this.name);
        }
        if (this.enableLabelIndex != null) {
            throw new NotAllowException("Not allowed to update enable_label_index for edge label '%s'", this.name);
        }
    }

    private void checkTtl() {
        E.checkArgument((this.ttl >= 0L ? 1 : 0) != 0, (String)"The ttl must be >= 0, but got: %s", (Object[])new Object[]{this.ttl});
        if (this.ttl == 0L) {
            E.checkArgument((this.ttlStartTime == null ? 1 : 0) != 0, (String)"Can't set ttl start time if ttl is not set", (Object[])new Object[0]);
            return;
        }
        for (Pair<String, String> link : this.links) {
            VertexLabel source = this.graph().vertexLabel((String)link.getLeft());
            VertexLabel target = this.graph().vertexLabel((String)link.getRight());
            E.checkArgument((!(source.ttl() != 0L && this.ttl > source.ttl() || target.ttl() != 0L && this.ttl > target.ttl()) ? 1 : 0) != 0, (String)"The ttl(%s) of edge label '%s' should less than ttl(%s) of source label '%s' and ttl(%s) of target label '%s'", (Object[])new Object[]{this.ttl, this.name, source.ttl(), link.getLeft(), target.ttl(), link.getRight()});
        }
        if (this.ttlStartTime == null) {
            return;
        }
        E.checkArgument((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"The properties can't be empty when exist ttl start time for edge label '%s'", (Object[])new Object[]{this.name});
        E.checkArgument((boolean)this.properties.contains(this.ttlStartTime), (String)"The ttl start time '%s' must be contained in properties '%s' for edge label '%s'", (Object[])new Object[]{this.ttlStartTime, this.name, this.properties});
        PropertyKey pkey = this.graph().propertyKey(this.ttlStartTime);
        E.checkArgument((boolean)pkey.dataType().isDate(), (String)"The ttl start time property must be date type,but got '%s(%s)'", (Object[])new Object[]{this.ttlStartTime, pkey.dataType()});
    }

    private void checkUserdata(Action action) {
        switch (action) {
            case INSERT: 
            case APPEND: {
                for (Map.Entry e : this.userdata.entrySet()) {
                    if (e.getValue() != null) continue;
                    throw new NotAllowException("Not allowed pass null userdata value when create or append edge label");
                }
                break;
            }
            case ELIMINATE: 
            case DELETE: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unknown schema action '%s'", action));
            }
        }
    }

    private static Set<String> mapPkId2Name(HugeGraph graph, Set<Id> ids) {
        return new HashSet<String>(graph.mapPkId2Name(ids));
    }

    private static List<String> mapPkId2Name(HugeGraph graph, List<Id> ids) {
        return graph.mapPkId2Name(ids);
    }

    private static String mapElId2Name(HugeGraph graph, Id fatherId) {
        return graph.mapElId2Name((Collection<Id>)ImmutableList.of((Object)fatherId)).get(0);
    }

    private static Set<Pair<String, String>> mapPairId2Name(HugeGraph graph, Set<Pair<Id, Id>> pairs) {
        return graph.mapPairId2Name(pairs);
    }
}

