# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import asyncio
import builtins
import collections.abc
import datetime
import typing

class AutoCommit:
    r"""
    The auto-commit configuration for storing the offset on the server.
    """
    class Disabled(AutoCommit):
        r"""
        The auto-commit is disabled and the offset must be stored manually by the consumer.
        """

        __match_args__ = ((),)
        def __new__(cls) -> AutoCommit.Disabled: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    class Interval(AutoCommit):
        r"""
        The auto-commit is enabled and the offset is stored on the server after a certain interval.
        """

        __match_args__ = ("_0",)
        @property
        def _0(self) -> datetime.timedelta: ...
        def __new__(cls, _0: datetime.timedelta) -> AutoCommit.Interval: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    class IntervalOrWhen(AutoCommit):
        r"""
        The auto-commit is enabled and the offset is stored on the server after a certain interval or depending on the mode when consuming the messages.
        """

        __match_args__ = (
            "_0",
            "_1",
        )
        @property
        def _0(self) -> datetime.timedelta: ...
        @property
        def _1(self) -> AutoCommitWhen: ...
        def __new__(
            cls, _0: datetime.timedelta, _1: AutoCommitWhen
        ) -> AutoCommit.IntervalOrWhen: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    class IntervalOrAfter(AutoCommit):
        r"""
        The auto-commit is enabled and the offset is stored on the server after a certain interval or depending on the mode after consuming the messages.
        """

        __match_args__ = (
            "_0",
            "_1",
        )
        @property
        def _0(self) -> datetime.timedelta: ...
        @property
        def _1(self) -> AutoCommitAfter: ...
        def __new__(
            cls, _0: datetime.timedelta, _1: AutoCommitAfter
        ) -> AutoCommit.IntervalOrAfter: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    class When(AutoCommit):
        r"""
        The auto-commit is enabled and the offset is stored on the server depending on the mode when consuming the messages.
        """

        __match_args__ = ("_0",)
        @property
        def _0(self) -> AutoCommitWhen: ...
        def __new__(cls, _0: AutoCommitWhen) -> AutoCommit.When: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    class After(AutoCommit):
        r"""
        The auto-commit is enabled and the offset is stored on the server depending on the mode after consuming the messages.
        """

        __match_args__ = ("_0",)
        @property
        def _0(self) -> AutoCommitAfter: ...
        def __new__(cls, _0: AutoCommitAfter) -> AutoCommit.After: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    ...

class AutoCommitAfter:
    r"""
    The auto-commit mode for storing the offset on the server **after** receiving the messages.
    """
    class ConsumingAllMessages(AutoCommitAfter):
        r"""
        The offset is stored on the server after all the messages are consumed.
        """

        __match_args__ = ((),)
        def __new__(cls) -> AutoCommitAfter.ConsumingAllMessages: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    class ConsumingEachMessage(AutoCommitAfter):
        r"""
        The offset is stored on the server after consuming each message.
        """

        __match_args__ = ((),)
        def __new__(cls) -> AutoCommitAfter.ConsumingEachMessage: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    class ConsumingEveryNthMessage(AutoCommitAfter):
        r"""
        The offset is stored on the server after consuming every Nth message.
        """

        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.int: ...
        def __new__(
            cls, _0: builtins.int
        ) -> AutoCommitAfter.ConsumingEveryNthMessage: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    ...

class AutoCommitWhen:
    r"""
    The auto-commit mode for storing the offset on the server.
    """
    class PollingMessages(AutoCommitWhen):
        r"""
        The offset is stored on the server when the messages are received.
        """

        __match_args__ = ((),)
        def __new__(cls) -> AutoCommitWhen.PollingMessages: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    class ConsumingAllMessages(AutoCommitWhen):
        r"""
        The offset is stored on the server when all the messages are consumed.
        """

        __match_args__ = ((),)
        def __new__(cls) -> AutoCommitWhen.ConsumingAllMessages: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    class ConsumingEachMessage(AutoCommitWhen):
        r"""
        The offset is stored on the server when consuming each message.
        """

        __match_args__ = ((),)
        def __new__(cls) -> AutoCommitWhen.ConsumingEachMessage: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    class ConsumingEveryNthMessage(AutoCommitWhen):
        r"""
        The offset is stored on the server when consuming every Nth message.
        """

        __match_args__ = ("_0",)
        @property
        def _0(self) -> builtins.int: ...
        def __new__(
            cls, _0: builtins.int
        ) -> AutoCommitWhen.ConsumingEveryNthMessage: ...
        def __len__(self) -> builtins.int: ...
        def __getitem__(self, key: builtins.int) -> typing.Any: ...

    ...

class IggyClient:
    r"""
    A Python class representing the Iggy client.
    It wraps the RustIggyClient and provides asynchronous functionality
    through the contained runtime.
    """
    def __new__(cls, conn: typing.Optional[builtins.str] = None) -> IggyClient:
        r"""
        Constructs a new IggyClient from a TCP server address.

        This initializes a new runtime for asynchronous operations.
        Future versions might utilize asyncio for more Pythonic async.
        """
    @classmethod
    def from_connection_string(cls, connection_string: builtins.str) -> IggyClient:
        r"""
        Constructs a new IggyClient from a connection string.

        Returns an error if the connection string provided is invalid.
        """
    def ping(self) -> collections.abc.Awaitable[None]:
        r"""
        Sends a ping request to the server to check connectivity.

        Returns `Ok(())` if the server responds successfully, or a `PyRuntimeError`
        if the connection fails.
        """
    def login_user(
        self, username: builtins.str, password: builtins.str
    ) -> collections.abc.Awaitable[None]:
        r"""
        Logs in the user with the given credentials.

        Returns `Ok(())` on success, or a PyRuntimeError on failure.
        """
    def connect(self) -> collections.abc.Awaitable[None]:
        r"""
        Connects the IggyClient to its service.

        Returns Ok(()) on successful connection or a PyRuntimeError on failure.
        """
    def create_stream(self, name: builtins.str) -> collections.abc.Awaitable[None]:
        r"""
        Creates a new stream with the provided name.

        Returns Ok(()) on successful stream creation or a PyRuntimeError on failure.
        """
    def get_stream(
        self, stream_id: builtins.str | builtins.int
    ) -> collections.abc.Awaitable[typing.Optional[StreamDetails]]:
        r"""
        Gets stream by id.

        Returns Option of stream details or a PyRuntimeError on failure.
        """
    def create_topic(
        self,
        stream: builtins.str | builtins.int,
        name: builtins.str,
        partitions_count: builtins.int,
        compression_algorithm: typing.Optional[builtins.str] = None,
        replication_factor: typing.Optional[builtins.int] = None,
        message_expiry: typing.Optional[datetime.timedelta] = None,
        max_topic_size: typing.Optional[builtins.int] = None,
    ) -> collections.abc.Awaitable[None]:
        r"""
        Creates a new topic with the given parameters.

        Returns Ok(()) on successful topic creation or a PyRuntimeError on failure.
        """
    def get_topic(
        self,
        stream_id: builtins.str | builtins.int,
        topic_id: builtins.str | builtins.int,
    ) -> collections.abc.Awaitable[typing.Optional[TopicDetails]]:
        r"""
        Gets topic by stream and id.

        Returns Option of topic details or a PyRuntimeError on failure.
        """
    def send_messages(
        self,
        stream: builtins.str | builtins.int,
        topic: builtins.str | builtins.int,
        partitioning: builtins.int,
        messages: list[SendMessage],
    ) -> collections.abc.Awaitable[None]:
        r"""
        Sends a list of messages to the specified topic.

        Returns Ok(()) on successful sending or a PyRuntimeError on failure.
        """
    def poll_messages(
        self,
        stream: builtins.str | builtins.int,
        topic: builtins.str | builtins.int,
        partition_id: builtins.int,
        polling_strategy: PollingStrategy,
        count: builtins.int,
        auto_commit: builtins.bool,
    ) -> collections.abc.Awaitable[list[ReceiveMessage]]:
        r"""
        Polls for messages from the specified topic and partition.

        Returns a list of received messages or a PyRuntimeError on failure.
        """
    def consumer_group(
        self,
        name: builtins.str,
        stream: builtins.str,
        topic: builtins.str,
        partition_id: typing.Optional[builtins.int] = None,
        polling_strategy: typing.Optional[PollingStrategy] = None,
        batch_length: typing.Optional[builtins.int] = None,
        auto_commit: typing.Optional[AutoCommit] = None,
        create_consumer_group_if_not_exists: builtins.bool = True,
        auto_join_consumer_group: builtins.bool = True,
        poll_interval: typing.Optional[datetime.timedelta] = None,
        polling_retry_interval: typing.Optional[datetime.timedelta] = None,
        init_retries: typing.Optional[builtins.int] = None,
        init_retry_interval: typing.Optional[datetime.timedelta] = None,
        allow_replay: builtins.bool = False,
    ) -> collections.abc.Awaitable[IggyConsumer]:
        r"""
        Creates a new consumer group consumer.

        Returns the consumer or a PyRuntimeError on failure.
        """

class IggyConsumer:
    r"""
    A Python class representing the Iggy consumer.
    It wraps the RustIggyConsumer and provides asynchronous functionality
    through the contained runtime.
    """
    def get_last_consumed_offset(
        self, partition_id: builtins.int
    ) -> typing.Optional[builtins.int]:
        r"""
        Get the last consumed offset or `None` if no offset has been consumed yet.
        """
    def get_last_stored_offset(
        self, partition_id: builtins.int
    ) -> typing.Optional[builtins.int]:
        r"""
        Get the last stored offset or `None` if no offset has been stored yet.
        """
    def name(self) -> builtins.str:
        r"""
        Gets the name of the consumer group.
        """
    def partition_id(self) -> builtins.int:
        r"""
        Gets the current partition id or `0` if no messages have been polled yet.
        """
    def stream(self) -> builtins.str | builtins.int:
        r"""
        Gets the name of the stream this consumer group is configured for.
        """
    def topic(self) -> builtins.str | builtins.int:
        r"""
        Gets the name of the topic this consumer group is configured for.
        """
    def store_offset(
        self, offset: builtins.int, partition_id: typing.Optional[builtins.int]
    ) -> collections.abc.Awaitable[None]:
        r"""
        Stores the provided offset for the provided partition id or if none is specified
        uses the current partition id for the consumer group.

        Returns `Ok(())` if the server responds successfully, or a `PyRuntimeError`
        if the operation fails.
        """
    def delete_offset(
        self, partition_id: typing.Optional[builtins.int]
    ) -> collections.abc.Awaitable[None]:
        r"""
        Deletes the offset for the provided partition id or if none is specified
        uses the current partition id for the consumer group.

        Returns `Ok(())` if the server responds successfully, or a `PyRuntimeError`
        if the operation fails.
        """
    def iter_messages(self) -> collections.abc.AsyncIterator[ReceiveMessage]:
        r"""
        Asynchronously iterate over `ReceiveMessage`s.

        Returns an async iterator that raises `StopAsyncIteration` when no more messages are available
        or a `PyRuntimeError` on failure.

        Note: This method does not currently support `AutoCommit.After`.
        For `AutoCommit.IntervalOrAfter(datetime.timedelta, AutoCommitAfter)`,
        only the interval part is applied; the `after` mode is ignored.
        Use `consume_messages()` if you need commit-after-processing semantics.
        """
    def consume_messages(
        self,
        callback: collections.abc.Callable[
            [ReceiveMessage], collections.abc.Awaitable[None]
        ],
        shutdown_event: typing.Optional[asyncio.Event],
    ) -> collections.abc.Awaitable[None]:
        r"""
        Consumes messages continuously using a callback function and an optional `asyncio.Event` for signaling shutdown.

        Returns an awaitable that completes when shutdown is signaled or a PyRuntimeError on failure.
        """

class PollingStrategy:
    class Offset(PollingStrategy):
        __match_args__ = ("value",)
        @property
        def value(self) -> builtins.int: ...
        def __new__(cls, value: builtins.int) -> PollingStrategy.Offset: ...

    class Timestamp(PollingStrategy):
        __match_args__ = ("value",)
        @property
        def value(self) -> builtins.int: ...
        def __new__(cls, value: builtins.int) -> PollingStrategy.Timestamp: ...

    class First(PollingStrategy):
        __match_args__ = ((),)
        def __new__(cls) -> PollingStrategy.First: ...

    class Last(PollingStrategy):
        __match_args__ = ((),)
        def __new__(cls) -> PollingStrategy.Last: ...

    class Next(PollingStrategy):
        __match_args__ = ((),)
        def __new__(cls) -> PollingStrategy.Next: ...

    ...

class ReceiveMessage:
    r"""
    A Python class representing a received message.

    This class wraps a Rust message, allowing for access to its payload and offset from Python.
    """
    def payload(self) -> bytes:
        r"""
        Retrieves the payload of the received message.

        The payload is returned as a Python bytes object.
        """
    def offset(self) -> builtins.int:
        r"""
        Retrieves the offset of the received message.

        The offset represents the position of the message within its topic.
        """
    def timestamp(self) -> builtins.int:
        r"""
        Retrieves the timestamp of the received message.

        The timestamp represents the time of the message within its topic.
        """
    def id(self) -> builtins.int:
        r"""
        Retrieves the id of the received message.

        The id represents unique identifier of the message within its topic.
        """
    def checksum(self) -> builtins.int:
        r"""
        Retrieves the checksum of the received message.

        The checksum represents the integrity of the message within its topic.
        """
    def length(self) -> builtins.int:
        r"""
        Retrieves the length of the received message.

        The length represents the length of the payload.
        """
    def partition_id(self) -> builtins.int:
        r"""
        Retrieves the partition this message belongs to.
        """

class SendMessage:
    r"""
    A Python class representing a message to be sent.

    This class wraps a Rust message meant for sending, facilitating
    the creation of such messages from Python and their subsequent use in Rust.
    """
    def __new__(cls, data: builtins.str | bytes) -> SendMessage:
        r"""
        Constructs a new `SendMessage` instance from a string or bytes.

        This method allows for the creation of a `SendMessage` instance
        directly from Python using the provided string or bytes data.
        """

class StreamDetails:
    @property
    def id(self) -> builtins.int: ...
    @property
    def name(self) -> builtins.str: ...
    @property
    def messages_count(self) -> builtins.int: ...
    @property
    def topics_count(self) -> builtins.int: ...

class TopicDetails:
    @property
    def id(self) -> builtins.int: ...
    @property
    def name(self) -> builtins.str: ...
    @property
    def messages_count(self) -> builtins.int: ...
    @property
    def partitions_count(self) -> builtins.int: ...
