/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.limit.ratelimit;

import org.apache.seata.common.XID;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.NumberUtils;
import org.apache.seata.config.CachedConfigurationChangeListener;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationChangeEvent;
import org.apache.seata.config.ConfigurationChangeListener;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.protocol.ResultCode;
import org.apache.seata.core.protocol.transaction.AbstractTransactionRequestToTC;
import org.apache.seata.core.protocol.transaction.AbstractTransactionResponse;
import org.apache.seata.core.protocol.transaction.GlobalBeginResponse;
import org.apache.seata.core.rpc.RpcContext;
import org.apache.seata.server.limit.AbstractTransactionRequestHandler;
import org.apache.seata.server.limit.ratelimit.RateLimitInfo;
import org.apache.seata.server.limit.ratelimit.RateLimiter;
import org.apache.seata.server.limit.ratelimit.RateLimiterHandlerConfig;
import org.apache.seata.server.metrics.MetricsPublisher;

public class RateLimiterHandler
extends AbstractTransactionRequestHandler
implements CachedConfigurationChangeListener {
    private static volatile RateLimiterHandler instance;
    private final RateLimiter rateLimiter;
    private final RateLimiterHandlerConfig config;

    public RateLimiterHandler(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        this.config = new RateLimiterHandlerConfig();
    }

    private RateLimiterHandler() {
        this.rateLimiter = (RateLimiter)EnhancedServiceLoader.load(RateLimiter.class);
        this.config = this.rateLimiter.obtainConfig();
        Configuration config = ConfigurationFactory.getInstance();
        config.addConfigListener("server.ratelimit.enable", (ConfigurationChangeListener)this);
        config.addConfigListener("server.ratelimit.bucketTokenNumPerSecond", (ConfigurationChangeListener)this);
        config.addConfigListener("server.ratelimit.bucketTokenMaxNum", (ConfigurationChangeListener)this);
        config.addConfigListener("server.ratelimit.bucketTokenInitialNum", (ConfigurationChangeListener)this);
    }

    public AbstractTransactionResponse handle(AbstractTransactionRequestToTC originRequest, RpcContext context) {
        if (!this.rateLimiter.isEnable()) {
            return this.next(originRequest, context);
        }
        if (1 == originRequest.getTypeCode() && !this.rateLimiter.canPass()) {
            GlobalBeginResponse response = new GlobalBeginResponse();
            response.setTransactionExceptionCode(TransactionExceptionCode.BeginFailed);
            response.setResultCode(ResultCode.Failed);
            RateLimitInfo rateLimitInfo = RateLimitInfo.generateRateLimitInfo((String)context.getApplicationId(), (String)"globalBeginFailed", (String)XID.getIpAddressAndPort());
            MetricsPublisher.postRateLimitEvent((RateLimitInfo)rateLimitInfo);
            response.setMsg(String.format("TransactionException[rate limit exception, rate limit info: %s]", rateLimitInfo));
            return response;
        }
        return this.next(originRequest, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RateLimiterHandler getInstance() {
        if (instance != null) return instance;
        Class<RateLimiterHandler> clazz = RateLimiterHandler.class;
        synchronized (RateLimiterHandler.class) {
            if (instance != null) return instance;
            instance = new RateLimiterHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void onChangeEvent(ConfigurationChangeEvent event) {
        String dataId = event.getDataId();
        String newValue = event.getNewValue();
        if ("server.ratelimit.enable".equals(dataId)) {
            this.config.setEnable(Boolean.parseBoolean(newValue));
        }
        if ("server.ratelimit.bucketTokenNumPerSecond".equals(dataId)) {
            this.config.setBucketTokenNumPerSecond(NumberUtils.toInt((String)newValue, (int)this.config.getBucketTokenNumPerSecond()));
        }
        if ("server.ratelimit.bucketTokenMaxNum".equals(dataId)) {
            this.config.setBucketTokenMaxNum(NumberUtils.toInt((String)newValue, (int)this.config.getBucketTokenMaxNum()));
        }
        if ("server.ratelimit.bucketTokenInitialNum".equals(dataId)) {
            this.config.setBucketTokenInitialNum(NumberUtils.toInt((String)newValue, (int)this.config.getBucketTokenInitialNum()));
        }
        this.rateLimiter.reInit(this.config);
    }
}

